;******************************************************************************
;*                                                                            *
;*            VGA/MCGA Md 13H Grafick rutiny v Turbo Assembleri             *
;*                                                                            *
;*                   Bodov, spriteov a paletov funkcie                     *
;*                       Turbo & Borland Pascal 7.01                          *
;*               pre 286, 386, 486, P5, K5, M1, Nx586, P6 ...                 *
;*                                                                            *
;*                     (P) 1993, 94, 95 ALAC Software                         *
;*                                                                            *
;******************************************************************************

TITLE Box

MODEL Small

LOCALS

.286

.DATA

BoxPage   DW    0A000H

.CODE

;******************************************************************************
;*           Procedra DrawBox (X1, Y1, X2, Y2: Word; Color: Byte);           *
;*       Vykresl vntro obdnika s farbou Color, ktorho jeden roh m       *
;*                sradnice X1, Y1 a druh roh sradnice X2, Y2.              *
;******************************************************************************

PUBLIC DrawBox
DrawBox PROC FAR
 ARG Color: Byte, Y2: Word, X2: Word, Y1: Word, X1: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[Y1]                  ;Porovnanie Y1 a Y2
                    MOV    BX,[Y2]
                    CMP    AX,BX
                    JNA    @CBPX                    ;Ak Y1<=Y2, cho alej
                    MOV    [Y1],BX                  ;Inak vyme Y1 s Y2
                    MOV    [Y2],AX
         @CBPX:     MOV    AX,[X1]                  ;Porovnanie X1 a X2
                    MOV    BX,[X2]
                    CMP    AX,BX
                    JNA    @CBDo                    ;Ak X1<=X2, cho alej
                    MOV    [X1],BX                  ;Inak vyme X1 s X2
                    MOV    [X2],AX
         @CBDo:     MOV    AX,[Y1]                  ;Adresa = X+Y*320
                    MOV    SI,AX
                    SHL    AX,8
                    SHL    SI,6
                    ADD    SI,AX
                    MOV    BX,[Y2]                  ;Vka obdnika
                    SUB    BX,[Y1]
                    INC    BX
                    ADD    SI,[X1]                  ;Dka obdnika
                    MOV    DX,[X2]
                    SUB    DX,[X1]
                    INC    DX
                    MOV    DI,DX
                    MOV    AX,[BoxPage]
                    MOV    ES,AX
                    MOV    AX,319                   ;Rozdiel medzi riadkami
                    SUB    AX,DX
                    INC    AX
                    MOV    CL,[Color]
         @CBBegin:  MOV    ES:[SI],CL               ;Vyplnenie obdnika
                    INC    SI
                    DEC    DX
                    JNZ    @CBBegin
                    MOV    DX,DI
                    ADD    SI,AX
                    DEC    BX
                    JNZ    @CBBegin
                    POP    BP
                    RET    10
DrawBox ENDP

;******************************************************************************
;*     Procedra DrawBoxRel (X1, Y1, BWidth, BHeight: Word; Color: Byte);     *
;*     Vykresl vntro obdnika s farbou Color, ktorho av horn roh m    *
;*            sradnice X1, Y1, so rkou BWidth a vkou BHeight             *
;******************************************************************************

PUBLIC DrawBoxRel
DrawBoxRel PROC FAR
 ARG Color: Byte, BHeight: Word, BWidth: Word, Y: Word, X: Word
                    PUSH   BP
                    MOV    BP,SP
                    CMP    [Y],0
                    JZ     @CBREnd
                    CMP    [X],0
                    JZ     @CBREnd
                    MOV    AX,[Y]
                    MOV    SI,AX
                    SHL    AX,8
                    SHL    SI,6
                    ADD    SI,AX
                    MOV    SI,AX
                    ADD    SI,[X]
                    MOV    BX,[BHeight]
                    MOV    DX,[BWidth]
                    MOV    DI,DX
                    MOV    AX,[BoxPage]
                    MOV    ES,AX
                    MOV    AX,319
                    SUB    AX,DX
                    INC    AX
                    MOV    CL,[Color]
        @CBRBegin:  MOV    ES:[SI],CL
                    INC    SI
                    DEC    DX
                    JNZ    @CBRBegin
                    MOV    DX,DI
                    ADD    SI,AX
                    DEC    BX
                    JNZ    @CBRBegin
        @CBREnd:    POP    BP
                    RET    10
DrawBoxRel ENDP

;******************************************************************************
;*       Procedra DrawBoxVirtual (X1, Y1, X2, Y2: Word; Color: Byte);        *
;*       Vykresl vntro obdnika s farbou Color, ktorho jeden roh m       *
;*    sradnice X1, Y1 a druh roh sradnice X2, Y2 na virtulnu obrazovku    *
;******************************************************************************

PUBLIC DrawBoxVirtual
DrawBoxVirtual PROC FAR
 ARG Color: Byte, Y2: Word, X2: Word, Y1: Word, X1: Word, SegVirtual: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[Y1]
                    MOV    BX,[Y2]
                    CMP    AX,BX
                    JNA    @CBVPX
                    MOV    [Y1],BX
                    MOV    [Y2],AX
         @CBVPX:    MOV    AX,[X1]
                    MOV    BX,[X2]
                    CMP    AX,BX
                    JNA    @CBVDo
                    MOV    [X1],BX
                    MOV    [X2],AX
         @CBVDo:    MOV    AX,[Y1]
                    MOV    SI,AX
                    SHL    AX,8
                    SHL    SI,6
                    ADD    SI,AX
                    MOV    BX,[Y2]
                    SUB    BX,[Y1]
                    INC    BX
                    ADD    SI,[X1]
                    MOV    DX,[X2]
                    SUB    DX,[X1]
                    INC    DX
                    MOV    DI,DX
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    MOV    AX,319
                    SUB    AX,DX
                    INC    AX
                    MOV    CL,[Color]
        @CBVBegin:  MOV    ES:[SI],CL
                    INC    SI
                    DEC    DX
                    JNZ    @CBVBegin
                    MOV    DX,DI
                    ADD    SI,AX
                    DEC    BX
                    JNZ    @CBVBegin
                    POP    BP
                    RET    12
DrawBoxVirtual ENDP

;******************************************************************************
;* Procedra DrawBoxRelVirtual (X1, Y1, BWidth, BHeight: Word; Color: Byte);  *
;*     Vykresl vntro obdnika s farbou Color, ktorho av horn roh m    *
;* sradnice X1, Y1 so rkou BWidth a vkou BHeight na virtulnu obrazovku  *
;******************************************************************************

PUBLIC DrawBoxRelVirtual
DrawBoxRelVirtual PROC FAR
 ARG Color: Byte,BHeight: Word,BWidth: Word,Y: Word,X: Word,SegVirtual: Word
                    PUSH   BP
                    MOV    BP,SP
                    CMP    [Y],0
                    JZ     @CBRVEnd
                    CMP    [X1],0
                    JZ     @CBRVEnd
                    MOV    AX,[Y]
                    MOV    SI,AX
                    SHL    AX,8
                    SHL    SI,6
                    ADD    SI,AX
                    ADD    SI,[X]
                    MOV    BX,[BHeight]
                    MOV    DX,[BWidth]
                    MOV    DI,DX
                    MOV    AX,[SegVirtual]
                    MOV    ES,AX
                    MOV    AX,319
                    SUB    AX,DX
                    INC    AX
                    MOV    CL,[Color]
       @CBRVBegin:  MOV    ES:[SI],CL
                    INC    SI
                    DEC    DX
                    JNZ    @CBRVBegin
                    MOV    DX,DI
                    ADD    SI,AX
                    DEC    BX
                    JNZ    @CBRVBegin
       @CBRVEnd:    POP    BP
                    RET    12
DrawBoxRelVirtual ENDP

;******************************************************************************
;*                    Procedra SetBoxPage (BPage: Word);                     *
;*       Nastav premenn BoxPage tak, aby urovala segment obrazovky,        *
;*                          do ktorej chceme psa                            *
;******************************************************************************

PUBLIC SetBoxPage
SetBoxPage PROC FAR
 ARG BPage: Word
                    PUSH   BP
                    MOV    BP,SP
                    MOV    AX,[BPage]
                    MOV    [BoxPage],AX
                    POP    BP
                    RET    2
SetBoxPage ENDP

;******************************************************************************
;*                         Funkcia GetBoxPage : Word;                         *
;*       Vrti hodnotu premennej BoxPage, obrazovky, do ktorej kreslme       *
;******************************************************************************

PUBLIC GetBoxPage
GetBoxPage PROC FAR
                    MOV    AX,[BoxPage]
                    RET
GetBoxPage ENDP

END