// DemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Demo.h"
#include "DemoDlg.h"
#include <winioctl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ---------------------------------------------------------------------------
//
// Floppy 2000 interface
//
// ---------------------------------------------------------------------------

const F2kSuccess = 0; // OK
const F2kError   = 1; // floppy 2000 error

typedef DWORD __stdcall tF2kInitialize(void);
typedef void  __stdcall tF2kUninitialize(void);
typedef DWORD __stdcall tF2kSetFloppyParamsToZSK(void);
typedef void  __stdcall tF2kRestoreFloppyParams(void);

tF2kInitialize *F2kInitialize;
tF2kUninitialize *F2kUninitialize;
tF2kSetFloppyParamsToZSK *F2kSetFloppyParamsToZSK;
tF2kRestoreFloppyParams *F2kRestoreFloppyParams;

void Init(void)
{
	HMODULE hLibrary = LoadLibrary("floppy2k");
    F2kInitialize = (tF2kInitialize *)GetProcAddress(hLibrary, "F2kInitialize");
    F2kUninitialize = (tF2kUninitialize *)GetProcAddress(hLibrary, "F2kUninitialize");
    F2kSetFloppyParamsToZSK = (tF2kSetFloppyParamsToZSK *)GetProcAddress(hLibrary, "F2kSetFloppyParamsToZSK");
	F2kRestoreFloppyParams = (tF2kRestoreFloppyParams *)GetProcAddress(hLibrary, "F2kRestoreFloppyParams");
}

// ---------------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////////////
// CDemoDlg dialog

CDemoDlg::CDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDemoDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	Init();
}

void CDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDemoDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDemoDlg, CDialog)
	//{{AFX_MSG_MAP(CDemoDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_FORMAT, OnFormat)
	ON_BN_CLICKED(IDC_READIMAGE, OnReadImage)
	ON_BN_CLICKED(IDC_ABORT, OnAbort)
	ON_BN_CLICKED(IDC_WRITEIMAGE, OnWriteImage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemoDlg message handlers

BOOL CDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// ---------------------------------------------------------------------------
//
// Demo application
//
// ---------------------------------------------------------------------------

CString SysErrorMessage(int ErrorCode)
{
  char Buffer[256];

  FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_ARGUMENT_ARRAY,
 	            NULL,  ErrorCode, 0,	Buffer, sizeof(Buffer), NULL);

  return Buffer;  
}

void CDemoDlg::F2kCheck(DWORD Value)
{
  if (Value != F2kSuccess)
    throw CString("Floppy 2000 error");
}

void CDemoDlg::StartProcessing(const CString Message)
{
  Aborted = false;

  CWnd *ButtonFormat = GetDlgItem(IDC_FORMAT);
  ButtonFormat->EnableWindow(false);
  
  CWnd *ButtonReadImage = GetDlgItem(IDC_READIMAGE);
  ButtonReadImage->EnableWindow(false);
  
  CWnd *ButtonWriteImage = GetDlgItem(IDC_WRITEIMAGE);
  ButtonWriteImage->EnableWindow(false);
  
  CWnd *ButtonAbort = GetDlgItem(IDC_ABORT);
  ButtonAbort->ShowWindow(SW_SHOW);

  ShowProgress(Message, 0);
}

void CDemoDlg::StopProcessing()
{
  CWnd *ButtonFormat = GetDlgItem(IDC_FORMAT);
  ButtonFormat->EnableWindow(true);
  
  CWnd *ButtonReadImage = GetDlgItem(IDC_READIMAGE);
  ButtonReadImage->EnableWindow(true);
  
  CWnd *ButtonWriteImage = GetDlgItem(IDC_WRITEIMAGE);
  ButtonWriteImage->EnableWindow(true);
  
  CWnd *ButtonAbort = GetDlgItem(IDC_ABORT);
  ButtonAbort->ShowWindow(SW_HIDE);
}

void CDemoDlg::ShowProgress(const CString Message, int Percent)
{
  CWnd *LabelInfo = GetDlgItem(IDC_INFO);

  CString PercentStr;
  PercentStr.Format("%d%%", Percent);

  LabelInfo->SetWindowText(Message + PercentStr);

  CProgressCtrl *ProgressBar = (CProgressCtrl *)GetDlgItem(IDC_PROGRESS);
  ProgressBar->SetPos(Percent);

  MSG Msg;
  while (PeekMessage(&Msg, 0, 0, 0, PM_NOREMOVE))
    AfxGetThread()->PumpMessage();

  if (Aborted)
    throw CString("Operation aborted");
}

void CDemoDlg::OnFormat() 
{
  try	
  {

    if (MessageBox("Insert DD floppy disk for drive A: and click OK when ready.""\xd""All data on the floppy will be lost!",
      	           NULL, MB_OKCANCEL | MB_ICONINFORMATION) != IDOK)
      return;

    F2kCheck(F2kInitialize());
    try
	{
      StartProcessing("Formatting ");
      F2kCheck(F2kSetFloppyParamsToZSK());

      HANDLE FloppyDevice = CreateFile("\\\\.\\A:", GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
      try
	  {
        for (int Track = 0; Track <= 79; ++Track)
          for (int Side = 0; Side <= 1; ++Side)
		  {
            DWORD BytesReturned;
            FORMAT_PARAMETERS FormatParameters;

            FormatParameters.MediaType = F3_720_512;
            FormatParameters.StartCylinderNumber = Track;
            FormatParameters.EndCylinderNumber = Track;
            FormatParameters.StartHeadNumber = Side;
            FormatParameters.EndHeadNumber = Side;

            if (!DeviceIoControl(FloppyDevice, IOCTL_DISK_FORMAT_TRACKS, &FormatParameters, sizeof(FormatParameters),
                                 NULL, 0, &BytesReturned, NULL))
              throw CString("Can't format: ") + SysErrorMessage(GetLastError());

            ShowProgress("Formatting ", 100 * (Track * 2 + (Side + 1)) / 160);
		  }
        CloseHandle(FloppyDevice);
	  }
      catch (...)
	  {
        CloseHandle(FloppyDevice);
	    throw;
	  }

      F2kRestoreFloppyParams();
      F2kUninitialize();
      StopProcessing();
	}
    catch(...)
	{
      F2kRestoreFloppyParams();
      F2kUninitialize();
      StopProcessing();
      throw;
	}
  }
  catch (CString &str)
  {
    MessageBox(str, 0, MB_ICONEXCLAMATION | MB_OK);
  }
}

void CDemoDlg::OnReadImage() 
{
  try
  {
	CFileDialog SaveDialog(false, "img", "floppy.img", OFN_HIDEREADONLY | OFN_ENABLESIZING, "Floppy image (*.img)|*.img|All files (*.*)|*.*||");
	if (SaveDialog.DoModal() != IDOK)
      return;

    F2kCheck(F2kInitialize());
    try
	{
      StartProcessing("Reading ");
      F2kCheck(F2kSetFloppyParamsToZSK());

      HANDLE FloppyDevice = CreateFile("\\\\.\\A:", GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
      HANDLE DiskDevice = CreateFile(SaveDialog.GetFileName(), GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
      try
	  {
        for (int Track = 0; Track <= 79; ++Track)
          for (int Side = 0; Side <= 1; ++Side)
		  {
            char Buffer[16 * 256];
            DWORD ReadBytes, WriteBytes;

            if (!ReadFile(FloppyDevice, Buffer, sizeof(Buffer), &ReadBytes, NULL))
              throw CString("Can't read: " + SysErrorMessage(GetLastError()));

			if (ReadBytes != sizeof(Buffer))
			  throw CString("Can't read");

            if (!WriteFile(DiskDevice, Buffer, sizeof(Buffer), &WriteBytes, NULL))
              throw CString("Can't write: " + SysErrorMessage(GetLastError()));

			if (WriteBytes != sizeof(Buffer))
			  throw CString("Can't write");

            ShowProgress("Reading ", 100 * (Track * 2 + (Side + 1)) / 160);
		  }
        CloseHandle(FloppyDevice);
        CloseHandle(DiskDevice);
	  }
      catch(...)
	  {
        CloseHandle(FloppyDevice);
        CloseHandle(DiskDevice);
		throw;
	  }
      F2kRestoreFloppyParams();
      F2kUninitialize();
      StopProcessing();
	}
    catch(...)
	{
      F2kRestoreFloppyParams();
      F2kUninitialize();
      StopProcessing();
	  throw;
	}
  }
  catch (CString &str)
  {
    MessageBox(str, 0, MB_ICONEXCLAMATION | MB_OK);
  }
}

void CDemoDlg::OnWriteImage() 
{
  try
  {
	CFileDialog OpenDialog(true, "img", "floppy.img", OFN_HIDEREADONLY | OFN_ENABLESIZING, "Floppy image (*.img)|*.img|All files (*.*)|*.*||");
	if (OpenDialog.DoModal() != IDOK)
      return;

    F2kCheck(F2kInitialize());
    try
	{
      StartProcessing("Writing ");
      F2kCheck(F2kSetFloppyParamsToZSK());

      HANDLE FloppyDevice = CreateFile("\\\\.\\A:", GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
      HANDLE DiskDevice = CreateFile(OpenDialog.GetFileName(), GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
      try
	  {
        for (int Track = 0; Track <= 79; ++Track)
          for (int Side = 0; Side <= 1; ++Side)
		  {
            char Buffer[16 * 256];
            DWORD ReadBytes, WriteBytes;

            if (!ReadFile(DiskDevice, Buffer, sizeof(Buffer), &ReadBytes, NULL))
              throw CString("Can't read: " + SysErrorMessage(GetLastError()));

			if (ReadBytes != sizeof(Buffer))
			  throw CString("Can't read");

            if (!WriteFile(FloppyDevice, Buffer, sizeof(Buffer), &WriteBytes, NULL))
              throw CString("Can't write: " + SysErrorMessage(GetLastError()));

			if (WriteBytes != sizeof(Buffer))
			  throw CString("Can't write");

            ShowProgress("Writing ", 100 * (Track * 2 + (Side + 1)) / 160);
		  }
        CloseHandle(FloppyDevice);
        CloseHandle(DiskDevice);
	  }
      catch(...)
	  {
        CloseHandle(FloppyDevice);
        CloseHandle(DiskDevice);
		throw;
	  }
      F2kRestoreFloppyParams();
      F2kUninitialize();
      StopProcessing();
	}
    catch(...)
	{
      F2kRestoreFloppyParams();
      F2kUninitialize();
      StopProcessing();
	  throw;
	}
  }
  catch (CString &str)
  {
    MessageBox(str, 0, MB_ICONEXCLAMATION | MB_OK);
  }
}

void CDemoDlg::OnAbort() 
{
  Aborted = true;
}