Attribute VB_Name = "ModuleGlobal"
Option Explicit

' ---------------------------------------------------------------------------
'
' Floppy 2000 interface
'
' ---------------------------------------------------------------------------

Public Const F2kSuccess = 0 ' OK
Public Const F2kError   = 1 ' floppy driver don't found

Declare Function F2kInitialize Lib "Floppy2k" () As Long
Declare Sub F2kUninitialize Lib "Floppy2k" ()

Declare Function F2kSetFloppyParamsToZSK Lib "Floppy2k" () As Long
Declare Sub F2kRestoreFloppyParams Lib "Floppy2k" ()

' ---------------------------------------------------------------------------
'
' Windows API
'
' ---------------------------------------------------------------------------

Public Const IOCTL_DISK_BASE = 7
Public Const METHOD_BUFFERED = 0
Public Const FILE_READ_ACCESS = 1
Public Const FILE_WRITE_ACCESS = 2
Public Const IOCTL_DISK_FORMAT_TRACKS = 507928

Public Const GENERIC_WRITE = &H40000000
Public Const GENERIC_READ = &H80000000
Public Const FILE_ATTRIBUTE_NORMAL = &H80
Public Const INVALID_HANDLE_VALUE = -1
Public Const FILE_SHARE_READ = &H1
Public Const FILE_SHARE_WRITE = &H2
Public Const CREATE_NEW = 1
Public Const CREATE_ALWAYS = 2
Public Const OPEN_EXISTING = 3
Public Const OPEN_ALWAYS = 4

Public Const FORMAT_MESSAGE_ALLOCATE_BUFFER = &H100
Public Const FORMAT_MESSAGE_IGNORE_INSERTS = &H200
Public Const FORMAT_MESSAGE_FROM_STRING = &H400
Public Const FORMAT_MESSAGE_FROM_HMODULE = &H800
Public Const FORMAT_MESSAGE_FROM_SYSTEM = &H1000
Public Const FORMAT_MESSAGE_ARGUMENT_ARRAY = &H2000
Public Const FORMAT_MESSAGE_MAX_WIDTH_MASK = 255

Public Type OFSTRUCT
    cBytes As Byte
    fFixedDisk As Byte
    nErrCode As Integer
    nReserved1 As Integer
    nReserved2 As Integer
    szPathName As String * 256
End Type

Public Type TypeFormatParameters
  MediaType As Long
  StartCylinderNumber As Long
  EndCylinderNumber As Long
  StartHeadNumber As Long
  EndHeadNumber As Long
End Type

Declare Function CreateFile Lib "Kernel32" Alias "CreateFileA" (ByVal lpFilename As String, ByVal dwDesiredAccess As Long, ByVal dwShareMode As Long, ByVal lpSecurityAttributes As Long, ByVal dwCreationDisposition As Long, ByVal dwFlagsAndAttributes As Long, ByVal hTemplateFile As Long) As Long
Declare Function CloseHandle Lib "Kernel32" (ByVal hObject As Long) As Long
Declare Function OpenFile Lib "Kernel32" (ByVal lpFilename As String, lpReOpenBuff As OFSTRUCT, ByVal wStyle As Long) As Long

Declare Function DeviceIoControl Lib "Kernel32" ( _
  ByVal hDevice As Long, _
  ByVal dwIoControlCode As Long, _
  ByRef lpInBuffer As TypeFormatParameters, _
  ByVal nInBufferSize As Long, _
  ByVal lpOutBuffer As Long, _
  ByVal nOutBufferSize As Long, _
  ByRef lpBytesReturned As Long, _
  ByVal lpOverlapped As Long) As Long

Declare Function ReadFile Lib "Kernel32" ( _
  ByVal hFile As Long, _
  ByRef lpBuffer As Byte, _
  ByVal nNumberOfBytesToRead As Long, _
  ByRef lpNumberOfBytesRead As Long, _
  ByVal lpOverlapped As Long) As Long

Declare Function WriteFile Lib "Kernel32" ( _
  ByVal hFile As Long, _
  ByRef lpBuffer As Byte, _
  ByVal nNumberOfBytesToWrite As Long, _
  ByRef lpNumberOfBytesWritten As Long, _
  ByVal lpOverlapped As Long) As Long

Declare Function GetLastError Lib "Kernel32" () As Long

Declare Function FormatMessage Lib "Kernel32" Alias "FormatMessageA" ( _
  ByVal dwFlags As Long, _
  ByVal lpSource As Long, _
  ByVal dwMessageId As Long, _
  ByVal dwLanguageId As Long, _
  ByRef lpBuffer As Byte, _
  ByVal nSize As Long, _
  ByVal Arguments As Long) As Long
