VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form FormDemo 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Floppy 2000 demo application, Copyright (c) 2000 WINSOFT"
   ClientHeight    =   3780
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5865
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3780
   ScaleWidth      =   5865
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin MSComDlg.CommonDialog CommonDialogOpen 
      Left            =   120
      Top             =   1680
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
      DefaultExt      =   "img"
      DialogTitle     =   "Load floppy image from"
      FileName        =   "floppy.img"
      Filter          =   "Floppy image (*.img)|*.img|All files (*.*)|*.*"
   End
   Begin VB.CommandButton CommandAbort 
      Caption         =   "Abort"
      Height          =   375
      Left            =   2085
      TabIndex        =   5
      Top             =   3240
      Visible         =   0   'False
      Width           =   1695
   End
   Begin MSComctlLib.ProgressBar ProgressBar 
      Height          =   255
      Left            =   165
      TabIndex        =   4
      Top             =   2760
      Width           =   5535
      _ExtentX        =   9763
      _ExtentY        =   450
      _Version        =   393216
      BorderStyle     =   1
      Appearance      =   0
   End
   Begin MSComDlg.CommonDialog CommonDialogSave 
      Left            =   120
      Top             =   960
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
      DefaultExt      =   "img"
      DialogTitle     =   "Save floppy image to"
      FileName        =   "floppy.img"
      Filter          =   "Floppy image (*.img)|*.img|All files (*.*)|*.*"
   End
   Begin VB.CommandButton CommandWriteImage 
      Caption         =   "Write image to floppy disk"
      Height          =   495
      Left            =   765
      TabIndex        =   2
      Top             =   1680
      Width           =   4335
   End
   Begin VB.CommandButton CommandReadImage 
      Caption         =   "Read image from floppy disk"
      Height          =   495
      Left            =   765
      TabIndex        =   1
      Top             =   960
      Width           =   4335
   End
   Begin VB.CommandButton CommandFormat 
      Caption         =   "Format DD floppy disk to ZSK embroidery format"
      Height          =   495
      Left            =   765
      TabIndex        =   0
      Top             =   240
      Width           =   4335
   End
   Begin VB.Label LabelInfo 
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   2400
      Width           =   5535
   End
End
Attribute VB_Name = "FormDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim Aborted As Boolean

Private Function SysErrorMessage(ByVal ErrorCode As Long) As String
  Dim ErrMessage(1 To 255) As Byte
  Dim i As Long
  
  FormatMessage FORMAT_MESSAGE_FROM_SYSTEM + FORMAT_MESSAGE_ARGUMENT_ARRAY _
  , 0, ErrorCode, 0, ErrMessage(1), UBound(ErrMessage), 0
  
  SysErrorMessage = ""
  For i = LBound(ErrMessage) To UBound(ErrMessage)
    If ErrMessage(i) = 0 Then
      Exit For
    End If
    SysErrorMessage = SysErrorMessage + Chr(ErrMessage(i))
  Next i
End Function

Private Sub F2kCheck(ByVal Value As Long)
  If Value <> F2kSuccess Then
    Err.Raise -1, , "Floppy 2000 error"
  End If
End Sub

Private Sub StartProcessing(Message As String)
  Aborted = False
  CommandFormat.Enabled = False
  CommandReadImage.Enabled = False
  CommandWriteImage.Enabled = False
  CommandAbort.Visible = True
  ShowProgress Message, 0
End Sub

Private Sub StopProcessing()
  CommandFormat.Enabled = True
  CommandReadImage.Enabled = True
  CommandWriteImage.Enabled = True
  CommandAbort.Visible = False
End Sub

Private Sub ShowProgress(Message As String, Percent As Long)
  LabelInfo.Caption = Message + Str(Percent) + "%"
  ProgressBar.Value = Percent
  DoEvents
  If Aborted Then
    Err.Raise -1, , "Operation aborted"
  End If
End Sub

Private Sub CommandAbort_Click()
  Aborted = True
End Sub

Private Sub CommandFormat_Click()
  
  If MsgBox("Insert DD floppy disk for drive A: and click OK when ready." + Chr(13) + "All data on the floppy will be lost!", vbOKCancel) <> vbOK Then
    Exit Sub
  End If

  ' Floppy 2000 initialization
  On Error GoTo Finally1
  F2kCheck F2kInitialize
  
  ' Screen initialization
  StartProcessing "Formatting "
  
  ' Set ZSK parameters
  On Error GoTo Finally2
  F2kCheck F2kSetFloppyParamsToZSK

  ' Formatting floppy
  Dim FloppyDevice, Track, Side As Long
  Dim FormatParameters As TypeFormatParameters
  Dim BytesReturned As Long
    
  FloppyDevice = CreateFile("\\.\A:", GENERIC_READ + GENERIC_WRITE, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0)
      
  On Error GoTo Finally3
  For Track = 0 To 79
    For Side = 0 To 1
      FormatParameters.MediaType = 5
      FormatParameters.StartCylinderNumber = Track
      FormatParameters.EndCylinderNumber = Track
      FormatParameters.StartHeadNumber = Side
      FormatParameters.EndHeadNumber = Side

      If DeviceIoControl(FloppyDevice, IOCTL_DISK_FORMAT_TRACKS, FormatParameters, Len(FormatParameters), _
                         0, 0, BytesReturned, 0) = 0 Then
        Err.Raise -1, , "Can't format: " + SysErrorMessage(GetLastError)
      End If

      ' Update screen
      ShowProgress "Formatting ", 100 * (Track * 2 + (Side + 1)) \ 160
    Next Side
  Next Track
  
Finally3:
  CloseHandle FloppyDevice
Finally2:
  F2kRestoreFloppyParams
Finally1:
  F2kUninitialize
  StopProcessing

  If Err.Description <> "" Then
    MsgBox Err.Description
  End If
End Sub

Private Sub CommandReadImage_Click()

  ' SaveFile dialog
  On Error GoTo Finally1
  CommonDialogSave.ShowSave

  ' Floppy 2000 initialization
  On Error GoTo Finally2
  F2kCheck F2kInitialize
  
  ' Screen initialization
  StartProcessing "Reading "
  
  ' Set ZSK parameters
  On Error GoTo Finally3
  F2kCheck F2kSetFloppyParamsToZSK

  ' Reading floppy image
  Dim FloppyDevice, DiskDevice, Track, Side As Long
  Dim ReadBytes, WriteBytes As Long
  Dim Buffer(1 To 16 * 256) As Byte
    
  FloppyDevice = CreateFile("\\.\A:", GENERIC_READ, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0)
  DiskDevice = CreateFile(CommonDialogSave.FileName, GENERIC_WRITE, 0, 0, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0)
    
  On Error GoTo Finally4
  For Track = 0 To 79
    For Side = 0 To 1
      
      If ReadFile(FloppyDevice, Buffer(1), UBound(Buffer), ReadBytes, 0) = 0 Then
        Err.Raise -1, , "Can't read: " + SysErrorMessage(GetLastError)
      End If
      
      If ReadBytes <> UBound(Buffer) Then
        Err.Raise -1, , "Can't read"
      End If
      
      If WriteFile(DiskDevice, Buffer(1), UBound(Buffer), WriteBytes, 0) = 0 Then
        Err.Raise -1, , "Can't write: " + SysErrorMessage(GetLastError)
      End If
      
      If WriteBytes <> UBound(Buffer) Then
        Err.Raise -1, , "Can't write"
      End If
      
      ' Update screen
      ShowProgress "Reading ", 100 * (Track * 2 + (Side + 1)) \ 160
    Next Side
  Next Track
Finally4:
    CloseHandle FloppyDevice
    CloseHandle DiskDevice
Finally3:
  F2kRestoreFloppyParams
Finally2:
  F2kUninitialize
  StopProcessing

  If Err.Description <> "" Then
    MsgBox Err.Description
  End If
Finally1:

End Sub

Private Sub CommandWriteImage_Click()

  ' OpenFile dialog
  On Error GoTo Finally1
  CommonDialogOpen.ShowOpen

  ' Floppy 2000 initialization
  On Error GoTo Finally2
  F2kCheck F2kInitialize
  
  ' Screen initialization
  StartProcessing "Writing "
  
  ' Set ZSK parameters
  On Error GoTo Finally3
  F2kCheck F2kSetFloppyParamsToZSK

  ' Reading floppy image
  Dim FloppyDevice, DiskDevice, Track, Side As Long
  Dim ReadBytes, WriteBytes As Long
  Dim Buffer(1 To 16 * 256) As Byte
    
  FloppyDevice = CreateFile("\\.\A:", GENERIC_WRITE, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0)
  DiskDevice = CreateFile(CommonDialogOpen.FileName, GENERIC_READ, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0)
    
  On Error GoTo Finally4
  For Track = 0 To 79
    For Side = 0 To 1
      
      If ReadFile(DiskDevice, Buffer(1), UBound(Buffer), ReadBytes, 0) = 0 Then
        Err.Raise -1, , "Can't read: " + SysErrorMessage(GetLastError)
      End If
      
      If ReadBytes <> UBound(Buffer) Then
        Err.Raise -1, , "Can't read"
      End If
      
      If WriteFile(FloppyDevice, Buffer(1), UBound(Buffer), WriteBytes, 0) = 0 Then
        Err.Raise -1, , "Can't write: " + SysErrorMessage(GetLastError)
      End If
      
      If WriteBytes <> UBound(Buffer) Then
        Err.Raise -1, , "Can't write"
      End If
      
      ' Update screen
      ShowProgress "Writing ", 100 * (Track * 2 + (Side + 1)) \ 160
    Next Side
  Next Track
Finally4:
    CloseHandle DiskDevice
    CloseHandle FloppyDevice
Finally3:
  F2kRestoreFloppyParams
Finally2:
  F2kUninitialize
  StopProcessing

  If Err.Description <> "" Then
    MsgBox Err.Description
  End If
Finally1:

End Sub
