unit UDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Buttons;

type
  TFormDemo = class(TForm)
    SpeedButtonFormat: TSpeedButton;
    ProgressBar: TProgressBar;
    SpeedButtonReadImage: TSpeedButton;
    SpeedButtonWriteImage: TSpeedButton;
    LabelInfo: TLabel;
    SpeedButtonAbort: TSpeedButton;
    SaveDialog: TSaveDialog;
    OpenDialog: TOpenDialog;
    procedure SpeedButtonFormatClick(Sender: TObject);
    procedure SpeedButtonAbortClick(Sender: TObject);
    procedure SpeedButtonReadImageClick(Sender: TObject);
    procedure SpeedButtonWriteImageClick(Sender: TObject);
  private
    { Private declarations }
    procedure StartProcessing(const Message: String);
    procedure StopProcessing;
    procedure ShowProgress(const Message: String; Percent: Integer);
  public
    { Public declarations }
  end;

var
  FormDemo: TFormDemo;

implementation

{$R *.DFM}

// ---------------------------------------------------------------------------
//
// Floppy 2000 interface
//
// ---------------------------------------------------------------------------

const
  F2kSuccess = 0; // OK
  F2kError   = 1; // floppy 2000 error

function F2kInitialize: DWORD; stdcall; external 'floppy2k.dll';
procedure F2kUninitialize; stdcall; external 'floppy2k.dll';

function F2kSetFloppyParamsToZSK: DWORD; stdcall; external 'floppy2k.dll';
procedure F2kRestoreFloppyParams; stdcall; external 'floppy2k.dll';

// ---------------------------------------------------------------------------
//
// Demo Application
//
// ---------------------------------------------------------------------------

var
  Aborted: Boolean;

procedure F2kCheck(Value: DWORD);
begin
  if Value <> F2kSuccess then
    raise Exception.Create('Floppy 2000 error');
end;

procedure TFormDemo.StartProcessing(const Message: String);
begin
  Aborted := False;
  SpeedButtonFormat.Enabled := False;
  SpeedButtonReadImage.Enabled := False;
  SpeedButtonWriteImage.Enabled := False;
  SpeedButtonAbort.Visible := True;
  ShowProgress(Message, 0);
end;

procedure TFormDemo.StopProcessing;
begin
  SpeedButtonFormat.Enabled := True;
  SpeedButtonReadImage.Enabled := True;
  SpeedButtonWriteImage.Enabled := True;
  SpeedButtonAbort.Visible := False;
end;

procedure TFormDemo.ShowProgress(const Message: String; Percent: Integer);
begin
  LabelInfo.Caption := Message + IntToStr(Percent) + '%';
  ProgressBar.Position := Percent;
  Application.ProcessMessages;
  if Aborted then
    raise Exception.Create('Operation aborted');
end;

procedure TFormDemo.SpeedButtonFormatClick(Sender: TObject);
const
  IOCTL_DISK_BASE = $7;
  METHOD_BUFFERED = 0;
  FILE_READ_ACCESS = $1;
  FILE_WRITE_ACCESS = $2;
  IOCTL_DISK_FORMAT_TRACKS = (IOCTL_DISK_BASE shl 16) or ($6 shl 2) or METHOD_BUFFERED or ((FILE_READ_ACCESS or FILE_WRITE_ACCESS) shl 14);
type
  TFormatParameters = packed record
    MediaType: LongWord;
    StartCylinderNumber: DWORD;
    EndCylinderNumber: DWORD;
    StartHeadNumber: DWORD;
    EndHeadNumber: DWORD;
  end;
var
  FloppyDevice: THandle;
  FormatParameters: TFormatParameters;
  BytesReturned: DWORD;
  Side, Track: Integer;
begin
  if MessageDlg('Insert DD floppy disk for drive A: and click OK when ready.'#13'All data on the floppy will be lost!',
                mtConfirmation, [mbOk, mbCancel], 0) <> mrOk then
    Exit;

  F2kCheck(F2kInitialize);
  try
    StartProcessing('Formatting ');
    F2kCheck(F2kSetFloppyParamsToZSK);

    FloppyDevice := CreateFile('\\.\A:', GENERIC_READ or GENERIC_WRITE, 0, nil, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    try
      for Track := 0 to 79 do
        for Side := 0 to 1 do
        begin
          FormatParameters.MediaType := 5; // F3_720_512
          FormatParameters.StartCylinderNumber := Track;
          FormatParameters.EndCylinderNumber := Track;
          FormatParameters.StartHeadNumber := Side;
          FormatParameters.EndHeadNumber := Side;

          if not DeviceIoControl(FloppyDevice, IOCTL_DISK_FORMAT_TRACKS, @FormatParameters, SizeOf(FormatParameters),
                                 nil, 0, BytesReturned, nil) then
            raise Exception.Create('Can''t format: ' + SysErrorMessage(GetLastError));

          ShowProgress('Formatting ', 100 * (Track * 2 + (Side + 1)) div 160);
        end;
    finally
      CloseHandle(FloppyDevice);
    end;
  finally
    F2kRestoreFloppyParams;
    F2kUninitialize;
    StopProcessing;
  end;
end;

procedure TFormDemo.SpeedButtonReadImageClick(Sender: TObject);
var
  FloppyDevice, DiskDevice: THandle;
  Side, Track: Integer;
  Buffer: array [0..16 * 256 - 1] of Char;
  ReadBytes, WriteBytes: DWORD;
begin
  if not SaveDialog.Execute then
    Exit;

  F2kCheck(F2kInitialize);
  try
    StartProcessing('Reading ');
    F2kCheck(F2kSetFloppyParamsToZSK);

    FloppyDevice := CreateFile('\\.\A:', GENERIC_READ, 0, nil, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    DiskDevice := CreateFile(PChar(SaveDialog.FileName), GENERIC_WRITE, 0, nil, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
    try
      for Track := 0 to 79 do
        for Side := 0 to 1 do
        begin
          if not ReadFile(FloppyDevice, Buffer, SizeOf(Buffer), ReadBytes, nil) then
            raise Exception.Create('Can''t read: ' + SysErrorMessage(GetLastError));

          if ReadBytes <> SizeOf(Buffer) then
            raise Exception.Create('Can''t read');

          if not WriteFile(DiskDevice, Buffer, SizeOf(Buffer), WriteBytes, nil) then
            raise Exception.Create('Can''t write: ' + SysErrorMessage(GetLastError));

          if WriteBytes <> SizeOf(Buffer) then
            raise Exception.Create('Can''t write');

          ShowProgress('Reading ', 100 * (Track * 2 + (Side + 1)) div 160);
        end;
    finally
      CloseHandle(FloppyDevice);
      CloseHandle(DiskDevice);
    end;
  finally
    F2kRestoreFloppyParams;
    F2kUninitialize;
    StopProcessing;
  end;
end;

procedure TFormDemo.SpeedButtonWriteImageClick(Sender: TObject);
var
  FloppyDevice, DiskDevice: THandle;
  Side, Track: Integer;
  Buffer: array [0..16 * 256 - 1] of Char;
  ReadBytes, WriteBytes: DWord;
begin
  if not OpenDialog.Execute then
    Exit;

  F2kCheck(F2kInitialize);
  try
    StartProcessing('Writing ');
    F2kCheck(F2kSetFloppyParamsToZSK);

    FloppyDevice := CreateFile('\\.\A:', GENERIC_WRITE, 0, nil, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    DiskDevice := CreateFile(PChar(OpenDialog.FileName), GENERIC_READ, 0, nil, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    try
      for Track := 0 to 79 do
        for Side := 0 to 1 do
        begin
          if not ReadFile(DiskDevice, Buffer, SizeOf(Buffer), ReadBytes, nil) then
            raise Exception.Create('Can''t read: ' + SysErrorMessage(GetLastError));

          if ReadBytes <> SizeOf(Buffer) then
            raise Exception.Create('Can''t read');

          if not WriteFile(FloppyDevice, Buffer, SizeOf(Buffer), WriteBytes, nil) then
            raise Exception.Create('Can''t write: ' + SysErrorMessage(GetLastError));

          if WriteBytes <> SizeOf(Buffer) then
            raise Exception.Create('Can''t write');

          ShowProgress('Writing ', 100 * (Track * 2 + (Side + 1)) div 160);
        end;
    finally
      CloseHandle(DiskDevice);
      CloseHandle(FloppyDevice);
    end;
  finally
    F2kRestoreFloppyParams;
    F2kUninitialize;
    StopProcessing;
  end;
end;

procedure TFormDemo.SpeedButtonAbortClick(Sender: TObject);
begin
  Aborted := True;
end;

end.