//---------------------------------------------------------------------------

#include <vcl.h>
#include <winioctl.h>
#pragma hdrstop

#include "UDemo.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TFormDemo *FormDemo;
//---------------------------------------------------------------------------
__fastcall TFormDemo::TFormDemo(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

// ---------------------------------------------------------------------------
//
// Floppy 2000 interface
//
// ---------------------------------------------------------------------------

const F2kSuccess = 0; // OK
const F2kError   = 1; // floppy 2000 error

extern "C"
{
  DWORD __stdcall F2kInitialize(void);
  void  __stdcall F2kUninitialize(void);
  DWORD __stdcall F2kSetFloppyParamsToZSK(void);
  void  __stdcall F2kRestoreFloppyParams(void);
}

// ---------------------------------------------------------------------------
//
// Demo Application
//
// ---------------------------------------------------------------------------

bool Aborted;

void F2kCheck(DWORD Value)
{
  if (Value != F2kSuccess)
    throw Exception("Floppy 2000 error");
}

void TFormDemo::StartProcessing(const String Message)
{
  Aborted = false;
  SpeedButtonFormat->Enabled = false;
  SpeedButtonReadImage->Enabled = false;
  SpeedButtonWriteImage->Enabled = false;
  SpeedButtonAbort->Visible = true;
  ShowProgress(Message, 0);
}

void TFormDemo::StopProcessing(void)
{
  SpeedButtonFormat->Enabled = true;
  SpeedButtonReadImage->Enabled = true;
  SpeedButtonWriteImage->Enabled = true;
  SpeedButtonAbort->Visible = false;
}

void TFormDemo::ShowProgress(const String Message, int Percent)
{
  LabelInfo->Caption = Message + IntToStr(Percent) + '%';
  ProgressBar->Position = Percent;
  Application->ProcessMessages();
  if (Aborted)
    throw Exception("Operation aborted");
}

//---------------------------------------------------------------------------

void __fastcall TFormDemo::SpeedButtonFormatClick(TObject *Sender)
{
  if (MessageDlg("Insert DD floppy disk for drive A: and click OK when ready.""\xd""All data on the floppy will be lost!",
                mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel, 0) != mrOk)
    return;

  F2kCheck(F2kInitialize());
  __try
  {
    StartProcessing("Formatting ");
    F2kCheck(F2kSetFloppyParamsToZSK());

    HANDLE FloppyDevice = CreateFile("\\\\.\\A:", GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    __try
    {
      for (int Track = 0; Track <= 79; ++Track)
        for (int Side = 0; Side <= 1; ++Side)
        {
          DWORD BytesReturned;
          FORMAT_PARAMETERS FormatParameters;

          FormatParameters.MediaType = F3_720_512;
          FormatParameters.StartCylinderNumber = Track;
          FormatParameters.EndCylinderNumber = Track;
          FormatParameters.StartHeadNumber = Side;
          FormatParameters.EndHeadNumber = Side;

          if (!DeviceIoControl(FloppyDevice, IOCTL_DISK_FORMAT_TRACKS, &FormatParameters, sizeof(FormatParameters),
                                 NULL, 0, &BytesReturned, NULL))
            throw Exception("Can't format: " + SysErrorMessage(GetLastError()));

          ShowProgress("Formatting ", 100 * (Track * 2 + (Side + 1)) / 160);
        }
    }
    __finally
    {
      CloseHandle(FloppyDevice);
    }
  }
  __finally
  {
    F2kRestoreFloppyParams();
    F2kUninitialize();
    StopProcessing();
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormDemo::SpeedButtonReadImageClick(TObject *Sender)
{
  if (!SaveDialog->Execute())
    return;

  F2kCheck(F2kInitialize());
  __try
  {
    StartProcessing("Reading ");
    F2kCheck(F2kSetFloppyParamsToZSK());

    HANDLE FloppyDevice = CreateFile("\\\\.\\A:", GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    HANDLE DiskDevice = CreateFile((SaveDialog->FileName).c_str(), GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
    __try
    {
      for (int Track = 0; Track <= 79; ++Track)
        for (int Side = 0; Side <= 1; ++Side)
        {
          char Buffer[16 * 256];
          DWORD ReadBytes, WriteBytes;

          if (!ReadFile(FloppyDevice, Buffer, sizeof(Buffer), &ReadBytes, NULL))
            throw Exception("Can't read: " + SysErrorMessage(GetLastError()));

          if (ReadBytes != sizeof(Buffer))
            throw Exception("Can't read");

          if (!WriteFile(DiskDevice, Buffer, sizeof(Buffer), &WriteBytes, NULL))
            throw Exception("Can't write: " + SysErrorMessage(GetLastError()));

          if (WriteBytes != sizeof(Buffer))
            throw Exception("Can't write");

          ShowProgress("Reading ", 100 * (Track * 2 + (Side + 1)) / 160);
        }
     }
    __finally
    {
      CloseHandle(FloppyDevice);
      CloseHandle(DiskDevice);
    }
  }
  __finally
  {
    F2kRestoreFloppyParams();
    F2kUninitialize();
    StopProcessing();
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormDemo::SpeedButtonWriteImageClick(TObject *Sender)
{
  if (!OpenDialog->Execute())
    return;

  F2kCheck(F2kInitialize());
  __try
  {
    StartProcessing("Writing ");
    F2kCheck(F2kSetFloppyParamsToZSK());

    HANDLE FloppyDevice = CreateFile("\\\\.\\A:", GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    HANDLE DiskDevice = CreateFile((SaveDialog->FileName).c_str(), GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    __try
    {
      for (int Track = 0; Track <= 79; ++Track)
        for (int Side = 0; Side <= 1; ++Side)
        {
          char Buffer[16 * 256];
          DWORD ReadBytes, WriteBytes;

          if (!ReadFile(DiskDevice, Buffer, sizeof(Buffer), &ReadBytes, NULL))
            throw Exception("Can't read: " + SysErrorMessage(GetLastError()));

          if (ReadBytes != sizeof(Buffer))
            throw Exception("Can't read");

          if (!WriteFile(FloppyDevice, Buffer, sizeof(Buffer), &WriteBytes, NULL))
            throw Exception("Can't write: " + SysErrorMessage(GetLastError()));

          if (WriteBytes != sizeof(Buffer))
            throw Exception("Can't write");

          ShowProgress("Writing ", 100 * (Track * 2 + (Side + 1)) / 160);
        }
     }
    __finally
    {
      CloseHandle(FloppyDevice);
      CloseHandle(DiskDevice);
    }
  }
  __finally
  {
    F2kRestoreFloppyParams();
    F2kUninitialize();
    StopProcessing();
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormDemo::SpeedButtonAbortClick(TObject *Sender)
{
  Aborted = true;
}
//---------------------------------------------------------------------------

