*--- PUBLIC DOMAIN SOFTWARE
*--- made by Branislav Stofko Trebisovska 21   821 01 Bratislava  Slovakia
*--- http://www.geocites.com/SiliconValley/Peaks/6312
*--- This source code for database compiler FORCE may bee freelly modified
*--- and after them translated with other compilers. Please remove my name,
*--- from source, if you make any modifications.
*--- I am not responsible for any damages made in with this code.
*---
#include fileio.hdr
#include string.hdr
#include system.hdr
*-------------------
PROCEDURE FORCE_MAIN
PARAMETERS CONST CHAR(127) Cmnd_line
*-------------------
VARDEF
  UINT      Blanks, Increment, Position_of_then, Line_counter, Line_length
  FILE      Input_handle, Output_handle
  CHAR(3)   File_extension
  CHAR(4)   Previous_line
  CHAR(8)   Short_name
  CHAR(12)  Full_name
  CHAR(255) Original_line, Uppercase_line
  LOGICAL   Structure_on, Second_line, Virgin
ENDDEF
*--- this is the best solution (default)
Increment     = 3
Virgin        = .T.
Structure_on  = .F.
Previous_line = ""
*--- get file_name and increment from command line
Uppercase_line = UPPER(TRIM(Cmnd_line))
*--- separate file extension, if any
Blanks = AT(".",Uppercase_line)
IF Blanks > 0
  File_extension = TRIM(SUBSTR(Uppercase_line,Blanks+1,3))
ELSE
  File_extension = "BAS"
ENDIF
*--- determine if there is a INCREMENT switch
Blanks = AT("/I:",Uppercase_line)
IF Blanks > 0
  Increment = I_val(SUBSTR(Uppercase_line,Blanks+3,1))
ENDIF
*--- determine if there is a STRUCTURE switch
Blanks = AT("/S",Uppercase_line)
IF Blanks > 0
  Structure_on = .T.
ENDIF
*--- now get file_name from command line
*--- really max. 8 chars are copied because Short_name has length 8 !!!
Short_name = Uppercase_line
*--- strip out eventually extension
Blanks = AT(".",Short_name)
IF Blanks > 0
  Short_name = SUBSTR(Short_name,1,Blanks-1)
ENDIF
*--- first character "/" ends the file name
Blanks = AT("/",Short_name)
IF Blanks > 0
  Short_name = SUBSTR(Short_name,1,Blanks-1)
ENDIF
*--- I hope we have at end some name
IF Short_name = ""
  ? " Visual Basic source file reformatter       FREEWARE B.Stofko"
  ?
  ? " Syntax: VBF <filename> [options]"
  ?
  ? " Options: /I:n  use increment of n blanks for indent, default = 3"
  ? " Options: /S    generate comment lines before and after SUB or FUNCTION"
  ? " Output:        the same filename !!!"
  ?
ELSE
  *--- the name is defined, but I dont know if really exist
  Full_name = Short_name + "." + File_extension
  IF EXIST(Full_name)
    IF F_open(Input_handle, Full_name ,&F_read)
      *--- the same name but with extension .LST will be created
      IF F_open(Output_handle,Short_name+".LST",&F_create)
        Blanks = 0
        Line_counter = 0
        *--- go thru whole input file
        DO WHILE .NOT. F_eof(Input_handle)
          IF F_getln(Input_handle,Original_line)
            *--- strip out spaces from begin and end of line
            Original_line = LTRIM(TRIM(Original_line))
            *--- convert to UPPER CASE characters
            Uppercase_line = UPPER(Original_line)
            *--- give my some signals
            IF Line_counter = 10
              ?? "X"
              Line_counter = 0
            ELSE
              Line_counter = Line_counter + 1
            ENDIF
            *--- END must be proccesed before output
            IF AT("END",Uppercase_line) = 1
              IF Blanks => Increment
                Blanks = Blanks - Increment
              ENDIF
            ENDIF
            *--- ELSE too , but after output of line go back please
            IF AT("ELSE",Uppercase_line) = 1
              IF Blanks => Increment
                Blanks = Blanks - Increment
              ENDIF
            ENDIF
            *--- NEXT must be proccesed before output
            IF AT("NEXT",Uppercase_line) = 1
              IF Blanks => Increment
                Blanks = Blanks - Increment
              ENDIF
            ENDIF
            *--- WEND must be proccesed before output
            IF AT("WEND",Uppercase_line) = 1
              IF Blanks => Increment
                Blanks = Blanks - Increment
              ENDIF
            ENDIF
            *--- LOOP must be proccesed before output
            IF AT("LOOP",Uppercase_line) = 1
              IF Blanks => Increment
                Blanks = Blanks - Increment
              ENDIF
            ENDIF
            Second_line = .F.
            *--- function can be PRIVATE, strip this word out
            IF AT("PRIVATE ",Uppercase_line) = 1
              Uppercase_line = SUBSTR(Uppercase_line,9,255)
            ENDIF
            *--- if STRUCTURE ON make first additionally line
            *--- before and after SUB or FUNCTION
            IF AT("SUB ",Uppercase_line) = 1 .OR. AT("FUNCTION ",Uppercase_line) = 1
              *--- but only if is this wanted too
              IF Structure_on
                Line_length = Blanks + LEN(Original_line) - 1
                *--- make no addionally line if there was before !!!
                *--- may be some peoples are reformating source code twice
                IF Previous_line <> "'---"
                  F_putln(Output_handle,"'"+REPLICATE("-",Line_length))
                  Second_line = .T.
                ENDIF
              ENDIF
            ENDIF
            *--- and this is all for this moment
            IF Virgin
              *--- first line should not be preceeded with CR + LF
              *--- this is only one place for use F_put instead F_putln
              *--- otherwise will be after every reformatting a new blank
              *--- line created
              F_put(Output_handle,REPLICATE(" ",Blanks)+Original_line)
              Virgin = .F.
            ELSE
              F_putln(Output_handle,REPLICATE(" ",Blanks)+Original_line)
            ENDIF
            *--- only 4 character are really stored for next comparision
            Previous_line = Original_line
            *--- if STRUCTURE ON make second extra line after if wanted
            IF Second_line
              F_putln(Output_handle,"'"+REPLICATE("-",Line_length))
            ENDIF
            *--- set new position of next line after some words
            IF AT("TYPE",Uppercase_line) = 1
              Blanks = Blanks + Increment
            ENDIF
            IF AT("ELSE",Uppercase_line) = 1
              Blanks = Blanks + Increment
            ENDIF
            IF AT("SELECT",Uppercase_line) = 1
              Blanks = Blanks + Increment
            ENDIF
            IF AT("FOR ",Uppercase_line) = 1
              Blanks = Blanks + Increment
            ENDIF
            IF AT("WHILE",Uppercase_line) = 1
              Blanks = Blanks + Increment
            ENDIF
            IF AT("BEGIN",Uppercase_line) = 1
              Blanks = Blanks + Increment
            ENDIF
            *--- for DO WHILE check DO and WHILE
            IF AT("DO",Uppercase_line) = 1 .AND. AT("WHILE",Uppercase_line) > 1
              Blanks = Blanks + Increment
            ENDIF
            *--- IF x = 1 THEN y = 1 dont needs some increments
            Position_of_then = LEN(Uppercase_line) - 3
            IF AT("IF",Uppercase_line) = 1 .AND. ;
              AT("THEN",Uppercase_line) = Position_of_then
              Blanks = Blanks + Increment
            ENDIF
          ELSE
            ?
            ?? "Sorry, read error has been detected"
          ENDIF
          *--- next line please
        ENDDO
        *--- close both files
        F_close(Output_handle)
      ENDIF
      F_close(Input_handle)
      ? " "
      *--- and now will be new file renamed to one one
      ERASE Full_name
      RENAME Short_name + ".LST" TO Full_name
    ENDIF
  ELSE
    ? "Source file "
    ?? Full_name
    ?? " not found !"
  ENDIF
ENDIF
ENDPRO

