*--- PUBLIC DOMAIN SOFTWARE
*--- made by Branislav Stofko Trebisovska 21   821 01 Bratislava  Slovakia
*--- This source code for database compiler FORCE may bee freelly modified
*--- and after them translated with other compilers. Please remove my name,
*--- from source, if you make any modifications.
*--- I am not responsible for any damages made in with this code.
*---
#include bslib.hdr
#include bsnetw.hdr
#include bsdos.hdr

#include data.hdr
#include io.hdr
#include string.hdr
#include system.hdr
#include JDdos.hdr

*-----------------------------------------------------------------------------
*  This program can show all drives and their capacity and free space.
*  FORCE programing language gives me possibility to use TASM /ASM/ and
*  Turbo C /TC/ for solving some problems there are not ideally for FORCE.
*
* ASM   - Ukazuj_hodiny()       show clock
* FORCE - TODAY()               date
* JD    - Drivestr()            all drives
* ASM   - Flopytype()           floppy drive capacity
* ASM   - Is_ramdisk()          no comment
* ASM   - Is_cdrom()            no comment
* ASM   - Net_drive()           net drive name \\SERVER\DATA
* JD    - Get_vol()             volume label
* TC    - Pad()                 pad string with spaces
* JD    - Disksize()            no comment
* JD    - Diskfree()            no comment
* FORCE - DELAY()               time delay
* ASM   - Zrus_hodiny()         disable clock
*
* JD is Jeff Davis library for FORCE

*--- problems
* label of CDROM is not displayed                              - SOLVED
* If isnt label of disk present bad position of collumns       - SOLVED
* incorrect display of CDROM parameters                        - SOLVED
* RAM disk is not correctly reported , please give mee message, I have
* not any RAM disk in MY machine

*-------------------
PROCEDURE FORCE_MAIN
*-------------------

VARDEF
  INT       Floppy_type
  UINT      I, Nr_of_drives
  ULONG     Total_capacity, Free_space
  Dbl(14:2) Percentually
  CHAR(1)   Drive_character
  CHAR(7)   Drive_type
  CHAR(26)  All_drives_string
  CHAR(127) Network_name
ENDDEF
*---
SET Date GERMAN   && DD.MM.YY is normally for Europe
SET CENTURY ON    && remember 2000 is comming in next few years
CURSOR_OFF        && cursor is not usefull for mee
__COLOR_STD = 31
*Ukazuj_hodiny(1,40,.T.) && show clock
*--- main loop
DO WHILE .T.
  __COLOR_STD = 31
  CLEAR
  *--- header
  ? "  Disk    Typ                "
  ?? TODAY()
  ?? "            Total          Free"
  ? " "
  *--- check all drives, floppy too
  All_drives_string = Drivestr(.T.)
  *--- how namy disks we have today
  Nr_of_drives = LEN(All_drives_string)
  *--- show all drives, secondary loop
  FOR I = 1 TO Nr_of_drives
    Drive_character = SUBSTR(All_drives_string,I,1)
    Floppy_type = Flopytype(Drive_character)
    Network_name = ""
    __COLOR_STD = 30
    *--- flopy drives without LABEL and capacity info
    DO CASE
      CASE Floppy_type = 0
        * neznmy typ mechaniky, alebo mechanika A nie intalovan
        Drive_type = " Unkown"
      CASE Floppy_type = 1
        * ak je mechanika   5 palcov s kapacitou 360 kB
        Drive_type = " 360 kB"
      CASE Floppy_type = 2
        * ak je mechanika   5 palcov s kapacitou 1.2 MB
        Drive_type = " 1.2 MB"
      CASE Floppy_type = 3
        * ak je mechanika 3.5 palcov s kapacitou 720 kB
        Drive_type = " 720 kB"
      CASE Floppy_type = 4
        * ak je mechanika 3.5 palcov s kapacitou 1.44 MB
        Drive_type = "1.44 MB"
      CASE Floppy_type = 5
        * doteraz neznma kombincia
        Drive_type = "       "
      CASE Floppy_type = 6
        * ak je mechanika 3.5 palcov s kapacitou 2.88 MB
        Drive_type = "2.88 MB"
        *--- this is not a floppy
      CASE Floppy_type = -1
        Network_name = Get_vol(Drive_character)
        IF Is_ramdisk(Drive_character)
          __COLOR_STD = 29
          Drive_type = "  ram  "
        ELSE
          IF Is_cdrom(Drive_character)
            __COLOR_STD = 27
            Drive_type = " cdrom "
          ELSE
            Network_name = Net_drive(Drive_character)
            IF Network_name = "DISCONNECTED"
              __COLOR_STD = 28
              Drive_type = " netw  "
            ELSE
              IF Network_name = ""
                __COLOR_STD = 31
                Drive_type = " local "
                Network_name = Get_vol(Drive_character)
              ELSE
                __COLOR_STD = 26
                Drive_type = " netw  "
                Network_name = Network_name + "  " + Get_vol(Drive_character)
              ENDIF
            ENDIF
          ENDIF
        ENDIF
    ENDCASE
    *--- and now show me results
    ? "   "
    ?? Drive_character
    ?? ":  "
    ?? Drive_type
    ?? "  "
    ?? Pad(Network_name,32)
    ?? "  "
    *--- if is not a floppy
    IF Floppy_type = -1
      Total_capacity = Disksize(Drive_character)
      Free_space = Diskfree(Drive_character)
      Percentually = Free_space
      Percentually = Percentually/Total_capacity
      Percentually = Percentually*100
      ?? Total_capacity
      ?? " "
      ?? Free_space
      ?? " "
      ?? STR(Percentually,5,1)
      ?? " %"
    ENDIF
  NEXT
  *--- wait 30 seconds and go back to loop
  I = DELAY(30)
  *--- if ESC key hit, bye bye
  IF LASTKEY() = 27
    EXIT
  ENDIF
ENDDO
*--- final but neccesary things
*Zrus_hodiny()  && clock must be disabled , it was connected to INTerupt
CURSOR_ON
__COLOR_STD = 7
CLEAR
ENDPRO
