<?

// Core engine class / base functions
class CEngine extends CAuth
{

   // Constructor, sets the all variables
   function CEngine()
   {
   $this->CAuth();
   if (!defined("TEMPDIR")) define("TEMPDIR","./");
   @include(TEMPDIR."variables.php");
   @include(TEMPDIR."settings.php");
   $this->server=$server;
   $this->path=$path;
   $this->pathimages=$pathimages;
   $this->pathfiles=$pathfiles;
   $this->timeout=$timeout;
   $this->dbserver=$dbserver;
   $this->dbuser=$dbuser;
   $this->dbpass=$dbpass;
   $this->dbname=$dbname;
   $this->tableprefixmod=$tableprefixmod;
   $this->table[0]=$tableprefix.$table[0];
   $this->table[1]=$tableprefix.$table[1];
   $this->table[2]=$tableprefix.$table[2];
   $this->table[3]=$tableprefix.$table[3];
   $this->table[4]=$tableprefix.$table[4];
   $this->table[4]=$tableprefix.$table[4];
   $this->table[5]=$tableprefix.$table[5];
   $this->table[6]=$tableprefix.$table[6];
   $this->table[8]=$tableprefix.$table[8];
   $this->table[9]=$tableprefix.$table[9];
   $this->table[10]=$tableprefix.$table[10];
   $this->table[7]=$tableprefix.$table[7];
   $this->table[8]=$tableprefix.$table[8];
   $this->emailwebmaster=$emailwebmaster;
   $this->cleanurls=$cleanurls;
   $this->sizemaximages=$sizemaximages;
   $this->thumbwidth=$thumbwidth;
   $this->thumbheight=$thumbheight;
   $this->jpegquality=$jpegquality;
   $this->sizemaxfiles=$sizemaxfiles;
   $this->uploadforbid=$uploadforbid;
   $this->surveyblocktime=$surveyblocktime;
   $this->dateformat=$dateformat;
   $this->charset=$charset;
   $this->textbasic=$textbasic;
   $this->textwarning=$textwarning;
   if (imagetypes() & IMG_GIF)
      {
      $this->GIFSupport=1;
      }
   if (imagetypes() & IMG_JPG)
      {
      $this->JPGSupport=1;
      }
   if (imagetypes() & IMG_PNG)
      {
      $this->PNGSupport=1;
      }
   }

   // Initializes engine - connects to database and selects user language
   function EngineInitialize()
   {
   $this->DBConnect();
   $this->DBQuery("SELECT * FROM ".$this->table[5]." WHERE user='".$this->username."'");
   $this->DBGetRow();
   $languagedef=$this->access["language"];
   if (!$languagedef) $languagedef="EN";
   $languagedef=strtolower($languagedef);
   $file="variables-".$languagedef.".php";
   if ($file=="variables-en.php") $file="variables.php";
   if (file_exists(TEMPDIR.$file)) @include(TEMPDIR.$file); else @include(TEMPDIR.'variables.php');
   // Re-initialize variables to match user language
   $this->charset=$charset;
   $this->textbasic=$textbasic;
   $this->textwarning=$textwarning;
   // Retrieve settings for modules
   $this->DBQuery("SELECT * FROM ".$this->table[8]." ORDER BY module");
   while ($this->DBGetRow())
         {
         $directory=$this->access["directory"];
         $messagename="text".$directory;
         $tablename="table".$directory;
         $variablename="var".$directory;
         $file="variables-".$languagedef.".php";
         if ($file=="variables-en.php") $file="variables.php";
         if (file_exists(TEMPDIR.'modules/'.$directory.'/'.$file))
            {
            @include(TEMPDIR.'modules/'.$directory.'/'.$file);
            }
         elseif (file_exists(TEMPDIR.'modules/'.$directory.'/'.'variables.php'))
            {
            @include(TEMPDIR.'modules/'.$directory.'/'.'variables.php');
            }
         $this->charset=$charset;
         $this->$messagename=$$messagename;
         if (file_exists(TEMPDIR.'modules/'.$directory.'/'.'settings.php'))
            {
            @include(TEMPDIR.'modules/'.$directory.'/'.'settings.php');
            // Create object variables for DB tables
            foreach ($$tablename as $key=>$value)
                 {
                 $this->{$tablename}[$key]=$this->tableprefixmod.$value;
                 }
            // Create object variables for additional settings variables
            if (is_array($$variablename))
               {
               foreach ($$variablename as $key=>$value)
                       {
                       $this->{$variablename}[$key]=$value;
                       }
               }
            }
         }
   }

   // Displays basic information about Absolut Engine
   function EngineInfo()
   {
   echo '<pre>';
   echo '<strong>Absolut Engine</strong> by <a href="mailto:dusoft@staznostiNOSPAM.sk">dusoft</a><br />';
   echo '<strong>Author:</strong> Daniel Duris<br />';
   echo '<strong>Version:</strong> '.AE_VERSION.'<br />';
   echo '<strong>Download:</strong> <a href="http://www.absolutengine.com" title="Absolut Engine Website">www.absolutengine.com</a><hr>';
   echo '<strong>Support, questions, ideas, comments and general info at author\'s email or:</strong><br />';
   echo 'All about Absolut Engine mailing list at all-about@absolutengine.com<br />';
   echo 'subscribe at <a href="mailto:majordomo@absolutengine.com?body=subscribe all-about" title="Subscribe to all-about mailing list">majordomo@absolutengine.com</a> - in the body of email insert:<br />';
   echo 'subscribe all-about<br />';
   }

   // Displays error message and stops execution of the script
   function DisplayError($errorcode,$before="",$after="",$modulename="")
   {
   $noback=TRUE;
   @include(TEMPDIR."header.php");
   echo '<img src="',TEMPDIR,'images/error.gif" alt="!" class="errorimage"><div id="errormessage">';
   echo '<strong>';
   if (!$modulename)
      {
      echo $before." ".$this->textwarning[$errorcode]." ".$after;
      }
   else
      {
      $variablename="text".$modulename;
      echo $before." ".$this->{$variablename}[$errorcode]." ".$after;
      }
   echo '</strong>';
   if ($errorcode<>1) echo '<form action="javascript:history.go(-1)"><p><input type="submit" value="&lt;= ',$this->textbasic[29],' " class="button" /></p></form>';
   echo '</div>';
   $nologout=TRUE;
   @include(TEMPDIR."footer.php");
   exit;
   }

   // Performs date conversion from custom date format to MySQL date format and back
   // from form to MySQL $direction=1, from MySQL to form $direction=2
   function DateConversion($adate,$direction=1)
   {
   if (!$adate) return;
   $this->dateformat=strtoupper($this->dateformat); // Makes sure it's UPPERCASE
   if ($direction==1)
      {
      for ($i=32;$i<48;$i++)
      {
      $delimiter=strpos($this->dateformat,chr($i));
      if ($delimiter) break;
      }
      $delimiter=chr($i); // Get the delimiter used
      $formatparts=explode($delimiter,$this->dateformat);
      $adateparts=explode($delimiter,$adate);
      for ($i=0;$i<=2;$i++)
          {
          if ($formatparts[$i]=="DD") $day=sprintf("%02d",$adateparts[$i]);
          if ($formatparts[$i]=="MM") $month=sprintf("%02d",$adateparts[$i]);
          if ($formatparts[$i]=="YYYY") $year=$adateparts[$i];
          }
      $day=trim($day);
      $month=trim($month);
      $year=trim($year);
      $adate="$year-$month-$day";
      }
   else
      {
      $year=strval(substr($adate,0,4));
      $month=strval(substr($adate,5,2));
      $day=strval(substr($adate,8,2));
      $adate=str_replace("DD",$day,$this->dateformat);
      $adate=str_replace("MM",$month,$adate);
      $adate=str_replace("YYYY",$year,$adate);
      }
   return $this->adate=$adate;
   }

   // Checks for file handling error and stops the script of needed
   function FileError()
   {
   if (!$this->error) $this->DisplayError(22,""," ".$this->emailwebmaster);
   }

   // Uploads file
   function SubmitFile($file,$filenametmp,$number)
   {
   $testnumber=0;
   $fileparts=explode(".",$file);
   $extforbid=explode(",",$this->uploadforbid);
   $filename=$fileparts[0];
   $extension=$fileparts[1];
   for ($i=0;$i<=count($extforbid);$i++) if ($extforbid[$i]==$extension) $this->DisplayError(23,"#".($number+1)," ".$this->sizemaxfiles);
   $filename=ereg_replace('&#([0-9]{1,10});','',$filename);
   $filename=strtr($filename," 㥹弾","-AAACEEIIOOOUUYsaaaceeiiooouuyAaAaCcCcDdDdEeEeLlLlLlNnNnOoRrRrSsSsSsTtTtUuUuZzZzZz");
   for ($i=0;$i<=strlen($filename);$i++)
       {
       if (ord($filename[$i])<32 OR (ord($filename[$i])>=33 AND ord($filename[$i])<=44) OR (ord($filename[$i])>=46 AND ord($filename[$i])<=47) OR (ord($filename[$i])>=58 AND ord($filename[$i])<=64) OR (ord($filename[$i])>=91 AND ord($filename[$i])<=94) OR ord($filename[$i])==96 OR ord($filename[$i])>122)
          {
          $filename=substr($filename,0,$i).substr($filename,$i+1,strlen($filename));
          }
       }
   $filename=str_replace('---','-',$filename);
   $filename=str_replace('--','-',$filename);
   $filename=strtolower($filename);
   $filename.=".".$extension;
   while (file_exists($this->pathfiles.$filename))
         {
         $filename=$fileparts[0]."-".$testnumber.".".$extension;
         $testnumber++;
         }
   @$this->error=copy($filenametmp,$this->pathfiles.$filename);
   $this->FileError();
   return $this->filename=$filename;
   }

   // Deletes a file
   function DeleteFile($file)
   {
   if (file_exists($this->pathfiles.$file))
      {
      @$this->error=unlink($this->pathfiles.$file);
      $this->FileError();
      }
   }

   // Submits image and crates thubmnail for it
   function SubmitImage($file,$filetype,$number)
   {
   if ($filetype=="image/gif" AND !$this->GIFSupport)
      {
      $this->imageextension="GIF";
      $this->DisplayError(24,$this->imageextension);
      }
   elseif (($filetype=="image/jpeg" OR $filetype=="image/pjpeg") AND !$this->JPGSupport)
          {
          $this->imageextension="JPEG";
          $this->DisplayError(24,$this->imageextension);
          }
   elseif ($filetype=="image/png" AND !$this->PNGSupport)
          {
          $this->imageextension="PNG";
          $this->DisplayError(24,$this->imageextension);
          }
   if ($filetype=="image/gif") $extension=".gif";
   elseif ($filetype=="image/jpeg" OR $filetype=="image/pjpeg") $extension=".jpg";
   elseif ($filetype=="image/png") $extension=".png";
   else $this->DisplayError(20,"#".($number+1)," ".$this->sizemaximages);
   $timestamp=Date("dmYHis");
   $filename=$timestamp."-".$number.$extension;
   @$this->error=copy($file,$this->pathimages.$filename);
   $this->FileError();
   if ($extension==".gif") $image=imagecreatefromgif($this->pathimages.$filename);
   if ($extension==".jpg") $image=imagecreatefromjpeg($this->pathimages.$filename);
   if ($extension==".png") $image=imagecreatefrompng($this->pathimages.$filename);
   $width=imagesx($image); $height=imagesy($image);
   $thumbw=$width; $thumbh=$height;
   while ($thumbw>$this->thumbwidth AND $thumbh>$this->thumbheight) { $thumbw=$thumbw/1.1; $thumbh=$thumbh/1.1; }
   $image2=imagecreatetruecolor($thumbw,$thumbh);
   imagecopyresampled($image2,$image,0,0,0,0,$thumbw,$thumbh,$width,$height);
   $filename=$timestamp."-".$number."a".$extension;
   if ($extension==".gif")
      {
      $this->error=imagegif($image2,$this->pathimages.$filename);
      $this->FileError();
      }
   if ($extension==".jpg")
      {
      $this->error=imagejpeg($image2,$this->pathimages.$filename,$this->jpegquality);
      $this->FileError();
      }
   if ($extension==".png")
      {
      $this->error=imagepng($image2,$this->pathimages.$filename);
      $this->FileError();
      }
   imagedestroy($image);
   imagedestroy($image2);
   return $this->filename=$timestamp."-".$number.$extension;
   }

   // Deletes image and its thumbnail:
   function DeleteImage($file)
   {
   if (file_exists($this->pathfiles.$file))
      {
      @$this->error=unlink($this->pathimages.$file);
      $this->FileError();
      }
   $file=substr($file,0,-4)."a".substr($file,-4,4);
   if (file_exists($file))
      {
      @$this->error=unlink($this->pathimages.$file);
      $this->FileError();
      }
   }

   // Gets thumbnail name from image file
   function GetThumbnail($image)
   {
   return $thumbnail=substr($image,0,-4)."a".substr($image,-4,4);
   }

   // Creates array of messages translations available
   function RequestLanguageVersions()
   {
   $i=0;
   @$dirhandle=opendir(".");
   while (@$languageversion=readdir($dirhandle))
         {
         if (substr($languageversion,0,9)=="variables")
            {
            $languageversion=substr($languageversion,10,2);
            if ($languageversion=="ph")
               {
               $languageversion="en";
               }
            $languagearray[$i]=strtoupper($languageversion);
            }
         ++$i;
         }
   @closedir($dirhandle);
   sort($languagearray);
   reset($languagearray);
   return $this->languagearray=$languagearray;
   }

   // Genereates physical files from articles if $cleanurls set to 1
   function GeneratePhysicalFile($articleID)
   {
   $content=join('',file('../showarticle.php'));
   $content=str_replace('$aepublic->articleID',$articleID,$content);
   $this->filename=str_replace('.php','',$this->filename);
   if (!$this->filename)
      {
      $this->filename=$this->title;
      }
   $this->filename=ereg_replace('&#([0-9]{1,10});','',$this->filename);
   $this->filename=strtr($this->filename," 㥹弾","-AAACEEIIOOOUUYsaaaceeiiooouuyAaAaCcCcDdDdEeEeLlLlLlNnNnOoRrRrSsSsSsTtTtUuUuZzZzZz");
   for ($i=0;$i<=strlen($this->filename);$i++)
       {
       if (ord($this->filename[$i])<32 OR (ord($this->filename[$i])>=33 AND ord($this->filename[$i])<=44) OR (ord($this->filename[$i])>=46 AND ord($this->filename[$i])<=47) OR (ord($this->filename[$i])>=58 AND ord($this->filename[$i])<=64) OR (ord($this->filename[$i])>=91 AND ord($this->filename[$i])<=94) OR ord($this->filename[$i])==96 OR ord($this->filename[$i])>122)
          {
          $this->filename=substr($this->filename,0,$i).substr($this->filename,$i+1,strlen($this->filename));
          }
       }
   $this->filename=str_replace('---','-',$this->filename);
   $this->filename=str_replace('--','-',$this->filename);
   $this->filename.=".php";
   $this->filename=strtolower($this->filename);
   @$this->error=$handle=fopen('../'.$this->filename,'wb');
   $this->FileError();
   @$this->error=fwrite($handle,$content);
   $this->FileError();
   @$this->error=fclose($handle);
   $this->FileError();
   }

   function DeletePhysicalFile($articleID)
   {
   $this->DBQuery("SELECT filename FROM ".$this->table[3]." WHERE ID='".$articleID."'");
   $this->DBGetRow();
   $filename=$this->access["filename"];
   if ($filename AND file_exists('../'.$filename))
      {
      @$this->error=unlink('../'.$filename);
      $this->FileError();
      }
   }

   // WYSIWYG (Rich text editor) function for safe code inserting into RTE form
   function RTESafe($strText)
   {
	//returns safe code for preloading in the RTE
	$tmpString = trim($strText);
	//convert all types of single quotes
	$tmpString = str_replace(chr(145), chr(39), $tmpString);
	$tmpString = str_replace(chr(146), chr(39), $tmpString);
	$tmpString = str_replace("'", "&#39;", $tmpString);
	//convert all types of double quotes
	$tmpString = str_replace(chr(147), chr(34), $tmpString);
	$tmpString = str_replace(chr(148), chr(34), $tmpString);
   //	$tmpString = str_replace("\"", "\"", $tmpString);
	//replace carriage returns & line feeds
	$tmpString = str_replace(chr(10), " ", $tmpString);
	$tmpString = str_replace(chr(13), " ", $tmpString);
	return $tmpString;
   }

   // Cleans up the HTML code created by WYSIWYG editor (Richt text editor)
   // Tries to make the code XHTML 1.0 Strict (web standards compliant)
   function WYSIWYGtoXHTML($text)
   {
   $text=stripslashes($text);
   $length=strlen($text);
   // Make HTML tags lowercase
   for ($i=0;$i<=$length;$i++)
       {
       if ($text[$i]=="<")
          {
          while ($text[$i]<>">")
                {
                if (substr($text,$i,4)=="href" OR substr($text,$i,4)=="HREF")
                   {
                   $text=substr_replace($text,'href',$i,4);
                   $i=$i+6;
                   while ($text[$i]<>'"')
                         {
                         $i++;
                         }
                   continue;
                   }
                if (substr($text,$i,5)=="title" OR substr($text,$i,5)=="TITLE")
                   {
                   $text=substr_replace($text,'title',$i,5);
                   $i=$i+7;
                   while ($text[$i]<>'"')
                         {
                         $i++;
                         }
                   continue;
                   }
                if (substr($text,$i,3)=="alt" OR substr($text,$i,3)=="ALT")
                   {
                   $text=substr_replace($text,'alt',$i,3);
                   $i=$i+5;
                   while ($text[$i]<>'"')
                         {
                         $i++;
                         }
                   continue;
                   }
                if (substr($text,$i,8)=="longdesc" OR substr($text,$i,8)=="LONGDESC")
                   {
                   $text=substr_replace($text,'longdesc',$i,8);
                   $i=$i+10;
                   while ($text[$i]<>'"')
                         {
                         $i++;
                         }
                   continue;
                   }
                $text[$i]=strtolower($text[$i]);
                $i++;
                }
          }
       }
   $conversiontable=array(
                         '<br>'=>'<br />',
                         '<hr>'=>'<hr />',
                         '<b>'=>'<strong>',
                         '</b>'=>'</strong>',
                         '<i>'=>'<em>',
                         '</i>'=>'</em>',
                         '<u>'=>'<span style="text-decoration: underline;">',
                         '</u>'=>'</span>',
                         '<font'=>'<span',
                         '</font>'=>'</span>',
                         'size="1"'=>'style="font-size: xx-small;"',
                         'size="2"'=>'style="font-size: x-small;"',
                         'size="3"'=>'style="font-size: small;"',
                         'size="4"'=>'style="font-size: medium;"',
                         'size="5"'=>'style="font-size: large;"',
                         'size="6"'=>'style="font-size: x-large;"',
                         'size="7"'=>'style="font-size: xx-large;"',
                         '&nbsp;'=>' ',
                         ' class="msonormal"'=>'',
                         ' class="sonormal"'=>'',
                         '<?xml:namespace prefix ="o" ns =""urn:schemas-microsoft-com:office:office"" />'=>'',
                         '<o:p></o:p>'=>''
                         );
   // Pre-processing - add quotes to enclose attributes in HTML tags (only IE)
   // change HTML tags as per conversion table
   $browser=$_SERVER['HTTP_USER_AGENT'];
   if (strpos($browser,'MSIE')===TRUE) $text=ereg_replace('=([^\ |^>]+)','="\\1"',$text);
   while (eregi('&nbsp;&nbsp;',$text))
         {
         $text=ereg_replace('&nbsp;&nbsp;','&nbsp;',$text);
         }
   $text=strtr($text,$conversiontable);
   // Processing - change few tags with values
   $text=ereg_replace('<img ([^>]+)>','<img \\1 />"',$text);
   $text=ereg_replace(' valign="([^"]+)"','',$text);
   $text=ereg_replace('align="([^"]+)"','style="text-align: \\1;"',$text);
   $text=ereg_replace('face="([^"]+)"','style="font-family: \\1;"',$text);
   $text=ereg_replace('color="([^"]+)"','style="color: \\1;"',$text);
   $text=ereg_replace('border="([^"]+)"','style="border: \\1px;"',$text);
   $text=ereg_replace('cellpadding="([^"]+)"','style="padding: \\1px;"',$text);
   $text=ereg_replace(' cellspacing="([^"]+)"','',$text);
   $text=ereg_replace(' lang="([^"]+)"','',$text);
   $text=ereg_replace(' style="mso-([^"]+)"','',$text);
   $text=str_replace('<b style="">','<strong>',$text);
   // Post-processing - redundant tag attributes are joined into one tag
   // comment tags, empty paragraphs and span tags are removed
   $text=ereg_replace('<!--([^>]+)>','',$text);
   while (eregi('style="([^"]+)" style="([^"]+)"',$text))
         {
         $text=ereg_replace('style="([^"]+)" style="([^"]+)"','style="\\1 \\2"',$text);
         }
   while (eregi('<span style="([^"]+)"><span style="([^"]+)">([^<]+)</span></span>',$text))
         {
         $text=ereg_replace('<span style="([^"]+)"><span style="([^"]+)">([^<]+)</span></span>','<span style="\\1 \\2">\\3</span>',$text);
         }
   // while (eregi('style="\s([A-Za-z]+)\s"'
   $text=ereg_replace('style="\s([A-Za-z]+)\s"','\\1',$text);
   $text=ereg_replace('<span>([^>]+)</span>','\\1',$text);
   $text=ereg_replace('<span></span>','',$text);
   $text=ereg_replace('<span>[ ]{1,}</span>','',$text);
   $text=ereg_replace('<span[^>]+></span>','',$text);
   $text=ereg_replace('<span[^>]+>[ ]{1,}</span>','',$text);
   $text=ereg_replace('<span[^>]+>(.[^<]+)</span>','\\1',$text);
   while (eregi('<p[^>]+></p>',$text))
         {
         $text=ereg_replace('<p[^>]+></p>','',$text);
         }
   $text=ereg_replace('<p[^>]+>[ ]{1,}</p>','',$text);
   /*
   // NOT FINISHED YET
   // Post-processing - double breaks are converted to paragraphs
   $text=str_replace('<br /><br />','</p><p>',$text);
   // paragraph counting is done to ensure both opening and closing tags are present
   $parcount=0;
   for ($i=0;$i<=$length;$i++)
       {
       if ($text[$i]=="<")
          {
          if ($text[$i+1]=='p' AND $text[$i+2]=='>') $parcount++;
          if ($text[$i+1]=='/' AND $text[$i+2]=='p') $parcount--;
          $i=$i+2;
          }
       if ($parcount<0)
          {
          // find position where opening paragraph tag should be inserted
          }
       }
   */
   $text=addslashes($text);
   return $text;
   }

   // Searches for modules available in the system
   function RetrieveModules()
   {
   $this->DBQuery("DELETE FROM ".$this->table[8]);
   @$dirhandle=opendir('modules/');
   while ((@$moduledir=readdir($dirhandle))!==false)
         {
         if ($moduledir=='.' OR $moduledir=='..') continue;
         if (file_exists('modules/'.$moduledir.'/module.xml'))
            {
            @$moduleinfo=join('',file('modules/'.$moduledir.'/module.xml'));
            eregi("[^<]+<name>([^<]+)</name>",$moduleinfo,$regs);
            $name=trim($regs[1]);
            $regs="";
            eregi("[^<]+<version>([^<]+)</version>",$moduleinfo,$regs);
            $version=$regs[1];
            $regs="";
            eregi("[^<]+<author>([^<]+)</author>",$moduleinfo,$regs);
            $author=$regs[1];
            $regs="";
            eregi("[^<]+<website>([^<]+)</website>",$moduleinfo,$regs);
            $website=$regs[1];
            $regs="";
            eregi("[^<]+<description>([^<]+)</description>",$moduleinfo,$regs);
            $description=$regs[1];
            }
         else continue;
         $menu1=0; $menu2=0; $menu3=0; $guestmodify=0;
         if (file_exists('modules/'.$moduledir.'/'.'menu1.php')) $menu1=1;
         if (file_exists('modules/'.$moduledir.'/'.'menu2.php')) $menu2=1;
         if (file_exists('modules/'.$moduledir.'/'.'menu3.php')) $menu3=1;
         if (file_exists('modules/'.$moduledir.'/'.'guestmodify.php')) $guestmodify=1;
         $this->DBQuery("INSERT INTO ".$this->table[8]." VALUES (NULL,'".$name."','".$version."','".$author."','".$website."','".$description."','".$moduledir."','".$menu1."','".$menu2."','".$menu3."','".$guestmodify."')");
         }
   }

   // Sets variables received through POST/GET/COOKIE (forms and links mostly)
   // Add slashes if $mode=1, strip slashes when $mode=0 (by default)
   function RequestVariables($mode=0)
   {
   // Strip slashes
   if ($mode==0)
      {
      if (!ini_get(magic_quotes_gpc))
         {
         foreach ($_COOKIE as $key=>$value)
                 {
                 $this->$key=stripslashes($_COOKIE[$key]);
                 }
         foreach ($_GET as $key=>$value)
                 {
                 $this->$key=stripslashes($_GET[$key]);
                 }
         foreach ($_POST as $key=>$value)
                 {
                 $this->$key=stripslashes($_POST[$key]);
                 }
         }
      else
         {
         foreach ($_COOKIE as $key=>$value)
                 {
                 $this->$key=$_COOKIE[$key];
                 }
         foreach ($_GET as $key=>$value)
                 {
                 $this->$key=$_GET[$key];
                 }
         foreach ($_POST as $key=>$value)
                 {
                 $this->$key=$_POST[$key];
                 }
         }
      }
   // Add slashes
   if ($mode==1)
      {
      if (!ini_get(magic_quotes_gpc))
         {
         foreach ($_POST as $key=>$value)
                 {
                 $this->$key=$_POST[$key];
                 if (!is_array($_POST[$key])) $this->$key=addslashes($this->$key);
                 }
         foreach ($_GET as $key=>$value)
                 {
                 $this->$key=$_GET[$key];
                 if (!is_array($_GET[$key])) $this->$key=addslashes($this->$key);
                 }
         }
      else
         {
         foreach ($_POST as $key=>$value)
                 {
                 $this->$key=$_POST[$key];
                 }
         foreach ($_GET as $key=>$value)
                 {
                 $this->$key=$_GET[$key];
                 }
         }
      foreach ($_FILES as $key=>$value)
              {
              $this->$key=$_FILES[$key];
              }
      }
   }

/* ****************************************************************************************
*******************************************************************************************
******************************** FUNCTIONS FOR PUBLIC PAGES *******************************
*******************************************************************************************
**************************************************************************************** */

   // Initializes variables for use in public pages
   function PublicInitialize()
   {
   $this->DBConnect();
   $this->pathimages=str_replace("../","",$this->pathimages);
   $this->pathfiles=str_replace("../","",$this->pathfiles);
   $this->DBQuery("SELECT * FROM ".$this->table[8]." ORDER BY module");
   while ($this->DBGetRow())
         {
         $directory=$this->access["directory"];
         $variablename="text".$directory;
         $tablename="table".$directory;
         $file="variables-".$languagedef.".php";
         if ($file=="variables-en.php") $file="variables.php";
         if (file_exists(TEMPDIR.'modules/'.$directory.'/'.$file))
            {
            @include(TEMPDIR.'modules/'.$directory.'/'.$file);
            }
         elseif (file_exists(TEMPDIR.'modules/'.$directory.'/'.'variables.php'))
            {
            @include(TEMPDIR.'modules/'.$directory.'/'.'variables.php');
            }
         $this->charset=$charset;
         $this->$variablename=$$variablename;
         if (file_exists(TEMPDIR.'modules/'.$directory.'/'.'settings.php'))
            {
            @include(TEMPDIR.'modules/'.$directory.'/'.'settings.php');
            foreach ($$tablename as $key=>$value)
                 {
                 $this->{$tablename}[$key]=$this->tableprefixmod.$value;
                 }
            }
         }
   }

}

?>