(* SysError - kritische Fehler auch ohne Turbo-Vision abfangen *)
(* Andres Cvitkovich / c't 04/93 / Turbo Pascal ab 6.0         *)
unit SysError;
interface
const ErrTxt: Byte = $4F;      { die Farbe fr den Fehlertext     }
      KeyTxt: Byte = $4E;      { die Farbe fr den <Tasten>-Text  }
      (*$IFDEF Ver60 *)        { Segmentadressen bzw. -Selektoren }
      Seg0040 : Word = $40;    { aus BP7 fr TP6 nachrsten       }
      SegB000 : Word = $B000;  SegB800 : Word = $B800; (*$ENDIF *)

procedure EnableHandler (What: Boolean);   { Unit (de-) aktivieren }
                                           { Default: aktiviert    }
function Enabled: Boolean;     { Gibt zurck, ob die Unit "aktiv", }
                               { entspricht Drivers.SysErrActive   }
implementation
uses Drivers, Crt;
var EGA,                            { EGA oder hher?                }
    IsEnabled: Boolean;             { Unit "aktiv"?                  }
    ExitSave: Pointer;              { ursprngliche Exit-Prozedur    }
    Lines: ^Byte;                   { Anzahl der Zeilen (ab EGA)     }
    VPort: ^Word;                   { Video-Port-Adresse (3D4h=color)}
    frame,                          { Video frame buffer address     }
    c_pos, c_shape: Word;           { Cursorposition und -form       }
    buf: Array[1..80] of Word;      { Puffer fr letzte Zeile        }

{ TestEGA - stellt fest, ob mindestens eine EGA-Karte vorhanden ist }
{ (ab EGA wird die Anzahl der Zeilen-1 in $40:$84 festgehalten)     }
function TestEGA: Boolean; assembler;
asm
    push bp       { manch altes BIOS zuerstrt BP beim Int 10h }
    mov  ah,12h   { 12h/10h: EGA info request }
    mov  bl,10h
    int  10h
    xor  al,al    { Annahme: EGA=FALSE }
    cmp  bl,10h   { bl=10h -> CGA/mono }
    je   @@1
    inc  al       { EGA=TRUE }
@@1:
    pop  bp
end;

{ SaveLine - kopiert den Bildschirmbereich der angegebenen Zeile von }
{            Zeichen 1 bis 80 (inkl. Attribut) in den Buffer "buf"   }
procedure SaveLine (line: Word);
begin Move (Ptr(frame,160*line)^, buf, SizeOf (buf)); end;

{ RestoreLine - das Komplementr zu SaveLine }
procedure RestoreLine (line: Word);
begin Move (buf, Ptr(frame,160*line)^, SizeOf (buf)); end;

{ SaveCursor - hlt die aktuelle Cursorposition in "c_pos" und }
{              das Aussehen in "c_shape" fest                  }
procedure SaveCursor; assembler;
asm
    push bp
    mov  ah,3
    mov  bh,0
    int  10h
    mov  c_pos,dx
    mov  c_shape, cx
    pop  bp
end;

{ RestoreCursor - das Komplementr zu SaveCursor }
procedure RestoreCursor; assembler;
asm
    push bp
    mov  ah,2
    xor  bh,bh
    mov  dx,c_pos
    int  10h
    mov  ah,1
    mov  cx,c_shape
    int  10h
    pop  bp
end;

{ HideCursor - lsst den Cursor verschwinden }
procedure HideCursor; assembler;
asm
    push bp
    mov  ah,1
    mov  cx,$2000
    int  10h
    pop  bp
end;

{ MySystemError - Die Systemfehler-Abfangroutine : FAR !!! }
{ notwendiger Aufbau steht im Turbo-Vision-Handbuch        }
function MySystemError(ErrorCode:Integer; Drive:Byte): Integer; far;
var Attr: Byte; c: Char;
begin
  SaveCursor;                { Cursoreigenschaften retten... }
  HideCursor;                { ...und Cursor unsichtbar machen }
  SaveLine (Lines^);         { letzte Zeile retten }
  Attr := TextAttr;          { Crt.TextAttr sichern }
  TextAttr := ErrTxt;        { Fehlerfarbe aktivieren }
  GotoXY (1, Lines^+1);      { gehe in die letzte Zeile }
  c := Chr (65+Drive);       { c als Laufwerksbuchstaben verwenden }
  case ErrorCode of
   0:  Write (' Diskette im Laufwerk ', c, ': schreibgeschtzt.   ');
   2:  Write (' Laufwerk ', c, ': ist nicht bereit.               ');
   4:  Write (' Datenfehler im Laufwerk ', c, ':                  ');
   6:  Write (' Zugriffsfehler im Laufwerk ', c, ':               ');
   7:  Write (' Unbekannter Medientyp in Laufwerk ', c, ':        ');
   8:  Write (' Laufwerk ', c, ': Sektor nicht gefunden.          ');
   9:  Write (' Kein Papier im Drucker.                     ');
   10: Write (' Schreibfehler auf Laufwerk ', c, ':               ');
   11: Write (' Lesefehler auf Laufwerk ', c, ':                  ');
   12: Write (' Hardware-Fehler auf Laufwerk ', c, ':             ');
   13: Write (' Fehlerhafte FAT auf Laufwerk ', c, ': entdeckt.   ');
   14: Write (' Zugriffsfehler auf Laufwerk ', c, ':              ');
   15: Write (' Legen Sie Diskette in Laufwerk ', c, ': ein.      ');
  else { bei 1,3,5 und fr unvorhersehbare Flle }
       Write (' Kritischer Fehler auf Laufwerk ', c, ':           ')
  end;
  TextAttr := KeyTxt;  Write ('<Enter>');
  TextAttr := ErrTxt;  Write (' Wiederholen  ');
  TextAttr := KeyTxt;  Write ('<Esc>');
  TextAttr := ErrTxt;  Write (' Abbruch');
  ClrEol;
  Repeat
    c := ReadKey;
    If c = #0 Then BEGIN c:=ReadKey; c:=#0 END
  Until c In [#13, #27];
  TextAttr := Attr;
  RestoreLine (Lines^); RestoreCursor;
  If c=#13 Then MySystemError:=0 Else MySystemError:=1
end;

{ EnableHandler - What = TRUE aktiviert die Unit    }
{                 What = FALSE deaktiviert die Unit }
procedure EnableHandler (What: Boolean);
begin
  if What = IsEnabled then Exit;
  if What then InitSysError else DoneSysError;
  IsEnabled := What
end;

{ Enabled - ergibt TRUE, wenn die Unit aktiv ist }
function Enabled: boolean;
begin Enabled := IsEnabled end;

{ Die ExitRoutine sorgt fr den korrekten Ablauf bei Programmende. }
procedure SysErrExit; far;
begin
  ExitProc := ExitSave;
  if IsEnabled then EnableHandler (FALSE);
end;

begin { Initialisierung }
  Lines:=Ptr(Seg0040,$84);
  VPort:=Ptr(Seg0040,$63);
  IsEnabled := FALSE;              { noch ist nix aktiviert }
  EGA := TestEGA;                  { "EGA" initialisieren }
  if not EGA then Lines^ := 24;    { CGA/Mono: BIOS-Variable setzen}
  if VPort^=$3D4 then frame := SegB800
  else begin                 { in Farbmodi gilt Adresse $B800:$0000 }
    frame := SegB000;        { sonst $B000:$0000 }
    ErrTxt := $07; KeyTxt := $0F; { Farben anpassen }
  end;
  SysErrorFunc:=MySystemError; { Drivers.SysErrorFunc auf neue Func  }
  ExitSave := ExitProc;        { umbiegen, bisherige ExitProc sichern}
  ExitProc := @SysErrExit;     { neuen Exit-Prozedur installieren    }
  EnableHandler (TRUE)         { Handler aktivieren                  }
end.

