/*  Copyright(C) 1999 Owen Borseth
	borsethom@lcc.ctc.edu
	Version 2.2

	Valentine 2.2 is written by Owen Borseth. It is currently a simple
	command line encryption program that allows the user to enter the name
	of the file that she or he would like to encrypt or decrypt. As it is now, 
	it uses	an XOR cipher based on a user entered key and a compiled key. It has 
	been tested, compiled and verified stable on Linux RedHat 5.2, Windows NT, 
	and Windows95. The compiled key is comp_key and can be changed before 
	compiling the program. As the program is currently written, the file name 
	must not contain any spaces.

	This program is free software, you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 2 of the license, or any
	later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY. Without even the implied warranty of MERCHANTABILITY
	or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
	for more details.

	You should have recieved a copy of the GNU General Public License along
	with this program, if not, write to the Free Software Foundation, INC.,
	675 Mass Avenue, Cambridge, MA 02139, USA.

	Read the readme.txt file before using or editing this program.

	November 27, 1999
*/

#include <stdio.h>
#include <string.h>

void keytobin(int);  //converts user key to binary
int cipher(int);    //the cipher function
void comptobin(int); //converts compiled key to binary

static int mcount = 0;	//counter for turning the user key into binary (used in keytobin)
static int ccount = 0;	//counter for progressing within the binary user key
int compcount = 0;      //counter for turning the compiled key into binary (used in comptobin)
int compcc = 0;         //counter for progressing within the binary compiled key
int key_bin[1024];      //stores user entered key in binary
int comp_bin[1024];     //stores compiled key in binary
int key_len;			//length of user key
int comp_len;			//length of compiled key

int main(int args, char * chars_array[])
{
	
	unsigned char ret_char;
	unsigned char ret_get;
	double file_leng = 0;
	double end_count = 0;
	int check_eof;
	int i = 0;
	void exit(int);
	FILE * open_file;
	FILE * new_file;
	char * keyp;
	int search_length = 0;
	char key_array[128];
	int temp = 0;
	char temp_char;
	char * ret_file;
	char point_val[] = {".val"};
	
	/******************************************/
	//this is the internaly compiled key in decimal form. This can be changed. However,
	//a file encrypted with this key must be decrypted with the same internal key.
	//I recommend that you do not exceed the length of the key used here.
	//The key used here is not the one I use to compile the executable I distribute. 
	//This one is generic. I do not make the key I use to compile the executable available 
	//to anyone. Do not enter the key as a string, enter it only as decimal.
	char comp_key[] = {75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75, 0};
	
	/******************************************/

	char point_file[128];
	int file_len;
	char check_end[3] = {0,0,0};
	char new_name[128];
	int rem_file;
	char dumpIt;
	int got_key = 0;
	
	if(args == 1)	//check for arguments
	{
		printf("\nNot enough parameters. Try val --help for help.\n\n");
		exit(1);
	}

	if(strcmp(chars_array[1], "--help") == 0)	//check for help
	{
		printf("\n             **Valentine 2.2**\n");
		printf("     Command line encryption program.\n");
        printf("      Copyright(C) 1999 Owen Borseth \n");
		printf("          borsethom@lcc.ctc.edu\n\n");
		printf("Usage:     val FILENAME OPTION [KEY]\n");
		printf("Encrypts/decrypts the chosen file utilizing the chosen key.\n\n");
		printf("FILENAME:  This is a required parameter. Enter the path\n");
		printf("           to where the file you would like to encrypt\n");
		printf("           resides. Example:  /root/file.dat\n");
		printf("           The filename must not contain any spaces.\n");
	    printf("OPTION:    This is a required parameter. Choose -k to\n");
		printf("           kill the original file, and -l to leave it alone.\n"); 
		printf("KEY:       This is an optional parameter If you do not enter it\n");
		printf("           at the command prompt, Valentine will ask for it.\n");
		printf("           Due to some OS's that keep track of command prompt entries,\n");
		printf("           it is more secure to allow Valentine to prompt for the KEY.\n");
		printf("           Your key should be between 5 and 128 characters in length.\n");
		printf("           This will be used in the encryption of the file and should\n");
		printf("           be something that you can remember.\n\n");
		printf("Example:   val /root/file.dat -k Thisismykey\n\n");
		printf("**Hit Enter to continue.**\n");
		scanf("%c", &dumpIt);
		printf("More:      Encrypted files will be saved with the extension .val\n");
		printf("           When a file with this extension is entered in the FILENAME\n");
		printf("	   area, this file will be decrypted and saved with the\n");
		printf("	   same name, less the .val extension.\n\n");
		printf("	   There are certain key lengths that seem to provide stronger\n");
		printf("	   encryption. Read the readme.txt file for more information.\n\n");
		printf("	   Currently, filenames and paths with spaces are not permitted.\n\n");
		printf("           Licensed under the GNU General Public License.\n\n");
		printf("	   No warranty expressed or implied. Use at your own risk.\n\n");
		printf("           Read the readme.txt file before using this program.\n\n");
 	 	exit(1);
 	} 

	if(args < 3)  //checks for at least 2 parameters
	{
		printf("\nNot enough parameters. Try val --help for help.\n\n");
		exit(1);
	}

	//makes sure that an OPTION has been entered
	if(strcmp(chars_array[2], "-k") != 0 && strcmp(chars_array[2], "-l") != 0)
	{
		printf("\nInvalid parameters. Try val --help for help.\n\n");
		exit(1);
	}
	
	if((open_file = fopen(chars_array[1],"rb+")) == NULL)	//makes sure the file exists
	{
		printf("\nFile does not exist or cannot be opened.\n\n");
		exit(1);
	}

	if(args < 4)  //checks to see if key was entered
	{
		printf("\nPlease enter your key:  ");
		scanf("%s", key_array);
		got_key = 1;
	}	
	
	printf("\n      **Valentine 2.2**\n");
	printf("Copyright(C) 1999 Owen Borseth\n");
	printf("  ORIGINAL DISTRIBUTION COPY\n");
	
	if(got_key != 1)
	{
	//converts the keys into strings (Martin Cenek)
	keyp = chars_array[3];
	while( * keyp)
	{
		temp_char = (char) * keyp;
		key_array[temp] = temp_char;
		keyp++;
		temp++;
	}
	key_array[temp] = '\0';
	fflush(stdin);
	}

	key_len = strlen(key_array);
	for(i = 0; i < key_len; i++)
	{
		keytobin(key_array[i]);
	}
	mcount = 0;
	comp_len = strlen(comp_key);
	for(i = 0; i < comp_len; i++)
	{
		comptobin(comp_key[i]);
	}
	mcount = 0;

	//converts FILENAME into a string (Martin Cenek)
	keyp = chars_array[1];
	temp = 0;
	while( * keyp)
	{
		temp_char = (char) * keyp;
		point_file[temp] = temp_char;
		keyp++;
		temp++;
	}
	point_file[temp] = '\0';
	fflush(stdin);
	file_len = strlen(point_file);
		
	//gets last three characters of the FILENAME, to check for "val"
	for(i = 0; i < 3; i++)
	{
		check_end[2 - i] = point_file[(file_len - (i + 1))];
	}
	check_end[i] = '\0';
	
	//gets FILENAME less last three characters, for decrypted file
        for(i = 0; i < (file_len - 4); i++)
	{
        	new_name[i] = point_file[i];
	}
	new_name[i++] = '\0';
	
	//gets the length of the open file
	check_eof = feof(open_file);
	while(check_eof == 0)
	{
		file_leng++;
		ret_get = getc(open_file);
		check_eof = feof(open_file);
	}
	rewind(open_file);
	
	printf("\nFile %s", point_file);
	ret_file = strcat(point_file, point_val);  //creates FILENAME plus "val"
	                                           //for encrypted file
	
	//the next two if statements check for "val". If "val" was the extension
	//then it creates a file with the FILENAME minus "val", else it creates
	//the FILENAME plus "val".
	
	if(strcmp(check_end, "val") == 0)
	{
	    printf("\nDecrypting to %s...\n", new_name);
		new_file = fopen(new_name, "wb");
	}

    if(strcmp(check_end, "val") != 0)
	{
	    printf("\nEncrypting to %s...\n", point_file);
		new_file = fopen(point_file, "wb"); 	
	}

	//this is where the file is read and sent to cipher
	check_eof = feof(open_file);
	file_leng --;
	while(check_eof == 0 && end_count <= file_leng)
	{
		end_count++;
		check_eof = feof(open_file);	//checks for end of file
		if(check_eof == 0 && end_count <= file_leng)
		{
			ret_char = getc(open_file);

			/*******************************/
			//this loop sends the character that was read to cipher
			//the number of times that that is entered into the for loop
			for(i=0;i<5;i++)
			{
			ret_char = cipher(ret_char);
			if(ccount%2==0)
				compcc++;
			ccount++;
			}
			/*******************************/

			fwrite(&ret_char, sizeof(ret_char), 1, new_file); 
		}
	}
	fclose(open_file);

	if(strcmp(chars_array[2], "-k") == 0) //checks to delete old file
	{
		rem_file = remove(chars_array[1]);
		if(rem_file == -1)
			printf("\nOriginal file was not able to be removed");
		if(rem_file == 0)
			printf("\nOriginal file removed");
	}
	for(i=0;i<comp_len;i++)
		comp_key[i]=0;
	for(i=0;i<1024;i++)
		comp_bin[i]=0;
	printf("\nValentine Done.\n\n");
}

//this is where the ciphering takes place
int cipher(ret_cyph)
{
	int bin_array[] = {0, 0, 0, 0, 0, 0, 0, 0}; //array for binary equivelant of character
	int i;
	int j;
	int modding = ret_cyph;
	i = 0;

	//converts the character number to binary
	for(i = 0; i < 8; i++)
	{
		if(ccount > (key_len * 8)) 
			ccount = 0;
		if(compcc > (comp_len * 8))
			compcc = 1;
		bin_array[i] = ((modding % 2) ^ key_bin[ccount]); //XOR routine
		bin_array[i] = bin_array[i] ^ comp_bin[compcc];   //XOR routine
		modding = modding / 2;		
		ccount++;
		compcc++;
	}
	ret_cyph = 0;

	//gets the decimal value of the ciphered binary number
	for(i = 0, j = 1; i < 8; i++, j = j * 2)
	{
		if(bin_array[i] == 1)
		ret_cyph = ret_cyph + j;
	}
	return(ret_cyph);
}

//converts the user key into binary
void keytobin(ret_key)
{
	int i;
	int modding = ret_key;
	for(i = 0; i < 8; i++)
	{
		key_bin[mcount] = (modding % 2);
		modding = modding / 2;
		mcount++;
	}
}

//converts the compiled key into binary
void comptobin(ret_key)
{
	int i;
	int modding = ret_key;
	for(i = 0; i < 8; i++)
	{
		comp_bin[compcount] = (modding % 2);
		modding = modding / 2;
		compcount++;
	}
}

