; to compile: use tasm 3.2 or newer
; do:
; tasm stncrp.asm
; tlink stncrp /t

  .model tiny
  .code                                        
  
          org 100h                          ; COM file starting IP
  ; ExeEnCrypter
  ; Written by Stone of MASQUE and KLAN
  ; For his own writting pleassure
  
startprogram:                                 ; program code starts here
  
            mov  ah,1Ah                       ; Set new DTA
            lea  dx,newDTA                    ; new DTA @ DS:DX
            int  21h            
  
            lea  dx, exe_mask                 ; fetch-input-filemask

            mov  ah,4eh                       ; find first file
            mov  cx,7                         ; any attribute
findfirstnext:
            int  21h                          ; DS:DX points to mask
            jc   kill                         ; No files? if so Exit!

            mov  al,0h                        ; Open read only
            call open

;read the first 1ah bytes of the exe-file 
;(The part of the header interesting to us!)

            mov  ah,3fh                       ; Read file to header
            lea  dx,header                    ; @ DS:DX
            mov  cx,1Ah                       ; 1Ah bytes
            int  21h
  
            mov  ah,3eh                       ; Close file
            int  21h

            call  Encrypt

kill:                                         ; Program termination
            mov  ax,4c00h                     ; Terminate program error code=0
            int 21h

;************* START ENCRYPTION OF EXE-FILE ***********
encrypt:
            mov  al,0h                        ; open the file read-write
            call open                         ; bx=filehandle
            push bx  
 
            call crea_out                     ; create output-file!

            mov al,2h
            call openout
	    mov dx, bx                        ; save filehandle in dx

            mov  cx, word ptr [header + 8]    ; Get header size in paragraph

            pop   bx                          ; fetch the inputfile-handle
            

            call copy_header                  ; Copy the header: 
                                              ; cx=number of paragraphs in header
                                              ; dx=output filehandle
                                              ; bx=input filehandle

	    push bx                           ; save file handles
            push dx          

            call calc_imagesize               ; calculate the size of the exe-image
            int 3
            mov word ptr ds:[offsetdx+1],dx   ; patch the decryption rutine
            mov word ptr ds:[offparag+1],ax

            pop dx                            ; fetch handle of outputfile
            pop bx                            ; fetch handle of inputfile

            call copy_image                   ; copy and encrypt image to 
                                              ; output file
                                              
            push bx                           ; save the file handles!
            push dx  

            call last_para                    ; encrypt and copy the last 
                                              ; paragraph in the exe-image            

            pop  bx                           ; fetch output filehandle
            mov  ah,3eh                       ; Close file output file
            int  21h

            pop  bx                           ; fetch input filehandle
            mov  ah,3eh                       ; Close file input file
            int  21h

            call calc_header                  ; calculate new exe-header

            mov  al,2                         ; open output file RW
            call openout
  
            mov  ah,40h                       ; Write to file
            lea  dx,header                    ; Write from header
            mov  cx,1ah                       ; cx bytes: cx=1ah
            int  21h
  
            mov  ax,4202h                     ; Move file pointer
            xor  cx,cx                        ; to end of file
            cwd                               ; xor dx,dx
            int  21h
  
            mov  ah,40h                       ; Append decryption code
            lea  dx,append_this               ; Write from here
            mov  cx,code_end-append_this      ; # bytes to write
            int  21h
  
  
            mov  ah,3eh                       ; Close file
            int  21h
  
            ret 
;**** Done encrypting the exe-file  

open:                                        ; Procedure to open input-file
            mov  ah,3dh                      ; open file al=open mode: 0=RO, 
                                             ; 2=RW
            lea  dx,newDTA+30                ; filename in DTA
            int  21h
            xchg ax,bx                       ; exit with filehandle in bx
            ret
  
openout:                                     ; Procedure to open output-file
            mov  ah,3dh                      ; open file al=open mode: 
                                             ; 0=readonly 2=readwrite
            lea  dx,outfile                  ; dx points to filename
            int  21h 
            xchg ax,bx                       ; leave with the handle in bx
            ret

attributes:
            mov  ax,4301h                    ; Set attributes to cx
            lea  dx,newDTA+30                ; filename in DTA
            int  21h
            ret

enc_buffer:                                ; Procedure to encrypt a
                                             ; paragraph in cryptbuffr
	    xor   bp,bp                      ; xero bp
            encrypt_loop:            
            sub byte ptr ds:[bp+cryptbuffr],1; encrypt byte at 
                                             ; cryptbuffr +bp
            inc bp                           ; let bp point to the next byte
            cmp bp,10h                       ; are we done yet?
            jnz encrypt_loop                 ; next byte
            ret

calc_header:
            les  ax, dword ptr [header+14h]  ; Save old entry point
            mov  word ptr [jmpsave], ax      ; patch final-jump with entrypoint
            mov  word ptr [jmpsave+2], es
  
            les  ax, dword ptr [header+0Eh]  ; Save old stack
            mov  word ptr [stacksave], es    
            mov  word ptr [stacksave+2], ax

            mov  ax, word ptr [header + 8]   ; Get header size
            mov  cl, 4                       ; convert to bytes
            shl  ax, cl                      ; shl ax,4 <=> ax*16
            xchg bx, ax                      ; let dx be the header size in bytes
  
  
            les  ax, dword ptr [newDTA+26]   ; Get file size
            mov  dx, es                      ; to DX:AX
            push ax
            push dx
  
            sub  ax, bx                      ; Subtract header size from
            sbb  dx, 0                       ; file size
  
            mov  cx, 10h                     ; Convert to number of paragraphs
            div  cx                          ; form
  
            mov  word ptr header+14h, dx     ; Save  New entry point in header
            mov  word ptr header+16h, ax   
  
            mov  word ptr header+0Eh, ax     ; and stack
  
            pop  dx                          ; get file length from stack
            pop  ax
  
            add  ax,code_end-append_this     ; add decrypter size
            adc  dx, 0
  
            mov  cl, 9                       ; 2**9 = 512
            push ax                          ; save ax
            shr  ax, cl                       
            ror  dx, cl
            stc
            adc  dx, ax                      ; filesize in pages
            pop  ax
            and  ah, 1                       ; mod 512
  
            mov  word ptr [header+4], dx     ; new file size
            mov  word ptr [header+2], ax      
  
            push cs                          ; restore ES
            pop  es
  
            ret


crea_out: 
            mov  ax, 3c00h                    ; Create output file
            xor  cx,cx                        ; no attributes
            lea  dx, outfile                  ; with [outfile] as name
            int  21h
            ret
last_para:                                   ; load and encrypt the last bytes 
                                             ; in the exe-file, then save them
            push dx
            push es                          ; get the bytes that was'nt in a paragraph
            pop  cx                          ; in cx
            mov   ah,3fh                     ; Read file to cryptbuffr
            lea   dx,cryptbuffr              ; @ DS:DX
            int   21h
            call enc_buffer                  ; encrypt it
            
            pop bx                           ; fetch output filehandle
            mov ah,40h                       ; ah=40, write to file
            push es                          ; fetch number of bytes from es
            pop  cx                          ; to cx
            lea dx, cryptbuffr               ; let dx point to our buffer
            int 21h 
            ret

copy_header:     ;(bx=infile-handle, dx=outfile-handle, cx= number of parag.)
            push  cx                         ; save current iteration

            push  dx                         ; save file handle of output file
            mov   ah,3fh                     ; Read file to header
            lea   dx,cryptbuffr              ; @ DS:DX
            mov   cx,10h                     ; 10h bytes
            int   21h
            pop   dx                         ; fetch outputfile handle
 
            push  dx                         ; save the file-handles
            push  bx
            mov   bx,dx                      ; let bx point to the filehandle 
                                             ; of outputfile
            lea   dx,cryptbuffr              ; ds:dx = cryptbuffr
            mov   cx,10h                     ; write 10h bytes 
            mov   ah,40h                     ; write cx bytes to bx, from ds:dx
            int   21h             
            pop   bx                         ; fetch the file-handles
            pop   dx

            pop   cx                         ; fetch iteration number
            loop copy_header                 ; do it for every paragraph
            ret

copy_image:     ;(bx=infile-handle, dx=outfile-handle, cx= number of paragr.)
            push  cx                         ; save current iteration

            push  dx                         ; save file handle of output file
            mov   ah,3fh                     ; Read file to header
            lea   dx,cryptbuffr              ; @ DS:DX
            mov   cx,10h                     ; 10h bytes
            int   21h
            call enc_buffer

            pop   dx                         ; fetch outputfile handle

            push  dx                         ; save filehandles
            push  bx
            mov   bx,dx                      ; let bx point to the filehandle 
                                             ; of outputfile
            lea   dx,cryptbuffr              ; ds:dx = cryptbuffr
            mov   cx,10h                     ; write 10h bytes 
            mov   ah,40h                     ; write cx bytes to bx, from ds:dx
            int   21h             
            pop   bx                         ; fetch filehandles
            pop   dx

            pop   cx                         ; fetch iteration number
loop copy_image                              ; do it for every paragraph
            ret

Calc_imagesize:
            mov  ax, word ptr [header + 8]   ; Get header size
            mov  cl, 4                       ; convert to bytes
            shl  ax, cl                      ; shl ax,4 <=> ax*16
            xchg bx, ax                      ; let bx be the header size in bytes
  
  
            les  ax, dword ptr [newDTA+26]   ; Get file size
            mov  dx, es                      ; to DX:AX
  
            sub  ax, bx                      ; Subtract header size from
            sbb  dx, 0                       ; file size
  
            mov  cx, 10h                     ; convert to paragraphs
            div  cx                          ; ax= number of paragraphs in the
     
            mov  cx,ax                       ; image, dx= number of bytes besides the paragraphs
            mov  es, dx                      ; store dx in es
            
            ret

  exe_mask            db 'input.exe',0       ; input-filename, zero terminated
  newDTA              db 42 dup (?)          ; Temporary DTA
  header              db 1ah dup (?)         ; read header for the header
  cryptbuffr          db 10h dup (?)        ; read buffer for encryption
  outfile             db 'output.exe'        ; output filename

;************************************************************************
;**** WHAT HAS TO BE APPPENDED TO THE DAMN EXE FILE GOES AFTER HERE: ****
;************************************************************************
  Append_this:                               ; decryption code starts here
            call next                        ; calculate delta offset
  next:     pop  bp                          ; bp = IP next
            sub  bp,offset next              ; bp = delta offset
  
            push ds                          ; save ds and es (*IMPORTANT*)
            push es
            push cs                          ; DS = CS
            pop  ds
            push cs                          ; ES = CS
            pop  es

;*** Decrypt all paragraphs from start till end
            pop es                           ; fetch es
            pop ax                           ; fetch the address of the PSP
            push es                          ; see to it that the stack is
            push ax                          ; unchanged

offparag:            
            mov cx, 0ffffh                   ; mov cx, imagesize in paragraphs           
                                             ; 0ffffh was patched by the 
                                             ; encryption
            add ax,0fh                       ; let ax point to the last segment
                                             ; of the PSP
loopme:
            inc ax                           ; point one segment further
            mov ds,ax
            xor bx,bx                        ; byte ptr ds:[bx]= first byte in ds
loopme1: 
            add byte ptr ds:[bx],1           ; decrypt! this byte
            inc bx                           ; move the point to next byte
            cmp bx,10h                       ; are we done with this paragraph?
            jne loopme1
            loop loopme
;**** end decrypt all paragraphs

;**** Decrypt the last couple of bytes
offsetdx:                                    ; Reference so we can patch 
                                             ; next line
            mov cx, 0ffffh                   ; is patched to mov cx, ????
                                             ; where ???? = number of bytes 
                                             ; not in any paragraph

            test cx,cx                       ; is there more bytes to decrypt?
            jz no_more             

            inc ax                           ; Update ds to point to 
            mov ds,ax                        ; current segment
            xor bx,bx                        ; ds:bx = first byte in current segment
more:
            add byte ptr ds:[bx],1           ; decrypt it
            inc bx                           ; point to next byte
            loop more                        ; do it for all bytes nessecary
no_more:
;**** End decrypt the last couple of bytes

;**** Return control to the exe-file's original code
            pop  es  
            pop  ds                          ; DS->PSP
            mov  ax,es                       ; AX = PSP segment
            add  ax,10h                      ; Adjust for PSP
            add  word ptr cs:[bp+jmpsave+2],ax
            add  ax,word ptr cs:[bp+stacksave+2]
            cli                              ; Clear intrpts for stack manip.
            mov  sp,word ptr cs:[bp+stacksave]
            mov  ss,ax
            sti
            db   0eah                        ; jmp ssss:oooo
  jmpsave             dd ?                   ; Original CS:IP
  stacksave           dd ?                   ; Original SS:SP
  code_end:
  end       startprogram


  
  
  
  
  
