/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class SecretKeyEncryptionThread
extends Thread {
    private StrongCrypt sCrypt;
    private JProgressBar encryptProgressBar;
    private String alg;
    private int strength;
    private PublicKey pubKey;
    private File file;

    public SecretKeyEncryptionThread(JProgressBar jProgressBar, File file, PublicKey publicKey, String string, int n) {
        this.alg = string;
        this.strength = n;
        this.file = file;
        this.pubKey = publicKey;
        this.encryptProgressBar = jProgressBar;
    }

    private String getModeAndPadding() {
        String string = "";
        if (this.alg.equals("Blowfish")) {
            string = "/ECB/PKCS5Padding";
        } else if (this.alg.equals("DES")) {
            string = "/ECB/PKCS5Padding";
        } else if (this.alg.equals("DESede")) {
            string = "/ECB/PKCS5Padding";
        } else if (this.alg.equals("IDEA")) {
            string = "/ECB/PKCS5Padding";
        } else if (this.alg.equals("RC4")) {
            string = "";
        } else if (this.alg.equals("Twofish")) {
            string = "/ECB/PKCS7Padding";
        }
        return string;
    }

    public void run() {
        try {
            this.encryptProgressBar.setValue(0);
            this.sCrypt.enableEncryption(false);
            KeyGenerator keyGenerator = KeyGenerator.getInstance(this.alg);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            keyGenerator.init(this.strength, secureRandom);
            TimerThread timerThread = new TimerThread(this.encryptProgressBar);
            timerThread.start();
            SecretKey secretKey = keyGenerator.generateKey();
            timerThread.setKeepAlive(false);
            timerThread = null;
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, this.pubKey);
            byte[] byArray = cipher.doFinal(secretKey.getEncoded());
            FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(String.valueOf(this.file)) + ".key");
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            cipher = Cipher.getInstance(String.valueOf(this.alg) + this.getModeAndPadding());
            cipher.init(1, secretKey);
            EncryptThread encryptThread = new EncryptThread(this.encryptProgressBar, this.file, cipher);
            encryptThread.setParent(this.sCrypt);
            encryptThread.start();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "NoSuchAlgorithmException: " + noSuchAlgorithmException.getMessage(), "Error", 0);
            this.sCrypt.enableEncryption(true);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "NoSuchPaddingException: " + noSuchPaddingException.getMessage(), "Error", 0);
            this.sCrypt.enableEncryption(true);
        }
        catch (InvalidKeyException invalidKeyException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "InvalidKeyException: " + invalidKeyException.getMessage(), "Error", 0);
            this.sCrypt.enableEncryption(true);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "IllegalBlockSizeException: " + illegalBlockSizeException.getMessage(), "Error", 0);
            this.sCrypt.enableEncryption(true);
        }
        catch (BadPaddingException badPaddingException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "BadPaddingException: " + badPaddingException.getMessage(), "Error", 0);
            this.sCrypt.enableEncryption(true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "FileNotFoundException: " + fileNotFoundException.getMessage(), "Error", 0);
            this.sCrypt.enableEncryption(true);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "IOException: " + iOException.getMessage(), "Error", 0);
            this.sCrypt.enableEncryption(true);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "Exception: " + exception.getMessage(), "Error", 0);
            this.sCrypt.enableEncryption(true);
        }
    }

    public void setParent(StrongCrypt strongCrypt) {
        this.sCrypt = strongCrypt;
    }
}

