/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class SecretKeyDecryptionThread
extends Thread {
    private StrongCrypt sCrypt;
    private JProgressBar decryptProgressBar;
    private String alg;
    private PrivateKey privKey;
    private File file;
    private File secKeyFile;

    public SecretKeyDecryptionThread(JProgressBar jProgressBar, File file, File file2, PrivateKey privateKey, String string) {
        this.alg = string;
        this.file = file;
        this.privKey = privateKey;
        this.secKeyFile = file2;
        this.decryptProgressBar = jProgressBar;
    }

    private String getModeAndPadding() {
        String string = "";
        if (this.alg.equals("Blowfish")) {
            string = "/ECB/PKCS5Padding";
        } else if (this.alg.equals("DES")) {
            string = "/ECB/PKCS5Padding";
        } else if (this.alg.equals("DESede")) {
            string = "/ECB/PKCS5Padding";
        } else if (this.alg.equals("IDEA")) {
            string = "/ECB/PKCS5Padding";
        } else if (this.alg.equals("RC4")) {
            string = "";
        } else if (this.alg.equals("Twofish")) {
            string = "/ECB/PKCS7Padding";
        }
        return string;
    }

    public void run() {
        try {
            this.sCrypt.enableDecryption(false);
            FileInputStream fileInputStream = new FileInputStream(this.secKeyFile);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            if (this.sCrypt.isDeleteSelected(1)) {
                this.secKeyFile.delete();
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, this.privKey);
            byte[] byArray2 = cipher.doFinal(byArray);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, this.alg);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.alg);
            SecretKey secretKey = secretKeyFactory.generateSecret(secretKeySpec);
            cipher = Cipher.getInstance(String.valueOf(this.alg) + this.getModeAndPadding());
            cipher.init(2, secretKey);
            DecryptThread decryptThread = new DecryptThread(this.decryptProgressBar, this.file, cipher);
            decryptThread.setParent(this.sCrypt);
            decryptThread.start();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "NoSuchAlgorithmException: " + noSuchAlgorithmException.getMessage(), "Error", 0);
            this.sCrypt.enableDecryption(true);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "NoSuchPaddingException: " + noSuchPaddingException.getMessage(), "Error", 0);
            this.sCrypt.enableDecryption(true);
        }
        catch (InvalidKeyException invalidKeyException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "InvalidKeyException: " + invalidKeyException.getMessage(), "Error", 0);
            this.sCrypt.enableDecryption(true);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "InvalidKeySpecException: " + invalidKeySpecException.getMessage(), "Error", 0);
            this.sCrypt.enableDecryption(true);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "IllegalBlockSizeException: " + illegalBlockSizeException.getMessage(), "Error", 0);
            this.sCrypt.enableDecryption(true);
        }
        catch (BadPaddingException badPaddingException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "BadPaddingException: " + badPaddingException.getMessage(), "Error", 0);
            this.sCrypt.enableDecryption(true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "FileNotFoundException: " + fileNotFoundException.getMessage(), "Error", 0);
            this.sCrypt.enableDecryption(true);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "IOException: " + iOException.getMessage(), "Error", 0);
            this.sCrypt.enableDecryption(true);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "Exception: " + exception.getMessage(), "Error", 0);
            this.sCrypt.enableDecryption(true);
        }
    }

    public void setParent(StrongCrypt strongCrypt) {
        this.sCrypt = strongCrypt;
    }
}

