/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class KeyDialog
extends JDialog
implements ActionListener {
    private JButton okButton;
    private JButton cancelButton;
    private JTextField aliasTextField;
    private JTextField keyStorePathTextField;
    private JTextField secretKeyTextField;
    private JPasswordField passwordField;
    private JPasswordField keyStorePasswordField;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private StrongCrypt sCrypt;
    public static int OK_OPTION = 0;
    public static int CANCEL_OPTION = 1;
    public static int SIGN_MODE = 2;
    public static int VERIFY_MODE = 3;
    public static int SECRET_KEY_MODE = 4;
    private static int MODE;
    private int selectedOption;
    private Certificate cert;
    private Key key;
    private boolean debug = false;
    private byte[] salt = new byte[]{-29, 81, -118, 97, -54, 79, 39, 61};
    private int count = 21;

    public KeyDialog(JFrame jFrame, String string, int n) {
        super(jFrame, string, true);
        Object object;
        JLabel jLabel;
        MODE = n;
        this.selectedOption = CANCEL_OPTION;
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridwidth = 0;
        this.topPanel = new JPanel();
        this.topPanel.setLayout(gridBagLayout);
        if (MODE == SECRET_KEY_MODE) {
            jLabel = new JLabel("Secret Key");
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.topPanel.add(jLabel);
            this.secretKeyTextField = new JTextField(15);
            jLabel.setLabelFor(this.secretKeyTextField);
            this.secretKeyTextField.setToolTipText("Press enter for file dialog");
            this.secretKeyTextField.addActionListener(this);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.secretKeyTextField, gridBagConstraints);
            this.topPanel.add(this.secretKeyTextField);
        }
        if (MODE == SECRET_KEY_MODE || MODE == SIGN_MODE || MODE == VERIFY_MODE) {
            jLabel = new JLabel("Key Store Password");
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.topPanel.add(jLabel);
            this.keyStorePasswordField = new JPasswordField(15);
            if (this.debug) {
                ((JTextComponent)this.keyStorePasswordField).setText("twocows");
            }
            jLabel.setLabelFor(this.keyStorePasswordField);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.keyStorePasswordField, gridBagConstraints);
            this.topPanel.add(this.keyStorePasswordField);
            object = new JLabel("Key Store");
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            this.topPanel.add((Component)object);
            this.keyStorePathTextField = new JTextField(15);
            if (this.debug) {
                this.keyStorePathTextField.setText("D:\\java\\StrongCrypt\\.keystore");
            }
            File file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + ".keystore");
            if (StrongCrypt.STORE_TYPE.equalsIgnoreCase("JKS")) {
                file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + ".keystore.encrypted");
            }
            if (file.exists() && file.isFile()) {
                this.keyStorePathTextField.setText(file.toString());
            }
            ((JLabel)object).setLabelFor(this.keyStorePathTextField);
            this.keyStorePathTextField.addActionListener(this);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.keyStorePathTextField, gridBagConstraints);
            this.topPanel.add(this.keyStorePathTextField);
        }
        if (MODE == SIGN_MODE || MODE == SECRET_KEY_MODE) {
            jLabel = new JLabel("Private Key Password");
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.topPanel.add(jLabel);
            this.passwordField = new JPasswordField(15);
            if (this.debug) {
                ((JTextComponent)this.passwordField).setText("wiki.60");
            }
            jLabel.setLabelFor(this.passwordField);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.passwordField, gridBagConstraints);
            this.topPanel.add(this.passwordField);
        }
        jLabel = new JLabel("Alias");
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.topPanel.add(jLabel);
        this.aliasTextField = new JTextField();
        if (this.debug) {
            this.aliasTextField.setText("waqas");
        }
        jLabel.setLabelFor(this.aliasTextField);
        this.aliasTextField.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.aliasTextField, gridBagConstraints);
        this.topPanel.add(this.aliasTextField);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridLayout(0, 2));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.okButton.setMnemonic('O');
        this.bottomPanel.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setMnemonic('C');
        this.bottomPanel.add(this.cancelButton);
        gridBagLayout.setConstraints(this.topPanel, gridBagConstraints);
        container.add(this.topPanel);
        gridBagLayout.setConstraints(this.bottomPanel, gridBagConstraints);
        container.add(this.bottomPanel);
        if (MODE == SIGN_MODE) {
            this.topPanel.setPreferredSize(new Dimension(330, 100));
            this.bottomPanel.setPreferredSize(new Dimension(330, 27));
        } else if (MODE == VERIFY_MODE) {
            this.topPanel.setPreferredSize(new Dimension(330, 75));
            this.bottomPanel.setPreferredSize(new Dimension(330, 27));
        } else if (MODE == SECRET_KEY_MODE) {
            this.topPanel.setPreferredSize(new Dimension(330, 127));
            this.bottomPanel.setPreferredSize(new Dimension(330, 27));
        }
        this.pack();
        object = this.getToolkit();
        int n2 = (((Toolkit)object).getScreenSize().width - this.getSize().width) / 2;
        int n3 = (((Toolkit)object).getScreenSize().height - this.getSize().height) / 2;
        ((Component)this).setLocation(n2, n3);
        this.setDefaultCloseOperation(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.okPressed();
        } else if (object == this.aliasTextField) {
            this.okPressed();
        } else if (object == this.cancelButton) {
            this.selectedOption = CANCEL_OPTION;
            ((Component)this).setVisible(false);
        } else if (object == this.keyStorePathTextField) {
            if (StrongCrypt.STORE_TYPE.equalsIgnoreCase("JKS")) {
                this.keyStorePathTextField.setText(this.getFile("JKS Key Store Files", "keystore.encrypted"));
            } else if (StrongCrypt.STORE_TYPE.equalsIgnoreCase("ABA")) {
                this.keyStorePathTextField.setText(this.getFile("ABA Key Store Files", "keystore"));
            }
            this.keyStorePathTextField.transferFocus();
        } else if (object == this.secretKeyTextField) {
            this.secretKeyTextField.setText(this.getFile("Secret Key Files", "key"));
            this.secretKeyTextField.transferFocus();
        }
    }

    public String getAlias() {
        return this.aliasTextField.getText();
    }

    private String getFile(String string, String string2) {
        String string3 = "";
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        jFileChooser.setDialogTitle("Select File");
        jFileChooser.setFileFilter(new StrongCryptFileFilter(string, string2));
        if (jFileChooser.showOpenDialog(this.sCrypt.getFrame()) == 0) {
            File file = jFileChooser.getSelectedFile();
            string3 = file.toString();
        }
        return string3;
    }

    public File getKeyStoreFile() {
        return new File(this.keyStorePathTextField.getText());
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePasswordField.getPassword();
    }

    public PrivateKey getPrivateKey() {
        return (PrivateKey)this.key;
    }

    public char[] getPrivateKeyPassword() {
        return this.passwordField.getPassword();
    }

    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    public File getSecretKeyFile() {
        return new File(this.secretKeyTextField.getText());
    }

    public int getSelectedOption() {
        return this.selectedOption;
    }

    public synchronized boolean keyExists() {
        boolean bl = false;
        try {
            try {
                File file = new File(this.keyStorePathTextField.getText());
                KeyStore keyStore = KeyStore.getInstance(StrongCrypt.STORE_TYPE);
                if (this.keyStorePathTextField.getText().indexOf(".encrypted") == -1) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    keyStore.load(fileInputStream, this.keyStorePasswordField.getPassword());
                    ((InputStream)fileInputStream).close();
                } else {
                    PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.salt, this.count);
                    PBEKeySpec pBEKeySpec = new PBEKeySpec(this.keyStorePasswordField.getPassword());
                    SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithSHA1And128BitRC4");
                    SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
                    Cipher cipher = Cipher.getInstance("PBEWithSHA1And128BitRC4");
                    cipher.init(2, (Key)secretKey, pBEParameterSpec);
                    CipherInputStream cipherInputStream = new CipherInputStream(new FileInputStream(file), cipher);
                    keyStore.load(cipherInputStream, this.keyStorePasswordField.getPassword());
                    cipherInputStream.close();
                }
                if (MODE == SIGN_MODE || MODE == SECRET_KEY_MODE) {
                    this.key = keyStore.getKey(this.aliasTextField.getText(), this.passwordField.getPassword());
                } else if (MODE == VERIFY_MODE) {
                    this.cert = keyStore.getCertificate(this.aliasTextField.getText());
                    ((X509Certificate)this.cert).checkValidity(new Date());
                }
                bl = true;
            }
            catch (CertificateExpiredException certificateExpiredException) {
                JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "CertificateExpiredException: " + certificateExpiredException.getMessage(), "Error", 0);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "CertificateNotYetValidException: " + certificateNotYetValidException.getMessage(), "Error", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "IOException: " + iOException.getMessage(), "Error", 0);
            }
            catch (KeyStoreException keyStoreException) {
                JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "KeyStoreException: " + keyStoreException.getMessage(), "Error", 0);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "NoSuchAlgorithmException: " + noSuchAlgorithmException.getMessage(), "Error", 0);
            }
            catch (CertificateException certificateException) {
                JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "CertificateException: " + certificateException.getMessage(), "Error", 0);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "CertificateException: " + unrecoverableKeyException.getMessage(), "Error", 0);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "Exception: " + exception.getMessage(), "Error", 0);
            }
        }
        catch (Throwable throwable) {}
        return bl;
    }

    private void okPressed() {
        File file;
        File file2 = new File(this.keyStorePathTextField.getText());
        if (!(MODE != SECRET_KEY_MODE || (file = new File(this.secretKeyTextField.getText())).exists() && file.isFile())) {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "File '" + file.toString() + "' not found.", "Error", 0);
            return;
        }
        if (file2.exists() && file2.isFile()) {
            if (this.keyExists()) {
                this.selectedOption = OK_OPTION;
                ((Component)this).setVisible(false);
            }
        } else {
            JOptionPane.showMessageDialog(this.sCrypt.getFrame(), "File '" + file2.toString() + "' not found.", "Error", 0);
        }
    }

    public void setParent(StrongCrypt strongCrypt) {
        this.sCrypt = strongCrypt;
    }
}

