#ifndef __TSS_H__
#define __TSS_H__ 1

/*
 * TSS_POOL_BYTES has to be 2^n and even multiple of 16.
 * 16k pool (0x4000) is standard and big enough.
 */
#define TSS_POOL_BYTES	0x800
#define TSS_POOL_MASK	(TSS_POOL_BYTES - 1)
/*
 * TSS_SALT_BYTES has to be more than 0x10 but it should not be too big.
 * 0x20 is standard and OK.
 */
#define TSS_SALT_BYTES	0x20

struct tss_context
{
  unsigned char key[TSS_POOL_BYTES];
  unsigned char salt[TSS_SALT_BYTES];
  int           keyidx;
};

/*
 * Encrypts (decrypts) one data block within TSS context.
 */
int           TSS_Encrypt( word32, unsigned char far *, unsigned int );
int           TSS_Decrypt( word32, unsigned char far *, unsigned int );

#endif				/* not __TSS_H__ */
