/* ----------------------------------------------------------------------
 * TRI's Simple Stream encryption system implementation
 * ----------------------------------------------------------------------
 * Created	: Fri Apr 14 14:20:00 1995 tri
 * Last modified: Wed Jul 12 21:58:55 1995 ylo
 * ----------------------------------------------------------------------
 * Copyright (c) 1995
 * Timo J. Rinne <tri@iki.fi> and Cirion oy.
 *
 * Address: Cirion oy, PO-BOX 250, 00121 HELSINKI, Finland
 *
 * Even though this code is copyrighted property of the author, it can
 * still be used for non-commercial purposes under following conditions:
 *
 *     1) This copyright notice is not removed.
 *     2) Source code follows any distribution of the software
 *	  if possible.
 *     3) Copyright notice above is found in the documentation
 *	  of the distributed software.
 *
 * For possibility to use this source code for commercial product,
 * please contact address above.
 *
 * Any express or implied warranties are disclaimed.  In no event
 * shall the author be liable for any damages caused (directly or
 * otherwise) by the use of this software.
 *
 * Permission granted to Mr. Tatu Ylonen <ylo@cs.hut.fi> to include this
 * code into SSH (Secure Shell).  Permission is granted to anyone to
 * use and distribute this code for any purpose as part of that product.
 * ----------------------------------------------------------------------
 * Adapted for DOS s-e-p secure encrypted partitions (Linux compatible)
 * by Emil Laurentiu <emil@techteam.static.golden.net>
 * Date: Wednesday, 25 March 1998
 */

#define __TSS_C__ 1

#include <string.h>
#include "machine.h"
#include "md5.h"
#include "tss.h"

struct tss_context tss_ctx;
struct tss_context work_ctx;
struct MD5Context mdctx;

#pragma aux encrypt_type value [es bx];
char far     *
encrypt_type( void )
{
  return "TSS";
}

#pragma aux transfer parm [] caller modify [ax bx cx dx es];
int
transfer( int cmd, unsigned char far * buffer,
	  unsigned int size, word32 block )
{
  if ( cmd == READ )
  {
    TSS_Decrypt( block, buffer, size );
  }
  else
  {
    TSS_Encrypt( block, buffer, size );
  }
  return 0;
}

/* Destroys any sensitive data in the context. */
void
destroy_context( void )
{
  memset( &tss_ctx, 0, sizeof( struct tss_context ) );
}

/* Sets tss key for encryption. */
#pragma aux set_key parm [BX ES] caller modify [ax bx cx dx es];
void
set_key( unsigned char far * key )
{
  int		i, keylen;

  for ( keylen = 0; *( key + keylen ); keylen++ )
    ;
  tss_ctx.keyidx = 0;
  ( tss_ctx.key )[0] = ( unsigned char ) ( keylen & 0xff );
  ( tss_ctx.key )[1] = ( unsigned char ) ( ( keylen >> 8 ) & 0xff );
  for ( i = 2; i < sizeof( tss_ctx.key ); i++ )
    ( tss_ctx.key )[i] = key[i % keylen];
  for ( i = 0; i <= 16; i++ )
  {
    MD5Init( &mdctx );
    MD5Update( &mdctx, tss_ctx.key, ( i + 1 ) * 16 );
    MD5Final( &( ( tss_ctx.key )[i * 16] ), &mdctx );
  }
  for ( i = 0; i < sizeof( tss_ctx.key ); i++ )
  {
    ( tss_ctx.key )[( i + 1 ) & TSS_POOL_MASK] ^= ( tss_ctx.key )[i];
    ( tss_ctx.key )[( i + 2 + ( ( tss_ctx.key )[i] ) ) & TSS_POOL_MASK] ^=
	    ( ( tss_ctx.key )[i] << 6 ) |
	    ( ( tss_ctx.key )[( i + 1 ) & TSS_POOL_MASK] >> 2 );
  }
  ( tss_ctx.salt )[0] = ( unsigned char ) ( keylen & 0xff );
  ( tss_ctx.salt )[1] = ( unsigned char ) ( ( keylen >> 8 ) & 0xff );
  for ( i = 2; i < sizeof( tss_ctx.salt ); i++ )
    ( tss_ctx.salt )[i] = key[i % keylen];
  MD5Init( &mdctx );
  MD5Update( &mdctx, tss_ctx.salt, sizeof( tss_ctx.salt ) );
  MD5Update( &mdctx, &( ( tss_ctx.key )[sizeof( tss_ctx.key ) - 16] ), 16 );
  MD5Final( tss_ctx.salt, &mdctx );
  for ( i = 0; i < 16; i++ )
    ( tss_ctx.key )[i] ^= ( tss_ctx.salt )[i];
}

int
TSS_Encrypt( word32 block, unsigned char far * data, unsigned int len )
{
  unsigned int	i;

  for ( i = 0; i < len; i++ )
  {
    if ( i % 0x200 == 0 )
    {
      memcpy( &work_ctx, &tss_ctx, sizeof( struct tss_context ) );
      work_ctx.keyidx = ( block + i / 0x200 ) / 2;
    }
    work_ctx.keyidx = ( work_ctx.keyidx + 1 ) & TSS_POOL_MASK;
    ( work_ctx.key )[( work_ctx.keyidx + 1 ) & TSS_POOL_MASK] ^= data[i];
    ( work_ctx.key )[( work_ctx.keyidx + 3 ) & TSS_POOL_MASK] ^=
	    ( data[i] << 6 ) | ( data[i] >> 2 );
    data[i] ^= ( work_ctx.key )[work_ctx.keyidx];
    ( work_ctx.key )[( work_ctx.keyidx + 2 ) & TSS_POOL_MASK] ^= data[i];
    ( work_ctx.key )[( work_ctx.keyidx + 4 ) & TSS_POOL_MASK] ^=
	    ( data[i] << 3 ) | ( data[i] >> 5 );
  }
  return 1;
}

int
TSS_Decrypt( word32 block, unsigned char far * data, unsigned int len )
{
  unsigned int	i;

  for ( i = 0; i < len; i++ )
  {
    if ( i % 0x200 == 0 )
    {
      memcpy( &work_ctx, &tss_ctx, sizeof( struct tss_context ) );
      work_ctx.keyidx = ( block + i / 0x200 ) / 2;
    }
    work_ctx.keyidx = ( work_ctx.keyidx + 1 ) & TSS_POOL_MASK;
    ( work_ctx.key )[( work_ctx.keyidx + 2 ) & TSS_POOL_MASK] ^= data[i];
    ( work_ctx.key )[( work_ctx.keyidx + 4 ) & TSS_POOL_MASK] ^=
	    ( data[i] << 3 ) | ( data[i] >> 5 );
    data[i] ^= ( work_ctx.key )[work_ctx.keyidx];
    ( work_ctx.key )[( work_ctx.keyidx + 1 ) & TSS_POOL_MASK] ^= data[i];
    ( work_ctx.key )[( work_ctx.keyidx + 3 ) & TSS_POOL_MASK] ^=
	    ( data[i] << 6 ) | ( data[i] >> 2 );
  }
  return 1;
}
