; Author Emil LAURENTIU
; Date: 17 March 1998
; Last modified: 29 August 1998

.386

PUBLIC		begin
PUBLIC		mulop_
PUBLIC		_small_code_

; int transfer( int cmd, char far *buffer, word16 size, word32 block )
extrn		transfer_:PROC
; char far * encrypt_type_( void )
extrn		encrypt_type_:PROC
; void set_key( unsigned char far *key )
extrn		set_key_:PROC
; void destroy_context_( void )
extrn		destroy_context_:PROC

DGROUP		GROUP	_TEXT, _DATA, _BSS

PARTLIM		STRUC
ph_drive	db	?
log_drive	db	?
g_head		db	?
g_sect		db	?
s_cyl		dw	?
s_head		db	?
s_sect		db	?
e_cyl		dw	?
e_head		db	?
e_sect		db	?
PARTLIM		ENDS

print	MACRO	from_offset
	lea	bx, from_offset
	call	o0
	ENDM

_TEXT	SEGMENT BYTE PUBLIC USE16 'CODE'
	assume	cs: DGROUP, ds: DGROUP

op_internals	proc	near
	push	ds
	push	cs
	pop	ds
	cmp	al, '1'
	jz	@@signature
	cmp	al, '2'
	jz	@@enc_type
	cmp	al, '3'
	jz	@@set_key
	cmp	al, '4'
	jz	@@destroy_context
	cmp	al, '5'
	jz	@@get_drive
	cmp	al, '6'
	jz	@@set_drive
	cmp	al, '7'
	jz	@@set_low_limit
	cmp	al, '8'
	jz	@@set_high_limit
	cmp	al, '9'
	jz	@@rem_drive
	jmp	@@ret
@@set_key:
	call	set_key_
	mov	byte ptr [is_pass], 1
	jmp	@@ret
@@destroy_context:
	call	destroy_context_
	mov	byte ptr [is_pass], 0
	jmp	@@ret
@@get_drive:
	mov	al, SIZE PARTLIM
	mul	bl
	lea	bx, part_descript
	add	bx, ax
	mov	ah, [bx].log_drive
	mov	al, [bx].ph_drive
	jmp	@@ret
@@set_drive:
	mov	al, SIZE PARTLIM
	mul	bl
	lea	bx, part_descript
	add	bx, ax
	mov	[bx].log_drive, dh
	mov	[bx].ph_drive, dl
	mov	[bx].g_head, ch
	mov	[bx].g_sect, cl
	jmp	@@ret
@@rem_drive:
	push	es si di
	mov	ax, cs
	mov	es, ax
	mov	al, SIZE PARTLIM
	mul	bl
	lea	di, part_descript
	add	di, ax
	mov	si, di
	mov	al, SIZE PARTLIM
	cbw
	add	si, ax
	sub	bl, 8
	neg	bl
	mul	bl
	mov	cx, ax
	rep	movsb
	pop	di si es
	jmp	@@ret
@@set_low_limit:
	mov	al, SIZE PARTLIM
	mul	bl
	lea	bx, part_descript
	add	bx, ax
	mov	[bx].s_cyl, dx
	mov	[bx].s_head, ch
	mov	[bx].s_sect, cl
	jmp	@@ret
@@set_high_limit:
	mov	al, SIZE PARTLIM
	mul	bl
	lea	bx, part_descript
	add	bx, ax
	mov	[bx].e_cyl, dx
	mov	[bx].e_head, ch
	mov	[bx].e_sect, cl
	jmp	@@ret
@@enc_type:
	call	encrypt_type_
	jmp	@@ret
@@signature:
	mov	ax, 7530h
	or	al, [is_pass]
@@ret:	pop	ds
	ret
op_internals	endp

block_nr	proc	near
	;	compute block number (for seed value)
	mov	al, byte ptr [g_head][si]
	mov	ah, 0
	mov	dx, [v_cyl]
	sub	dx, [s_cyl][si]
	mul	dx
	mov	dx,ax
	mov	al, [v_head]
	sub	al, [s_head][si]
	cbw
	add	ax, dx
	mov	dl, [g_sect][si]
	mov	dh, 0
	mul	dx
	mov	cx, ax
	mov	bx, dx
	mov	al, [v_sect]
	sub	al, [s_sect][si]
	cbw
	cwd
	add	ax, cx
	adc	dx, bx
IFDEF	SHOW_BLOCK
	push	dx
	push	ax
	mov	ax,dx
	call	p_dhex
	pop	ax
	push	ax
	call	p_dhex
	mov	al, ' '
	call	pr_ch
	mov	al, ' '
	call	pr_ch
	pop	ax
	pop	dx
ENDIF
	ret
block_nr	endp

IFDEF	SHOW_BLOCK
p_hex	proc	near
	push	ax
	mov	cl,4
	shr	al,cl
	call	p_half
	pop	ax
	and	al,0fh
p_half: add	al,90h		; external entry
	daa
	adc	al,40h
	daa
pr_ch:	mov	ah,0eh		; external entry
	int	10h		; display char
	ret
p_hex	endp

p_dhex	proc	near
	push	ax
	mov	al,ah
	call	p_hex
	pop	ax
	call	p_hex
	ret
p_dhex	endp
ENDIF

crypt	proc	near
	call	block_nr
	push	dx
	push	ax			; blocks / 2
	mov	al, [v_nsecs]
	shl	ax, 9
	push	ax			; size
	mov	bx, [bp + 08h]
	push	es
	push	bx			; buffer addr
	mov	al, [oper]
	cbw
	push	ax			; command
	call	transfer_
	add	sp, 12
	ret
crypt	endp

i13	proc	far
	cmp	ah, 2
	jz	op_rd
	cmp	ah, 3
	jz	op_wr
	cmp	ah, 77h
	jnz	cont13
	call	op_internals
	jmp	to_iret
op_rd:
op_wr:
	push	es ds
	pusha
	mov	bp, sp
	push	cs
	pop	ds
	mov	[oper], ah
	mov	[v_sect], cl
	and	byte ptr [v_sect], 3fh
	shr	cl, 6
	xchg	ch, cl
	mov	[v_cyl], cx
	mov	[v_head], dh
	mov	[v_nsecs], al
	lea	si, part_descript
try_again:
	cmp	byte ptr [si].ph_drive, -1
	jnz	forward
	popa
	pop	ds es
cont13:
	jmp	dword ptr cs:ex13
forward:
	cmp	byte ptr [si].ph_drive, dl
	jnz	try_next
	mov	cx, [v_cyl]
	cmp	word ptr [si].s_cyl, cx
	ja	try_next
	jb	@@f_test
	mov	dh, [v_head]
	cmp	byte ptr [si].s_head, dh
	ja	try_next
	jb	@@f_test
	mov	cl, [v_sect]
	cmp	byte ptr [si].s_sect, cl
	ja	try_next
@@f_test:
	mov	cx, [v_cyl]
	cmp	word ptr [si].e_cyl, cx
	jb	try_next
	ja	hit
	mov	dh, [v_head]
	cmp	byte ptr [si].e_head, dh
	jb	try_next
	ja	hit
	mov	cl, [v_sect]
	cmp	byte ptr [si].e_sect, cl
	jae	hit
try_next:
	add	si, SIZE PARTLIM
	jmp	try_again
hit:
	test	byte ptr [si].log_drive, 80h	; inactive ?
	jz	sect_crypt
	cmp	byte ptr [oper], 3	; do nothing for write
	jz	end_13
	mov	di, [bp + 08h]		; buffer offset
	mov	ch, [bp + 0eh]		; sector count
	xor	ax, ax
	mov	cl, al
	jcxz	end_13
	rep	stosw			; if inactive return 'empty' sectors
	jmp	end_13
sect_crypt:
	cmp	byte ptr [oper], 2
	jz	read_crypt
	test	byte ptr [si].log_drive, 20h
	jnz	read_crypt		; decrypt ?
	call	crypt
read_crypt:
	mov	es, [bp + 12h]
	mov	bx, [bp + 08h]
	mov	dx, [bp + 0ah]
	mov	cx, [bp + 0ch]
	mov	ax, [bp + 0eh]
	pushf
	call	dword ptr cs:ex13
	mov	[bp + 0eh], ax		; int 13 status
	pushf
	pop	ax
	mov	[bp + 18h], ax		; int 13 flags
	test	byte ptr [si].log_drive, 40h
	jnz	end_13			; encrypt ?
	cmp	byte ptr [oper], 2
	mov	byte ptr [oper], 2
	jz	f_crypt
	test	byte ptr [si].log_drive, 20h
	jnz	end_13			; decrypt ?
f_crypt:
	call	crypt
end_13:
	popa
	pop	ds es
to_iret:
	iret
i13	endp

; "multiplication" operation of IDEA
; mulop( word16 a, word16 b )
; CX = a , BX = b
mulop_	proc
	mov	ax, cx
	mul	bx
	or	ax, ax
	jnz	@@ab_nz
	or	dx, dx
	jz	@@ab_z
@@ab_nz:cmp	ax, dx
	adc	ax, 0
	sub	ax, dx
	jmp	ret_dw
@@ab_z: mov	ax, 1
	or	cx, cx
	jnz	@@a_nz
	sub	ax, bx
	jmp	ret_dw
@@a_nz: sub	ax, cx
ret_dw: cwd
	ret
mulop_	endp

;	Write asciiz from ds:bx
o0	proc	near
nxtltr:
	mov	dl,[bx]
	inc	bx
	mov	ah,02h		;DOS fn putchar from DL
	cmp	dl,0		;Test 0 at the END of string
	jz	exito0
	int	21h
	jmp	nxtltr
exito0: ret
o0	endp

begin:	xor	ax, ax
	mov	es, ax
	mov	ax, word ptr es:[4*13h]
	cmp	ax, offset i13	 ;test if this program was already resident
	jnz	install
	mov	ax, word ptr es:[4*13h+2]
	mov	ds, ax
	cli
	mov	ax, word ptr ex13
	mov	word ptr es:[4*13h], ax
	mov	ax, word ptr ex13+2
	mov	word ptr es:[4*13h+2], ax
	sti
	call	destroy_context_
	push	ds
	pop	es
	mov	ah, 49h		 ;release segment
	int	21h
	push	cs
	pop	ds
	print	crlf
	call	encrypt_type_
	call	o0
	print	mes_encr_daemon
	print	mes_removed
	print	crlf
	int	20h
install:
	mov	ah, 77h
	mov	al, '1'
	int	13h
	or	ax, 1
	cmp	ax, 7531h
	jnz	ok_inst
	print	crlf
	print	mes_onlyone
	print	mes_encr_daemon
	print	mes_can_inst
	print	crlf
	int	20h
ok_inst:cli
	xor	ax, ax
	mov	es, ax
	mov	ax, word ptr es:[4*13h]
	mov	word ptr ex13, ax
	mov	ax, offset i13
	mov	es:[4*13h], ax
	mov	ax, word ptr es:[4*13h+2]
	mov	word ptr ex13+2, ax
	mov	es:[4*13h+2], cs
	sti
	print	crlf
	call	encrypt_type_
	call	o0
	print	mes_encr_daemon
	print	mes_inst
	print	crlf
	mov	ah, 49h		 ;release the environment segment
	mov	es, ds:[2ch]
	int	21h
	lea	dx, crlf
	int	27h		; Terminate & stay resident
label	_small_code_

_TEXT	ENDS

_DATA	SEGMENT WORD PUBLIC USE16 'DATA'

ex13	dd	?
is_pass db	0
oper	db	?
v_sect	db	?
v_cyl	dw	?
v_head	db	?
v_nsecs db	?

label	part_descript
	PARTLIM <-1, -1>
	PARTLIM <-1, -1>
	PARTLIM <-1, -1>
	PARTLIM <-1, -1>
	PARTLIM <-1, -1>
	PARTLIM <-1, -1>
	PARTLIM <-1, -1>
	PARTLIM <-1, -1>
	dw	-1

_DATA	ENDS

_BSS	SEGMENT WORD PUBLIC USE16 'BSS'

crlf		db	0dh, 0ah, 0
mes_encr_daemon db	' encryption daemon', 0
mes_inst	db	' installed', 0
mes_removed	db	' removed from memory', 0
mes_onlyone	db	'Only one', 0
mes_can_inst	db	' can be installed', 0

_BSS	ENDS

	end

