typedef unsigned char byte;
typedef unsigned short word16;
typedef unsigned long word32;

#define GET_32BIT(cp) (((unsigned long)(unsigned char)(cp)[0] << 24) | \
		       ((unsigned long)(unsigned char)(cp)[1] << 16) | \
		       ((unsigned long)(unsigned char)(cp)[2] << 8) | \
		       ((unsigned long)(unsigned char)(cp)[3]))

#define GET_16BIT(cp) (((unsigned long)(unsigned char)(cp)[0] << 8) | \
		       ((unsigned long)(unsigned char)(cp)[1]))

#define PUT_32BIT(cp, value) do { \
  (cp)[0] = (value) >> 24; \
  (cp)[1] = (value) >> 16; \
  (cp)[2] = (value) >> 8; \
  (cp)[3] = (value); } while (0)

#define PUT_16BIT(cp, value) do { \
  (cp)[0] = (value) >> 8; \
  (cp)[1] = (value); } while (0)

#define GET_32BIT_LSB_FIRST(cp) (*(word32 far *)(cp))
#define GET_16BIT_LSB_FIRST(cp) (*(word16 far *)(cp))
#define PUT_32BIT_LSB_FIRST(cp, value) (*(word32 far *)(cp) = (value))
#define PUT_16BIT_LSB_FIRST(cp, value) (*(word16 far *)(cp) = (value))

#define READ		2
#define WRITE		3
