#ifndef IDEA_H
#define IDEA_H

typedef struct
{
  word16        key_schedule[52];
}             IDEAContext;

/* Performs the IDEA cipher transform on a block of data. */
void          idea_transform( word32, word32, word32 * );

/* Encrypts len bytes from src to dest in CFB mode.  Len need not be a multiple
   of 8; if it is not, iv at return will contain garbage.
   Otherwise, iv will be modified at end to a value suitable for continuing
   encryption. */
void          idea_cfb_encrypt( word32, unsigned char far *, unsigned int );

/* Decrypts len bytes from src to dest in CFB mode.  Len need not be a multiple
   of 8; if it is not, iv at return will contain garbage.
   Otherwise, iv will be modified at end to a value suitable for continuing
   decryption. */
void          idea_cfb_decrypt( word32, unsigned char far *, unsigned int );

#endif				/* IDEA_H */
