#ifndef DES_H
#define DES_H

typedef struct
{
  word32	key_schedule[32];
}	      DESContext;

/* Encrypts 32 bits in l,r, and stores the result in output[0] and output[1].
   Performs encryption if encrypt is non-zero, and decryption if it is zero.
   The key context must have been initialized previously with des_set_key. */
void
	      des_encrypt( word32 l, word32 r, word32 * output, int encrypt );

/* Encrypts len bytes from src to dest in CBC modes.  Len must be a multiple
   of 8.  iv will be modified at end to a value suitable for continuing
   encryption. */
void
	      des_cbc_encrypt( word32 block, unsigned char far * data, unsigned int len );

/* Decrypts len bytes from src to dest in CBC modes.  Len must be a multiple
   of 8.  iv will be modified at end to a value suitable for continuing
   decryption. */
void
	      des_cbc_decrypt( word32 block, unsigned char far * data, unsigned int len );

#endif				/* DES_H */
