/* ARCFOUR cipher (based on a cipher posted on the Usenet in Spring-95).
 * This cipher is widely believed and has been tested to be equivalent
 * with the RC4 cipher from RSA Data Security, Inc.  (RC4 is a trademark
 * of RSA Data Security)
 */

#ifndef ARCFOUR_H
#define ARCFOUR_H

typedef struct
{
  unsigned int  x;
  unsigned int  y;
  unsigned char state[256];
}             ArcfourContext;

/* Initializes the context and sets the key. */
void          set_key( unsigned char far * key );

/* Returns the next pseudo-random byte from the arcfour (pseudo-random
   generator) stream. */
unsigned int  arcfour_byte( ArcfourContext * ctx );

/* Encrypts & Decrypts data */
void
              arcfour_crypt( word32 block, unsigned char far * data, unsigned int len );
#endif				/* ARCFOUR_H */
