/* ARCFOUR cipher (based on a cipher posted on the Usenet in Spring-95).
 * This cipher is widely believed and has been tested to be equivalent
 * with the RC4 cipher from RSA Data Security, Inc.  (RC4 is a trademark
 * of RSA Data Security)
 *
 * Adapted for DOS s-e-p secure encrypted partitions (Linux compatible)
 * by Emil Laurentiu <emil@techteam.static.golden.net>
 * Date: Wednesday, 25 March 1998
 */

#include <string.h>
#include "machine.h"
#include "arcfour.h"

ArcfourContext arc4_ctx;
ArcfourContext work_ctx;

#pragma aux encrypt_type value [es bx];
char far     *
encrypt_type( void )
{
  return "ARCFOUR";
}

#pragma aux transfer parm [] caller modify [ax bx cx dx es];
int
transfer( int cmd, unsigned char far * buffer,
	  unsigned int size, word32 block )
{
  cmd = 0;
  arcfour_crypt( block, buffer, size );
  return 0;
}

/* Destroys any sensitive data in the context. */
void
destroy_context( void )
{
  memset( &arc4_ctx, 0, sizeof( arc4_ctx ) );
}

/* Sets arcfour key for encryption. */
#pragma aux set_key parm [BX ES] caller modify [ax bx cx dx es];
void
set_key( unsigned char far * key )
{
  unsigned int	t, u;
  unsigned int	keyindex;
  unsigned int	stateindex;
  unsigned char *state;
  unsigned int	counter;
  unsigned int	key_len;

  for ( key_len = 0; *( key + key_len ); key_len++ )
    ;
  state = &arc4_ctx.state[0];
  arc4_ctx.x = 0;
  arc4_ctx.y = 0;
  for ( counter = 0; counter < 256; counter++ )
    state[counter] = counter;
  keyindex = 0;
  stateindex = 0;
  for ( counter = 0; counter < 256; counter++ )
  {
    t = state[counter];
    stateindex = ( stateindex + key[keyindex] + t ) & 0xff;
    u = state[stateindex];
    state[stateindex] = t;
    state[counter] = u;
    if ( ++keyindex >= key_len )
      keyindex = 0;
  }
}

unsigned int
arcfour_byte( ArcfourContext * ctx )
{
  unsigned int	x;
  unsigned int	y;
  unsigned int	sx, sy;
  unsigned char *state;

  state = ctx->state;
  x = ( ctx->x + 1 ) & 0xff;
  sx = state[x];
  y = ( sx + ctx->y ) & 0xff;
  sy = state[y];
  ctx->x = x;
  ctx->y = y;
  state[y] = sx;
  state[x] = sy;
  return state[( sx + sy ) & 0xff];
}

void
arcfour_crypt( word32 block, unsigned char far * data, unsigned int len )
{
  unsigned int	i;
  word32	k;

  for ( i = 0; i < len; i++ )
  {
    if ( i % 0x200 == 0 )
    {
      memcpy( &work_ctx, &arc4_ctx, sizeof( ArcfourContext ) );
      k = ( block + i / 0x200 ) / 2;
      work_ctx.x = k & 0xffff;
      work_ctx.y = ( k >> 16 ) & 0xffff;
    }
    data[i] ^= arcfour_byte( &work_ctx );
  }
}
