//
// TRSA component demo
//
// Copyright Cygron 1997
//

unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, RSA, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    RSA1: TRSA;
    ButtonEncode: TButton;
    ButtonDecode: TButton;
    Label1: TLabel;
    Memo3: TMemo;
    Edit1: TEdit;
    Edit3: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    LabelProgress: TLabel;
    Button2: TButton;
    Button3: TButton;
    ListBox1: TListBox;
    Label4: TLabel;
    Label5: TLabel;
    UpDown1: TUpDown;
    Edit2: TEdit;
    Label6: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ButtonEncodeClick(Sender: TObject);
    procedure ButtonDecodeClick(Sender: TObject);
    procedure RSA1Progress(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  public
    pub,priv: TRSAKey;
    procedure ShowKey;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ShowKey;
begin
  ButtonDecode.Enabled := False;
  Edit1.Text := 'Test message';
  ListBox1.Clear;
  Edit3.Text := IntToStr(Priv.m_16Bits);
  Memo3.Clear;
  Memo3.Lines.Add('n=' + pub.m_mod.ToStr);
  Memo3.Lines.Add('e=' + pub.m_a.ToStr);
  Memo3.Lines.Add('d=' + priv.m_a.ToStr);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  pub := TRSAKey.Create;
  priv := TRSAKey.Create;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Randomize;
  Screen.Cursor := crHourglass;
  LabelProgress.Caption := '';
  try
    RSA1.GenerateKey(StrToInt(Edit3.Text),pub,priv);
  finally
    Screen.Cursor := crDefault;
    ShowKey;
    LabelProgress.Caption := '';
    ButtonEncode.Enabled := TRUE;
    Button2.Enabled := TRUE;
    Button3.Enabled := TRUE;
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  pub.Free;
  priv.Free;
end;

procedure TForm1.ButtonEncodeClick(Sender: TObject);
var
  output: Pointer;
  o: ^TBigArray;
  i,ol: Longint;
  buffer: array[0..1000] of char;
  il: Longint;
begin
  Screen.Cursor := crHourglass;
  LabelProgress.Caption := '';
  strpcopy(buffer,Edit1.Text);
  il := strlen(@buffer);
  RSA1.Encode(pub,@buffer,il,output,ol);
  o := output;
  ListBox1.Clear;
  for i := 1 to ol do ListBox1.Items.Add(IntToStr(o[i]));
  FreeMem(output);
  ButtonDecode.Enabled := True;
  Screen.Cursor := crDefault;
end;

procedure TForm1.ButtonDecodeClick(Sender: TObject);
var
  output: Pointer;
  o: ^TBigArray;
  i,ol: Longint;
  buffer: array[0..1000] of byte;
  il: Longint;
  s: String;
begin
  Screen.Cursor := crHourglass;
  LabelProgress.Caption := '';
  for i := 0 to ListBox1.Items.Count-1 do buffer[i] := StrToInt(ListBox1.Items[i]);
  il := ListBox1.Items.Count;
  RSA1.Decode(priv,@buffer,il,output,ol);
  o := output;
  s := '';
  for i := 1 to ol do s := s + char(o[i]);
  Edit2.Text := s;
  FreeMem(output);
  Screen.Cursor := crDefault;
end;

procedure TForm1.RSA1Progress(Sender: TObject);
begin
  if Length(LabelProgress.Caption)>40
  then LabelProgress.Caption := 'x'
  else LabelProgress.Caption := LabelProgress.Caption + 'x';
  LabelProgress.Update;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  pub.Save(ExtractFilePath(Application.ExeName)+'pub.key');
  priv.Save(ExtractFilePath(Application.ExeName)+'priv.key');
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  pub.Load(ExtractFilePath(Application.ExeName)+'pub.key');
  priv.Load(ExtractFilePath(Application.ExeName)+'priv.key');
  Edit3.Text := IntToStr(pub.m_16Bits);
  ShowKey;
end;



end.
