{
 Program:  ROT13.PAS
  Author:  Eric E. A. Schreiber
Function:  Rotate 13, for simple alphabet encryption
}

{ Algorithm:  Get file name from command line, else halt.  Open source }
{ and temp files.  Read each line from source, inspect each char in    }
{ line.  If matches 'a'..'z' or 'A'..'Z' (match strings) then replace  }
{ with character found 13 places later in match strings.  If 13th is   }
{ past end of match string, then subtract 26 (effecively looping back) }
{ Repeat for each char in each string, and write line to temp file.    }
{ When done, close both files, delete original, and rename temp to     }
{ original filename.                                                   }
{ Notes:  This program will both encrypt and decrypt text files, since }
{ 13 is half the length of the alphabet.  ROT13 will not change any    }
{ characters except letters.  Number, punctuation, and other ascii     }
{ items will be unaffected.                                            }
{ Acknowledgements:  I got the idea for writing this from the Usenet   }
{ function of the same name.  It can be used for encoding any message  }
{ that you don't want to be readily understood.  Anyone with a pencil  }
{ and 5 minutes could decode a ROT13ed message.                        }


program ROT13;

uses Dos;

var
  TempFile,                 { * Temporary work file             * }
  TextFile     : Text;      { * File handle for textfile        * }
  FileName,                 { * Source file name from paramstr  * }
  BigSet,                   { * String of Uppercase letters     * }
  LitSet,                   { * String of Lowercase letters     * }
  TextString   : String;    { * Line being altered from source  * }
  CharPos,                  { * Position of char in B/L string  * }
  Counter      : Integer;   { * Loop control counter            * }


{ *** If char at Counter is in LitSet, replace with 13th succ *** }
procedure SwapLittle;
begin

  CharPos := Pos (TextString[Counter], LitSet);
  if CharPos <> 0 then
  begin
  
    CharPos := CharPos + 13;
    if CharPos > 26
    then CharPos := CharPos - 26; { ** Correct for overrun ** }

    Delete (TextString, Counter, 1);
    Insert (LitSet [CharPos], TextString, Counter);
    
  end;
  
end;


{ *** If char at Counter is in BigSet, replace with 13th succ *** }
procedure SwapBig;
begin

  CharPos := Pos (TextString[Counter], BigSet);
  if CharPos <> 0 then
  begin

    CharPos := CharPos + 13;
    if CharPos > 26
    then CharPos := CharPos - 26; { ** Correct for overrun ** }

    Delete (TextString, Counter, 1);
    Insert (BigSet [CharPos], TextString, Counter);
    
  end;
  
end;


begin  { *** Mainline *** }

  { *** Check for parameters, halt if not = 1 *** }
  if ParamCount <> 1 then
  begin

    Writeln ('Must specify a filename to rotate...');
    Halt;
    
  end;

  { *** Get filename from command line *** }
  FileName := ParamStr(1);

  { *** Attempt to open source file *** }
  Assign (TextFile, FileName);
  {$I-} Reset (TextFile); {$I+}
  if IOResult <> 0 then
  begin
  
    Writeln ('Error opening file ', ParamStr(1));
    Halt;
    
  end;

  { *** Attempt to open temporary file *** }
  Assign (TempFile, '$$$$$$$$.$$$');
  {$I-} Rewrite (TempFile); {$I+}
  if IOResult <> 0 then
  begin
  
    Writeln ('Error creating temporary work file...');
    Halt;
    
  end;

  { *** Assign letter strings *** }
  BigSet := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  LitSet := 'abcdefghijklmnopqrstuvwxyz';

  { *** Read each line from textfile *** }
  while not EOF (TextFile) do
  begin
  
    Readln (TextFile, TextString);
    for Counter := 1 to Length (TextString) do
    begin
    
      SwapLittle;
      SwapBig;

    end;
    
    Writeln (TempFile, TextString);
    
  end;

  { *** Close all, delete source file and rename temp file *** }
  Close (TempFile);
  Close (TextFile);
  Erase (TextFile);
  Rename (TempFile, FileName);

end.
