#ifndef IDEA_H
#define IDEA_H

/*
 *	idea.h - header file for idea.c
 */

#include "usuals.h"  /* typedefs for byte, word16, boolean, etc. */

#define IDEAKEYSIZE 16
#define IDEABLOCKSIZE 8

#define IDEAROUNDS 8
#define IDEAKEYLEN (6*IDEAROUNDS+4)

/*
 * iv[] is used as a circular buffer.  bufleft is the number of
 * bytes at the end which have to be filled in before we crank
 * the block cipher again.  We do the block cipher operation
 * lazily: bufleft may be 0.  When we need one more byte, we
 * crank the block cipher and set bufleft to 7.
 *
 * oldcipher[] holds the previous 8 bytes of ciphertext, for use
 * by blockCfbSync() and Phil's, ahem, unique (not insecure, just
 * unusual) way of doing CFB encryption.
 */

void ideaExpandKey(byte const *userkey, word16 * EK);
void ideaCipher(byte const inbuf[8], byte outbuf[8], word16 const *key);

#endif /* !IDEA_H */
