#ifndef BLOCK_H
#define BLOCK_H

/*
 *	block.h - header file for block.c
 */

#include "usuals.h"  /* typedefs for byte, word16, boolean, etc. */

#include "idea.h"
#include "cast5.h"

#define BLOCKKEYSIZE 16 /* max( IDEAKEYSIZE , CASTKEYSIZE ) */

/*
 * iv[] is used as a circular buffer.  bufleft is the number of
 * bytes at the end which have to be filled in before we crank
 * the block cipher again.  We do the block cipher operation
 * lazily: bufleft may be 0.  When we need one more byte, we
 * crank the block cipher and set bufleft to 7.
 *
 * oldcipher[] holds the previous 8 bytes of ciphertext, for use
 * by blockCfbSync() and Phil's, ahem, unique (not insecure, just
 * unusual) way of doing CFB encryption.
 */
struct BlockCfbContext {
	byte oldcipher[8];
	byte iv[8];
	word16 idea_key[IDEAKEYLEN];
    CAST5_context C5ctx;
	int bufleft;
    int Cipher;
};

struct BlockRandContext {
	byte outbuf[8];
    CAST5_context C5ctx;
	int bufleft;
	byte internalbuf[8];
};

void blockCfbReinit(struct BlockCfbContext *context, byte const *iv);
void blockCfbInit(struct BlockCfbContext *context, byte const (key[16]), int Cipher);
void blockCfbSync(struct BlockCfbContext *context);
void blockCfbDestroy(struct BlockCfbContext *context);
void blockCfbEncrypt(struct BlockCfbContext *context,
		    byte const *src, byte *dest, int count);
void blockCfbDecrypt(struct BlockCfbContext *context,
		    byte const *src, byte *dest, int count);

void blockRandInit(struct BlockRandContext *context, byte const (key[16]),
		  byte const (seed[8]));
byte blockRandByte(struct BlockRandContext *c);
void blockRandWash(struct BlockRandContext *c, struct BlockCfbContext *cfb);
void blockRandState(struct BlockRandContext *c, byte key[16], byte seed[8]);

#endif /* BLOCK_H */
