;;
;; MiCRoXoR  --  silly .com file crypter with 16/17 byte decrypter
;;
;; Copyright (c) 2000 by Joergen Ibsen / Jibz
;; All Rights Reserved
;;

; Note: This was thrown together in about 30 minutes, after reading
;       about the worlds smallest xor-com-crypter having an 18 byte
;       decrypter. It has not been tested in any way, and was just
;       made to amuse the people on the exe-list (Hi! ;-).

; The decrypter assumes that si = 0100h on load. This is true for DOS,
; but if you add another crypter after MiCRoXoR (or you are using Win2K)
; it may not be the case. If this variable is set to 0, the decrypter
; will be 1 byte larger, but will not use the assumption on si
ASSUME_SI_0100h equ 1

code segment byte public
assume cs:code, ds:code, es:code

.386

org 100h

start:
        mov     ah, 9
        mov     dx, offset intro
        int     21h

        mov     ah, 4ah
        mov     bh, 32
        int     21h                     ; resize mem block to 128k
        jc      _mem_error              ; mem error?

; ===================================================================
;  get filename
; ===================================================================
        mov     si, 0081h
skipspaces:
        lodsb
        cmp     al, " "
        je      short skipspaces
        jb      _syntax                 ; no filename given

        lea     dx, [si - 1]            ; ds:dx -> filename
findend:
        lodsb
        cmp     al, " "
        ja      short findend

        mov     ax, 3d02h
        xor     cx, cx
        mov     byte ptr [si - 1], cl   ; zero terminate filename

        int     21h                     ; open file (read/write)
        jc      _open_error             ; open error?

        xchg    ax, bx                  ; bx = handle

; ===================================================================
;  read file
; ===================================================================
        mov     ax, cs
        add     ah, 10h
        mov     ds, ax                  ; ds -> next segment

        mov     dx, 0103h
        mov     di, dx

        mov     cx, 0fe00h
        mov     ah, 3fh
        int     21h                     ; read from file
        jc      _read_error             ; read error?

        cmp     ax, cx
        je      _format_error           ; format error?

        cmp     word ptr [di - 3], 'MZ'
        je      _format_error           ; format error?

        cmp     word ptr [di - 3], 'ZM'
        je      _format_error           ; format error?

; ===================================================================
;  encrypt file
; ===================================================================
        push    es                      ;
        push    ds                      ; es -> file
        pop     es                      ; ds -> MiCRoXoR
        pop     ds                      ;

        mov     word ptr [file_size + 1], ax ; store file size in decrypter
        xchg    ax, cx                  ; cx = filesize

crypt_next:
        xor     es:[di], cl             ;
        inc     di                      ; encrypt code
        loop    crypt_next              ;

        mov     ax, di                  ; ax = absolute offset of decrypt

        mov     si, offset handler      ;
        mov     cx, HANDLER_SIZE        ; append decrypter
        rep     movsb                   ;

        push    es                      ;
        push    ds                      ; es -> MiCRoXoR
        pop     es                      ; ds -> file
        pop     ds                      ;

        sub     ax, 0103h               ; ax = relative offset of decrypt
        mov     byte ptr ds:[0100h], 0e8h
        mov     ds:[0101h], ax          ; add call to decrypter

; ===================================================================
;  write encrypted file
; ===================================================================
        xor     cx, cx                  ;
        xor     dx, dx                  ;
        mov     ax, 4200h               ;
        int     21h                     ; lseek to begin of file
        jc      _write_error            ; seek error?

        mov     dx, 0100h               ; dx -> crypted file
        mov     cx, di
        sub     cx, dx                  ; cx = crypted size

        mov     ah, 40h
        int     21h                     ; write to file
        jc      _write_error            ; write error?

_ok:
        call    _error
        db      'File encyption successfull!$'

; ===================================================================
;  error handling
; ===================================================================
intro:
        db      '-------------------------------------------------------------------------------',0dh,0ah
        db      'MiCRoXoR (just for fun ;-)           Copyright (c) 2000 by Joergen Ibsen / Jibz',0dh,0ah
        db      '                                                            All Rights Reserved',0dh,0ah
        db      '-------------------------------------------------------------------------------',0dh,0ah
        db      0dh,0ah,'$'

_syntax:
        call    _error
        db      ' Syntax:   MiCRoXoR <filename>',0dh,0ah
        db      0dh,0ah
IF ASSUME_SI_0100h EQ 0
        db      'This version does not assume SI = 0100h, and should be Win2K compatible.',0dh,0ah
        db      0dh,0ah
        db      'MiCRoXoR will encrypt the file, adding 17 bytes for decryption.',0dh,0ah
ELSE
        db      'This version assumes SI = 0100h, and is not Win2K compatible.',0dh,0ah
        db      0dh,0ah
        db      'MiCRoXoR will encrypt the file, adding 16 bytes for decryption.',0dh,0ah
ENDIF
        db      'The original file is overwritten.',0dh,0ah
        db      '$'

_mem_error:
        call    _error
        db      'ERR: mem error!$'

_open_error:
        call    _error
        db      'ERR: could not open file!$'

_read_error:
        call    _error
        db      'ERR: could not read from file!$'

_format_error:
        call    _error
        db      'ERR: file is not a .com file or too big!$'

_write_error:
        call    _error
        db      'ERR: could not write to file!$'

_error:
        pop     dx                      ;
        push    cs                      ; ds:dx -> error message
        pop     ds                      ;
        mov     ah, 09h
        int     21h                     ; print error message
        int     20h                     ; exit to DOS

; ===================================================================
;  decrypter
; ===================================================================
handler:

IF ASSUME_SI_0100h EQ 0
        mov     di, 0100h               ; di = 0100h
        pop     si                      ; si = 0103h
ELSE
        mov     di, si                  ; di = 0100h (assumes si = 0100h)
        pop     si                      ; si = 0103h
ENDIF

        push    di                      ; push return address
file_size:
        mov     cx, 1234h               ; # bytes to decrypt
next:
        xor     [si], cl                ; xor byte with counter
        movsb                           ; move byte to right position
        loop    next
        ret                             ; return to decrypted code

HANDLER_SIZE equ $ - handler

code ends

end start
