unit test_unit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TfrmRegistration = class(TForm)
    btnRegister: TButton;
    btnExit: TButton;
    eUserInfo: TEdit;
    eKey: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label2: TLabel;
    Label5: TLabel;
    lbUserInfo: TLabel;
    lbKey: TLabel;
    Bevel1: TBevel;
    btnDeleteKey: TButton;
    Label1: TLabel;
    procedure btnExitClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnRegisterClick(Sender: TObject);
    procedure btnDeleteKeyClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmRegistration: TfrmRegistration;

implementation

uses enigma_ide;

{$R *.dfm}

procedure TfrmRegistration.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TfrmRegistration.FormShow(Sender: TObject);
var
  pcKey, pcUserInfo : PChar;
begin

  {$I Inc/reg_crypt_begin.inc}
  // Hide "UNREGISTERED" label if application is registered,
  // key is valid and reg_crypt_section was encrypted
  Label1.Visible := false;
  {$I Inc/reg_crypt_end.inc}

  if LoadAndCheckKey then
  begin
    if LoadKey(pcUserInfo, pcKey) then
    begin
      lbUserInfo.Caption := pcUserInfo;
      lbKey.Caption := pcKey;
    end;
  end else
    ShowMessage('*************   Reminder window   *************'#13#10#13#10#13#10 +
                '   Register software to remove this message!   '#13#10 +
                '    For registration visit www.YourProduct.com    '#13#10#13#10);
end;

procedure TfrmRegistration.btnRegisterClick(Sender: TObject);
var
  pcKey, pcUserInfo : PChar;
begin
  if CheckAndSaveKey(PChar(eUserInfo.Text), PChar(eKey.Text)) then
  begin
    if LoadKey(pcUserInfo, pcKey) then
    begin
      lbUserInfo.Caption := pcUserInfo;
      lbKey.Caption := pcKey;
      ShowMessage('Thanks for registration! Restart application to complete registration.');
    end;
  end else ShowMessage('Invalid key');
end;

procedure TfrmRegistration.btnDeleteKeyClick(Sender: TObject);
begin
  DeleteKey;
end;

end.
