unit test_unit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls;

type          
  TForm1 = class(TForm)
    Label1: TLabel;
    dateExpiration: TDateTimePicker;
    Label2: TLabel;
    editHardware: TEdit;
    Label3: TLabel;
    editKey: TEdit;
    Label4: TLabel;
    btnGenProject: TButton;
    btnGen: TButton;
    memoUser: TMemo;
    procedure btnGenClick(Sender: TObject);
    procedure btnGenProjectClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{$I inc/enigma_keygen.inc}
procedure TForm1.btnGenClick(Sender: TObject);
var
  kp : TKeyParams;
  KeyBuf : array [0..$FF] of byte;
  expDay, expMonth, expYear : word;
  sUserInfo : string;
  GenResult : PChar;
begin
  FillChar(kp, SizeOf(kp), 0);
  FillChar(KeyBuf, SizeOf(KeyBuf), 0);
  sUserInfo := Trim(memoUser.Text);
  DecodeDate(dateExpiration.Date, expYear, expMonth, expDay);
  with kp do
  begin
    Key := @KeyBuf;
    KeyLen := SizeOf(KeyBuf);
    UserInfo := PChar(sUserInfo);
    UserInfoLen := StrLen(kp.UserInfo);
    ExrirationYear := expYear;
    ExpirationMonth := expMonth;
    ExpirationDay := expDay;
    HardwareID := PChar(editHardware.Text);
    A := 'CECB532D507556AA9FA9ABA0F5411508';
    D := 'HNZ7RNW3YU2M6NTS4NUU64GYT778E8E737GQ6EDQRFH67WP44VJDRLSSTJNHUHEHHNFZ98J65KRKYGZNQ8TKP624BD8RCWKTMLVBX';
    N := '4TWMD8B6B726PQAK2WCJSMADEECTEJ2BJKTQCAD23EHNUW74XW8JX3Y6SHFTQ7Y2JZFM7NZARDMP8GNXJ4ESWHLPJQZZAFRU6CU4KB';
  end;
  GenResult := GenerateRegistrationKey(kp);
  if GenResult = nil then
    editKey.Text := PChar(kp.Key)
  else
    editKey.Text := string(GenResult);
end;

procedure TForm1.btnGenProjectClick(Sender: TObject);
var
  kp : TKeyParams;
  KeyBuf : array [0..$FF] of byte;
  expDay, expMonth, expYear : word;
  sUserInfo : string;
  GenResult : PChar;
  sProjectFileName : string;
begin
  FillChar(kp, SizeOf(kp), 0);
  FillChar(KeyBuf, SizeOf(KeyBuf), 0);
  sUserInfo := Trim(memoUser.Text);
  DecodeDate(dateExpiration.Date, expYear, expMonth, expDay);
  with kp do
  begin
    Key := @KeyBuf;
    KeyLen := SizeOf(KeyBuf);
    UserInfo := PChar(sUserInfo);
    UserInfoLen := StrLen(kp.UserInfo);
    ExrirationYear := expYear;
    ExpirationMonth := expMonth;
    ExpirationDay := expDay;
    HardwareID := PChar(editHardware.Text);
  end;
  sProjectFileName := ExtractFilePath(ParamStr(0)) + 'enigma_test.ini';
  GenResult := GenerateRegistrationKeyFromProject(PChar(sProjectFileName), kp);
  if GenResult = nil then
    editKey.Text := PChar(kp.Key)
  else
    editKey.Text := string(GenResult);
end;

end.
