

/** 
  *	SHA1.h
  *	header file for SHA1.cpp 
  * Copright (C) 1998 Markus Hahn
  *	last update: 1 Mar 98
  */

#ifndef __SHA_H
#define __SHA_H

#include "BasicTypes.h"

// size of an SHA-1 digest
#define SHA1_DIGESTSIZE	20

// the SHS block size (in bytes)
#define SHA1_DATASIZE	64


// structure for storing SHA info 
#pragma pack(push, 1)
typedef struct {
  WORD32 digest[5];					// message digest
  WORD32 lCountLo, lCountHi;		// 64bit bit counter
  WORD32 data[16];					// SHS data buffer
  WORD8 dataBuffer[SHA1_DATASIZE];	// byte buffer for data
  BYTEBOOL blDone;					// whether final digest present
} SHA1CTX;
#pragma pack(pop)



/**
  * sets up an SHA-1 context
  * @param pCtx pointer to SHA-1 context
  */
void __stdcall 
    SHA1_Init( SHA1CTX* pCtx );


/**
  * scrambles a bunch of bytes to the digest
  * @param pCtx pointer to SHA-1 context
  * @param pData pointer to data to scramble
  * @param lNumOfBytes number of bytes to scramble
  */
void __stdcall 
    SHA1_Update ( SHA1CTX* pCtx,
	              void* pData,
	              WORD32 lNumOfBytes );


/**
  * finalize the scrambling, copies the digest
  * @param pDigest pointer to the digest storage
  * @param pCtx pointer to SHA-1 context
  */
void __stdcall 
    SHA1_Final( WORD8* pDigest,
	            SHA1CTX* pCtx );


/**
  * executes a selftest
  * @return  BOOL_TRUE: selftest succeded / FALSE: selftest failed
  */
BYTEBOOL __stdcall 
   SHA1_SelfTest();


#endif
