
/**
  *	RandomPool.h
  *	header file for RandomPool.cpp
  *	Copyright (C) 1998 Markus Hahn
  *	last update: 7 Nov 98
  */

#ifndef __RANDOMPOOL_H
#define __RANDOMPOOL_H

#include "BasicTypes.h"

// we use SHA-1 for creating random numbers
#include "SHA1.h"

// context type for random data creation
#pragma pack(push, 1)
typedef struct {
  // for holding the last digest, our random pool
  WORD8 pool[SHA1_DIGESTSIZE];
  // number of remaining bytes in the pool
  WORD32 lPoolSize;
} RANDOMPOOLCTX;
#pragma pack(pop)


/**
  * sets up a new random pool context
  * @param pCtx pointer to context
  * @param pAddSeed pointer to additional seed data (ignored if NULL)
  * @param lAddSeedLen number of additional seed bytes (ignored if pAddSeed equals NULL)
  */
void __stdcall 
    RandomPool_Startup( RANDOMPOOLCTX* pCtx,
	                    void* pAddSeed,
                        WORD32 lAddSeedLen );

/**
  * adds seed to the random generator
  * @param pCtx pointer to context
  * @param pSeed pointer to the seed data
  * @param lSeedLen number of seed bytes
  */
void __stdcall 
    RandomPool_Reseed( RANDOMPOOLCTX* pCtx,
	                   void* pSeed,
                       WORD32 lSeedLen );


/**
  * returns random bytes
  * @param pCtx pointer to context
  * @param pDataTarget pointer to target buffer
  * @param lNumOfBytes number of random bytes to deliver
  */
void __stdcall 
    RandomPool_GetData( RANDOMPOOLCTX* pCtx,
               		    void* pDataTarget,
						WORD32 lNumOfBytes );

#endif