

/**
  * MD5.h
  * header for the MD5 digest algorithm
  * Copyright (C) 1998 Markus Hahn
  * last update: 7 Nov 98
  */

#ifndef __MD5_H
#define __MD5_H

#include "BasicTypes.h"

// size of an MD5 digest
#define MD5_DIGESTSIZE	16


// MD5 context
#pragma pack(push, 1)
typedef struct {
  WORD32 state[4];	// state (ABCD)
  WORD32 count[2];  // number of bits, modulo 2^64 (lsb first)
  WORD8 buffer[64];	// input buffer
} MD5CTX;
#pragma pack(pop)



/**
  * initialization, begins an MD5 operation, writing a new context
  * @param pCtx pointer to MD5 context
  */
void __stdcall 
    MD5_Init( MD5CTX* pCtx );



/**
  * block update operation, continues an MD5 message-digest operation,
  * processing another message block, and updating the context
  * @param pCtx pointer to MD5 context
  * @param pData pointer to input buffer, which is treated as a byte buffer
  * @param lNumOfBytes number of bytes to scramble
  */
void __stdcall 
    MD5_Update( MD5CTX* pCtx,
	            void* pData,
                WORD32 lNumOfBytes );



/**
  * MD5 finalization, ends an MD5 message-digest operation,
  * writing the message digest and clearing the context
  * @param digest buffer where to copy the digest's bytes
  * @param pCtx pointer to MD5 context
  */
void __stdcall 
    MD5_Final( WORD8 digest[MD5_DIGESTSIZE],
	           MD5CTX* pCtx );


/**
  * selftest
  * @return BOOL_TRUE: selftest succeded / BOOL_FALSE: error
  */
BYTEBOOL __stdcall 
    MD5_SelfTest();

#endif
