

/**
  *	LZSS.h
  *	header file for LZSS.cpp
  * Copright (C) 1998 Markus Hahn
  *	last update: 7 Nov 98
  */

#ifndef __LZSS_H
#define __LZSS_H

#include "BasicTypes.h"

// the condition codes, these are bitflags
#define  LZSS_START  1
#define  LZSS_WORK   2
#define  LZSS_STOP   4


// some compressor constants
#define LZSS_N          4096    // size of ring buffer
#define LZSS_F            18    // upper limit for match_length
#define LZSS_THRESHOLD	   2    // encode string into position and length
							    // if match_length is greater than this
#define LZSS_NIL	  LZSS_N    // index for root of binary search trees



// an LZSS context, due to its size (> 16kB) it should be dynamically
// allocated by the caller to avoid stack overflow problems

#pragma pack(push, 1)
typedef struct {

	// state freeze for compression
  BYTEBOOL blSaveDone;
  int nSaveI, nSaveR, nSaveC, nSaveLen, nSaveS;
  int nSaveLastMatchLength, nSaveCodeBufPtr;
  WORD8 bSaveMask;
  WORD8 saveCode_buf[17];
  // state freeze for decompression (additional necessary data)
  int nSaveJ, nSaveK;
  WORD16 wSaveFlags;
  // the interrupt point code
  WORD16 wInterruptPoint;

  // general runtime stuff
  WORD8 text_buf[LZSS_N + LZSS_F - 1];		// ring buffer of size N, with
                                            // extra F-1 bytes to facilitate
                                            // string comparison
  int nMatchPosition, nMatchLength;   // of longest match.
  // these are set by the insertNode() procedure.
  int lson[LZSS_N + 1];     // left & right children & parents
  int rson[LZSS_N + 257];	// these constitute binary search trees
  int dad[LZSS_N + 1];
  // for readByte() and writeByte()
  WORD32 lSourceSize;
  WORD32 lDrainSize;
  WORD32 lBytesRead;
  WORD32 lBytesWritten;
  WORD8* pDataSource;
  WORD8* pDataDrain;
  // End Of Data (stream)
  BYTEBOOL blEOD;

} LZSSCTX;
#pragma pack(pop)


/**
  * compresses a buffer content into a second buffer, due to
  * the stream characteristic of the original source we need 
  * a clever interruption technique, and it's not guaranteed
  * that there'll be something in the target buffer, so the
  * target buffer should be least 12.5% larger than the source
  * @param pCtx pointer to work context
  * @param pSource pointer to source buffer
  * @param pTarget pointer to target buffer
  * @param lNumOfBytes number of bytes to compress
  * @param bCondition code number, for sending start and stop signals
  * @return number of compressed bytes
  */
WORD32 __stdcall 
    LZSS_Compress( LZSSCTX* pCtx,
	               void* pSource,
                   void* pTarget,
	               WORD32 lNumOfBytes,
	               WORD8 bCondition);

				   
/**
  * decompresses a data stream, has two interrupt
  * possibilities in a cycle: either a buffer has been
  * processed completely or the output buffer is full and
  * needs to be emptied
  * @param pCtx pointer to work context
  * @param pSource pointer to source buffer
  * @param pTarget pointer to target buffer
  * @param lNumOfBytes number of bytes to decompress
  * @param lSizeOfOutputBuffer size of the output buffer
  * @param bCondition code number, for sending start and stop signals
  * @param pblRepeatMe pointer to a flag which 
  *        a) lets the routine detect that not all input data
  *           of the last cycle has been decompressed
  *        b) forces the caller to empty its output buffer
  *           and to recall (!) the routine
  *        (the flag has to be set to BOOL_FALSE for a new input buffer)
  * @return number of decompressed bytes when the cycle is finished
  */
WORD32 __stdcall 
    LZSS_Decompress( LZSSCTX* pCtx,
	                 void* pSource,
                     void* pTarget,
	                 WORD32 lNumOfBytes,
	                 WORD32 lSizeOfOutputBuffer,
	                 WORD8 bCondition,
	                 BYTEBOOL* pblRepeatMe);

#endif

