
/**
  * CRC32.h
  * header for the CRC32.cpp file
  * Copyright (C) 1998 Markus Hahn
  * last update: 7 Nov 98
  */

#ifndef __CRC32_H
#define __CRC32_H

#include "BasicTypes.h" 

// startup value for a CRC32
#define CRC32_INITVALUE  0xffffffff
// xor this value to finish a CRC32
#define CRC32_DONEVALUE  0xffffffff


/**
  * updates an existing CRC32
  * @param lOldCRC32 old CRC32
  * @param pData pointer to (byte) buffer
  * @param lNumOfBytes number of bytes to process
  * @return new CRC32
  */
WORD32 __stdcall 
    CRC32_Update( WORD32 lOldCRC32,
	              void* pData,
                  WORD32 lNumOfBytes );


#endif
