

/**
  *	TMS.h
  *	header for the TMS UCDI driver
  *	Copyright (C) 1997/1998 Markus Hahn
  *	last update: 26 July 98
  */

#ifndef __TMS_UCDI_H
#define __TMS_UCDI_H

#include "UCDI_Def.h"

// TMS "characteristics", simulate a stream cipher
// depending on a 16bit key
#define TMS_BLOCKSIZE	1
#define TMS_KEYSIZE		2


WORD32 __cdecl TMS_GetDriverInfo(UCDIINFOBLOCK* pInfo);

WORD32 __cdecl TMS_SelfTest (void* pTestContext);

WORD32 __cdecl TMS_CreateWorkContext(void* pContext,
                                     WORD8* pKey,
                                     WORD16 wKeyLen,
                                     WORD16 wMode,
                                     void* pInitData,
#ifndef __EXTENDED_UCDI
                                     UCDI_RandomGenerator GetRndBytes,
						         	 void* pRndGenData);
#else
                                     UCDI_RandomGenerator GetRndBytes);
#endif

void  __cdecl TMS_ResetWorkContext(void* pContext,
                                   WORD16 wMode,
                                   void* pInitData,
#ifndef __EXTENDED_UCDI
                                   UCDI_RandomGenerator GetRndBytes,
						           void* pRndGenData);
#else
                                   UCDI_RandomGenerator GetRndBytes);
#endif

WORD32 __cdecl TMS_DestroyWorkContext (void* pContext);

void __cdecl TMS_EncryptBuffer(void* pContext,
			          		   void* pSource,
					           void* pTarget,
  	       		          	   WORD32 lNumOfBytes);

void __cdecl TMS_DecryptBuffer(void* pContext,
				          	   void* pSource,
				          	   void* pTarget,
  				        	   WORD32 lNumOfBytes,
					           void* pPreviousBlock);

#endif
