
/**
  * TMS.cpp
  * UCDI driver implemention of zero encryption, don't use this driver
  * in the real world, but just for debugging your applications
  * (TMS stands for "Too Many Secrets" :)
  *	Copyright (C) 1998 Markus Hahn
  * last update: 26 July 98
  */


#include "TMS.h"


#pragma pack(push, 1)
typedef struct {

  // just one dummy word
  WORD32 lDummy;

} TMSCTX;
#pragma pack(pop)



// driver title
#ifdef __EXTENDED_UCDI
  static char* _TMS_UCDI_DRIVERNAME = "TMS Extended UCDI Driver 0.02";
#else
  static char* _TMS_UCDI_DRIVERNAME = "TMS UCDI Driver 0.02";
#endif



WORD32 __cdecl TMS_GetDriverInfo(UCDIINFOBLOCK* pInfo) {

  // prepare the information context
  UCDIINFOBLOCK tempinfo;
  tempinfo.wSizeOf = pInfo->wSizeOf;
  tempinfo.pDriverName = (WORD8*) _TMS_UCDI_DRIVERNAME;
  tempinfo.wBlockSize = TMS_BLOCKSIZE;
  tempinfo.wKeySize = TMS_KEYSIZE;
#ifndef __EXTENDED_UCDI
  tempinfo.blBlockLink = BOOL_FALSE;
#endif
  tempinfo.blOwnHasher = BOOL_FALSE;
  tempinfo.wInitDataSize = 0;
  tempinfo.lContextSize = sizeof(TMSCTX);
#ifdef __EXTENDED_UCDI
  tempinfo.wVersion = (UCDI_VERSION_MAJOR << 8) | UCDI_VERSION_MINOR;
  tempinfo.bCipherIs = UCDI_CIPHERIS_BLOCK;
#endif
  // copy as many bytes of the information block as possible
  WORD8* pSrc = (WORD8*) &tempinfo;
  WORD8* pDst = (WORD8*) pInfo;
  for (int nI = 0; nI < tempinfo.wSizeOf; nI++)
    *pDst++ = *pSrc++;
  return UCDI_ERROR_NOERROR;
};


WORD32 __cdecl TMS_SelfTest (void* pTestContext) {
  // no selftest implemented until now,
  // so we assume a proper implementation
  return UCDI_ERROR_NOERROR;
};


WORD32 __cdecl TMS_CreateWorkContext(void* pContext, WORD8* pKey,
                                     WORD16 wKeyLen, WORD16 wMode,
                                     void* pInitData,
#ifdef __EXTENDED_UCDI
                                     UCDI_RandomGenerator GetRndBytes,
		           				 	 void *pRndGenData) {
#else
                                     UCDI_RandomGenerator GetRndBytes) {
#endif

  // nothing to setup
  return UCDI_ERROR_NOERROR;
};


void __cdecl TMS_ResetWorkContext(void* pContext, WORD16 wMode,
                                 void* pInitData,
#ifdef __EXTENDED_UCDI
                                 UCDI_RandomGenerator GetRndBytes,
						         void *pRndGenData) {
#else
                                 UCDI_RandomGenerator GetRndBytes) {
#endif

	// nothing to reset
};


WORD32 __cdecl TMS_DestroyWorkContext (void* pContext) {
  
  // nothing to destroy	
  return UCDI_ERROR_NOERROR;
};



void __cdecl TMS_EncryptBuffer(void* pContext, void* pSource, void* pTarget,
  			                   WORD32 lNumOfBytes) {

  WORD8* pDataIn = (WORD8*) pSource;
  WORD8* pDataOut = (WORD8*) pTarget;

  // just copy the bytes
  while (lNumOfBytes--) 
	*pDataOut++ = *pDataIn++;
};



void __cdecl TMS_DecryptBuffer(void* pContext, void* pSource, void* pTarget,
	  		            	   WORD32 lNumOfBytes, void* pPreviousBlock) {

	// just map the call
  TMS_EncryptBuffer(pContext, pSource, pTarget, lNumOfBytes);
};



int __stdcall DriverEntryPoint(WORD32 hinst, unsigned long reason, void*)
{
    return 1;
}
