

/**
  * testing the SHA-1 hash algorithm of CRYPTPAK.DLL
  *	Copyright (C) 1998 Markus Hahn
  *	last update: 7 Nov 98
  */


#include <stdio.h>
#include <string.h>
#include "CryptPak.h"

#define BUFSIZE 10000

// reference string
char refstr[] = "ABCDEFG - Marshmellows for you and me!";



void main(int argc, char* argv[]) {


	SHA1CTX ctx;
	WORD8 dg[SHA1_DIGESTSIZE];


    // run selftest

    printf("running SHA-1 selftest...");
	if (SHA1_SelfTest() == BOOL_FALSE) {
      puts(", FAILED"); 
      return;
	};
    puts(", done."); 


    puts("testing SHA-1 routines..." );
	
	// hash reference string

	SHA1_Init(&ctx);
	SHA1_Update(&ctx, refstr, strlen(refstr));
	SHA1_Final(dg, &ctx);

    printf("reference string: "\
		   "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\n",
	       dg[0],dg[1],dg[2],dg[3],dg[4],dg[5],dg[6],dg[7],dg[8],
		   dg[9],dg[10],dg[11],dg[12],dg[13],dg[14],dg[15],
		   dg[16],dg[17],dg[18],dg[19]);


	// hash nothing

	SHA1_Init(&ctx);
	SHA1_Final(dg, &ctx);

    printf("zero: "\
		   "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\n",
	       dg[0],dg[1],dg[2],dg[3],dg[4],dg[5],dg[6],dg[7],dg[8],
		   dg[9],dg[10],dg[11],dg[12],dg[13],dg[14],dg[15],
		   dg[16],dg[17],dg[18],dg[19]);


	// hash test file

	if (argc < 2) {
      puts("test file name not passed");
	  return;	   
	};

    FILE* binfile;
    WORD8 testbuf[BUFSIZE]; 

	if ((binfile = fopen(argv[1], "rb")) == NULL) {
      printf("cannot open \"%s\" for reading.\n", argv[1]);
	  return;
	};

    SHA1_Init(&ctx);
    WORD32 lRead;
	do {
      lRead = fread(testbuf, 1, BUFSIZE, binfile);
  	  SHA1_Update(&ctx, testbuf, lRead);
	  printf("#");
	}
	while (lRead == BUFSIZE);
	fclose(binfile);
	SHA1_Final(dg, &ctx);

    printf("\nhash of \"%s\" : "\
		   "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\n",
		   argv[1],
	       dg[0],dg[1],dg[2],dg[3],dg[4],dg[5],dg[6],dg[7],dg[8],
		   dg[9],dg[10],dg[11],dg[12],dg[13],dg[14],dg[15],
		   dg[16],dg[17],dg[18],dg[19]);


};





