

/**
  * testing the MD5 hash algorithm of CRYPTPAK.DLL
  *	Copyright (C) 1998 Markus Hahn
  *	last update: 7 Nov
  */


#include <stdio.h>
#include <string.h>
#include "CryptPak.h"

#define BUFSIZE 12345

// reference string
char refstr[] = "ABCDEFG - Marshmellows for you and me!";


void main(int argc, char* argv[]) {


	MD5CTX ctx;
	WORD8 dg[MD5_DIGESTSIZE];

    
    // selftest

	printf("running selftest...");
	if (MD5_SelfTest() == BOOL_FALSE) {
      puts(", FAILED");
	  return;
	};
	puts(", done.");

    puts("testing MD5 routines..." );
	
	// hash reference string

	MD5_Init(&ctx);
	MD5_Update(&ctx, refstr, strlen(refstr));
	MD5_Final(dg, &ctx);

    printf("reference string: "\
		   "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\n",
	       dg[0],dg[1],dg[2],dg[3],dg[4],dg[5],dg[6],dg[7],dg[8],
		   dg[9],dg[10],dg[11],dg[12],dg[13],dg[14],dg[15]);


	// hash nothing

	MD5_Init(&ctx);
	MD5_Final(dg, &ctx);

    printf("zero: "\
		   "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\n",
	       dg[0],dg[1],dg[2],dg[3],dg[4],dg[5],dg[6],dg[7],dg[8],
		   dg[9],dg[10],dg[11],dg[12],dg[13],dg[14],dg[15]);


	// hash test file

	if (argc < 2) {
      puts("test file name not passed");
	  return;	   
	};


    FILE* binfile;
    WORD8 testbuf[BUFSIZE]; 

	if ((binfile = fopen(argv[1], "rb")) == NULL) {
      printf("cannot open \"%s\" for reading.\n", argv[1]);
	  return;
	};

    MD5_Init(&ctx);
    WORD32 lRead;
	do {
      lRead = fread(testbuf, 1, BUFSIZE, binfile);
  	  MD5_Update(&ctx, testbuf, lRead);
	  printf("#");
	}
	while (lRead == BUFSIZE);
	fclose(binfile);
	MD5_Final(dg, &ctx);

    printf("\ndigest of \"%s\" : "\
		   "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\n",
		   argv[1],
	       dg[0],dg[1],dg[2],dg[3],dg[4],dg[5],dg[6],dg[7],dg[8],
		   dg[9],dg[10],dg[11],dg[12],dg[13],dg[14],dg[15]);


};





