

/**
  * testing the LZSS compression of CRYPTPAK.DLL
  *	Copyright (C) 1998 Markus Hahn
  *	last update: 17 June 98
  */


#include <stdio.h>
#include <string.h>
#include "CryptPak.h"


#define TESTBUFSIZE		16384


const char TESTFILE_ORIG[]   = "D:\\TEST\\TEST.DAT";
const char TESTFILE_COMP[]   = "D:\\TEST\\TEST.PAK";
const char TESTFILE_DECOMP[] = "D:\\TEST\\TEST.OUT";


WORD8 inbuf[TESTBUFSIZE];
WORD8 outbuf[TESTBUFSIZE * 2];

LZSSCTX ctx;

void main() {

	FILE *infile, *outfile;
	WORD8 bCond;
	WORD32 lRes, lRead, lWritten;
	BYTEBOOL blEOF;

	puts("opening files...");

	// open original file
	if ((infile = fopen(TESTFILE_ORIG, "rb")) == NULL) {
		printf("cannot open input file %s\n", TESTFILE_ORIG);
		return;
	};

	// open file for compressed data
	if ((outfile = fopen(TESTFILE_COMP, "wb")) == NULL) {
		printf("cannot open output file %s\n", TESTFILE_ORIG);
		fclose(infile);
		return;
	};

	// start compression...
	printf("compressing (%d bytes per hash)...\n", TESTBUFSIZE);
    lRead = 0;
    lWritten = 0;
    bCond = LZSS_START | LZSS_WORK;
    blEOF = BOOL_FALSE;
	do {
	  if ((lRes = fread(inbuf, 1, TESTBUFSIZE, infile)) < TESTBUFSIZE) 
	    blEOF = BOOL_TRUE;
      lRead += lRes;
      if (blEOF == BOOL_TRUE) bCond |= LZSS_STOP;
	  lRes = LZSS_Compress(&ctx, inbuf, outbuf, lRes, bCond);
      bCond &= ~LZSS_START;
	  fwrite(outbuf, 1, lRes, outfile);
	  lWritten += lRes;
      printf("#");
	}
	while (blEOF == BOOL_FALSE);

	// close the files
	fclose(outfile);
	fclose(infile);

	// print the result
	printf("\ncompressed %d bytes into %d bytes\n", lRead, lWritten);


	// open compressed file 
	if ((infile = fopen(TESTFILE_COMP, "rb")) == NULL) {
		printf("cannot open input file %s\n", TESTFILE_ORIG);
		return;
	};

	// open file for decompressed data
	if ((outfile = fopen(TESTFILE_DECOMP, "wb")) == NULL) {
		printf("cannot open output file %s\n", TESTFILE_ORIG);
		fclose(infile);
		return;
	};

	// start decompression...
	printf("decompressing (%d bytes per hash)...\n", TESTBUFSIZE);
    lRead = 0;
    lWritten = 0;
    bCond = LZSS_START | LZSS_WORK;
    blEOF = BOOL_FALSE;
	do {
	  if ((lRes = fread(inbuf, 1, TESTBUFSIZE, infile)) < TESTBUFSIZE) 
	    blEOF = BOOL_TRUE;
      lRead += lRes;
      if (blEOF == BOOL_TRUE) bCond |= LZSS_STOP;

      BYTEBOOL blMustRepeat = BOOL_FALSE; // this is a must
	  do {
  	    WORD32 lDecomp = LZSS_Decompress(&ctx, inbuf, outbuf, lRes,
		                                 TESTBUFSIZE, bCond, &blMustRepeat);
        bCond &= ~LZSS_START;
	    fwrite(outbuf, 1, lDecomp, outfile);
	    lWritten += lDecomp;
        printf("#");
	  }
      while (blMustRepeat == BOOL_TRUE);

	}
	while (blEOF == BOOL_FALSE);

	// close the files
	fclose(outfile);
	fclose(infile);

	// print the result
	printf("\ndecompressed %d bytes into %d bytes\n", lRead, lWritten);

};