

/**
  * testing the CRC32 checksumming of CRYPTPAK.DLL
  *	Copyright (C) 1998 Markus Hahn
  *	last update: 17 June 98
  */


#include <stdio.h>
#include <string.h>
#include "CryptPak.h"


void main() {

    // test zero string
	char zerostring[] = "";
	WORD32 lCRC32 = CRC32_INITVALUE;
	puts("checksumming zero string...");
    CRC32_Update(lCRC32, zerostring, 0);
	lCRC32 ^= CRC32_DONEVALUE;
	printf("CRC32 -> 0x%08x\n", lCRC32);

    // checksumming the reference string
	char refstring[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
	lCRC32 = CRC32_INITVALUE;
	puts("checksumming reference string...");
    lCRC32 = CRC32_Update(lCRC32, refstring, strlen(refstring));
	lCRC32 ^= CRC32_DONEVALUE;
	printf("CRC32 -> 0x%08x\n", lCRC32);

};