program Encrypting_Utility;  { (C) 1994-1995 Sven Winnecke }

{ The program codes and decodes files;  refer also to CRYPT.DOC .           }

{$N+,E-}           { Use numeric coprocessor, do NOT use emulation !!
                     Without coprocessor : replace '$N+,E-' with '$N-,E-'
		     and 'extended' with 'real' to get the source code 
		     for CRYPT_WO.EXE.               			    }

{$M 16384,0,65535} { preserve memory for the file viewer execution          }

uses  dos,crt;
const source   : ComStr = 'CRYPTED!.TXT';
      cryp     : ComStr = 'CRYPTED!.CRY';
      decr     : ComStr = '';
      view     =          'TXTVIEW.COM' ; { a file viewer, to which I can
                                            pass a file name                }
      version  : byte = 17;   { version number of the encoding algorithm:
                              version 2.1 binary in 6 bits : 010.001 => 17  }
      t1       = 'Change original file name';
      t2       = 'Change name of the coded file / file to decode';
      t3       = 'Change name of the decoded file';

var   rnd_1,rnd_2,num  : extended;
        { Zufallszahlen :  rnd_1 :  for (de-)coding key table generation,
                           rnd_2 :  for running offset (protection against
                                    a statistical file analysis)
                             num :  number of (trash) bytes that will be
                                    written at the begin of the coded file  }
      i,j,k,kk : Integer;  { temporary variables, l : length of password    }
      l,len    : longint;
      c1,c2    : longint;
      passwd   : string;   { Input variable                                 }

      passw2   : string;   { for password check and for temporary use       }
      d,n,e    : string;   { temporary variables for file handling          }

      by,y,z   : Byte; { by : byte to (de)code; y,z for 'working' indicator }
      ch       : Char; { auxiliary variable for keystroke inputs            }
      s0,s1    : Array [0..255] of byte; { (de-)coding key table,
                                         s0 for decoding, s1 for encoding   }
      f1,f2    : file of Byte;         {                 in-/output files   }
      s        : SearchRec;            {    aux. variable for file handling }
      copro    : byte;                 {         type of num. coprocessor   }
      cry      : boolean;              { flag : 'Is file a crypt!-file ?'   }
      hs       : boolean;              { flag : 'HiSec mode'                }
      mac,pwd  : boolean;              { flags 'password / MAC okay'        }

{  -----------------  find out numeric coprocessor type  -----------------  }
function Test87 : byte; {  0=none, 1=8087-, 2=80287-, 3=80387-coprocessor   }
var re:extended; ig:byte;
begin
  re:=test8087;
  ig:=trunc(re); test87:=ig;  
end;

{  ---------------  write Coprocessor type to screen ---------------------- }
procedure Write_CoP (ust:string; uby:byte);
begin
  Write('          ',ust,' : version ',uby shr 5,'.',(uby and $1C) shr 2);
  Write(', ');
  case (uby and $03) of
    0: Write ('no numeric Co');
    1: Write ('with 8087 ');
    2: Write ('with 80287 ');
    3: Write ('with 80387 ');
  end;
  WriteLn ('processor');
end;

{  ------  generate the random numbers - the heart of the program  -------  }
Procedure Rnd_First;
begin
  rnd_1:=Frac(sqrt(rnd_1)*1000);
end;

Procedure Rnd_Second;
begin
  rnd_2:=Frac(sqrt(rnd_2)*10000);
end;

{  ---------------------- code / decode one byte -------------------------  }
Function Crypted(data : extended) : byte;
begin
  Rnd_Second;                            { generate new offset              }
  k:=Trunc (data)+Trunc (256*rnd_2);     { sum up data byte and and offset  }
  if k>255 then k:=k-256;                { check for overflow               }
  k:=s1[k];                              { take encoded byte from table     }
  Crypted:=k;                            { done.                            }
end;

Function Decrypted(data : extended) : byte;
begin
  Rnd_Second;                            { generate new offset              }
  data:=s0[Trunc(data)];                 { look up decoded byte in table    }
  data:=data-Trunc (256*rnd_2);          { subtract offset from table byte  }
  if data<0 then data:=data+256;         { check for overflow               }
  Decrypted:=Trunc(data);                { done.                            }
end;

{  ----------------------  file name dialogue  ---------------------------  }
Procedure Chg_Name (txt : string; var name : ComStr);
begin
  ClrScr;
  GotoXY (15,10); TextColor (LightRed);
  WriteLn (txt);
  GotoXY (15,12); TextColor (Cyan);
  Write ('current name :  ');
  TextColor (LightRed); Write (name);
  GotoXY (15,14);
  Write ('new name     :  ');
  TextColor (White); ReadLn (name);
end;

{  ----  move the cursor as a sign that the program is still working  ----  }
Procedure Working;
begin
  inc (z); if z>250 then z:=0;
  if z=0 then
  begin
    y:=y+1; if y=15 then y:=0;
    GotoXY (28+y,15); Write (' ');
  end;
end;

{ ---------------------  Read / Write Checksums  -------------------------- }
procedure ReadLongint (var li : longint);
var p:^byte;
begin
  p:=addr(li);
  for i:=1 to 4 do
  begin
    Read (f1,by);
    p^:=Decrypted(by);
    inc(p);
  end;
end;

procedure WriteLongint (li : longint);
var p:^byte;
begin
  p:=addr(li);
  for i:=1 to 4 do
  begin
    by:=Crypted(p^);
    Write (f2,by); inc(p);
  end;
end;

{ -- getting the password,calculation of (de-)coding key table and so on -- }
Function Passwd_In : Boolean;
begin
  Passwd_In:=true;                       { 'there's a valid password'-sign  }
  rnd_1:=2; rnd_2:=3;
  GotoXY (15,12); TextColor (LightRed); passwd:='';
  Write ('Password (<Return> for cancel) :  '); TextColor (White);
  ReadLn (passwd);
  if passwd='' then
  begin
    Passwd_In:=false;                         { 'no valid password - abort' }
    Exit;
  end;
  l:=length (passwd);
  for i:=1 to (l div 2)+(l mod 2) do        { take >= first half of password }
  begin
    rnd_1:=rnd_1+cos (20*Ord (passwd[i])*i);
  end;
  for j:=(l div 2)+1 to l do             { second half of word              }
  begin
    rnd_2:=rnd_2+sin (10*Ord (passwd[j])*j);
  end;
{  ----------------  calculation of the initial numbers  -----------------  }
  rnd_1:=Frac (Ln (Sqr (Frac (1000*rnd_1)))*10*Frac (10000*rnd_2));
  rnd_2:=Frac (Ln (Abs (Frac ( 100*rnd_2)))*10*Frac (10000*rnd_1));
  num:=Frac (l*(rnd_1+rnd_2)*10000); num:=Abs (Int (num*256));
  rnd_1:=Abs(rnd_1); rnd_2:=Abs(rnd_2);
{  --------------  generate the tables for encoding / decoding  ----------  }
  for i:=0 to 255 do s0[i]:=i;       { make a sorted table first            }
  for i:=0 to 255 do
  begin
    Rnd_First;                       { generate new (pseudo-) random number }
    j:=256-i; { current length of the sorted table = number of last element }
    s1[i]:=s0[Trunc(j*rnd_1)];   { put current s0-value at i-th place in s1 }
    s0[Trunc(j*rnd_1)]:=s0[j-1];     {put last entry into the gap           }
  end;
  for i:=0 to 255 do s0[s1[i]]:=i;   { generate decoding table by mirroring }
end;

{  ------------------------  file encryption  ----------------------------  }
Procedure Crypt;
begin
  ClrScr; GotoXY (15,9); TextColor (Cyan);             { messages on screen }
  Write ('Encoding the file ');
  TextColor (LightGreen); Write (source);
  TextColor (Cyan); Write (',');
  GotoXY (15,10); Write ('Destination is  ');
  TextColor (LightGreen); Write (cryp);
  TextColor (Cyan); Write ('.');
  if not (Passwd_In) then Exit;
  GotoXY(15,WhereY); Write('High security mode (y/n) ? ');
  repeat
    ch:=ReadKey; ch:=UpCase(ch);
  until(ch='Y') or(ch='N'); Writeln (ch);
  if ch='Y' then hs:=true else hs:=false;
  GotoXY (15,15); TextColor (Cyan);
  WriteLn ('Encoding ...');
  DosError:=0;
  {$i-}
  Assign (f1,source); Reset (f1); j:=IOResult;       {try to open the files }
  Assign (f2,cryp); Rewrite (f2); j:=j+IOResult;
  {$i+}
  if j<>0 then
  begin
    GotoXY (26,20); TextColor (LightMagenta);
    Write ('Error opening one of the files !');
    ch:=ReadKey;
    Exit;
  end;
  copro:=Test87+4*version; { lower 2 bits : coproc., upp. 6: version number }
  Write (f2,copro);                  { write version & coprocessor type     }
  by:=ord ('C'); write (f2,by);
  by:=ord ('r'); write (f2,by);
  by:=ord ('y'); write (f2,by);
  if hs=true then by:=1 else by:=0;
  Write(f2,by);                      { write flag 'HiSec-Mode j/n'to file   }
  FSplit(source,d,n,e);
  n:=n+e+'            ';
  for i:=1 to 12 do
  begin
    by:=ord(n[i]); Write(f2,by);    { store original file name              }
  end;
  for i:=1 to 29 do
  begin
    Rnd_First; Rnd_Second;
    if ((i mod 10)=0) and (hs=false) then {use every 10th byte for pwd check}
    begin
      by:=Crypted(Rnd_1);
      Write (f2,by);
    end;
  end;
  passwd:='                        '; { clear the password variable (safety)}
  passw2:='                        ';
  z:=0; y:=0;		             { initial numbers for function working }
  len:=FileSize(f1);
  if hs=true then                    { do this only in normal mode          }
  begin
    for l:=1 to len do                 { for each byte of the original file }
    begin
      Read (f1,by);
      by:=Crypted (by);                   { read and encode file data bytes }
      Write (f2,by);                       { Write the encoded data         }
      Working;                             { indicate progress              }
    end;
  end else                                 { do this in HiSec mode          }
  begin
    c1:=0;
    for l:=1 to len do                 { for each byte of the original file }
    begin
      Read (f1,by);                       { read the data bytes             }
      c1:=c1+by;                          { calculate authentication code   }
      by:=Crypted (by);                   { encode the data bytes           }
      Write (f2,by);                      { and write them to file          }
      Working;                            { indicate progress               }
    end;
    WriteLongint(c1);
  end;
  Close (f1); Close (f2);
end;

{  ---------------------  decrypt the file  ------------------------------  }
Procedure Decrypt;
begin
  ClrScr; GotoXY (15,9); TextColor (Cyan);             { messages on screen }
  Write ('decoding the file ');
  TextColor (LightGreen); Write (cryp);
  TextColor (Cyan); Write ('.');
  if not (Passwd_In) then Exit;
  GotoXY (15,15); TextColor (Cyan);
  WriteLn ('Decoding ... ');
  DosError:=0;
  {$i-}
  Assign (f1,cryp); Reset (f1); j:=IOResult;         {try to open read file }
  {$i+}
  if (j<>0) or (filesize (f1)=0) then
  begin
    GotoXY (26,20); TextColor (LightMagenta);
    Write ('Error opening the input file !!!');
    ch:=ReadKey;
    Exit;
  end;
  read (f1,by);   { read version number & coprocessor type                  }
  if by <> Test87+4*version then  {if coded with other environment :        }
  begin                           { put out a warning                       }
    GotoXY (10,19); TextColor (LightMagenta);
    WriteLn ('Warning : File was created in a different environment  !!');
    Writeln; Write_CoP ('crypted file        ',by);
    Write_CoP ('current environment ',Test87+4*version);
    Writeln; Write ('             (A)bort or (c)ontinue anyway ?');
    repeat
      ch:=ReadKey;
    until (UpCase(ch)='A') or (UpCase(ch)='C');
    GotoXY (10,19);
    for i:=1 to 6 do
    WriteLn
    ('                                                                     ');
    if UpCase(ch)='A' then Exit;
  end;
  cry:=true;
  read (f1,by); if by<>ord ('C') then cry:=false;
  read (f1,by); if by<>ord ('r') then cry:=false;
  read (f1,by); if by<>ord ('y') then cry:=false;
  if cry=false then
  begin                           { display warning                         }
    GotoXY (10,20); TextColor (LightMagenta);
    WriteLn ('Warning : File seems not to be a Crypt! - file !');
    Writeln; Write ('             (A)bort or (c)ontinue anyway ?');
    repeat
      ch:=ReadKey;
    until (UpCase(ch)='A') or (UpCase(ch)='C');
    GotoXY (10,19);
    for i:=1 to 6 do
    WriteLn
    ('                                                                     ');
    if UpCase(ch)='A' then Exit;
  end;
  Read(f1,by); if by=1 then hs:=true else hs:=false; { HiSec - Datei ?      }
  n:='';
  for i:=1 to 12 do                         { reading the original file name}
  begin
    Read(f1,by); n:=n+chr(by);
  end;
  FSplit(cryp,d,e,e);
  if (length(d)>0) and (d[length(d)]<>'\') then d:=d+'\';
  decr:=d+n;
  {$i-}
  Assign (f2,decr); Rewrite (f2); j:=IOResult;
  {$i+}
  if j<>0 then
  begin
    GotoXY (26,20); TextColor (LightMagenta);
    Write ('Error opening the destination file !!!');
    ch:=ReadKey;
    Exit;
  end;
  pwd:=true;
  for i:=1 to 29 do
  begin
    Rnd_First; Rnd_Second;
    if ((i mod 10)=0) and (hs=false) then {use every 10th byte for pwd check}
    begin
      Read (f1,by);
      if by<>Trunc(Crypted(Rnd_1)) then pwd:=false;
    end;
  end;
  passwd:='                        '; { clear the password variable (safety)}
  passw2:='                        ';
  mac:=true;
  if hs=false then                                    { if normal mode file }
  begin
    if pwd=true then len:=FileSize(f1)-23 else len:=1;
    c1:=0; c2:=0;
    for l:=1 to len do
    begin
      Read (f1,by);                       { read encoded bytes              }
      by:=Decrypted (by);                 { decode the data                 }
      c1:=c1+by;                          { calculate authentication code   }
      Write (f2,by);                      { write decoded data to file      }
      Working;
    end;
    ReadLongint(c2);
    if c1<>c2 then mac:=false;
  end else                                 { if HiSec file                  }
  begin
    len:=FileSize(f1)-19;
    for l:=1 to len do
    begin
      Read (f1,by); by:=Decrypted (by); { read and decode data bytes      }
      Write (f2,by);                    { write them to file              }
      Working;
    end;
  end;
  Close(f1); Close(f2);
  c1:=0;                           { get the status of the previous actions }
  if mac=false then c1:=c1+1;      { has the encoded file been altered?     }
  if pwd=false then c1:=c1+2;      { was the passwod wrong?                 }
  WriteLn; WriteLn; TextColor (LightMagenta);
  case c1 of
    2..3 : WriteLn('         The password you entered was wrong !');
    1    : WriteLn('         The encoded file has been altered !');
    0    : WriteLn('               Encoding finished.');
  end;
  writeLn; write('             Press a key to continue.');
  ch:=ReadKey;
end;

{  --- Calling the file viewer, it must be able to accept the file name --  }
procedure FileView;
begin
  ClrScr;
  DosError:=0;
  FindFirst (view,AnyFile,s);         { locate the viewer                   }
  if DosError<>0 then
  begin
    TextColor (LightMagenta);
    GotoXY (15,12); Write (' File viewer program not found : - ',view);
    ch:=ReadKey;
    Exit;
  end;
  Window (15,7,70,22); ClrScr;
  WriteLn ('Show file :  Please enter the file name, or :');
  TextColor (LightRed); WriteLn;
  WriteLn ('      *  "1" for ',source,',');
  WriteLn ('      *  "2" for ',cryp,',');
  WriteLn ('      *  "3" for ',decr,','); WriteLn;
  WriteLn ('( If the file name is "1","2" oder "3",');
  WriteLn ('  please enter "/1","/2" bzw. "/3" ! )');
  TextColor (Yellow); passw2:='';
  WriteLn; Write ('File name (<Return> for cancel)  :  ');
  TextColor (White); ReadLn (passw2);
  if passw2 <> '' then
  begin
    if passw2 = '1' then passw2:=source;
    if passw2 = '2' then passw2:=cryp;
    if passw2 = '3' then passw2:=decr;
    if passw2 = '/1' then passw2:='1';
    if passw2 = '/2' then passw2:='2';
    if passw2 = '/3' then passw2:='3';
    FindFirst (passw2,AnyFile,s);     { look for the file to view           }
    if DosError<>0 then
    begin
      WriteLn; WriteLn; WriteLn; WriteLn;
      TextColor (LightMagenta);
      Write ('File not found - ',passw2);
      ch:=ReadKey;
    end else
    begin
      SwapVectors;
      Exec (view,passw2);             { show file                           }
      SwapVectors;
    end;
  end;
  Window (1,1,80,25);
end;

{  ------------------------  main program  -------------------------------  }
begin
  textmode (co80);
  repeat
    TextBackground (Blue); TextColor (Yellow); ClrScr;
    GotoXY (23,2); Write ('C r y p t   !     v 2 . 1');
    GotoXY (20,3); Write ('*******************************');
    WriteLn; WriteLn;
    WriteLn ('      Current settings :');
    WriteLn ('     --------------------');
    TextColor (Cyan); WriteLn;
    Write ('     Name of the original file                  :  ');
    TextColor (LightRed); WriteLn (source); TextColor (Cyan);
    Write ('     Name of the coded file or file to decode   :  ');
    TextColor (LightRed); WriteLn (Cryp); WriteLn;
    TextColor (Yellow);
    WriteLn ('   Warning : While encoding "',Cryp,'" will be overwritten,');
    WriteLn ('   while decoding any file as called as the original file name !!');
    TextColor (Yellow+Blink);
    WriteLn ('   The program will overwrite these files without re-confirmation !!');
    TextColor (Yellow);
    WriteLn;
    WriteLn ('   Menu :');
    WriteLn ('  --------');
    TextColor (White);
    Write   ('      (1)');
    TextColor (LightRed);
    WriteLn (' ... ',t1);
    TextColor (White);
    Write   ('      (2)');
    TextColor (LightRed);
    WriteLn   (' ... ',t2);
    TextColor (White);
    Write   ('      (3)');
    TextColor (LightRed);
    WriteLn (' ... Encoding');
    TextColor (White);
    Write   ('      (4)');
    TextColor (LightRed);
    WriteLn (' ... Decoding');
    TextColor (White);
    Write   ('      (5)');
    TextColor (LightRed);
    WriteLn (' ... View (text-) files');
    TextColor (White);
    Write   ('      (0)');
    TextColor (LightRed);
    WriteLn (' ... Quit program');
    WriteLn; i:=WhereY;
    repeat
      TextColor (LightRed);
      GotoXY (13,i); Write ('Your Choice :  ');
      TextColor (White); passwd:=''; { use passwd as auxiliary variable here}
      GotoXY (28,i);
      passwd:=ReadKey; val (passwd,kk,j);
      if j>0 then kk:=-1;
    until (kk>=0) and (kk<7);
    case kk of
      1 :  Chg_Name (t1,source);
      2 :  Chg_Name (t2,cryp);
      3 :  Crypt;
      4 :  Decrypt;
      5 :  FileView;
    end;
  until kk=0;
  TextBackground (Black); TextColor (LightGray); ClrScr;
end.
