{$V-}
program Crypting_Utility;  { (C) 1994-1995 Sven Winnecke }

{
        zum Ver- / Entschlsseln von Dateien; siehe auch CRYPT.DOK !
        Dieses Programm ist zur Demonstration des Verschlsselungs-
        algorithmusses gedacht, nicht als Anwendung. Daher sind solche
        Dinge wie Fehlerbehandlung, Komfort und Geschwindigkeitsopti-
        mierung hier nur rudimentr oder gar nicht zu finden.
        Entwickelt mit Turbo Pascal 6.0.
}

{$N+,E-}           { Mit mathematischen Coprozessor, ohne Emulation !!
                     Ohne Coprozessor : mit $N-,E- statt $N+,E- bersetzen
                     und 'real' duch 'extended' ersetzen, um Quelltext zur
                     CRYPT_OC.EXE zu erhalten.
                     Die Coprozessor-Emulation weicht in den letzten Nach-
                     kommastellen so sehr ab, da die Zufallszahlenfolge
                     signifikant abweicht - deshalb nicht verwendbar.       }

{$M 16384,0,65535} { Platz zum Ausfhren des Dateibetrachters reservieren   }

uses  dos,crt;

const source   : ComStr = 'CRYPTED!.TXT';           { Standard - Dateinamen }
      cryp     : ComStr = 'CRYPTED!.CRY';
      decr     : ComStr = '';
      view     =          'TXTVIEW.COM' ; { ein Dok-Viewer, dem man einen
                                            Dateinamen bergeben kann       }
      version  : byte = 17;{ Versionsnr. des Verschlsselungsalgorithmusses:
                               Version 2.1 binr in 6 Bits : 010.001 => 17  }
      t1       = 'Name der zu verschlsselnden Datei ndern';
      t2       = 'Name der verschlsselten/zu entschlsselnden Datei ndern';
      t3       = 'Name der entschlsselten Datei ndern';

var   rnd_1,rnd_2       : extended;
        { Zufallszahlen :  rnd_1 :  fr (De-)Codierschlssel-Tabelle,
                           rnd_2 :  fr laufenden Offset(gegen statistische
                                    Untersuchungen des Textes)}
      i,j,k,kk : Integer;  { Hilfsvariablen                                 }
      c1,c2    : longint;
      l,len    : longint;
      passwd   : string;   { Eingabevariable                                }

      passw2   : string;   { zum Testen, ob Dechiffrier-Passwort korrekt    }
      d,n,e    : string;   { Hilfsvar. fr Dateiarbeit                      }

      by,y,z   : Byte; { by:zu ver-/entschlsselnde Byte; y,z fr 'working' }
      ch       : Char; { Hilfsvariable fr Warten auf Tastendruck           }
      s0,s1    : Array [0..255] of byte; {(De-)Codierschlssel-Tabellen,
                                         s0 fr Decodieren, s1 fr Codieren }
      f1,f2    : file of Byte;         {                 Ein-/Ausgangsdatei }
      s        : SearchRec;            {    Hilfsvariable fr Dateihandling }
      copro    : byte;                 {         Art des math. Coprozessors }
      cry      : boolean;              { Flag 'Ist Datei ein *.cry - File ? }
      hs       : boolean;              {         Hochsicherheitsmodus j/n ? }
      mac,pwd  : boolean;              { MAC bzw. Pawort okay j/n ?        }

{  ----------------  Bestimme Art des math. Coprozessors  ----------------  }
function Test87 : byte; {  0=kein math. Coproz., 1=8087, 2=80287, 3=80387   }
var re:extended; ig:byte;
begin
  re:=test8087;
  ig:=trunc(re); test87:=ig;  
end;

{  --------------  Coprozessorart auf Bildschirm ausgeben  ---------------- }
procedure Write_CoP(ust:string; uby:byte);
begin
  Write('          ',ust,' : Version ',uby shr 5,'.',(uby and $1C) shr 2);
  Write(', ');
  case(uby and $03) of
    0: Write('kein math. Co-');
    1: Write('mit 8087 - ');
    2: Write('mit 80287 - ');
    3: Write('mit 80387 - ');
  end;
  WriteLn('Prozessor');
end;

{  -- (Pseudo-)Zufallszahlengeneratoren - das Herzstck des Programms  --  }
Procedure Rnd_First;
begin
  rnd_1:=Frac(sqrt(rnd_1)*1000);
end;

Procedure Rnd_Second;
begin
  rnd_2:=Frac(sqrt(rnd_2)*10000);
end;

{  --------------- Ver-/Entschlsselung der Datenbytes -------------------  }
Function Crypted(data : extended) : byte;
begin
  Rnd_Second;                            { neuer lfd. Offset                }
  k:=Trunc (data)+Trunc (256*rnd_2);     { Offset zu Datenbyte addieren     }
  if k>255 then k:=k-256;                { Bercksichtigung des bertrags   }
  k:=s1[k];                              { Wert aus Codiertabelle nehmen    }
  Crypted:=k;
end;

Function Decrypted(data : extended) : byte;
begin
  Rnd_Second;                            { neuer lfd. Offset                }
  data:=s0[Trunc(data)];                 { Wert aus Decodiertabelle nehmen  }
  data:=data-Trunc (256*rnd_2);          { Datenbyte minus Offset,          }
  if data<0 then data:=data+256;         { bertrag bercksichtigen         }
  Decrypted:=Trunc(data);                { und als entschlss. Byte setzen  }
end;

{  ---------------------  Dateinamensnderung  ---------------------------  }
Procedure Chg_Name(txt : string; var name : ComStr);
begin
  ClrScr;
  GotoXY(15,10); TextColor(LightRed);
  WriteLn(txt);
  GotoXY(15,12); TextColor(Cyan);
  Write('bisheriger Name :  ');
  TextColor(LightRed); Write(name);
  GotoXY(15,14);
  Write('neuer Name      :  ');
  TextColor(White); ReadLn(name);
end;

{  ------  'Cursorschieben' als Zeichen fr 'Rechner arbeitet ...'  ------  }
Procedure Working;
begin
  inc(z);
  if z=0 then
  begin
    y:=y+1; if y=15 then y:=0;
    GotoXY(28+y,15); Write(' ');
  end;
end;

{ -------------  Schreibe bzw. lese Checksummen  -------------------------- }
procedure ReadLongint (var li : longint);
var p:^byte;
begin
  p:=addr(li);
  for i:=1 to 4 do
  begin
    Read (f1,by);
    p^:=Decrypted(by);
    inc(p);
  end;
end;

procedure WriteLongint (li : longint);
var p:^byte;
begin
  p:=addr(li);
  for i:=1 to 4 do
  begin
    by:=Crypted(p^);
    Write (f2,by); inc(p);
  end;
end;

{  ----  Paworteingabe mit Berechnung der(De-)Codierschlssel usw. -----  }
Function Passwd_In : Boolean;
begin
  Passwd_In:=true;                       { 'Pawort wurde eingegeben'       }
  rnd_1:=2; rnd_2:=3;
  GotoXY(15,12); TextColor(LightRed); passwd:='';
  Write('Passwort(<Enter> fr Abbruch) :  '); TextColor(White);
  ReadLn(passwd);
  if passwd='' then
  begin
    Passwd_In:=false;                    { 'kein Pawort - Prozedurabbruch' }
    Exit;
  end;
  l:=length(passwd);
  for i:=1 to(l div 2)+(l mod 2) do       { 1. Worthlfte(+1, wenn ungerade)}
  begin
    rnd_1:=rnd_1+cos(20*Ord(passwd[i])*i);
  end;
  for j:=(l div 2)+1 to l do             { 2. Worthlfte                    }
  begin
    rnd_2:=rnd_2+sin(10*Ord(passwd[j])*j);
  end;
{  -------------  Ermittlung der Startwerte aus dem Pawort  -------------  }
  rnd_1:=Frac(Ln(Sqr(Frac(1000*rnd_1)))*10*Frac(10000*rnd_2));
  rnd_2:=Frac(Ln(Abs(Frac( 100*rnd_2)))*10*Frac(10000*rnd_1));
  rnd_1:=Abs(rnd_1); rnd_2:=Abs(rnd_2);
{  ------------  Generierung der Verschlsselungstabelle  ----------------  }
  for i:=0 to 255 do s0[i]:=i;       { Erstellung der sortierten Tabelle    }
  for i:=0 to 255 do
  begin
    Rnd_First;  { neue Zufallszahl fr 1. Variable generieren               }
    j:=256-i;   { entspricht Tabellenlnge ( = Nr. des letzten Elements )   }
    s1[i]:=s0[Trunc(j*rnd_1)]; {Wert aus Orig.-Tabelle an i-te Stelle von s1}
    s0[Trunc(j*rnd_1)]:=s0[j-1];     {letzter Tab.-eintrag -> 'Lcke'       }
  end;
  for i:=0 to 255 do s0[s1[i]]:=i;   { Decodierschlssel                    }
end;

{  -------------------  Dateiverschlsselung  ----------------------------  }
Procedure Crypt;
begin
  ClrScr; GotoXY(15,9); TextColor(Cyan);
  Write('Verschlsselung von ');
  TextColor(LightGreen); Write(source);
  TextColor(Cyan); Write(',');
  GotoXY(15,10); Write('Zieldatei ist       ');
  TextColor(LightGreen); Write(cryp);
  TextColor(Cyan); Write('.');
  if not(Passwd_In) then Exit;
  GotoXY(15,WhereY); Write('Hochsicherheitsmodus (j/n) ? ');
  repeat
    ch:=ReadKey; ch:=UpCase(ch);
  until(ch='J') or(ch='N'); Writeln (ch);
  if ch='J' then hs:=true else hs:=false;
  GotoXY(15,15); TextColor(Cyan);
  WriteLn('Chiffriere');
  DosError:=0;
  {$i-}
  Assign(f1,source); Reset(f1); j:=IOResult;
  Assign(f2,cryp); Rewrite(f2); j:=j+IOResult;
  {$i+}
  if j<>0 then
  begin
    GotoXY(26,20); TextColor(LightMagenta);
    Write('Fehler beim ffnen der Dateien !!!');
    ch:=ReadKey;
    Exit;
  end;
  copro:=Test87+4*version; { untere 2 Bits : Coproz., ob. 6: Versionsnummer }
  Write(f2,copro);                   { Schreibe Version & Coprozessor       }
  by:=ord('C'); Write(f2,by);	     { Schreibe Dateikennung                }
  by:=ord('r'); Write(f2,by);
  by:=ord('y'); Write(f2,by);
  if hs=true then by:=1 else by:=0;
  Write(f2,by);                      { Schreibe Kennung 'HiSec-Mode j/n'    }
  FSplit(source,d,n,e);
  n:=n+e+'            ';
  for i:=1 to 12 do
  begin
    by:=ord(n[i]); Write(f2,by);    { Lege Originalnamen in Datei ab        }
  end;
  for i:=1 to 29 do
  begin
    Rnd_First; Rnd_Second;
    if ((i mod 10)=0) and (hs=false) then { Benutze jedes 10. Byte fr Pa- }
    begin                                 { wortcheck                       }
      by:=Crypted(Rnd_1);
      Write (f2,by);
    end;
  end;
  passwd:='                        '; { Sicherheitslschen                  }
  passw2:='                        ';
  z:=0; y:=0;				{ Startwerte fr Working - Funktion }
  len:=FileSize(f1);
  if hs=true then
  begin
    for l:=1 to len do                   { fr alle Bytes der Originaldatei }
    begin
      Read (f1,by);
      by:=Crypted (by);                   { Lesen & Verschlsseln der Daten }
      Write (f2,by);                       { Schreiben der codierten Daten  }
      Working;                             { Fortschritt anzeigen           }
    end;
  end else
  begin
    c1:=0;
    for l:=1 to len do                   { fr alle Bytes der Originaldatei }
    begin
      Read (f1,by);                       { Lesen der Daten                 }
      c1:=c1+by;                          { Prfsumme fr Authentittscheck }
      by:=Crypted (by);                   { Verschlsseln der Daten         }
      Write (f2,by);                      { Schreiben der codierten Daten   }
      Working;                            { Fortschritt anzeigen            }
    end;
    WriteLongint(c1);
  end;
  Close(f1); Close(f2);
end;

{  -------------------  Dateientschlsselung  ----------------------------  }
Procedure Decrypt;
begin
  ClrScr; GotoXY(15,9); TextColor(Cyan);
  Write('Entschlsselung von ');
  TextColor(LightGreen); Write(cryp);
  TextColor(Cyan); Write('.');
  if not(Passwd_In) then Exit;
  GotoXY(15,15); TextColor(Cyan);
  WriteLn('Dechiffriere ');
  DosError:=0;
  {$i-}
  Assign(f1,cryp); Reset(f1); j:=IOResult;
  {$i+}
  if(j<>0) or(FileSize(f1)=0) then
  begin
    GotoXY(23,20); TextColor(LightMagenta);
    Write('Fehler beim ffnen der Originaldatei !!!');
    ch:=ReadKey;
    Exit;
  end;
  read(f1,by);    { Lies Versionsnummer & Coprozessor                       }
  if by <> Test87+4*version then  {Wenn mit anderer Version verschlsselt : }
  begin                           { Warnung ausgeben                        }
    GotoXY(10,19); TextColor(LightMagenta);
    WriteLn('Achtung : Datei wurde mit anderer Umgebung verschlsselt !!');
    WriteLn; Write_CoP('verschlsselte Datei',by);
    Write_CoP('aktuelle Umgebung   ',Test87+4*version);
    WriteLn; Write('              (A)bbrechen oder trotzdem (f)ortfahren ?');
    repeat
      ch:=ReadKey;
    until(UpCase(ch)='A') or(UpCase(ch)='F');
    GotoXY(10,19);
    for i:=1 to 6 do
    WriteLn
   ('                                                                     ');
    if UpCase(ch)='A' then Exit;
  end;
  cry:=true;
  read(f1,by); if by<>ord('C') then cry:=false;
  read(f1,by); if by<>ord('r') then cry:=false;
  read(f1,by); if by<>ord('y') then cry:=false;
  if cry=false then
  begin                           { Warnung ausgeben                        }
    GotoXY(10,20); TextColor(LightMagenta);
    WriteLn('Achtung : Datei scheint kein Crypt! - File zu sein !!');
    WriteLn; Write('              (A)bbrechen oder trotzdem (f)ortfahren ?');
    repeat
      ch:=ReadKey;
    until(UpCase(ch)='A') or(UpCase(ch)='F');
    GotoXY(10,19);
    for i:=1 to 6 do
    WriteLn
   ('                                                                     ');
    if UpCase(ch)='A' then Exit;
  end;
  Read(f1,by); if by=1 then hs:=true else hs:=false; { HiSec - Datei ?      }
  n:='';
  for i:=1 to 12 do                         { Ermittlung des Originalnamens }
  begin
    Read(f1,by); n:=n+chr(by);
  end;
  FSplit(cryp,d,e,e);
  if (length(d)>0) and (d[length(d)]<>'\') then d:=d+'\';
  decr:=d+n;
  {$i-}
  Assign(f2,decr); Rewrite(f2); j:=IOResult;
  {$i+}
  if j<>0 then
  begin
    GotoXY(26,20); TextColor(LightMagenta);
    Write('Fehler beim ffnen der Zieldatei !!!');
    ch:=ReadKey;
    Exit;
  end;
  pwd:=true;
  for i:=1 to 29 do
  begin
    Rnd_First; Rnd_Second;
    if ((i mod 10)=0) and (hs=false) then { Benutze jedes 10. Byte fr Pa- }
    begin                                 { wortcheck                       }
      Read (f1,by);
      if by<>Trunc(Crypted(Rnd_1)) then pwd:=false;
    end;
  end;
  passwd:='                        '; { Sicherheitslschen                  }
  passw2:='                        ';
  mac:=true;
  if hs=false then
  begin
    if pwd=true then len:=FileSize(f1)-23 else len:=1;
    c1:=0; c2:=0;
    for l:=1 to len do
    begin
      Read (f1,by);                       { Lesen der Daten                 }
      by:=Decrypted (by);                 { Entschlsseln der Daten         }
      c1:=c1+by;                          { Prfsumme fr Authentittscheck }
      Write (f2,by);                      { Schreiben der decodierten Daten }
      Working;
    end;
    ReadLongint(c2);
    if c1<>c2 then mac:=false;
  end else
  begin
    len:=FileSize(f1)-19;
    for l:=1 to len do
    begin
      Read (f1,by); by:=Decrypted (by); { Lesen & Entschlsseln der Daten }
      Write (f2,by);                    { Schreiben der decodierten Daten }
      Working;
    end;
  end;
  Close(f1); Close(f2);
  c1:=0;                           { Ergebnis der Entschlsselung ermitteln }
  if mac=false then c1:=c1+1;      { wurde die Datei verndert ?            }
  if pwd=false then c1:=c1+2;      { war das Pawort falsch ?               }
  WriteLn; WriteLn; TextColor (LightMagenta);
  case c1 of
    2..3 : WriteLn('         Das eingegebene Pawort ist falsch !');
    1    : WriteLn('     Die verschlsselte Datei ist verndert worden !');
    0    : WriteLn('         Entschlsselung beendet.');
  end;
  writeLn; write('         Zur Fortsetzung Taste drcken.');
  ch:=ReadKey;
end;

{  --- Datei anzeigen mit einem Doc-Viewer, Form <viewer> filename.ext' --  }
procedure FileView;
begin
  ClrScr;
  DosError:=0;
  FindFirst(view,AnyFile,s);          { Viewer suchen                       }
  if DosError<>0 then
  begin
    TextColor(LightMagenta);
    GotoXY(15,12); Write('Betrachterprogramm nicht gefunden - ',view);
    ch:=ReadKey;
    Exit;
  end;
  Window(15,7,70,22); ClrScr;
  WriteLn('Datei anzeigen :  Bitte Dateinamen eingeben oder :');
  TextColor(LightRed); WriteLn;
  WriteLn('      *  "1" fr ',source,',');
  WriteLn('      *  "2" fr ',cryp,',');
  WriteLn('      *  "3" fr ',decr,','); WriteLn;
  WriteLn('( Falls der Dateiname "1","2" oder "3" lautet,');
  WriteLn('  bitte "/1","/2" bzw. "/3" eingeben ! )'); { zugegeben : nicht  }
  TextColor(Yellow); passw2:='';                       { sehr schn ... :-( }
  WriteLn; Write('Dateiname(<Enter> fr Abbruch)  :  ');
  TextColor(White); ReadLn(passw2);
  if passw2 <> '' then
  begin
    if passw2 = '1' then passw2:=source;
    if passw2 = '2' then passw2:=cryp;
    if passw2 = '3' then passw2:=decr;
    if passw2 = '/1' then passw2:='1';
    if passw2 = '/2' then passw2:='2';
    if passw2 = '/3' then passw2:='3';
    FindFirst(passw2,AnyFile,s);      { anzuzeigende Datei suchen           }
    if DosError<>0 then
    begin
      WriteLn; WriteLn; WriteLn; WriteLn;
      TextColor(LightMagenta);
      Write('Datei nicht gefunden - ',passw2);
      ch:=ReadKey;
    end else
    begin
      SwapVectors;
      Exec(view,passw2);              { Datei anzeigen                      }
      SwapVectors;
    end;
  end;
  Window(1,1,80,25);
end;

{  -----------------------  Hauptprogramm  -------------------------------  }
begin
  TextMode(co80);
  repeat
    TextBackground(Blue); TextColor(Yellow); ClrScr;
    GotoXY(23,2); Write('C r y p t   !    v .   2 . 1');
    GotoXY(20,3); Write('**********************************');
    WriteLn; WriteLn;
    WriteLn('   aktuelle Einstellungen :');
    WriteLn('  --------------------------');
    TextColor(Cyan);
    Write('     zu verschlsselnde Datei                   :  ');
    TextColor(LightRed); WriteLn(source); TextColor(Cyan);
    Write('     verschlsselte / zu entschlsselnde Datei  :  ');
    TextColor(LightRed); WriteLn(Cryp); WriteLn;
    TextColor(Yellow); WriteLn;
    WriteLn('   Warnung : Bei Chiffrierung wird "',Cryp,'" berschrieben,');
    WriteLn('   bei Dechiffrierung diejenige, deren Name im *.cry-File steht !');
    TextColor(Yellow+Blink);
    WriteLn('   Das berschreiben erfolgt ohne Sicherheitsabfrage !!');
    WriteLn;
    TextColor(Yellow);
    WriteLn('   Men :');
    WriteLn('  --------');
    TextColor(White);
    Write  ('     (1)');
    TextColor(LightRed);
    WriteLn(' ... ',t1);
    TextColor(White);
    Write  ('     (2)');
    TextColor(LightRed);
    WriteLn(' ... ',t2);
    TextColor(White);
    Write  ('     (3)');
    TextColor(LightRed);
    WriteLn(' ... Verschlsseln');
    TextColor(White);
    Write  ('     (4)');
    TextColor(LightRed);
    WriteLn(' ... Entschlsseln');
    TextColor(White);
    Write  ('     (5)');
    TextColor(LightRed);
    WriteLn(' ... (Text-)Datei betrachten');
    TextColor(White);
    Write  ('     (0)');
    TextColor(LightRed);
    WriteLn(' ... Programm beenden');
    WriteLn; i:=WhereY;
    repeat
      TextColor(LightRed);
      GotoXY(3,i); Write('Auswahl (Nummer des Menpunkts) :          ');
      TextColor(White); passwd:='';  { Variable 'passwd' hier als Hilfsvar. }
      GotoXY(38,i);
      passwd:=ReadKey; val(passwd,kk,j);
      if j>0 then kk:=-1;
    until(kk>=0) and(kk<7);
    case kk of
      1 :  Chg_Name(t1,source);
      2 :  Chg_Name(t2,cryp);
      3 :  Crypt;
      4 :  Decrypt;
      5 :  FileView;
    end;
  until kk=0;
  TextBackground(Black); TextColor(LightGray); ClrScr;
end.
