{
 SeanWARE Inc. 1995
  7/25/95 11:08:52 p.m.
}
unit hasshing;
interface {public}
uses
 crt,dos;


type
  str16  = string[16];
  hshrec = array[1..4] of str16;

procedure split(info : string;var temp1,temp2,temp3,temp4 : str16);
procedure shuffle(var info : string;temp1,temp2,temp3,temp4 : str16);
procedure rnd1(var instr : str16);
procedure addhash(var info : string);
procedure pad(var info : string;size : byte);
procedure hassh(var info : string);

implementation


procedure pad(var info : string;size : byte);
var
 x : byte;
begin
  if (length(info) < size) then
    for x := length(info) to (size - 1) do
      info := info + chr(x);
end;


function invert(const instring1 : string) : string;
var
  x,y : integer;
  endline : string;
begin
  endline := '';
  for x := length(instring1) downto 1 do
    endline := endline + instring1[x];
  invert := endline;
  endline := '';
end;


procedure switch(var cha1,cha2 : char);
var
 temp : char;
begin
  temp := cha1;
  cha1 := cha2;
  cha2 := temp;
end;


procedure split(info : string;var temp1,temp2,temp3,temp4 : str16);
begin
  temp1 := copy(info,1,16);
  temp2 := copy(info,17,16);
  temp3 := copy(info,33,16);
  temp4 := copy(info,49,16);
end;


procedure shuffle(var info : string;temp1,temp2,temp3,temp4 : str16);
var
 x : byte;
begin
  info := '';
  for x := 1 to 16 do
    info := info + temp1[x] + temp2[x] + temp3[x] + temp4[x];
end;


procedure rnd1(var instr : str16);
var
 x : byte;
 y : byte;
 tot : word;
begin
  tot := 0;
  for x := 1 to 16 do begin
    tot := tot + ord(instr[x]);
  end;

  for x := 1 to 16 do
    instr[x] := chr(ord(instr[x]) + tot);

  for x := 1 to 16 do begin
    for y := x to 16 do
      tot := tot + ord(instr[x]);
    instr[x] := chr(tot);
  end;

  for x := 1 to 16 do begin
    for y := x to 16 do
      tot := tot + ord(instr[y]);
    instr[x] := chr(tot);
  end;

  for x := 1 to 16 do begin
    tot := tot + ord(instr[x]);
  end;

  for x := 1 to 16 do
    instr[x] := chr(ord(instr[x]) + tot);
end;


procedure rnd2(var instr : str16);
var
 x : byte;
begin
  instr := invert(copy(instr,1,4)) + invert(copy(instr,5,4))
     + invert(copy(instr,9,4)) + invert(copy(instr,13,4));
  for x := 1 to 14 do
    switch(instr[x],instr[x+2]);
end;


procedure addhash(var info : string);
var
 x : byte;
 much : byte;
 summ : longint;
begin
  summ := 0;
  much := length(info);
  for x := 1 to much do
    summ := (summ + ord(info[x])) -x;
  for x := 1 to much do
    info[x] := chr(ord(info[x]) + (summ mod 256));
end;


procedure multhash(var info : string;var summ : word);
var
 x : byte;
 much : byte;
begin
 much := length(info) - 1;
 summ := 0;
 for x := 1 to much do begin
   info[x] := chr(ord(info[x]) + (ord(info[x]) * ord(info[x+1])));
   summ := summ + ord(info[x]);
 end;
end;


procedure makecombo(var combo : string);
var
 endline : string;
 od : byte;
 y : byte;
begin
 endline := '';
 for od := 0 to 255 do
  for y := 1 to length(combo) do
   if ord(combo[y]) = od then
     endline := endline + chr(y + od);
 combo := endline;
end;


procedure hassh(var info : string);
var
 dump,summ : word;
 x,y : word;
 hsh : string;
 bufer : hshrec;
 times : byte;
begin
  addhash(info);
  makecombo(info);
  pad(info,64);

  times := 0;
  split(info,bufer[1],bufer[2],bufer[3],bufer[4]);
  shuffle(info,bufer[1],bufer[2],bufer[3],bufer[4]);
  repeat
    multhash(info,summ);
    split(info,bufer[1],bufer[2],bufer[3],bufer[4]);
    shuffle(info,bufer[1],bufer[2],bufer[3],bufer[4]);
    split(info,bufer[1],bufer[2],bufer[3],bufer[4]);
    for y := 1 to 4 do begin
      rnd1(bufer[y]);
      if odd(summ) then rnd2(bufer[y]);
    end;
    inc(times);
    if (times < 9) then shuffle(info,bufer[2],bufer[3],bufer[4],bufer[1])
      else info := bufer[1] + bufer[2] + bufer[3] + bufer[4];
  until (times = 16);
end;


end.





