/*
 Copyright (C) 1996 Mike White
 Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as all of the original files are included,
 that it is not sold for profit, and that this copyright notice is retained.

*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "wiz.h"
#include "helpids.h"

/****************************************************************************

    FUNCTION: ZipPreferencesProc(HWND, unsigned, WPARAM, LPARAM)

    PURPOSE:  Processes messages for "Get Preferences" dialog box

    MESSAGES:

    WM_INITDIALOG - initialize dialog box
    WM_COMMAND    - Input received

****************************************************************************/

#ifdef __BORLANDC__
#pragma warn -par
#pragma warn -aus
#endif
DWORD WINAPI
ZipPreferencesProc(HWND hwndDlg, UINT wMessage, WPARAM wParam, LPARAM lParam)
{
int i;
#ifndef WIN32
FARPROC lpfnDate;
#endif
   switch (wMessage) {
   case WM_INITDIALOG:
      {
      char digits[2];
      ZPOPT zo;
      /* Check to see if encryption is supported in the zip dll */
      zo = ZipGetOptions();
      if (!zo.fEncryption)
         ShowWindow(GetDlgItem(hwndDlg, IDC_ENCRYPT), SW_HIDE);
#ifndef WIN32
      ShowWindow(GetDlgItem(hwndDlg, IDC_MAKE_W32_SFX), SW_HIDE);
      ShowWindow(GetDlgItem(hwndDlg, IDC_ACL), SW_HIDE);
      ShowWindow(GetDlgItem(hwndDlg, IDC_PRIVILEGE), SW_HIDE);
#endif
      CenterDialog(GetParent(hwndDlg), hwndDlg); /* center on parent */

      for (i = 9; i >= 0; i--)
         {
         char str[10];
         itoa(i, digits, 10);
         switch (i)
            {
            case 0:
               lstrcpy(str, "0 store");
               break;
            case 1:
               lstrcpy(str, "1 minimum");
               break;
            case 6:
               lstrcpy(str, "6 default");
               break;
            case 9:
               lstrcpy(str, "9 maximum");
               break;
            default:
               lstrcpy(str, digits);
            }
         SendMessage(GetDlgItem(hwndDlg, IDC_COMPRESSION), LB_ADDSTRING,
            0, (LPARAM)(LPCSTR)str);
         }
      digits[0] = ZpOpt.fLevel;
      digits[1] = '\0';
      SendMessage(GetDlgItem(hwndDlg, IDC_COMPRESSION), LB_SELECTSTRING,
         0, (LPARAM)(LPCSTR)digits);

      CheckDlgButton(hwndDlg, IDC_VERBOSE, ZpOpt.fVerbose);
      CheckDlgButton(hwndDlg, IDC_MSDOS, ZpOpt.fForce);
      CheckDlgButton(hwndDlg, IDC_SYS_FILES, ZpOpt.fSystem);
      CheckDlgButton(hwndDlg, IDC_VOL_LABEL, ZpOpt.fVolume);
      CheckDlgButton(hwndDlg, IDC_NO_DIR_ENTRY, ZpOpt.fNoDirEntries);
      CheckDlgButton(hwndDlg, IDC_IGNORE_DIR, ZpOpt.fJunkDir);
      CheckDlgButton(hwndDlg, IDC_CRLFLF, ZpOpt.fCRLF_LF);
      CheckDlgButton(hwndDlg, IDC_LFCRLF, ZpOpt.fLF_CRLF);
      CheckDlgButton(hwndDlg, IDC_ENCRYPT, ZpOpt.fEncrypt);
      CheckDlgButton(hwndDlg, IDC_RECURSE, ZpOpt.fRecurse);
      CheckDlgButton(hwndDlg, IDC_MOVE, ZpOpt.fMove);
      CheckDlgButton(hwndDlg, IDC_FILETIME, ZpOpt.fLatestTime);
      CheckDlgButton(hwndDlg, IDC_UPDATE, ZpOpt.fUpdate);
      CheckDlgButton(hwndDlg, IDC_FRESHEN, ZpOpt.fFreshen);
      CheckDlgButton(hwndDlg, IDC_COMMENT, ZpOpt.fComment);
      CheckDlgButton(hwndDlg, IDC_QUIET, ZpOpt.fQuiet);

#ifdef WIN32
      CheckDlgButton(hwndDlg, IDC_MAKE_DOS_SFX, (fMakeSFX & fMakeDosSFX));
      CheckDlgButton(hwndDlg, IDC_MAKE_W32_SFX, (fMakeSFX & !fMakeDosSFX));
      CheckDlgButton(hwndDlg, IDC_ACL, ZpOpt.fExtra);
#else
      CheckDlgButton(hwndDlg, IDC_MAKE_DOS_SFX, fMakeSFX);
#endif

      if (ZpOpt.fRepair == 1)
         CheckDlgButton(hwndDlg, IDC_REPAIR, TRUE);
      else
         CheckDlgButton(hwndDlg, IDC_REPAIR, FALSE);
      if (ZpOpt.fRepair ==2)
         CheckDlgButton(hwndDlg, IDC_REPAIR_MORE, TRUE);
      else
         CheckDlgButton(hwndDlg, IDC_REPAIR_MORE, FALSE);
#ifdef WIN32
      CheckDlgButton(hwndDlg, IDC_PRIVILEGE, ZpOpt.fPrivilege);
#endif
      }
      break;
    /*
     * NOTE: WM_CTLCOLOR is not a supported code under Win 32
     */
#ifdef WIN32
    case WM_CTLCOLORSTATIC:
    case WM_CTLCOLORBTN:
    case WM_CTLCOLORDLG:
#else
    case WM_CTLCOLOR: /* color background of buttons and statics */
        if ((HIWORD(lParam) == CTLCOLOR_STATIC) ||
           (HIWORD(lParam) == CTLCOLOR_BTN) ||
           (HIWORD(lParam) == CTLCOLOR_DLG))
#endif
           {
           POINT point;
           SetBkMode((HDC)wParam, OPAQUE);
           SetBkColor((HDC)wParam, GetSysColor(COLOR_MENU));
           SetTextColor((HDC)wParam, GetSysColor(COLOR_MENUTEXT));
           UnrealizeObject(hBrush);
           point.x = point.y = 0;
           ClientToScreen(hwndDlg, &point);
#ifndef WIN32
           SetBrushOrg((HDC)wParam, point.x, point.y);
#else
           SetBrushOrgEx((HDC)wParam, point.x, point.y, NULL);
#endif
           hBrush = CreateSolidBrush(GetSysColor(COLOR_MENU));
           return ((DWORD)hBrush);
           }

   case WM_COMMAND:
      switch (LOWORD(wParam)) {
         case IDCANCEL:
            EndDialog(hwndDlg, wParam);
            break;
         case IDOK:
            /* Zip Options */
            {
            ZpOpt.fLevel = (char)('9' - SendMessage(GetDlgItem(hwndDlg, IDC_COMPRESSION),
               LB_GETCURSEL, 0, 0));

            EndDialog(hwndDlg, wParam);
            break;
            }
         /* Zip Options */
         case IDC_ZIP_EXCLUDE_DATE:
               ZpOpt.fExcludeDate = !ZpOpt.fExcludeDate;
               if (ZpOpt.fExcludeDate)
                  {
                  ZpOpt.fIncludeDate = FALSE;
#ifndef WIN32
                  lpfnDate = MakeProcInstance(GetDateProc, hInst);
                  DialogBox(hInst, "GETDATE", hwndDlg, lpfnDate);
                  FreeProcInstance(lpfnDate);
#else
                  DialogBox(hInst, "GETDATE", hwndDlg, GetDateProc);
#endif
                  }
               if (ZpOpt.Date[0] == '\0')
                  ZpOpt.fExcludeDate = FALSE;
               CheckDlgButton(hwndDlg, IDC_ZIP_EXCLUDE_DATE, ZpOpt.fExcludeDate);
               CheckDlgButton(hwndDlg, IDC_ZIP_INCLUDE_DATE, ZpOpt.fIncludeDate);
               break;

         case IDC_ZIP_INCLUDE_DATE:
               ZpOpt.fIncludeDate = !ZpOpt.fIncludeDate;
               if (ZpOpt.fIncludeDate)
                  {
                  ZpOpt.fExcludeDate = FALSE;
#ifndef WIN32
                  lpfnDate = MakeProcInstance(GetDateProc, hInst);
                  DialogBox(hInst, "GETDATE", hwndDlg, lpfnDate);
                  FreeProcInstance(lpfnDate);
#else
                  DialogBox(hInst, "GETDATE", hwndDlg, GetDateProc);
#endif
                  }
               if (ZpOpt.Date[0] == '\0')
                  ZpOpt.fIncludeDate = FALSE;
               CheckDlgButton(hwndDlg, IDC_ZIP_EXCLUDE_DATE, ZpOpt.fExcludeDate);
               CheckDlgButton(hwndDlg, IDC_ZIP_INCLUDE_DATE, ZpOpt.fIncludeDate);
               break;


         case IDC_REPAIR:
            i = IsDlgButtonChecked(hwndDlg, IDC_REPAIR);
            if (i)
               {
               ZpOpt.fRepair = 0;
               CheckDlgButton(hwndDlg, IDC_REPAIR, FALSE);
               CheckDlgButton(hwndDlg, IDC_REPAIR_MORE, FALSE);
               }
            else
               {
               ZpOpt.fRepair = 1;
               CheckDlgButton(hwndDlg, IDC_REPAIR, TRUE);
               CheckDlgButton(hwndDlg, IDC_REPAIR_MORE, FALSE);
               }
            break;
         case IDC_REPAIR_MORE:
            i = IsDlgButtonChecked(hwndDlg, IDC_REPAIR_MORE);
            if (i)
               {
               ZpOpt.fRepair = 0;
               CheckDlgButton(hwndDlg, IDC_REPAIR, FALSE);
               CheckDlgButton(hwndDlg, IDC_REPAIR_MORE, FALSE);
               }
            else
               {
               ZpOpt.fRepair = 2;
               CheckDlgButton(hwndDlg, IDC_REPAIR, FALSE);
               CheckDlgButton(hwndDlg, IDC_REPAIR_MORE, TRUE);
               }
            break;
         case IDC_ACL:
            ZpOpt.fExtra = !ZpOpt.fExtra;
            CheckDlgButton(hwndDlg, IDC_ACL, ZpOpt.fExtra);
            if (ZpOpt.fExtra)
               {
               ZpOpt.fPrivilege = FALSE;
               CheckDlgButton(hwndDlg, IDC_PRIVILEGE, FALSE);
               }
            break;
#ifdef WIN32
         case IDC_PRIVILEGE:
            if (dwPlatformId)
               {
               ZpOpt.fPrivilege = !ZpOpt.fPrivilege;
               CheckDlgButton(hwndDlg, IDC_PRIVILEGE, ZpOpt.fPrivilege);
               ZpOpt.fExtra = FALSE;
               CheckDlgButton(hwndDlg, IDC_ACL, ZpOpt.fExtra);
               }
            break;
#endif
         case IDC_MAKE_DOS_SFX:
#ifdef WIN32
            fMakeDosSFX = TRUE;
            if (IsDlgButtonChecked(hwndDlg, IDC_MAKE_W32_SFX))
               fMakeSFX = TRUE;
            else
               fMakeSFX = !fMakeSFX;
            CheckDlgButton(hwndDlg, IDC_MAKE_W32_SFX, FALSE);
#else
            fMakeSFX = !fMakeSFX;
#endif
            CheckDlgButton(hwndDlg, IDC_MAKE_DOS_SFX, fMakeSFX);
            break;
#ifdef WIN32
         case IDC_MAKE_W32_SFX:
            fMakeDosSFX = FALSE;
            if (IsDlgButtonChecked(hwndDlg, IDC_MAKE_DOS_SFX))
               fMakeSFX = TRUE;
            else
               fMakeSFX = !fMakeSFX;
            CheckDlgButton(hwndDlg, IDC_MAKE_DOS_SFX, FALSE);
            CheckDlgButton(hwndDlg, IDC_MAKE_W32_SFX, fMakeSFX);
            break;
#endif
         case IDC_MSDOS:
            ZpOpt.fForce = !ZpOpt.fForce;
            CheckDlgButton(hwndDlg, IDC_MSDOS, ZpOpt.fForce);
            break;
         case IDC_SYS_FILES:
            ZpOpt.fSystem = !ZpOpt.fSystem;
            CheckDlgButton(hwndDlg, IDC_SYS_FILES, ZpOpt.fSystem);
            break;
         case IDC_VOL_LABEL:
            ZpOpt.fVolume = !ZpOpt.fVolume;
            CheckDlgButton(hwndDlg, IDC_VOL_LABEL, ZpOpt.fVolume);
            break;
         case IDC_NO_DIR_ENTRY:
            ZpOpt.fNoDirEntries = !ZpOpt.fNoDirEntries;
            CheckDlgButton(hwndDlg, IDC_NO_DIR_ENTRY, ZpOpt.fNoDirEntries);
            break;
         case IDC_IGNORE_DIR:
            ZpOpt.fJunkDir = !ZpOpt.fJunkDir;
            CheckDlgButton(hwndDlg, IDC_IGNORE_DIR, ZpOpt.fJunkDir);
            break;
         case IDC_CRLFLF:
            ZpOpt.fCRLF_LF = !ZpOpt.fCRLF_LF;
            if (ZpOpt.fCRLF_LF)
               {
               ZpOpt.fLF_CRLF = FALSE;
               CheckDlgButton(hwndDlg, IDC_LFCRLF, ZpOpt.fLF_CRLF);
               }
            CheckDlgButton(hwndDlg, IDC_CRLFLF, ZpOpt.fCRLF_LF);
            break;
         case IDC_LFCRLF:
            ZpOpt.fLF_CRLF = !ZpOpt.fLF_CRLF;
            if (ZpOpt.fLF_CRLF)
               {
               ZpOpt.fCRLF_LF = FALSE;
               CheckDlgButton(hwndDlg, IDC_CRLFLF, ZpOpt.fCRLF_LF);
               }
            CheckDlgButton(hwndDlg, IDC_LFCRLF, ZpOpt.fLF_CRLF);
            break;
         case IDC_ENCRYPT:
            ZpOpt.fEncrypt = !ZpOpt.fEncrypt;
            CheckDlgButton(hwndDlg, IDC_ENCRYPT, ZpOpt.fEncrypt);
            break;
         case IDC_RECURSE:
            ZpOpt.fRecurse = !ZpOpt.fRecurse;
            CheckDlgButton(hwndDlg, IDC_RECURSE, ZpOpt.fRecurse);
            break;
         case IDC_MOVE:
            ZpOpt.fMove = !ZpOpt.fMove;
            CheckDlgButton(hwndDlg, IDC_MOVE, ZpOpt.fMove);
            break;
         case IDC_FILETIME:
            ZpOpt.fLatestTime = !ZpOpt.fLatestTime;
            CheckDlgButton(hwndDlg, IDC_FILETIME, ZpOpt.fLatestTime);
            break;
         case IDC_UPDATE:
            ZpOpt.fUpdate = !ZpOpt.fUpdate;
            CheckDlgButton(hwndDlg, IDC_UPDATE, ZpOpt.fUpdate);
            break;
         case IDC_FRESHEN:
            ZpOpt.fFreshen = !ZpOpt.fFreshen;
            CheckDlgButton(hwndDlg, IDC_FRESHEN, ZpOpt.fFreshen);
            break;
         case IDC_COMMENT:
            ZpOpt.fComment = !ZpOpt.fComment;
            CheckDlgButton(hwndDlg, IDC_COMMENT, ZpOpt.fComment);
            break;
         case IDC_QUIET:
            ZpOpt.fQuiet = !ZpOpt.fQuiet;
            CheckDlgButton(hwndDlg, IDC_QUIET, ZpOpt.fQuiet);
            break;
         case IDC_VERBOSE:
            ZpOpt.fVerbose = !ZpOpt.fVerbose;
            CheckDlgButton(hwndDlg, IDC_VERBOSE, ZpOpt.fVerbose);
            break;
         case IDC_OFFSETS:
            ZpOpt.fOffsets = !ZpOpt.fOffsets;
            CheckDlgButton(hwndDlg, IDC_OFFSETS, ZpOpt.fOffsets);
            break;
         case ID_HELP:
            WinHelp(hwndDlg,szHelpFileName,HELP_CONTEXT, (DWORD)(HELPID_ZIP_OPTIONS));
            break;
         }
      default:
         break;
   }
   return FALSE;
}
#ifdef __BORLANDC__
#pragma warn .par
#pragma warn .aus
#endif

