/* Windows Info-ZIP Window Procedure, wndproc.c.
 * Author: Robert A. Heath, 157 Chartwell Rd., Columbia, SC 29210
 * I, Robert Heath, place this source code module in the public domain.
 *
 * Modifications: 1995, 1996 M. White
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#ifdef __BORLANDC__
#  include <dir.h>
#else
#  include <direct.h>
#endif
#include "wiz.h"
#include "helpids.h"
/* For a some reason I haven't bothered to try to figure out
 * shellapi.h must follow wiz.h
 */
#include <shellapi.h>

FARPROC lpOldEditProc;
extern LRESULT CALLBACK SubClassEditProc(HWND, WORD, WPARAM, LPARAM);

char LongFileTrailer[] =
     "%7lu  %7lu %4s                    %u file%s";
char ShortFileTrailer[] = "%7lu                    %u file%s";
char Far HeadersShort[]  = " Length    Date    Time    Name";
char Far HeadersLong[]  =
  " Length     Size Ratio   Date     Time   Name";
char Far *Headers[] = {HeadersShort, HeadersLong};
char szTotalsLine[80];              /* text for totals of zip archive */

BOOL fUpdateEntries, bSizing = FALSE, bMouseButtonDown = FALSE;
OPENFILENAME ofnTemp; /* Open file name structure for edit box save and open */
/* Forward Refs
 */
void GetDirectory(LPSTR lpDir);
void GetHelpContext(WPARAM wParam);
extern LPUSERFUNCTIONS lpUserFunctions;

HWND hPatternSelectDlg; /* pattern select modeless dialog   */
static UINT uCommDlgHelpMsg;   /* common dialog help message ID */
DWORD dwCommDlgHelpId = HELPID_HELP; /* what to pass to WinHelp() */
char szFormatKeyword[2][6] = { "short", "long" };
static BOOL move_flag = FALSE;
static BOOL rename_flag = FALSE;
DWORD dwHelpContextId;
LPSTR lpchLast;

#ifndef WIN32
/* Trailers are the lines just above the totals */
static char * __based(__segname("STRINGS_TEXT")) szTrailers[2] = {
" ------                    -------",
"-------  -------  ---                    -------"
} ;
#endif
static char __based(__segname("STRINGS_TEXT")) szCantChDir[] =
   "Internal error: Cannot change directory. Common dialog error code is 0x%lX.";

/* size of char in SYSTEM font in pixels */
#ifndef WIN32
short dxChar, dyChar;
#else
long dxChar, dyChar;
#endif
/*       This will allow you to perform a hit test on a line in the
         list box, however, you then tend to lose the concept of being
         able to do ctrl-mouse click and undo selections. It wasn't
         important enough to spend any more time fooling with.
*/
#if 0
void MapCursorToListItem(void);
void MapCursorToListItem(void)
{
DWORD          dwpos;
LV_HITTESTINFO lvhti;
UINT           state;
LV_ITEM        lvi;
int            iItemClicked;
if (ListView_GetItemCount(hWndList))
   {
   /* Find out where the cursor was */
   dwpos = GetMessagePos();
   lvhti.pt.x = LOWORD(dwpos);
   lvhti.pt.y = HIWORD(dwpos);

   MapWindowPoints(HWND_DESKTOP, hWndList, &lvhti.pt, 1);
   state = lvhti.pt.x;
   lvhti.pt.x = 0;
   /* Now do a hittest with this point. We keep testing so we can
      find out if the mouse click was anywhere on the row.
    */
   while (((iItemClicked = ListView_HitTest(hWndList, &lvhti)) < 0) &&
         (lvhti.pt.x < (int)state))
         {
         lvhti.pt.x++;
         }

   /* Okay, have we clicked on a live item? */
   if (lvhti.flags & LVHT_ONITEM)
      {
      lvi.mask      = LVIF_STATE;
      lvi.stateMask = LVIS_SELECTED | LVIS_FOCUSED;
      lvi.iItem     = iItemClicked;
      lvi.iSubItem  = 0;

      ListView_GetItem(hWndList, &lvi);

      if (lvi.state & LVIS_SELECTED)
         lvi.state = 0;
      else
         lvi.state = LVIS_SELECTED | LVIS_FOCUSED;

      ListView_SetItem(hWndList, &lvi);
      }
   }
}
#endif

LPSTR lstrrchr(LPSTR lpszSrc, char chFind)
{
LPSTR   lpszFound = (LPSTR)0;
LPSTR   lpszT;

if ( lpszSrc )
   {
   for (lpszT = lpszSrc; *lpszT; ++lpszT)
       {
       if ((*lpszT) == chFind)
          lpszFound = lpszT;
       }
   }
return lpszFound;
}

/* Copy only the path portion of current file name into
 * given buffer, lpszDestDir, translate into ANSI.
 */
void GetArchiveDir(LPSTR lpszDestDir)
{
LPSTR lpchLast;

/* strip off filename to make directory name    */
lstrcpy(lpszDestDir, lpumb->szFileName);
if ((lpchLast = lstrrchr(lpszDestDir, '\\'))!=0)
   *lpchLast = '\0';
else if ((lpchLast = lstrrchr(lpszDestDir, ':'))!=0)
   *(++lpchLast) = '\0'; /* clobber char AFTER the colon! */
}

void GetDirectory(LPSTR lpDir)
{
LPSTR lpchLast;
/* If no '\\' then set directory name to "" */
if ((lpchLast = lstrrchr(lpDir, '\\')) == 0)
   {
   lpDir[0] = '\0';
   return;
   }
/* strip off filename to make directory name    */
if ((lpchLast = lstrrchr(lpDir, '\\'))!=0)
   *lpchLast = '\0';
else if ((lpchLast = lstrrchr(lpDir, ':'))!=0)
   *(++lpchLast) = '\0'; /* clobber char AFTER the colon! */
}

/*
 * FUNCTION: SetCaption(HWND hWnd)
 * PURPOSE: Set new caption for main window
 */
void
SetCaption(HWND hWnd)
{
#define SIMPLE_NAME_LEN 15
static BOOL FirstTime = TRUE;
WORD wMenuState;
char szSimpleFileName[SIMPLE_NAME_LEN+1];  /* just the 8.3 part in ANSI char set */
LPSTR lpszFileNameT;        /* pointer to simple filename               */
BOOL    fIconic = IsIconic(hWnd);   /* is window iconic ?   */
BOOL fWndEnabled; /* Is button to be enabled? */

/* point to simple filename in OEM char set */
if ((((lpszFileNameT = lstrrchr(lpumb->szFileName, '\\'))!=0) ||
   ((lpszFileNameT = lstrrchr(lpumb->szFileName, ':')))!=0))
   lpszFileNameT++;
else
   lpszFileNameT = lpumb->szFileName;

#ifndef WIN32
_fstrncpy(szSimpleFileName, lpszFileNameT, SIMPLE_NAME_LEN);
#else
strncpy(szSimpleFileName, lpszFileNameT, SIMPLE_NAME_LEN);
#endif
szSimpleFileName[SIMPLE_NAME_LEN] = '\0'; /* force termination */

wMenuState = (WORD)(szSimpleFileName[0] ? MF_ENABLED : MF_GRAYED);
fWndEnabled = (BOOL) (szSimpleFileName[0] ? TRUE : FALSE);
/* Enable/Disable menu items */
EnableMenuItem(hMenu, IDM_SELECT_ALL, wMenuState|MF_BYCOMMAND);
EnableMenuItem(hMenu, IDM_DESELECT_ALL, wMenuState|MF_BYCOMMAND);
EnableMenuItem(hMenu, IDM_SELECT_BY_PATTERN, wMenuState|MF_BYCOMMAND);

/* Enable/Disable buttons */
if (!FirstTime)
   {
   WinAssert(hSelectAll);
   EnableWindow( hSelectAll, fWndEnabled);
   WinAssert(hDeselectAll);
   EnableWindow( hDeselectAll, fWndEnabled);
   WinAssert(hSelectPattern);
   EnableWindow( hSelectPattern, fWndEnabled);
   }

if ((lstrlen(szUnzipToDirName) == 2) && (szUnzipToDirName[1] == ':') &&
   szSimpleFileName[0])
   {
   lstrcpy(szUnzipToDirName, lpumb->szFileName);
   if ((lpszFileNameT = lstrrchr(szUnzipToDirName, '\\'))!=0)
      lpszFileNameT[0] = '\0';
   if (lstrlen(szUnzipToDirName) == 2)
      lstrcat(szUnzipToDirName, "\\");
   }
if (!szSimpleFileName[0])
   lstrcpy(szSimpleFileName, "No Zip File");
wsprintf(lpumb->szBuffer, "%s - %s %s %s",
               (LPSTR)szAppName,
               (LPSTR)(szSimpleFileName),
               (LPSTR)(!fIconic && szUnzipToDirName[0] ? " - " : ""),
               (LPSTR)(!fIconic ? szUnzipToDirName : ""));
SetWindowText(hWnd, lpumb->szBuffer);
FirstTime = FALSE;
}

/*
 * FUNCTION: WiZWndMainProc(HWND, unsigned, WORD, LONG)
 *
 * PURPOSE:  Processes messages
 *
 * MESSAGES:
 *
 * WM_DESTROY      - destroy window
 * WM_SIZE         - window size has changed
 * WM_QUERYENDSESSION - willing to end session?
 * WM_ENDSESSION   - end Windows session
 * WM_CLOSE        - close the window
 * WM_SIZE         - window resized
 * WM_PAINT        - windows needs to be painted
 * WM_DROPFILES    - open a dropped file
 * COMMENTS:
 * WM_COMMAND processing:
 *    IDM_OPEN -  open a new file.
 *    IDM_EXIT -  exit.
 *    IDM_ABOUT - display "About" box.
 */

LRESULT WINAPI WiZMainWndProc(HWND hWnd, WORD wMessage, WPARAM wParam, LPARAM lParam)
{

HDC hDC;                /* device context       */
TEXTMETRIC    tm;           /* text metric structure    */
char drive;
#ifndef WIN32
FARPROC lpfnAbout, lpfnSelectDir;
#endif
char *ptr;

switch (wMessage)
    {
    case WM_CREATE: /* create  window       */
      hInst = ((LPCREATESTRUCT)lParam)->hInstance;
      hAccTable = LoadAccelerators(hInst, "WiZAccels");
      hBrush = CreateSolidBrush(GetSysColor(BG_SYS_COLOR)); /* background */

      hMenu = GetMenu(hWnd);

      /* Get an hourglass cursor to use during file transfers */
      hHourGlass = LoadCursor(0, IDC_WAIT);

      hFixedFont = GetStockObject(ANSI_FIXED_FONT);
      hDC = GetDC(hWnd);  /* get device context */
      hOldFont = SelectObject(hDC, hFixedFont);
      GetTextMetrics(hDC, &tm);
      ReleaseDC(hWnd, hDC);
      dxChar = tm.tmAveCharWidth;
      dyChar = tm.tmHeight + tm.tmExternalLeading + tm.tmInternalLeading;

      WinAssert(hWnd);
#ifndef WIN32
      hWndList = CreateWindow("listbox", NULL,
                        WS_CHILD|WS_DLGFRAME|WS_VSCROLL|LBS_NOTIFY|
                        LBS_EXTENDEDSEL|ES_NOHIDESEL,
                        0, 0,
                        0, 0,
                        hWnd, (HMENU)IDM_LISTBOX,
                        GetWindowWord (hWnd, GWW_HINSTANCE), NULL);
#else
      hWndList = CreateWindow(WC_LISTVIEW, NULL,
                        WS_CHILD | WS_DLGFRAME |
                        LVS_REPORT | LVS_SHOWSELALWAYS |
                        LVS_SORTASCENDING,
                        0, 0,
                        0, 0,
                        hWnd, (HMENU)IDM_LISTBOX,
                        (HANDLE)GetWindowLong (hWnd, GWL_HINSTANCE), NULL);
#endif
      WinAssert(hWndList);
      SendMessage(hWndList, WM_SETFONT, (WPARAM)hFixedFont, FALSE);
      WinAssert(hWnd);

#ifdef WIN32
      {
      LV_COLUMN lvc;
      int       iCol;
      char      szText[6][20]= {"Name", "Orig Size", "Comp Size","Ratio","  Date",
                  "Time"};

      /* Initialize the LV_COLUMN structure. */
      lvc.mask    = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
      lvc.fmt     = LVCFMT_LEFT;
      lvc.cx      = 95;

      for (iCol = 0; iCol < 6; iCol++)
          {
          lvc.pszText = szText[iCol];
          lvc.iSubItem = iCol;
          if (ListView_InsertColumn(hWndList, iCol, &lvc) == -1)
              return FALSE;
          }

      ListView_SetColumnWidth(hWndList, 0, MAKELPARAM((int)30*dxChar, 0));
      ListView_SetColumnWidth(hWndList, 1, MAKELPARAM((int)11*dxChar, 0));
      ListView_SetColumnWidth(hWndList, 2, MAKELPARAM((int)11*dxChar, 0));
      ListView_SetColumnWidth(hWndList, 3, MAKELPARAM((int)7*dxChar, 0));
      ListView_SetColumnWidth(hWndList, 4, MAKELPARAM((int)10*dxChar, 0));
      ListView_SetColumnWidth(hWndList, 5, MAKELPARAM((int)7*dxChar, 0));
      }
#endif /* WIN32 */

#ifndef WIN32
      hWndStatic = CreateWindow("StaticClass", "WiZ Edit/Status Window",
                            WS_OVERLAPPEDWINDOW|WS_SIZEBOX,
                            0, 0,
                            0, 0,
                            hWnd,
                            (HWND) 0,
                            GetWindowWord (hWnd, GWW_HINSTANCE), NULL);

      hWndEdit = CreateWindow("edit", NULL,
                            WS_CHILD |ES_MULTILINE|ES_NOHIDESEL|
                            ES_AUTOHSCROLL|WS_VSCROLL|WS_HSCROLL,
                            0, 0,
                            0, 0,
                            hWndStatic,
                            NULL,
                            GetWindowWord (hWnd, GWW_HINSTANCE),
                            NULL);
#else
      hWndStatic = CreateWindow("StaticClass", "WiZ Edit/Status Window",
                            WS_OVERLAPPEDWINDOW|WS_SIZEBOX,
                            0, 0,
                            0, 0,
                            hWnd,
                            NULL, /* Use class menu */
                            (HANDLE)GetWindowLong (hWnd, GWL_HINSTANCE), NULL);

      WinAssert(hWndStatic);

      hWndEdit = CreateWindow("RICHEDIT", NULL,
                            WS_CHILD |ES_MULTILINE|ECO_AUTOWORDSELECTION|
                            ECO_AUTOHSCROLL|WS_VSCROLL|WS_HSCROLL|
                            ES_NOHIDESEL|ECO_AUTOVSCROLL,
                            0, 0,
                            0, 0,
                            hWndStatic,
                            NULL,
                            (HANDLE)GetWindowLong (hWnd, GWL_HINSTANCE),
                            NULL);
#endif
      WinAssert(hWndEdit);

      /* Subclass the edit control */
      lpOldEditProc = (FARPROC)GetWindowLong (hWndEdit, GWL_WNDPROC);
      SetWindowLong (hWndEdit, GWL_WNDPROC, (LONG)SubClassEditProc);

      /* Now we set the maximum size the edit control can utilize */
#ifdef WIN32
      SendMessage(hWndEdit, EM_EXLIMITTEXT, (WPARAM)0, (LPARAM)EDIT_BUF_SIZE);
#else
      SendMessage(hWndEdit, EM_LIMITTEXT, (WPARAM) 0, 0L);
#endif
      SendMessage(hWndEdit, WM_SETFONT, (WPARAM)hFixedFont, TRUE);

#ifdef WIN32
      /* Insure rich edit control alignment is set to left */
      {
      PARAFORMAT pf;

      pf.cbSize = sizeof(pf);
      pf.dwMask = PFM_ALIGNMENT;
      pf.wAlignment = PFA_LEFT;
      SendMessage(hWndEdit, EM_SETPARAFORMAT, 0, (LPARAM)&pf);
      }
#endif
      GetWizOptions(); /* Get options from .INI file */
      UpdateListBox();
#ifndef WIN32
      SendMessage(hWndList, LB_SETSEL, 1, 0L);
#else
      ListViewSetSel(0, TRUE);
#endif
      SetCaption(hWnd);
      uCommDlgHelpMsg = RegisterWindowMessage((LPSTR)HELPMSGSTRING); /* register open help message */
      if ( uf.fCanDragDrop )
         DragAcceptFiles( hWnd, TRUE );
      break;

    case WM_SETFOCUS:
        SetFocus(hWndList);
        break;

#ifdef WIN32
    /* This whole section is only for the ListView control which is only
       available with Windows 95/Windows NT - and not for 16 bit Windows
       programs.
     */
    case WM_NOTIFY:
         {
         DWORD          dwpos;
         NM_LISTVIEW *pNm = (NM_LISTVIEW *)lParam;

         /* Are we dealing with a message from the list box? */
         if (pNm->hdr.hwndFrom != hWndList)
            break;

         switch (pNm->hdr.code) {

         case NM_RCLICK: /* Now is it a right mouse button click? */
            {
/*       This will allow you to perform a hit test on a line in the
         list box, however, you then tend to lose the concept of being
         able to do ctrl-mouse click and undo selections. It wasn't
         important enough to spend any more time fooling with.
            MapCursorToListItem();
*/
            dwpos = GetMessagePos();
            PostMessage(hWndMain, WM_RBUTTONUP, (WPARAM) 0L, (LPARAM) dwpos); /* Yep */
            break;
            }

         case NM_DBLCLK: /* Double-click in ListView control */
            {
/*       This will allow you to perform a hit test on a line in the
         list box, however, you then tend to lose the concept of being
         able to do ctrl-mouse click and undo selections. It wasn't
         important enough to spend any more time fooling with.
            MapCursorToListItem();
*/
            UpdateButtons();
            if ( uf.fCanDragDrop )
               DragAcceptFiles( hWnd, FALSE );

            Action(hWnd, (WPARAM)(wLBSelection - IDM_LB_EXTRACT));
            if ( uf.fCanDragDrop )
               DragAcceptFiles( hWnd, TRUE );
            break;
            }
         /* This is for "sorting" and is a kludge as it requires reading
            from disk each time you do a sort, but I don't know a better
            way other than keeping a list in memory which results in a
            whole bunch of memory being eaten up just for a "fancy". If
            the time delay bothers you - don't do it, just take this out.
          */
         case LVN_COLUMNCLICK: /* Column clicked on - now sort */
            ListViewSortOnColumns(pNm->iSubItem);
#ifndef WIN32
            SendMessage(hWndList, LB_SETSEL, 1, 0L);
#else
            ListViewSetSel(0, TRUE);
#endif
            break;
         case LVN_ITEMCHANGED:
            {
            UpdateButtons();
            break;
            }
/*       This will allow you to perform a hit test on a line in the
         list box, however, you then tend to lose the concept of being
         able to do ctrl-mouse click and undo selections. It wasn't
         important enough to spend any more time fooling with.

         case NM_CLICK:
            MapCursorToListItem();
            break;
*/
            }
         break;
         }
#endif /* WIN32 ? */

    case WM_ACTIVATE:
        /* This section is put in to fix a weird problem with the listbox
           not displaying the contents of an archive file if it is either
           dropped on WiZ, or if it is started from the command line.
           I have no idea why this happens.
        */
        {
        extern int ofretval;
        if ((lpumb->szFileName[0]!='\0') && (ofretval))
           {
           UpdateListBox();
           /* We have to have something selected before we can
              activate the buttons!
            */
#ifndef WIN32
           SendMessage(hWndList, LB_SETSEL, 1, 0L);
#else
           ListViewSetSel(0, TRUE);
#endif
           UpdateButtons();
           }
        ofretval = 0;
        }
        SetCaption(hWnd);
        return DefWindowProc(hWnd, wMessage, wParam, lParam);

    case WM_SIZE:
        SizeWindow();
        break;

    case WM_SYSCOMMAND:
        return DefWindowProc( hWnd, wMessage, wParam, lParam );

    case WM_RBUTTONUP:
         /*
           PURPOSE: Display and track popup menu on button click.

           PARAMETERS:
             hWnd      - Window handle
             lparam    - Coordinates where the mouse was pressed

           Always returns 0 - Message handled
          */
         {
           HMENU hmenu;
           HMENU hmenuTrackPopup;
          RECT  rc;
         BOOL fButtonState;
          POINT pt;
         DWORD dwpos;

          /* Draw the appropriate "floating" popup in the client area
            Check the listbox first
          */
          GetWindowRect(hWndList, &rc);
            dwpos = GetMessagePos();
            pt.x = LOWORD(dwpos);
            pt.y = HIWORD(dwpos);
          if (PtInRect(&rc, pt))
             {
              /* Get the menu for the popup from the resource file. */
              hmenu = LoadMenu(hInst, "PopupListMenu");
              if (!hmenu)
                 return 0;

              /* Get the first menu in it which we will use for the call to
               * TrackPopup(). This could also be created on the fly using
               * CreatePopupMenu and then using InsertMenu() or
               * AppendMenu.
             */
              hmenuTrackPopup = GetSubMenu(hmenu, 0);
            if (lpumb->szFileName[0] &&
#ifndef WIN32
               SendMessage(hWndList, LB_GETSELCOUNT, 0, 0L)) /* anything selected ? */
#else
               ListView_GetSelectedCount(hWndList))
#endif
                  fButtonState = TRUE;
            else
                  fButtonState = FALSE;

            EnableMenuItem(hmenuTrackPopup, IDM_EXTRACT,
               (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_DISPLAY,
               (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_TEST,
               (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_SHOW_COMMENT,
                   (BOOL)(fButtonState && lpUserFunctions->cchComment ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_GET_ZIPINFO,
                 (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_UPDATE_ZIP,
                 (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_ZIP_DELETE_ENTRIES,
               (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            if (lpumb->szFileName[0] != '\0')
               fButtonState = TRUE;
            else
               fButtonState = FALSE;
            EnableMenuItem(hmenuTrackPopup, IDM_COPY_ARCHIVE,
               (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_MOVE_ARCHIVE,
               (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_DELETE_ARCHIVE,
               (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_RENAME_ARCHIVE,
                (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_SELECT_ALL,
               (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_DESELECT_ALL,
               (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_SELECT_BY_PATTERN,
               (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);

              /* Draw and track the "floating" popup */
#ifdef WIN32
              TrackPopupMenuEx(hmenuTrackPopup,
                         TPM_LEFTALIGN | TPM_TOPALIGN |     /* default values */
                         TPM_LEFTBUTTON | TPM_HORIZONTAL |  /* equivalent to 0 */
                         TPM_RIGHTBUTTON,                   /* Right selection */
                         pt.x, pt.y,
                         hWnd,
                         NULL);
#else
              TrackPopupMenu(hmenuTrackPopup,
                         TPM_LEFTALIGN |   /* default values */
                         TPM_LEFTBUTTON |  /* equivalent to 0 */
                         TPM_RIGHTBUTTON,  /* Right selection */
                         pt.x, pt.y, 0,
                         hWnd,
                         NULL);
#endif
              /* Destroy the menu since we are done with it. */
              DestroyMenu(hmenu);
              return 0;
             }

         /* The mouse was not in the list box, now let's check the edit box */
         GetWindowRect(hWndEdit, &rc);
         if (PtInRect(&rc, pt))
            {
            UINT fEnable;
            UINT ichStart, ichEnd;
#ifndef WIN32
            DWORD dwResult;
#endif
            /* Get the edit control menu which we will use for the call to
             * TrackPopup(). This could also be created on the fly using
             * CreatePopupMenu and then using InsertMenu() or
             * AppendMenu.
             */
            hmenu = LoadMenu(hInst, "EditMenu");
            if (!hmenu)
               return 0;
            /* Get the edit menu from the parent of the edit control */
            hmenuTrackPopup = GetSubMenu(hmenu, 1);
            /* Is an "undo" operation possible? */
                fEnable = (UINT)SendMessage(hWndEdit, EM_CANUNDO, 0, 0);
            EnableMenuItem(hmenuTrackPopup, IDM_EDIT_UNDO,
               (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);

                /* Can we paste to the edit control? */
                if (OpenClipboard(hWnd))
                   {
                   /* Only allow text */
                   if (IsClipboardFormatAvailable(CF_TEXT) ||
                       IsClipboardFormatAvailable(CF_OEMTEXT))
                       fEnable = TRUE;
                   else
                       fEnable = FALSE;
                   }
                CloseClipboard();
                EnableMenuItem(hmenuTrackPopup, IDM_EDIT_PASTE,
                    (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);

                /* Is anything selected in the edit control */
#ifdef WIN32
                SendMessage(hWndEdit, EM_GETSEL, (WPARAM)&ichStart, (LPARAM)&ichEnd);
            fEnable = (ichStart != ichEnd);
#else
                dwResult = SendMessage(hWndEdit, EM_GETSEL, 0, 0);
            ichStart = LOWORD(dwResult);
            ichEnd = HIWORD(dwResult);
            fEnable = (ichStart != ichEnd);
#endif
            EnableMenuItem(hmenuTrackPopup, IDM_EDIT_CUT,
               (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_EDIT_COPY,
               (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_EDIT_DELETE,
               (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);

            /* Anything in the edit control at all? */
            fEnable = (UINT)SendMessage(hWndEdit, WM_GETTEXTLENGTH, 0, 0);
            EnableMenuItem(hmenuTrackPopup, IDM_EDIT_SELECT_ALL,
               (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
            EnableMenuItem(hmenuTrackPopup, IDM_CLEAR_STATUS,
               (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);

            /* Draw and track the "floating" popup */
#ifdef WIN32
            TrackPopupMenuEx(hmenuTrackPopup,
                         TPM_LEFTALIGN | TPM_TOPALIGN |     /* default values */
                         TPM_LEFTBUTTON | TPM_HORIZONTAL |  /* equivalent to 0 */
                         TPM_RIGHTBUTTON,                   /* Right selection */
                         pt.x, pt.y,
                         hWndEdit,
                         NULL);
#else
            TrackPopupMenu(hmenuTrackPopup,
                         TPM_LEFTALIGN |      /* default values */
                         TPM_LEFTBUTTON |
                         TPM_RIGHTBUTTON,     /* Right selection */
                         pt.x, pt.y, 0,
                         hWnd,
                         NULL);
#endif
           }
        return 0;
        }

    /*
     *
     * This section is solely to cause the bubble help to be drawn with
     * different colors than the background window. This is not necessary
     * for 16 bit windows, as this is done for you.
     *
     */
#ifdef WIN32
    case WM_CTLCOLORSTATIC:
           {
           POINT point;
           SetBkColor((HDC)wParam, GetSysColor(COLOR_INFOBK));
           SetBkMode((HDC)wParam, OPAQUE);
           SetTextColor((HDC)wParam, GetSysColor(COLOR_INFOTEXT));
           point.x = point.y = 0;
           ClientToScreen(hWnd, &point);
           SetBrushOrgEx((HDC)wParam, point.x, point.y, NULL);
           hBrush = CreateSolidBrush(GetSysColor(COLOR_INFOBK));
           return ((DWORD)hBrush);
           }
#endif
    case WM_COMMAND:
        /* Was F1 just pressed in a menu, or are we in help mode */
        /* (Shift-F1)? */

        if (uf.fHelp)
           {
           GetHelpContext(wParam);

           if ((!dwHelpContextId) && (uf.fHelp))
              {
              MessageBox( hWnd, "Context Help not available for this item",
                         "Help Example", MB_OK);
              }
           else
              if (uf.fHelp)
                  WinHelp(hWnd,szHelpFileName,HELP_CONTEXT,dwHelpContextId);
           uf.fHelp = FALSE;
        }
        else /* not in help mode */
        {
#ifndef WIN32
        RECT  rClient;
#endif
            switch (LOWORD(wParam))
            {
            case IDM_GREP_ARCHIVE:
               {
               extern char baseDir[PATH_MAX];
               extern char SearchPattern[PATH_MAX];
               char *p, drive[2], szTmp[PATH_MAX];
               OPENFILENAME ofn;
#ifndef WIN32
               FARPROC lpfnGrepArchive;
#endif
               if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );

#ifndef WIN32
               _fmemset(&ofn, '\0', sizeof(OPENFILENAME)); /* initialize struct */
#else
               memset(&ofn, '\0', sizeof(OPENFILENAME)); /* initialize struct */
#endif
               WinAssert(hWnd);
               szTmp[0] = '\0';
               ofn.lStructSize = sizeof(OPENFILENAME);
               ofn.hwndOwner = hWnd;
               ofn.hInstance = hInst;
               ofn.lpstrFilter = "All Files (*.*)\0*.*\0\0";
               ofn.nFilterIndex = 1;

               ofn.lpstrFile = szTmp;
               ofn.nMaxFile = PATH_MAX;
               ofn.lpstrFileTitle = NULL;
               ofn.nMaxFileTitle = PATH_MAX; /* ignored ! */
               ofn.lpstrTitle = (LPSTR)"Find Files in Archive";
               ofn.lpstrInitialDir = NULL;
               ofn.Flags = OFN_SHOWHELP | OFN_ENABLEHOOK | OFN_CREATEPROMPT |
                  OFN_HIDEREADONLY | OFN_ENABLETEMPLATE | OFN_NOCHANGEDIR;
#ifndef WIN32
               lpfnGrepArchive = MakeProcInstance((FARPROC)GrepArchiveProc, hInst);
#   ifndef MSC
               (UINT CALLBACK *)ofn.lpfnHook = (UINT CALLBACK *)lpfnGrepArchive;
#   else
               ofn.lpfnHook = lpfnGrepArchive;
#   endif
#else
               ofn.lpfnHook = (LPOFNHOOKPROC)GrepArchiveProc;
#endif
               ofn.lpTemplateName = "GREPARCHIVES";   /* see grep.dlg   */
               GetOpenFileName(&ofn);
               if ((lstrlen(SearchPattern) != 0) &&
                  (lstrlen(baseDir) != 0))
                  {
                  drive[0] = baseDir[0];
                  drive[1] = '\0';
                  p = &baseDir[2];
                  /* Off we go - the control handle is set to null as a flag */
                  FindFile(drive, p, NULL);
                  }
               }
               if (uf.fCanDragDrop)
                   DragAcceptFiles(hWnd, TRUE);
               break;
#ifndef WIN32
            /* Deal with the Edit box menu items */
            case IDM_EDIT_UNDO:
                    SendMessage(hWndEdit, EM_UNDO, 0, 0);
               break;
            case IDM_EDIT_CUT:
                    SendMessage(hWndEdit, WM_CUT, 0, 0);
               break;
            case IDM_EDIT_COPY:
                    SendMessage(hWndEdit, WM_COPY, 0, 0);
               break;
            case IDM_EDIT_PASTE:
                    SendMessage(hWndEdit, WM_PASTE, 0, 0);
               break;
            case IDM_EDIT_DELETE:
                    SendMessage(hWndEdit, WM_CLEAR, 0, 0);
               SetWindowText(hWndStatic, "WiZ Edit/Status Window");
               break;
            case IDM_EDIT_SELECT_ALL:
                    SendMessage(hWndEdit, EM_SETSEL, (WPARAM)0,
                  (LPARAM)MAKELPARAM(0,-1));
               break;
#endif

            case IDM_ZIP_TARGET:
            case IDM_ZIP_PREFERENCES:
            case IDM_UNZIP_PREFERENCES:
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );

                ZipWndProc(hWnd, wMessage, wParam, lParam);
                WriteZipOptionsProfile();

                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, TRUE );
               break;
            case IDM_OPEN:
                /* If unzipping separately and previous file exists,
                 * go to directory where archive lives.
                 */
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );

            /* If not unzipping to same directory as archive and
             * file already open, go to where file lives.
             * If extracting to different directory, return to
             * that directory after selecting archive to open.
             */
            if (lpumb->szUnzipFromDirName[0])
               {
               lstrcpy(lpumb->szDirName, lpumb->szUnzipFromDirName);
               }
            if (lpumb->szFileName[0])
               {
               /* strip off filename to make directory name    */
               GetArchiveDir(lpumb->szDirName);
               }
            else
               {
               if (!lpumb->szUnzipFromDirName[0])
                  lpumb->szDirName[0] = '\0'; /* assume no dir   */
               }
            lpumb->szBuffer[0] = '\0';
#ifndef WIN32
            _fmemset(&lpumb->ofn, '\0', sizeof(OPENFILENAME)); /* initialize struct */
#else
            memset(&lpumb->ofn, '\0', sizeof(OPENFILENAME)); /* initialize struct */
#endif
            lpumb->ofn.lStructSize = sizeof(OPENFILENAME);
            lpumb->ofn.hwndOwner = hWnd;
            lpumb->ofn.lpstrFilter = "Zip Files (*.zip)\0*.zip\0Self-extracting Files (*.exe)\0*.exe\0All Files (*.*)\0*.*\0\0";
            lpumb->ofn.nFilterIndex = 1;
            lpumb->ofn.lpstrFile = lpumb->szFileName;
            lpumb->szFileName[0] = '\0';   /* no initial filename   */
            lpumb->ofn.nMaxFile = PATH_MAX;
            lpumb->ofn.lpstrFileTitle = lpumb->szBuffer; /* ignored */
            lpumb->ofn.lpstrInitialDir = (LPSTR)(!lpumb->szDirName[0] ? NULL : lpumb->szDirName);

            lpumb->ofn.nMaxFileTitle = PATH_MAX;
            lpumb->ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST |
                   OFN_HIDEREADONLY|OFN_NOVALIDATE;
            dwCommDlgHelpId = HELPID_OPEN; /* specify correct help for open dlg   */
            if (GetOpenFileName(&lpumb->ofn))   /* if successful file open  */
               {
               /* Yes, you should be able to get the fully qualified path name
                  in lpumb->szFileName when you return from GetOpenFileName(),
                  however, at least Borland 4.52 (others?) does not return a fully
                  qualified path, but simply the file name. This kludge gets
                  around that.
                */  
               getcwd(lpumb->szDirName, PATH_MAX);
               /* If we get a fully qualified file name, then the second
                  character should be a colon.
                */
               if (lpumb->szFileName[1] != ':')
                  {
                  lstrcpy(lpumb->szBuffer, lpumb->szDirName);
                  if (lpumb->szBuffer[lstrlen(lpumb->szBuffer)-1] != '\\')
                     lstrcat(lpumb->szBuffer, "\\");
                  lstrcat(lpumb->szBuffer, lpumb->szFileName);
                  lstrcpy(lpumb->szFileName, lpumb->szBuffer);
                  }
               /*
               Save the last "unzip from" directory
               */
               if (lpumb->szDirName[1] == ':')
                  drive = lpumb->szDirName[0];
               else
                  drive = '\0';

               if (uf.fSaveUnZipFromDir &&
                  (toupper(drive) != 'A') &&
                  (toupper(drive) != 'B'))
                  {
                  lstrcpy(lpumb->szUnzipFromDirName, lpumb->szDirName);
                  if (lpumb->szUnzipFromDirName[strlen(lpumb->szUnzipFromDirName)-1]
                     == ':')
                     lstrcat(lpumb->szUnzipFromDirName, "\\");
                  WritePrivateProfileString(szAppName, szDefaultUnzipFromDir,
                                 lpumb->szUnzipFromDirName, szWiZIniFile);
                  }
               else
                  WritePrivateProfileString(szAppName, szDefaultUnzipFromDir,
                                 "", szWiZIniFile);
               if (uf.fUnzipToZipDir || /* unzipping to same directory as archive */
                  szUnzipToDirName[0] == '\0') /* or no default */
                  {
                  /* strip off filename to make directory name    */
                  lstrcpy(szUnzipToDirName, lpumb->szDirName);
                  }
               }
               UpdateListBox(); /* fill in list box */
#ifndef WIN32
               SendMessage(hWndList, LB_SETSEL, 1, 0L);
#else
               ListViewSetSel(0, TRUE);
#endif               
               UpdateButtons(); /* update state of buttons */
               SetCaption(hWnd);
#ifndef WIN32
               /* Update archive totals area */
               WinAssert(hWndList);
               GetClientRect( hWndList, &rClient );
               OffsetRect( &rClient, 0, dyChar );
               rClient.top = rClient.bottom;
               rClient.bottom = rClient.top + (6*dyChar);
               InvalidateRect( hWnd, &rClient, TRUE);
#endif
               if ( uf.fCanDragDrop )
                  DragAcceptFiles( hWnd, TRUE );
               break;

            case IDM_CHDIR:
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );

#ifndef WIN32
                _fmemset(&lpumb->ofn, '\0', sizeof(OPENFILENAME)); /* initialize struct */
#else
                memset(&lpumb->ofn, '\0', sizeof(OPENFILENAME)); /* initialize struct */
#endif
                lpumb->ofn.lStructSize = sizeof(OPENFILENAME);
                lpumb->ofn.hwndOwner = hWnd;
                lpumb->ofn.hInstance = hInst;
                lpumb->ofn.lpstrFilter = "All Files (*.*)\0*.*\0\0";
                lpumb->ofn.nFilterIndex = 1;
                lstrcpy(lpumb->szUnzipToDirNameTmp, szUnzipToDirName); /* initialize */
                { /* Braces are here to allow the declaration of uDirNameLen */
#ifndef WIN32
                size_t uDirNameLen = _fstrlen(lpumb->szUnzipToDirNameTmp);
#else
                size_t uDirNameLen = strlen(lpumb->szUnzipToDirNameTmp);
#endif
               /* If '\\' not at end of directory name, add it now.
                */
                if (uDirNameLen > 0 && lpumb->szUnzipToDirNameTmp[uDirNameLen-1] != '\\')
                   lstrcat(lpumb->szUnzipToDirNameTmp, "\\");
                }
                lstrcat(lpumb->szUnzipToDirNameTmp,
                    "johnny\376\376.\375\374\373"); /* fake name */
                lpumb->ofn.lpstrFile = lpumb->szUnzipToDirNameTmp; /* result goes here! */
                lpumb->ofn.nMaxFile = PATH_MAX;
                lpumb->ofn.lpstrFileTitle = NULL;
                lpumb->ofn.nMaxFileTitle = PATH_MAX; /* ignored ! */
                lpumb->ofn.lpstrInitialDir = szUnzipToDirName;
                lpumb->ofn.lpstrTitle = (LPSTR)"Unzip To";
                lpumb->ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST |
                           OFN_HIDEREADONLY|OFN_NOCHANGEDIR;
                lpumb->ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_ENABLEHOOK |
                           OFN_HIDEREADONLY|OFN_ENABLETEMPLATE|OFN_NOCHANGEDIR;
#ifndef WIN32
                lpfnSelectDir =
                  MakeProcInstance((FARPROC)SelectDirProc, hInst);
#ifndef MSC
                (UINT CALLBACK *)lpumb->ofn.lpfnHook = (UINT CALLBACK *)lpfnSelectDir;
#else
                lpumb->ofn.lpfnHook = lpfnSelectDir;
#endif

#else
                lpumb->ofn.lpfnHook = (LPOFNHOOKPROC)SelectDirProc;
#endif
                lpumb->ofn.lpTemplateName = "SELDIR";   /* see seldir.dlg   */
                dwCommDlgHelpId = HELPID_CHDIR; /* in case user hits "help" button */
                if (GetSaveFileName(&lpumb->ofn)) /* successfully got dir name ? */
                   {
#ifndef WIN32
                   ptr = _fstrrchr(lpumb->ofn.lpstrFile, '\\');
#else
                   ptr = strrchr(lpumb->ofn.lpstrFile, '\\');
#endif
                   if (ptr != NULL)
                      lpumb->ofn.lpstrFile[(int)(ptr - lpumb->ofn.lpstrFile)] = '\0';
                   lstrcpy(szUnzipToDirName, lpumb->ofn.lpstrFile); /* save result */

                   if (szUnzipToDirName[1] == ':')
                      {
                      drive = szUnzipToDirName[0];
                      if (lstrlen(szUnzipToDirName) == 2)
                         { /* We only have a drive letter and a colon */
                         lstrcat(szUnzipToDirName, "\\");
                         }
                      }
                   else
                      drive = '\0';
                   if (uf.fSaveUnZipToDir &&
                      (toupper(drive) != 'A') &&
                      (toupper(drive) != 'B'))
                       {
                  /* Always save last directory written to */
                       WritePrivateProfileString(szAppName, szDefaultUnzipToDir,
                          szUnzipToDirName, szWiZIniFile);
                       }
                   SetCaption(hWnd);
                   }
                else /* either real error or canceled */
                   {
                   DWORD dwExtdError = CommDlgExtendedError(); /* debugging */

                   if (dwExtdError != 0L) /* if not canceled then real error */
                      {
                      wsprintf (lpumb->szBuffer, szCantChDir, dwExtdError);
                      MessageBox (hWnd, lpumb->szBuffer, szAppName, MB_ICONINFORMATION | MB_OK);
                      }
                   }
#ifndef WIN32
                FreeProcInstance(lpfnSelectDir);
#endif
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, TRUE );
                break;
            case IDM_DELETE_ARCHIVE:
                {
                char szStr[PATH_MAX];
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );
                sprintf(szStr, "Are you sure you want to delete\n%s", lpumb->szFileName);
                if (MessageBox(hWnd, szStr, "Deleting File", MB_ICONSTOP | MB_OKCANCEL) == IDOK)
                   {
                   remove(lpumb->szFileName);
                   BufferOut("Deleting %s\n", lpumb->szFileName);
#ifndef WIN32
                   SendMessage(hWndList, LB_RESETCONTENT, 0, 0);
#else
                   ListView_DeleteAllItems(hWndList);
#endif
                   lpumb->szFileName[0] = '\0';
                   SetCaption(hWnd);
                   UpdateButtons(); /* update state of buttons */
                   }
                if ( uf.fCanDragDrop )
                  DragAcceptFiles( hWnd, TRUE );
                break;
                }
            case IDM_MOVE_ARCHIVE:
                /*
                 * Yes - this can be done under Win32 differently, but
                 * you have to go through some hoops, and this just makes
                 * it easier.
                 */
                move_flag = TRUE;
                dwCommDlgHelpId = HELPID_MOVE_ARCHIVE; /* in case user hits "help" button */
            case IDM_RENAME_ARCHIVE:
                if (!move_flag)
                   {
                   rename_flag = TRUE;
                   dwCommDlgHelpId = HELPID_RENAME_ARCHIVE; /* in case user hits "help" button */
                   }
            case IDM_COPY_ARCHIVE:
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );
                if ((!move_flag) && (!rename_flag))
                   dwCommDlgHelpId = HELPID_COPY_ARCHIVE; /* in case user hits "help" button */
                CopyArchive(hWnd, move_flag, rename_flag);
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, TRUE );
                move_flag = FALSE;
                rename_flag = FALSE;
                break;

            case IDM_EXIT:
                WriteZipOptionsProfile();
                SendMessage(hWnd, WM_CLOSE, 0, 0L);
                break;

            case IDM_HELP:  /* Display Help */
#ifndef WIN32
                WinHelp(hWnd,szHelpFileName,HELP_INDEX,0L);
#else
                WinHelp(hWnd,szHelpFileName,HELP_FINDER,0L);
#endif
                break;

            case IDM_SHIFT_HELP:
                uf.fHelp = TRUE;
                SetCursor(hHelpCursor);
                break;

            case IDM_ESCAPE:
                if (uf.fHelp)
                    {
                   uf.fHelp = FALSE;
#ifndef WIN32
                   SetCursor((HCURSOR)GetClassWord(hWndMain,GCW_HCURSOR));
#else
                   SetCursor((HCURSOR)GetClassLong(hWndMain,GCL_HCURSOR));
#endif
                   dwHelpContextId = (DWORD) 0L;
                   return 0;
                   }
                break;

            case IDM_HELP_HELP:
                WinHelp(hWnd,"WINHELP.HLP",HELP_INDEX,0L);
                break;

            case IDM_ABOUT:
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );
#ifndef WIN32
                lpfnAbout = MakeProcInstance(AboutProc, hInst);
                DialogBox(hInst, "About", hWnd, lpfnAbout);
                FreeProcInstance(lpfnAbout);
#else
                DialogBox(hInst, "About", hWnd, AboutProc);
#endif
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, TRUE );
                break;

#ifndef WIN32
            case IDM_LISTBOX:       /* command from listbox     */
                if (cZippedFiles)
                {
                    switch (GET_WM_COMMAND_CMD(wParam, lParam))
                    {
                    case LBN_SELCHANGE:
                        UpdateButtons();
                        break;
                    case LBN_DBLCLK:
                        UpdateButtons();
                        if ( uf.fCanDragDrop )
                            DragAcceptFiles( hWnd, FALSE );

                        Action(hWnd, (WPARAM)(wLBSelection - IDM_LB_EXTRACT));
                        if ( uf.fCanDragDrop )
                            DragAcceptFiles( hWnd, TRUE );
                        break;
                    }
                }
                break;
            case IDM_LONG:
            case IDM_SHORT:
                /* If format change, uncheck old, check new. */
                if ((LOWORD(wParam) - IDM_SHORT) != (signed int)uf.fFormatLong)
                {
                    WPARAM wFormatTmp = (WPARAM)(LOWORD(wParam)  - IDM_SHORT);
                    int __far *pnSelItems; /* pointer to list of selected items */
                    HANDLE  hnd = 0;
                    int cSelLBItems ; /* no. selected items in listbox */
                    RECT    rClient;

                    cSelLBItems = CLBItemsGet(hWndList, &pnSelItems, &hnd);
                    CheckMenuItem(hMenu, (IDM_SHORT+uf.fFormatLong), MF_BYCOMMAND|MF_UNCHECKED);
                    CheckMenuItem(hMenu, (IDM_SHORT+wFormatTmp), MF_BYCOMMAND|MF_CHECKED);
                    uf.fFormatLong = wFormatTmp;
                    UpdateListBox();

                    WriteZipOptionsProfile();

                    /* anything previously selected ? */
                    if (cSelLBItems > 0)
                       {
                       ReselectLB(hWndList, cSelLBItems, pnSelItems);
                       GlobalUnlock(hnd);
                       GlobalFree(hnd);
                       }

                    /* make sure labels & Zip archive totals get updated */
                    WinAssert(hWnd);
                    GetClientRect( hWnd, &rClient );
                    /* Drop down two lines for button row */
                    rClient.top = (2*dyChar);
                    rClient.bottom = rClient.top + (2*dyChar);
                    /* Okay, now we selected only the "header" for
                     * repainting, invalidate it.
                     */
                    InvalidateRect( hWnd, &rClient, TRUE);
                    WinAssert(hWndList);
                    GetClientRect( hWndList, &rClient );
                    rClient.top = rClient.bottom;
                    /* Now allow for two lines for button row,
                     * two lines for the "header" and two lines
                     * for the trailer. Then invalidate it.
                     */
                    rClient.bottom = rClient.top + (6*dyChar);
                    InvalidateRect( hWnd, &rClient, TRUE);
                }
                break;
#endif
            case IDM_SAVE_UNZIP_TO_DIR:
                /* Toggle value of fSaveUnzipToDir flag. */
                uf.fSaveUnZipToDir = !uf.fSaveUnZipToDir;
                CheckMenuItem(hMenu,IDM_SAVE_UNZIP_TO_DIR,MF_BYCOMMAND|
                                (WORD)(uf.fSaveUnZipToDir ? MF_CHECKED: MF_UNCHECKED));
                WriteZipOptionsProfile();
                if (uf.fSaveUnZipToDir)
                   WritePrivateProfileString(szAppName, szDefaultUnzipToDir,
                         "", szWiZIniFile);
                break;

            case IDM_SAVE_UNZIP_FROM_DIR:
                /* Toggle value of fSaveUnzipToDir flag. */
                uf.fSaveUnZipFromDir = !uf.fSaveUnZipFromDir;
                CheckMenuItem(hMenu,IDM_SAVE_UNZIP_FROM_DIR,MF_BYCOMMAND|
                                (WORD)(uf.fSaveUnZipFromDir ? MF_CHECKED: MF_UNCHECKED));
                WriteZipOptionsProfile();
                if (uf.fSaveUnZipFromDir)
                   WritePrivateProfileString(szAppName, szDefaultUnzipFromDir,
                         "", szWiZIniFile);
                break;

            case IDM_UNZIP_TO_ZIP_DIR:
                /* toggle value of Unzip to .ZIP  */
                uf.fUnzipToZipDir = !uf.fUnzipToZipDir;
                CheckMenuItem(hMenu,IDM_UNZIP_TO_ZIP_DIR,MF_BYCOMMAND|
                                    (WORD)(uf.fUnzipToZipDir ? MF_CHECKED:MF_UNCHECKED));
                EnableMenuItem(hMenu,IDM_CHDIR,MF_BYCOMMAND|
                                    (WORD)(uf.fUnzipToZipDir ? MF_GRAYED:MF_ENABLED));
                WriteZipOptionsProfile();
                if (uf.fUnzipToZipDir && lpumb->szDirName[0])
                   {
                   lstrcpy(szUnzipToDirName, lpumb->szDirName); /* get new dirname */
                   SetCaption(hWnd);
                   }
                break;
            case IDM_SAVE_ZIP_TO_DIR:
               fSaveZipToDir = !fSaveZipToDir;
               CheckMenuItem(hMenu, IDM_SAVE_ZIP_TO_DIR,
                  MF_BYCOMMAND | (fSaveZipToDir ? MF_CHECKED : MF_UNCHECKED));
               if (!fSaveZipToDir)
                  szTargetZipDir[0] = '\0';
               WriteZipOptionsProfile();
               break;
            case IDM_MAKE_DIR:
               {
               FARPROC lpfnMakeDir;
               dwCommDlgHelpId = HELPID_MAKEDIR_HELP; /* if someone hits help */
               lpfnMakeDir = MakeProcInstance(MakeDirProc, hInst);
               DialogBox(hInst, "MAKEDIR", hWnd, lpfnMakeDir);
#ifndef WIN32
               FreeProcInstance(lpfnMakeDir);
#endif
               }
               break;
            case IDM_SOUND_OPTIONS: /* launch Sound Options dialog box   */
             {
            FARPROC lpfnSoundOptions;
            dwCommDlgHelpId = HELPID_SOUND_OPTIONS; /* if someone hits "help" */
                lpfnSoundOptions = MakeProcInstance(SoundProc, hInst);
                DialogBox(hInst, "SOUND", hWnd, lpfnSoundOptions);
#ifndef WIN32
                FreeProcInstance(lpfnSoundOptions);
#endif
            }
                break;

            case IDM_SHOW_COMMENT:
                /* display the archive comment in mesg window */
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );
                DisplayComment(hWnd);
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, TRUE );
                break;

            case IDM_SHOW_BUBBLE_HELP:
                /* Show toolbar help */
                uf.fShowBubbleHelp = !uf.fShowBubbleHelp;
                CheckMenuItem(hMenu, IDM_SHOW_BUBBLE_HELP,
                 MF_BYCOMMAND | (uf.fShowBubbleHelp ? MF_CHECKED : MF_UNCHECKED));
                WriteZipOptionsProfile();
                break;

            case IDM_GET_ZIPINFO:
            case IDM_UPDATE_ZIP:
            case IDM_DISPLAY:
            case IDM_TEST:
            case IDM_EXTRACT:
            case IDM_ZIP_DELETE_ENTRIES:
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );

                fUpdateEntries = TRUE;
                Action(hWnd, (WPARAM)(LOWORD(wParam) - IDM_EXTRACT));
                if (ZpOpt.fOffsets)
                   {
#ifndef WIN32
                   DWORD i;
                   i = SendMessage(hWndList , LB_GETCOUNT, 0, 0);
                   SendMessage(hWndList , LB_SELITEMRANGE,
                          (WPARAM) FALSE, MAKELONG(0, i));
#else
                   DWORD i, j;
                   i = ListView_GetItemCount(hWndList);
                   for (j = 0; j < i; j++)
                        ListViewSetSel(j, TRUE);
#endif
                   }
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, TRUE );
                break;

            case IDM_SELECT_ALL:
            case IDM_DESELECT_ALL:
                if (cZippedFiles)
                   {
#ifndef WIN32
                   SendMessage(hWndList , LB_SELITEMRANGE,
                          (WPARAM)(LOWORD(wParam) == IDM_DESELECT_ALL ? FALSE : TRUE),
                          MAKELONG(0, (cZippedFiles-1)));
#else
                   int i;
                   int iItems = ListView_GetItemCount(hWndList);
                   if (LOWORD(wParam) == IDM_DESELECT_ALL)
                       for (i = 0; i < iItems; i++)
                           ListViewSetSel(i, FALSE);
                   else
                       for (i = 0; i < iItems; i++)
                           ListViewSetSel(i, TRUE);
#endif
                   UpdateButtons();
                   }
                break;

         case IDM_SELECT_BY_PATTERN:
            if (!hPatternSelectDlg)
               {
               DLGPROC lpfnPatternSelect;

               dwCommDlgHelpId = HELPID_SELECT_BY_PATTERN;
               lpfnPatternSelect = (DLGPROC)MakeProcInstance(PatternSelectProc, hInst);
               WinAssert(lpfnPatternSelect)
               hPatternSelectDlg =
               CreateDialog(hInst, "PATTERN", hWnd, lpfnPatternSelect);
               WinAssert(hPatternSelectDlg);
               }
            break;

         case IDM_CLEAR_STATUS:  /* forward to status window */
            SendMessage(hWndEdit, WM_COMMAND, IDM_CLEAR_STATUS, 0L);
            break;

         case IDM_EDIT_SAVE_AS:
            {
            OFSTRUCT ofs;
            char szFilename[PATH_MAX] = "";
            char *p;
#ifdef WIN32
            DWORD bytes_written;
            HANDLE hFile;
#else
            HFILE hFile;
#endif

            memset(&ofnTemp, 0, sizeof (ofnTemp));
            memset(&ofs, 0, sizeof(ofs));
            GetWindowText(hWndStatic, szFilename, PATH_MAX);
            for (p = szFilename; *p; p++)
               if (*p == '/')
                  *p = '\\';
            ofnTemp.lStructSize = sizeof (ofnTemp);
            ofnTemp.hwndOwner = hWndMain;
            ofnTemp.hInstance = hInst;
            ofnTemp.lpstrFilter = "All Files (*.*)\0*.*\0\0";
            ofnTemp.nFilterIndex = 1;
            ofnTemp.lpstrFile = szFilename;
            ofnTemp.nMaxFile = PATH_MAX;
            ofnTemp.lpstrInitialDir = NULL;
            ofnTemp.Flags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;

             if (GetSaveFileName (&ofnTemp))
               {
               unsigned int txtlen;
               txtlen = (unsigned int)SendMessage(hWndEdit, WM_GETTEXTLENGTH, 0, 0);
               if (txtlen != 0)
                  txtlen++;
               SendMessage(hWndEdit, WM_GETTEXT, txtlen, (LPARAM)pszBuffer);
#ifndef WIN32
               hFile = OpenFile(szFilename, &ofs, OF_CREATE);
               _lwrite (hFile, pszBuffer, lstrlen(pszBuffer));
               _lclose (hFile);
#else
               hFile = CreateFile(szFilename, GENERIC_WRITE, 0, NULL,
                  CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
               WriteFile(hFile, pszBuffer, lstrlen(pszBuffer), &bytes_written,NULL);
               CloseHandle(hFile);
#endif
               SetWindowText(hWndStatic, szFilename);
               }
            }
            break;

         case IDM_EDIT_OPEN_FILE:
            {
            OFSTRUCT ofs;
            char szFilename[PATH_MAX] = "";
#ifdef WIN32
            DWORD bytes_written, dwSize;
            HANDLE hFile;
#else
            HFILE hFile;
#endif

            memset(&ofnTemp, 0, sizeof (ofnTemp));
            memset(&ofs, 0, sizeof(ofs));

            ofnTemp.lStructSize = sizeof (ofnTemp);
            ofnTemp.hwndOwner = hWndMain;
            ofnTemp.hInstance = hInst;
            ofnTemp.lpstrFilter = "All Files (*.*)\0*.*\0\0";
            ofnTemp.nFilterIndex = 1;
            ofnTemp.lpstrFile = szFilename;
            ofnTemp.nMaxFile = PATH_MAX;
            ofnTemp.lpstrInitialDir = NULL;
            ofnTemp.Flags = OFN_FILEMUSTEXIST;

            if (GetOpenFileName (&ofnTemp))
               {
               extern BOOL MapCRtoCRLF(LPSTR);
               SendMessage(hWndEdit, WM_COMMAND, IDM_CLEAR_STATUS, 0L);
#ifndef WIN32
               hFile = OpenFile(szFilename, &ofs, OF_READ);
               _lread (hFile, pszBuffer, (UINT)EDIT_BUF_SIZE);
               _lclose (hFile);
#else
               hFile = CreateFile(szFilename, GENERIC_READ, 0, NULL,
                  OPEN_EXISTING, FILE_ATTRIBUTE_ARCHIVE, NULL);
               dwSize = GetFileSize(hFile, NULL);
               if (dwSize >= (dwEditBufSize - 1))
                  {
                  HGLOBAL hTemp;
                  GlobalUnlock(hEditor);
                  hTemp = GlobalReAlloc(hEditor, dwSize + 0x1000,
                     GMEM_MOVEABLE|GMEM_ZEROINIT);
                  if (hTemp)
                     {
                     hEditor = hTemp;
                     dwEditBufSize = dwSize + 0x1000;
                     }
                  else
                     MessageBox(hWndMain,
                        "Cannot allocate enough memory for file. Truncating file.",
                        "Insufficient Memory",
                        MB_ICONINFORMATION|MB_OK);
                  pszBuffer = GlobalLock(hEditor);
                  memset(pszBuffer, '\0', dwEditBufSize);
                  }
               ReadFile(hFile, pszBuffer, dwSize, &bytes_written, NULL);
               CloseHandle(hFile);
#endif
               /* Convert CR to CRLF and strip formfeeds */
               MapCRtoCRLF(pszBuffer);

               SendMessage(hWndEdit, WM_SETTEXT, 0, (LPARAM)pszBuffer);
               SetWindowText(hWndStatic, szFilename);
               UpdateWindow(hWndEdit);
               }
            }
            break;

         case IDM_MAX_STATUS:
            {
            SendMessage(hStatusButton, WM_LBUTTONDOWN,
                  MK_LBUTTON, MAKELPARAM(5,5) );
            break;
            }

         case IDM_SETFOCUS_ON_STATUS: /* posted from Action() following extract-to-Status */
            SetFocus(hWndEdit);   /* set focus on Status so user can scroll */
            break;

         case IDM_ZIP_STATS:
            {
            char szCompFactor[10];
            char sgn;
            char CompFactorStr[] = "%c%d%%";
            char CompFactor100[] = "100%%";

            if (lpumb->szFileName[0])   /* if file selected */
               {
//               UpdateListBox();
               if (lpUserFunctions->TotalSizeComp > lpUserFunctions->TotalSize)
                  sgn = '-';
               else
                  sgn = ' ';

               if (lpUserFunctions->CompFactor == 100)
                   sprintf(szCompFactor, CompFactor100);
               else
                   sprintf(szCompFactor, CompFactorStr, sgn,
                      lpUserFunctions->CompFactor);
               wsprintf(szTotalsLine,
               "Total Size\t\t%7lu\nCompressed Size\t%7lu\nRatio\t\t%6s\nTotal Files\t%7u",
                      lpUserFunctions->TotalSize,
                      lpUserFunctions->TotalSizeComp,
                      szCompFactor,
                      lpUserFunctions->NumMembers);
               MessageBox(hWndMain, szTotalsLine,
                  lpumb->szFileName, MB_ICONINFORMATION | MB_OK);
               }
            }
            break;
         default:
            return DefWindowProc(hWnd, wMessage, wParam, lParam);
            }
        } /* bottom of not in help mode */
        break;

    case WM_SETCURSOR:
        /* In help mode it is necessary to reset the cursor in response */
        /* to every WM_SETCURSOR message.Otherwise, by default, Windows */
        /* will reset the cursor to that of the window class. */

        if (uf.fHelp)
        {
            SetCursor(hHelpCursor);
            break;
        }
        return DefWindowProc(hWnd, wMessage, wParam, lParam);


    case WM_INITMENU:
        if (uf.fHelp)
           {
           SetCursor(hHelpCursor);
           }
        return TRUE;

    case WM_ENTERIDLE:
        if ((LOWORD(wParam) == MSGF_MENU) && (GetKeyState(VK_F1) & 0x8000))
           {
           uf.fHelp = TRUE;
           PostMessage(hWnd, WM_KEYDOWN, VK_RETURN, 0L);
           }
        break;

    case WM_CLOSE:
        DestroyWindow(hWnd);
        break;

    case WM_DESTROY:
        if ( uf.fCanDragDrop )
            DragAcceptFiles( hWnd, FALSE );
        DeleteObject(hBrush);
        WinHelp(hWnd, szHelpFileName, HELP_QUIT, 0L);
        PostQuitMessage(0);
        break;

    case WM_DROPFILES:
        {
        WORD    cFiles;

        /* Get the number of files that have been dropped */
        cFiles = (WORD)DragQueryFile( (HDROP)wParam, (UINT)-1, lpumb->szBuffer, (UINT)256);

        /* Only handle one dropped file until MDI-ness happens */
        if (cFiles == 1)
           {
           RECT    rClient;

           DragQueryFile( (HDROP)wParam, 0, lpumb->szFileName, PATH_MAX);
           GetArchiveDir(lpumb->szDirName); /* get archive dir name */
           if (uf.fUnzipToZipDir || /* unzipping to same directory as archive */
               szUnzipToDirName[0] == '\0') /* or no default */
              {
              /* strip off filename to make directory name    */
              lstrcpy(szUnzipToDirName, lpumb->szDirName);
              }
           lstrcpy(lpumb->szBuffer, lpumb->szDirName); /* get scratch copy */
           DlgDirList (hWnd, lpumb->szBuffer, 0, 0, 0); /* change dir */
           UpdateListBox(); /* fill in list box */
#ifndef WIN32
           SendMessage(hWndList, LB_SETSEL, 1, 0L);
#else
           ListViewSetSel(0, TRUE);
#endif           
           UpdateButtons(); /* update state of buttons */

           WinAssert(hWndList);
           GetClientRect( hWndList, &rClient );
           OffsetRect( &rClient, 0, dyChar );
           rClient.top = rClient.bottom;
           rClient.bottom = rClient.top + (2*dyChar);
           InvalidateRect( hWnd, &rClient, TRUE);
           SetCaption(hWnd);
           }
        DragFinish( (HDROP)wParam );
        }
        break;

#ifndef WIN32
    case WM_PAINT:
           {
           PAINTSTRUCT ps;
           RECT    rClient;
           DWORD   dwBackColor;
           char szCompFactor[10];
           char sgn;
           char CompFactorStr[] = "%c%d%%";
           char CompFactor100[] = "100%%";

           hDC = BeginPaint( hWnd, &ps );
           if ( hDC )
              {
              WinAssert(hWndList);
              UpdateWindow( hWndList );
              hOldFont = SelectObject ( hDC, hFixedFont);

              WinAssert(hWnd);
              GetClientRect( hWnd, &rClient );
              dwBackColor = SetBkColor(hDC,GetSysColor(COLOR_SCROLLBAR));

              /* Move "header" down two lines for button room at top */
              rClient.top = 2 * dyChar;
              rClient.left += dxChar/2;
              /* "Draw the header */
              DrawText( hDC, (LPSTR)Headers[uf.fFormatLong], -1,
                  &rClient, DT_NOPREFIX | DT_TOP);

              if (lpumb->szFileName[0])   /* if file selected */
                 {
                 WinAssert(hWndList);
                 GetClientRect( hWndList, &rClient );
                 /* Drop rectangle down 1 vertical char + 2 */
                 OffsetRect( &rClient, 0, dyChar+2);
                 rClient.left += dxChar/2;

                 /* Move totals "trailer" down two lines for button room */
                 rClient.top = rClient.bottom + (2 * dyChar) +
                  (2 * GetSystemMetrics(SM_CYDLGFRAME));
                 rClient.bottom = rClient.top + dyChar;
                 DrawText( hDC, (LPSTR)szTrailers[uf.fFormatLong], -1,
                   &rClient, DT_NOPREFIX | DT_TOP);

                 /* Display totals line at bottom of listbox */
                 rClient.top += dyChar;
                 rClient.bottom += dyChar;

                 if (lpUserFunctions->TotalSizeComp > lpUserFunctions->TotalSize)
                    sgn = '-';
                 else
                    sgn = ' ';

                 if (lpUserFunctions->CompFactor == 100)
                     sprintf(szCompFactor, CompFactor100);
                 else
                     sprintf(szCompFactor, CompFactorStr, sgn,
                        lpUserFunctions->CompFactor);
                 if (uf.fFormatLong)
                     wsprintf(szTotalsLine, LongFileTrailer,
                        lpUserFunctions->TotalSize,
                        lpUserFunctions->TotalSizeComp,
                        szCompFactor,
                        lpUserFunctions->NumMembers,
                        lpUserFunctions->NumMembers == 1 ? "":"s");
                 else
                     wsprintf(szTotalsLine, ShortFileTrailer,
                        lpUserFunctions->TotalSize,
                        lpUserFunctions->NumMembers,
                        lpUserFunctions->NumMembers == 1 ? "" : "s");

                 DrawText( hDC, szTotalsLine, -1,
                    &rClient, DT_NOPREFIX | DT_TOP);
                 }
              SetBkColor(hDC, dwBackColor);
              (void)SelectObject ( hDC, hOldFont);
            }
           EndPaint(hWnd, &ps);
           break;
           }
#endif
   default:
      if (wMessage == uCommDlgHelpMsg)   /* common dialog help message ID */
         {
         WinHelp(hWnd, szHelpFileName, HELP_CONTEXT, dwCommDlgHelpId );
         return 0;
         }
      return DefWindowProc(hWnd, wMessage, wParam, lParam);
    }
    return 0;
}

void GetHelpContext(WPARAM wParam)
{
switch (LOWORD(wParam))
   {
   case IDM_ESCAPE:
      if (uf.fHelp)
         {
         uf.fHelp = FALSE;
#ifndef WIN32
         SetCursor((HCURSOR)GetClassWord(hWndMain,GCW_HCURSOR));
#else
         SetCursor((HCURSOR)GetClassLong(hWndMain,GCL_HCURSOR));
#endif
         dwHelpContextId = (DWORD) 0L;
         }
      break;
   case IDM_OPEN:
      dwHelpContextId = (DWORD) HELPID_OPEN;
      break;
   case IDM_EXIT:
      dwHelpContextId = (DWORD) HELPID_EXIT_CMD;
      break;
   case IDM_HELP:
      dwHelpContextId = (DWORD) HELPID_HELP;
      break;
   case IDM_HELP_HELP:
      dwHelpContextId = (DWORD) HELPID_HELP_HELP;
      break;
   case IDM_ABOUT:
      dwHelpContextId = (DWORD) HELPID_ABOUT;
      break;
   case IDM_RECR_DIR_STRUCT:
      dwHelpContextId = (DWORD) HELPID_RECR_DIR_STRUCT;
      break;
   case IDM_SHOW_BUBBLE_HELP:
      dwHelpContextId = (DWORD) HELPID_SHOW_BUBBLE_HELP;
      break;
   case IDM_UNZIP_TO_ZIP_DIR:
      dwHelpContextId = (DWORD) HELPID_UNZIP_TO_ZIP_DIR;
      break;
   case IDM_LISTBOX:
      dwHelpContextId = (DWORD) HELPID_LISTBOX;
      break;
   case IDM_EXTRACT:
      dwHelpContextId = (DWORD) HELPID_EXTRACT;
      break;
   case IDM_DISPLAY:
      dwHelpContextId = (DWORD) HELPID_DISPLAY;
      break;
   case IDM_TEST:
      dwHelpContextId = (DWORD) HELPID_TEST;
      break;
   case IDM_DESELECT_ALL:
      dwHelpContextId = (DWORD) HELPID_DESELECT_ALL;
      break;
   case IDM_SELECT_ALL:
      dwHelpContextId = (DWORD) HELPID_SELECT_ALL;
      break;
   case IDM_SELECT_BY_PATTERN:
      dwHelpContextId = (DWORD) HELPID_SELECT_BY_PATTERN;
      break;
   case IDM_CLEAR_STATUS:
      dwHelpContextId = (DWORD) HELPID_CLEAR_STATUS;
      break;
   case IDM_SOUND_OPTIONS:
      dwHelpContextId = (DWORD) HELPID_SOUND_OPTIONS;
      break;
   case IDM_MAX_STATUS:
      dwHelpContextId = (DWORD) HELPID_MAX_STATUS;
      break;
   case IDM_SAVE_UNZIP_FROM_DIR:
      dwHelpContextId = (DWORD) HELPID_SAVE_UNZIP_FROM_DIR;
      break;
   case IDM_SAVE_UNZIP_TO_DIR:
      dwHelpContextId = (DWORD) HELPID_SAVE_UNZIP_TO_DIR;
      break;
   case IDM_CHDIR:
      dwHelpContextId = (DWORD) HELPID_CHDIR;
      break;
   case IDM_COPY_ARCHIVE:
      dwHelpContextId = (DWORD) HELPID_COPY_ARCHIVE;
      break;
   case IDM_MOVE_ARCHIVE:
      dwHelpContextId = (DWORD) HELPID_MOVE_ARCHIVE;
      break;
   case IDM_DELETE_ARCHIVE:
      dwHelpContextId = (DWORD) HELPID_DELETE_ARCHIVE;
      break;
   case IDM_RENAME_ARCHIVE:
      dwHelpContextId = (DWORD) HELPID_RENAME_ARCHIVE;
      break;
   case IDM_MAKE_DIR:
      dwHelpContextId = (DWORD) HELPID_MAKEDIR_HELP;
      break;
   case IDM_MAKEDIR_HELP:
      dwHelpContextId = (DWORD) HELPID_MAKEDIR_HELP;
      break;
   case IDM_EDIT_OPEN_FILE:
      dwHelpContextId = (DWORD) HELPID_EDIT_OPEN_FILE;
      break;
   case IDM_EDIT_SAVE_AS:
      dwHelpContextId = (DWORD) HELPID_EDIT_SAVE_AS;
      break;
   default:
      dwHelpContextId = (DWORD) HELPID_BUTTONS;
   }
}

