/*
 WiZ 4.0 header file
*/
#ifndef _WIZ_H
#define _WIZ_H

#include <windows.h>
#include <assert.h>    /* required for all Windows applications */
#include <stdlib.h>
#include <stdio.h>
#include <commdlg.h>
#include <dlgs.h>
#include <ctype.h>

#ifdef WIN32
#include <windowsx.h>

#define NOIMAGEAPIS
#define NOTREEVIEW

#include <commctrl.h>  /* for ListView controls */
#include <richedit.h>  /* for RichEdit controls */
#else
#include <mem.h>
#endif

#include "resource.h"
#include "unzip\windll\structs.h"

#include "zip\windll\structs.h"
#ifdef USE_UNZIP_LIB
#include "unzip\windll\decs.h"
#endif

#ifndef UzpMatch
#define UzpMatch match
#endif

/* Defines */
#ifndef MSWIN
#define MSWIN
#endif

/* Porting definitions between Win 3.1x and Win32 */
#ifdef WIN32
#  undef far
#  undef _far
#  undef __far
#  undef near
#  undef _near
#  undef __near
#  undef FAR
#  define far
#  define _far
#  define __far
#  define near
#  define _near
#  define __near
#  define FAR
#  ifndef Far
#     define Far far
#  endif
#endif

/* Allow compilation under Borland C++ also */
#ifndef __based
#define __based(A)
#endif

/*
 * MW:
 * The following is to take care of some of the porting problems between
 * Win 3.1 and Win32 for WM_COMMAND notifications.
*/
#ifdef WIN32
#define GET_WM_COMMAND_CMD(wp, lp) HIWORD(wp)
#else
#define GET_WM_COMMAND_CMD(wp, lp) HIWORD(lp)
#endif

#ifdef WIN32
#define EDIT_BUF_SIZE     0x10001L
#else
#define EDIT_BUF_SIZE     0x7001
#endif
#define FILENAME_BUF_SIZE 0x10000L

/* These two are dependent on zip directory listing format string.
 * They help find the filename in the listbox entry.
 */
#define SHORT_FORM_FNAME_INX     26
#define LONG_FORM_FNAME_INX      40

#define MIN_SHORT_FORMAT_CHARS (SHORT_FORM_FNAME_INX+12)
#define MIN_LONG_FORMAT_CHARS (LONG_FORM_FNAME_INX+12)

/* Arbitrary Constants
 */
#define BG_SYS_COLOR COLOR_GRAYTEXT /* background color is a system color */

/* Main window menu item positions
 */
#define EDIT_MENUITEM_POS         1   /* edit menu position in main menu */
#define HELP_MENUITEM_POS         5   /* the Help menu                */

#define TABSTOP_ID_BASE IDM_LISTBOX

/* Help Window Menu and Message ID's
 */
#define INDEX_MENU_ITEM_POS       0

#define IDM_FORWARD             100
#define IDM_BACKWARD            101

#define BTNWIDTH        3.0
#define MIN_BTN_WIDTH   1.5
#ifdef MAX_BUTTONS
#define NUMOFBUTTONS 23
#else
#define NUMOFBUTTONS 15
#endif
#ifndef NDEBUG
#  define WinAssert(exp) \
        {\
        if (!(exp))\
            {\
            char szBuffer[40];\
            sprintf(szBuffer, "File %s, Line %d",\
                    __FILE__, __LINE__) ;\
            if (IDABORT == MessageBox((HWND)NULL, szBuffer,\
                "Assertion Error",\
                MB_ABORTRETRYIGNORE|MB_ICONSTOP))\
                    FatalExit(-1);\
            }\
        }

#else
#  define WinAssert(exp)
#endif

#define cchFilesMax 4096

/* Zip Flags */
extern BOOL fSaveZipToDir;
extern BOOL fSaveUnZipFromDir;
extern BOOL fMakeDosSFX;

/* Toolbar button structure */
typedef struct BUTTON_STRUCT
{
int    idBtn;
LPCSTR ButtonHelp;
LPCSTR hBMP;
HWND   hWndBtn;
} BUTTON, *LPBUTTON;

/* Unzip Miscellaneous Buffers */
typedef struct
{
char szFileName[PATH_MAX]; /* fully-qualified archive file name in OEM char set */
char szZipFileName[PATH_MAX]; /* fully-qualified archive file name in OEM char set */
char szDirName[PATH_MAX];  /* directory of archive file in ANSI char set */
char szUnzipToDirNameTmp[PATH_MAX]; /* temp extraction ("unzip to") directory name in ANSI */
char szUnzipFromDirName[PATH_MAX];  /* extraction ("unzip from") directory name in ANSI */
char szBuffer[PATH_MAX];  /* option strings from .INI, & gen'l scratch buf */
char szSoundName[PATH_MAX];/* wave file name or sound from WIZ.INI [sounds] in ANSI */
char szPassword[81];
LPSTR lpPasswordStr;
OPENFILENAME ofn;
OPENFILENAME wofn;                  /* wave open file name struct */
MSG msg;
OFSTRUCT of;                        /* archive open file struct */
OFSTRUCT wof;                       /* wave open file struct   */
} UMB, __far *LPUMB;

/* Unzip Flags */
typedef struct
{
BOOL fRecreateDirs;
BOOL fShowBubbleHelp;
BOOL fTranslate;
BOOL fSaveUnZipToDir;
BOOL fSaveUnZipFromDir;
BOOL fFormatLong;
BOOL fUnzipToZipDir;
BOOL fBeepOnFinish;
BOOL fDoAll;
BOOL fIconSwitched;
BOOL fHelp;
BOOL fCanDragDrop;
BOOL fTrailingSlash;
BOOL fPromptToOverwrite;
} UF, *PUF;

#ifndef USE_UNZIP_LIB
typedef int (WINAPI * _DLL_UNZIP)(int, char **, int, char **, LPDCL, LPUSERFUNCTIONS);
typedef int (WINAPI * _USER_FUNCTIONS)(LPUSERFUNCTIONS);
typedef BOOL (WINAPI * _DLL_UNZVAL)(char *, int);
#endif

#ifndef USE_ZIP_LIB
typedef int (WINAPI * _ZIP_USER_FUNCTIONS)(LPZIPUSERFUNCTIONS);
typedef int (WINAPI * _DLL_ZIP)(ZCL);
typedef BOOL (WINAPI * ZIPSETOPTIONS)(ZPOPT);
typedef ZPOPT (WINAPI * ZIPGETOPTIONS)(void);
#endif

/* Global variables */

extern LPUSERFUNCTIONS lpUserFunctions;
extern LPZIPUSERFUNCTIONS lpZipUserFunctions;
extern RECT MainRc;  /* Used only to remember window position/size */

extern LPUMB lpumb;
extern LPDCL lpDCL;
extern ZPOPT ZpOpt;
extern int argc;
extern char **argv;

extern DWORD dwEditBufSize;
extern ZCL ZpZCL;
extern BOOL fMakeSFX;
extern HINSTANCE hUnzipDll;
extern HINSTANCE hZipDll;

extern HWND hGetFilesDlg;
extern char szFilesToAdd[];
extern char rgszFiles[cchFilesMax];

extern HANDLE hInst;
extern HWND hWndMain;
extern HANDLE hEditor;
extern LPSTR pszBuffer;

extern int Width, Height;
extern int BtnSeparator;
extern float BtnMult;

/* Miscellaneous Buffers */
#ifndef WIN32
extern short dxChar, dyChar;    /* size of char in SYSTEM font in pixels    */
#else
extern long dxChar, dyChar;    /* size of char in SYSTEM font in pixels    */
#endif

extern HANDLE hFixedFont;

extern HWND hWndComment;        /* comment window */
extern HWND hWndList;       /* listbox handle */
extern HWND hWndButtonBar; /* Button bar handle */

extern HWND hWndMain;        /* the main window handle. */

extern HWND hExtract;           /* extract button  */
extern HWND hDisplay;           /*display button   */
extern HWND hTest;              /* test button     */
extern HWND hZipInfo;           /* Zip Info button */
extern HWND hShowComment;       /* show comment button */

extern HWND hExit;
extern HWND hMakeDir;
extern HWND hSelectAll;
extern HWND hDeselectAll;
extern HWND hSelectPattern;
extern HWND hClearStatus;
extern HWND hUnzipToDir;

extern HWND hHelp;
extern HWND hOpen;
extern HWND hArchive;
extern HWND hCopyArchive;
extern HWND hMoveArchive;
extern HWND hRenameArchive;
extern HWND hDeleteArchive;
extern HWND hStatusButton;

extern HWND hPatternSelectDlg; /* pattern select modeless dialog   */
extern HANDLE hInst;                       /* current instance */
extern HMENU  hMenu;                /* main menu handle         */
extern HANDLE hAccTable;

extern HANDLE hHourGlass;             /* handle to hourglass cursor      */
extern HANDLE hSaveCursor;            /* current cursor handle       */
extern HANDLE hHelpCursor;          /* help cursor              */
extern HANDLE hFixedFont;           /* handle to fixed font             */
extern HANDLE hOldFont;         /* handle to old font               */

extern int hFile;                 /* file handle             */
extern HWND hWndList;             /* list box handle        */
extern HWND hWndEdit;     /* status   */
extern HWND hWndStatic;
extern BOOL bRealTimeMsgUpdate; /* update messages window in real-time */
extern BOOL gfCancelDisplay;   /* cancel ongoing display operation */
extern UF uf;
extern int fLB_Selection;

extern char szTargetDirName[];
extern LPSTR lpchLast;

extern WPARAM wLBSelection;   /* default listbox selection action */
extern WPARAM wWindowSelection; /* window selection: listbox, status, both   */

extern HBRUSH hBrush ;          /* brush for  standard window backgrounds  */

extern char __based(__segname("STRINGS_TEXT")) szCantChDir[];
extern char __based(__segname("STRINGS_TEXT")) szCantCopyFile[];
extern char __based(__segname("STRINGS_TEXT")) szAppName[];     /* application name             */
extern char __based(__segname("STRINGS_TEXT")) szDefaultUnzipToDir[]; /* default Unz_SingleEntryPoint to dir */
extern char __based(__segname("STRINGS_TEXT")) szDefaultUnzipFromDir[]; /* default Unz_SingleEntryPoint from dir */
extern char __based(__segname("STRINGS_TEXT")) szLBSelectionKey[];  /* LBSelection keyword in .INI */
extern char __based(__segname("STRINGS_TEXT")) szNoMemory[] ;       /* error message            */
extern char __based(__segname("STRINGS_TEXT")) szHelpFileName[];        /* help file name                       */
extern char __based(__segname("STRINGS_TEXT")) szWiZIniFile[];   /* WiZ Private .INI file */

extern char __based(__segname("STRINGS_TEXT")) szZipOptionKey[];
extern char __based(__segname("STRINGS_TEXT")) szZipToDirKey[];
extern char __based(__segname("STRINGS_TEXT")) szTargetZipDir[];
extern char __based(__segname("STRINGS_TEXT")) szUnzipToDirName[PATH_MAX];    /* extraction ("Unz_SingleEntryPoint to") directory name in ANSI */

extern char * Headers[];        /* headers to display */
extern DWORD dwCommDlgHelpId;   /* what to pass to WinHelp() */
#ifdef WIN32
extern DWORD dwPlatformId;      /* True if running on NT */
#endif
/* List box stuff
 */
extern WORD cZippedFiles;       /* total personal records in file   */
extern WORD cListBoxLines; /* max list box lines showing on screen */
extern WORD cLinesMessageWin; /* max visible lines on message window  */


/* Global functions */
#ifndef USE_UNZIP_LIB
extern _DLL_UNZIP Unz_SingleEntryPoint;
extern _DLL_UNZIP windll_unzip;
extern _USER_FUNCTIONS UzInit;
extern _DLL_UNZVAL Unz_Validate;
#else
#define Unz_SingleEntryPoint windll_unzip
#define UzInit Unz_Init
#define Unz_Validate UzpValidate
#endif
#ifndef USE_ZIP_LIB
extern _DLL_ZIP ZipArchive;
extern _ZIP_USER_FUNCTIONS ZipInit;
extern ZIPSETOPTIONS ZipSetOptions;
extern ZIPGETOPTIONS ZipGetOptions;
#else
#define ZipArchive ZpArchive
#define ZipInit ZpInit
#define ZipSetOptions ZpSetOptions
#define ZipGetOptions ZpGetOptions
#endif
int match (char *, char *, int);          /* in match.c */
int __far __cdecl BufferOut(const char *format, ...);
void SetCaption(HWND);
void Action(HWND, WPARAM);
void CenterDialog(HWND, HWND);
void CopyStatusToClipboard(HWND);
void DisplayComment(HWND);
int CLBItemsGet(HWND, int __far * __far *, HANDLE *);
void ReselectLB(HWND, int, int __far *);
void InitSoundOptions(void); /* initialize sound options (sound.c)   */
void MigrateSoundOptions(void); /* translate beep into new option (sound.c) */
void SizeWindow(void);
void SoundAfter(void);
void WINAPI SoundDuring(void);
void UpdateButtons(void);
void UpdateListBox(void);
void UpdateMsgWndPos(void);
BOOL WiZInit(HANDLE);
void WriteBufferToMsgWin(LPSTR, int, BOOL);
void WriteStringToMsgWin(PSTR, BOOL);
int WINAPI DisplayBuf(char far *, unsigned long int);
void CopyArchive(HWND, BOOL, BOOL);
void GetDirectory(LPSTR);
BOOL MakeDirectory(char *, BOOL);
LPSTR lstrrchr(LPSTR lpszSrc, char chFind);
void MoveButtons(void);
void CreateButtonBar(HWND);
void FindFile(char *, char *, HWND);
void DoADir(char *, char *, char *, HWND, char);
BOOL FnMatch(char *, char *);
int WINAPI GetReplaceDlgRetVal(char *);
void WriteZipOptionsProfile(void);
void GetWizOptions(void);
void StripDirectory(LPSTR lpDir);
void MakeArchive(HWND hWnd);
int WINAPI password(LPSTR, int, LPCSTR, LPCSTR);
LPSTR WINAPI comment(LPSTR);
BOOL IsValidArchive(LPSTR);

/* Procedure Calls */
BOOL WINAPI AboutProc(HWND, WORD, WPARAM, LPARAM);
BOOL WINAPI SelectDirProc(HWND, WORD, WPARAM, LPARAM);
BOOL WINAPI CopyFileProc(HWND, WORD, WPARAM, LPARAM);
BOOL WINAPI PatternSelectProc(HWND, WORD, WPARAM, LPARAM);
BOOL WINAPI ReplaceProc(HWND, WORD, WPARAM, LPARAM);
BOOL WINAPI SoundProc(HWND, WORD, WPARAM, LPARAM);
BOOL WINAPI RenameProc (HWND, WORD, WPARAM, LPARAM);
BOOL WINAPI MakeDirProc(HWND, WORD, WPARAM, LPARAM);
LONG WINAPI ButtonBarWndProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK CommentBoxProc(HWND, WORD, WPARAM, LPARAM);
void ZipWndProc(HWND, WORD, WPARAM, LPARAM);
BOOL WINAPI GetFilesProc(HWND, WORD, WPARAM, LPARAM);
BOOL WINAPI GetDirProc(HWND, WORD, WPARAM, LPARAM);
BOOL WINAPI GetDateProc(HWND, WORD, WPARAM, LPARAM);
DWORD WINAPI UnZipPreferencesProc(HWND, WORD, WPARAM, LPARAM);
DWORD WINAPI ZipPreferencesProc(HWND, UINT, WPARAM, LPARAM);
void WINAPI ReceiveDllMessage(unsigned long,unsigned long,
   ush, ush, ush, ush, ush, ush, char, char *, char *, unsigned long, char);
BOOL WINAPI GrepArchiveProc(HWND, WORD, WPARAM, LPARAM);
void SearchArchive(LPSTR);
void GetArchiveDir(LPSTR lpszDestDir);
#ifdef WIN32
void ListViewSetSel(int, BOOL);  /* Only used for ListView control */
void ListViewSortOnColumns(int); /* Only used for ListView sorting */
#endif
#endif /* _WIZ_H */

