/* updatelb.c module of WizUnzip.
 * Author: Robert A. Heath
 * I, Robert Heath, place this source code module in the public domain.
 *
 * Modifications: 1995, 1996, 1997 Mike White.
 *  - Modified for WiZ
 */
#include <stdio.h>
#include <windows.h>
#include <string.h>
#include "wiz.h"

#ifdef WIN32
int iColumn = 0; /* Set externally to indicate which column is being sorted on
                    Should always be reset to zero after doing a sort!!!
                  */
BOOL bSorting = FALSE;
#endif

/* Update Buttons is called when an event possibly modifies the
 * number of selected items in the listbox.
 * The function reads the number of selected items.
 * A non-zero value enables relevant buttons and menu items.
 * A zero value disables them.
 */
void UpdateButtons(void)
{
int mf;
static BOOL fButtonState = FALSE;

if (lpumb->szFileName[0] &&
#ifndef WIN32
   SendMessage(hWndList, LB_GETSELCOUNT, 0, 0L)) /* anything selected ? */
#else
   ListView_GetSelectedCount(hWndList))
#endif
   {
   fButtonState = TRUE;
   }
else
   {
   fButtonState = FALSE;
   }
WinAssert(hExtract);
EnableWindow(hExtract, fButtonState);
#ifdef MAX_BUTTONS
WinAssert(hDisplay);
EnableWindow(hDisplay, fButtonState);
WinAssert(hTest);
EnableWindow(hTest, fButtonState);
WinAssert(hZipInfo);
EnableWindow(hZipInfo, fButtonState);
WinAssert(hShowComment);
EnableWindow(hShowComment, (BOOL)(fButtonState && lpUserFunctions->cchComment ? TRUE : FALSE));
WinAssert(hCopyArchive);
EnableWindow(hCopyArchive, fButtonState);
WinAssert(hMoveArchive);
EnableWindow(hMoveArchive, fButtonState);
WinAssert(hRenameArchive);
EnableWindow(hRenameArchive, fButtonState);
#endif
WinAssert(hDeleteArchive);
EnableWindow(hDeleteArchive, fButtonState);

EnableMenuItem(hMenu, IDM_GET_ZIPINFO, (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
EnableMenuItem(hMenu, IDM_EXTRACT, (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
EnableMenuItem(hMenu, IDM_DISPLAY, (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
EnableMenuItem(hMenu, IDM_TEST, (fButtonState ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
EnableMenuItem(hMenu, IDM_SHOW_COMMENT,
   (BOOL)(fButtonState && lpUserFunctions->cchComment ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);

if (lpumb->szFileName[0] != '\0')
   mf = MF_ENABLED|MF_BYCOMMAND;
else
   mf = MF_DISABLED | MF_GRAYED | MF_BYCOMMAND;
EnableMenuItem(hMenu, IDM_COPY_ARCHIVE,       mf);
EnableMenuItem(hMenu, IDM_MOVE_ARCHIVE,       mf);
EnableMenuItem(hMenu, IDM_DELETE_ARCHIVE,     mf);
EnableMenuItem(hMenu, IDM_RENAME_ARCHIVE,     mf);
EnableMenuItem(hMenu, IDM_UPDATE_ZIP,         mf);
EnableMenuItem(hMenu, IDM_ZIP_DELETE_ENTRIES, mf);
EnableMenuItem(hMenu, IDM_ZIP_STATS,          mf);
}

/* UpdateListBox fills in the listbox (or ListView), and sorts it
 * depending on what the column number is.
 *
 * Note that iColumn determines the data the sort is done on.
 */
void UpdateListBox(void)
{
#ifndef WIN32
SendMessage(hWndList, LB_RESETCONTENT, 0, 0L);
#else
char szTemp[14], szTemp1[14], *ptr;
int i, j;
SYSTEMTIME sysTime;
ListView_DeleteAllItems(hWndList);
#endif
UpdateWindow( hWndList );
cZippedFiles = 0;

if (lpumb->szFileName[0])       /* file selected? */
   {
        /* if so -- stuff list box              */
   SendMessage(hWndList, WM_SETREDRAW, FALSE, 0L);
   /* Call here when a file has been initially selected */

   lpDCL->ncflag = 0;
   lpDCL->ntflag = 0;
   lpDCL->nvflag = (int)(!uf.fFormatLong ? 1 : 2);
   lpDCL->nUflag = 1;
   lpDCL->nzflag = 0;
   lpDCL->ndflag = 0;
   lpDCL->noflag = 0;
   lpDCL->naflag = 0;
   argc   = 0;
   lpDCL->lpszZipFN = lpumb->szFileName;
   argv = NULL;
   lpDCL->lpszExtractDir = NULL;
   Unz_SingleEntryPoint(argc, argv, 0, NULL, lpDCL, lpUserFunctions);
   SendMessage(hWndList, WM_SETREDRAW, TRUE, 0L);
   InvalidateRect(hWndList, NULL, TRUE);   /* force redraw */
#ifndef WIN32
   cZippedFiles = (WORD)SendMessage(hWndList, LB_GETCOUNT, 0, 0L);
#else
   cZippedFiles = (WORD)ListView_GetItemCount(hWndList);
#endif
   WinAssert((int)cZippedFiles != LB_ERR);
   if (cZippedFiles)   /* if anything went into listbox set to top */
#ifndef WIN32
      SendMessage(hWndList, LB_SETTOPINDEX, 0, 0L);
#else
      ListView_EnsureVisible(hWndList, 0, FALSE);
if (!bSorting)
   {
   j = ListView_GetItemCount(hWndList);
   for (i = 0; i < j; i++)
       {
       ListView_GetItemText(hWndList, i, 4, szTemp, PATH_MAX);
       ptr = &szTemp[8];
       sysTime.wDay = (WORD)strtol(ptr, NULL, 10);
       szTemp[7] = '\0';
       ptr = &szTemp[5];
       sysTime.wMonth = (WORD)strtol(ptr, NULL, 10);
       szTemp[4] = '\0';
       ptr = &szTemp[0];
       sysTime.wYear = (WORD)strtol(ptr, NULL, 10);
       sysTime.wDayOfWeek = (WORD) 1;
       GetDateFormat(LOCALE_USER_DEFAULT,
                     DATE_SHORTDATE,
                     &sysTime,
                     NULL,
                     szTemp,
                     (int) 13);
       wsprintf(szTemp1, "%8s", szTemp);
       ListView_SetItemText(hWndList, i, 4, szTemp1);
       }
   }
#endif
   }
}
#ifndef WIN32
#ifdef __BORLANDC__
#pragma argsused
#endif
void WINAPI ReceiveDllMessage(unsigned long ucsize,unsigned long csiz,
   ush cfactor, ush mo, ush dy, ush yr, ush hh, ush mm,
   char c, char *filename, char *methbuf, unsigned long crc, char fCrypt)
{
char psLBEntry[PATH_MAX];
char LongHdrStats[] =
     "%7lu  %7lu %4s  %02u-%02u-%02u  %02u:%02u %c%s";
char ShortHdrStats[] = "%7lu  %02u-%02u-%02u  %02u:%02u %c%s";
char CompFactorStr[] = "%c%d%%";
char CompFactor100[] = "100%%";
char szCompFactor[10];
char sgn;
char szPicture[24];
extern BOOL fScanning;
extern char SearchPattern[PATH_MAX];

if (fScanning)
   {
#ifndef __BORLANDC__
   _strlwr(SearchPattern); /* convert filename to lower case */
#else
   strlwr(SearchPattern); /* convert filename to lower case */
#endif
   /* Use UnZip's match() function                  */
   if (UzpMatch(filename, SearchPattern, TRUE))
      BufferOut("Found match: %s\n", filename);
   return;
   }

if (csiz > ucsize)
   sgn = '-';
else
   sgn = ' ';
if (cfactor == 100)
   lstrcpy(szCompFactor, CompFactor100);
else
   sprintf(szCompFactor, CompFactorStr, sgn, cfactor);
GetProfileString("Intl",
                 "sShortDate",
                 "MM/dd/yy",
                 szPicture,
                 24);
switch (toupper(szPicture[0]))
       {
       case 'D':
              if (uf.fFormatLong)
                 wsprintf(psLBEntry, LongHdrStats,
                          ucsize,
                          csiz,
                          szCompFactor,
                          dy, mo, yr,
                          hh, mm,
                          c,
                          filename);
              else
                 wsprintf(psLBEntry, ShortHdrStats,
                          ucsize,
                          dy, mo, yr,
                          hh, mm,
                          c,
                          filename);
              break;
       case 'M':
       default:
              if (uf.fFormatLong)
                 wsprintf(psLBEntry, LongHdrStats,
                          ucsize,
                          csiz,
                          szCompFactor,
                          mo, dy, yr,
                          hh, mm,
                          c,
                          filename);
              else
                 wsprintf(psLBEntry, ShortHdrStats,
                          ucsize,
                          mo, dy, yr,
                          hh, mm,
                          c,
                          filename);
              break;
       }

SendMessage(hWndList, LB_ADDSTRING, 0,(LPARAM)(LPSTR)psLBEntry);
}

#else /* ?WIN32 */

#ifdef __BORLANDC__
#pragma argsused
#endif
void WINAPI ReceiveDllMessage(unsigned long ucsize,unsigned long csiz,
   ush cfactor, ush mo, ush dy, ush yr, ush hh, ush mm,
   char c, char *filename, char *methbuf, unsigned long crc, char fCrypt)
{
LV_ITEM lvi;
char Length[9];
char Size[9];
char Ratio[5];
char Date[14];
char Time[6];
char Name[PATH_MAX];
char CompFactorStr[] = "%c%d%%";
char CompFactor100[] = "100%%";
char szCompFactor[10];
char sgn, szTemp[14];
SYSTEMTIME sysTime;
extern BOOL fScanning;
extern char SearchPattern[PATH_MAX];

if (fScanning)
   {
#ifndef __BORLANDC__
   _strlwr(SearchPattern); /* convert filename to lower case */
#else
   strlwr(SearchPattern); /* convert filename to lower case */
#endif
   /* Use UnZip's match() function                  */
   if (UzpMatch(filename, SearchPattern, TRUE))
      BufferOut("Found match: %s\n", filename);
   return;
   }

if (csiz > ucsize)
   sgn = '-';
else
   sgn = ' ';
if (cfactor == 100)
   lstrcpy(szCompFactor, CompFactor100);
else
   sprintf(szCompFactor, CompFactorStr, sgn, cfactor);

if (yr < 30)
   yr = (ush)(yr + (ush)2000);
else
   yr = (ush)(yr + (ush)1900);

sysTime.wYear      = (WORD) yr;
sysTime.wMonth     = (WORD) mo;
sysTime.wDay       = (WORD)dy;
sysTime.wDayOfWeek = (WORD) 1; // If this is incorrect, the
                               // call corrects this.

GetDateFormat(LOCALE_USER_DEFAULT,
              0,
              &sysTime,
              "yyyy MM dd",
              szTemp,
              (int) 13);
wsprintf(Date,"%s", szTemp);
wsprintf(Length, "%7lu", ucsize);
wsprintf(Size, "%7lu", csiz);
wsprintf(Ratio, "%4s", szCompFactor);
wsprintf(Time, "%02u:%02u", hh, mm);
wsprintf(Name, "%c%s", c, filename);

lvi.mask        = LVIF_TEXT;
lvi.state       = 0;
lvi.stateMask   = LVIS_STATEIMAGEMASK;

lvi.iItem       = 0;
lvi.iSubItem    = 0;
lvi.cchTextMax  = 9;
lvi.iImage      = 0;

switch (iColumn)
   {
   case 0:
      lvi.pszText = Name;                                          /* sub-item 0 */
      lvi.iItem = ListView_InsertItem(hWndList, &lvi);
      ListView_SetItemText(hWndList, lvi.iItem, 1, (LPSTR) Length);/* sub-item 1 */
      ListView_SetItemText(hWndList, lvi.iItem, 2, (LPSTR) Size);  /* sub-item 2 */
      ListView_SetItemText(hWndList, lvi.iItem, 3, (LPSTR) Ratio); /* sub-item 3 */
      ListView_SetItemText(hWndList, lvi.iItem, 4, (LPSTR) Date);  /* sub-item 4 */
      ListView_SetItemText(hWndList, lvi.iItem, 5, (LPSTR) Time);  /* sub-item 5 */
      break;
   case 1:
      lvi.pszText = Length;                                        /* sub-item 0 */
      lvi.iItem = ListView_InsertItem(hWndList, &lvi);
      ListView_SetItemText(hWndList, lvi.iItem, 1, (LPSTR) Name);/* sub-item 0 */
      ListView_SetItemText(hWndList, lvi.iItem, 2, (LPSTR) Size);  /* sub-item 2 */
      ListView_SetItemText(hWndList, lvi.iItem, 3, (LPSTR) Ratio); /* sub-item 3 */
      ListView_SetItemText(hWndList, lvi.iItem, 4, (LPSTR) Date);  /* sub-item 4 */
      ListView_SetItemText(hWndList, lvi.iItem, 5, (LPSTR) Time);  /* sub-item 5 */
      break;
   case 2:
      lvi.pszText = Size;                                          /* sub-item 0 */
      lvi.iItem = ListView_InsertItem(hWndList, &lvi);
      ListView_SetItemText(hWndList, lvi.iItem, 1, (LPSTR) Length);/* sub-item 1 */
      ListView_SetItemText(hWndList, lvi.iItem, 2, (LPSTR) Name);  /* sub-item 0 */
      ListView_SetItemText(hWndList, lvi.iItem, 3, (LPSTR) Ratio); /* sub-item 3 */
      ListView_SetItemText(hWndList, lvi.iItem, 4, (LPSTR) Date);  /* sub-item 4 */
      ListView_SetItemText(hWndList, lvi.iItem, 5, (LPSTR) Time);  /* sub-item 5 */
      break;
   case 3:
      lvi.pszText = Ratio;                                          /* sub-item 0 */
      lvi.iItem = ListView_InsertItem(hWndList, &lvi);
      ListView_SetItemText(hWndList, lvi.iItem, 1, (LPSTR) Length);/* sub-item 1 */
      ListView_SetItemText(hWndList, lvi.iItem, 2, (LPSTR) Size);  /* sub-item 2 */
      ListView_SetItemText(hWndList, lvi.iItem, 3, (LPSTR) Name);  /* sub-item 0 */
      ListView_SetItemText(hWndList, lvi.iItem, 4, (LPSTR) Date);  /* sub-item 4 */
      ListView_SetItemText(hWndList, lvi.iItem, 5, (LPSTR) Time);  /* sub-item 5 */
      break;
   case 4:
      lvi.pszText = Date;                                          /* sub-item 0 */
      lvi.iItem = ListView_InsertItem(hWndList, &lvi);
      ListView_SetItemText(hWndList, lvi.iItem, 1, (LPSTR) Length);/* sub-item 1 */
      ListView_SetItemText(hWndList, lvi.iItem, 2, (LPSTR) Size);  /* sub-item 2 */
      ListView_SetItemText(hWndList, lvi.iItem, 3, (LPSTR) Ratio); /* sub-item 3 */
      ListView_SetItemText(hWndList, lvi.iItem, 4, (LPSTR) Name);  /* sub-item 0 */
      ListView_SetItemText(hWndList, lvi.iItem, 5, (LPSTR) Time);  /* sub-item 5 */
      break;
   case 5:
      lvi.pszText = Time;                                          /* sub-item 0 */
      lvi.iItem = ListView_InsertItem(hWndList, &lvi);
      ListView_SetItemText(hWndList, lvi.iItem, 1, (LPSTR) Length);/* sub-item 1 */
      ListView_SetItemText(hWndList, lvi.iItem, 2, (LPSTR) Size);  /* sub-item 2 */
      ListView_SetItemText(hWndList, lvi.iItem, 3, (LPSTR) Ratio); /* sub-item 3 */
      ListView_SetItemText(hWndList, lvi.iItem, 4, (LPSTR) Date);  /* sub-item 4 */
      ListView_SetItemText(hWndList, lvi.iItem, 5, (LPSTR) Name);  /* sub-item 0 */
      break;
   }
}

/* All this does is force a selection of the item number passed in */
void ListViewSetSel(int item, BOOL b)
{
/* Sure is a pain to force a selection within a program */
LV_ITEM lvi;

lvi.mask      = LVIF_STATE;
lvi.stateMask = LVIS_SELECTED;
lvi.iItem     = item;
lvi.iSubItem  = 0;

ListView_GetItem(hWndList, &lvi);

if (b)
    lvi.state = LVIS_SELECTED;
else
    lvi.state = 0;

SendMessage(hWndList, LVM_SETITEMSTATE, (WPARAM)item,
         (LPARAM)&lvi);
}

void ListViewSortOnColumns(int iCol)
{
int i, j;
char *p;
SYSTEMTIME sysTime;
LPTSTR lpStr1, lpStr2;
HANDLE hMem1, hMem2;
iColumn = iCol;
UpdateListBox();

/* Restore the ListView to the appropriate columns */
hMem1 = GlobalAlloc( GPTR, (PATH_MAX * 2));
if (!hMem1)
   return;
hMem2 = GlobalAlloc( GPTR, (PATH_MAX * 2));
if (!hMem2)
   {
   GlobalFree(hMem1);
   return;
   }
lpStr1 = (LPSTR)GlobalLock(hMem1);
if (!lpStr1)
   {
   GlobalFree(hMem1);
   GlobalFree(hMem2);
   return;
   }
lpStr2 = (LPSTR)GlobalLock(hMem2);
if (!lpStr2)
   {
   GlobalUnlock(lpStr1);
   GlobalFree(hMem1);
   GlobalFree(hMem2);
   return;
   }
hSaveCursor = SetCursor(hHourGlass);
ShowCursor(TRUE);

bSorting = TRUE;

/* Restore the ListView to the appropriate columns */

SendMessage(hWndList, WM_SETREDRAW, FALSE, 0L);

UpdateListBox();

j = ListView_GetItemCount(hWndList);
for (i = 0; i < j; i++)
    {
    switch (iColumn)
       {
       case 1: /* Swap subitem 0 and 1 */
          ListView_GetItemText(hWndList, i, 0, lpStr1, PATH_MAX);
          ListView_GetItemText(hWndList, i, 1, lpStr2, PATH_MAX);
          ListView_SetItemText(hWndList, i, 0, lpStr2);
          ListView_SetItemText(hWndList, i, 1, lpStr1);
          break;
       case 2: /* Swap subitem 0 and 2 */
          ListView_GetItemText(hWndList, i, 0, lpStr1, PATH_MAX);
          ListView_GetItemText(hWndList, i, 2, lpStr2, PATH_MAX);
          ListView_SetItemText(hWndList, i, 0, lpStr2);
          ListView_SetItemText(hWndList, i, 2, lpStr1);
          break;
       case 3: /* Swap subitem 0 and 3 */
          ListView_GetItemText(hWndList, i, 0, lpStr1, PATH_MAX);
          ListView_GetItemText(hWndList, i, 3, lpStr2, PATH_MAX);
          ListView_SetItemText(hWndList, i, 0, lpStr2);
          ListView_SetItemText(hWndList, i, 3, lpStr1);
          break;
       case 4: /* Swap subitem 0 and 4 */
          ListView_GetItemText(hWndList, i, 0, lpStr1, PATH_MAX);
          ListView_GetItemText(hWndList, i, 4, lpStr2, PATH_MAX);
          ListView_SetItemText(hWndList, i, 0, lpStr2);
          ListView_SetItemText(hWndList, i, 4, lpStr1);
          break;
       case 5: /* Swap subitem 0 and 5 */
          ListView_GetItemText(hWndList, i, 0, lpStr1, PATH_MAX);
          ListView_GetItemText(hWndList, i, 5, lpStr2, PATH_MAX);
          ListView_SetItemText(hWndList, i, 0, lpStr2);
          ListView_SetItemText(hWndList, i, 5, lpStr1);
          break;
       }
    }
for (i = 0; i < j; i++)
    {
    ListView_GetItemText(hWndList, i, 4, lpStr1, PATH_MAX);
    p = &lpStr1[8];
    sysTime.wDay = (WORD)strtol(p, NULL, 10);
    lpStr1[7] = '\0';
    p = &lpStr1[5];
    sysTime.wMonth = (WORD)strtol(p, NULL, 10);
    lpStr1[4] = '\0';
    p = &lpStr1[0];
    sysTime.wYear = (WORD)strtol(p, NULL, 10);
    sysTime.wDayOfWeek = (WORD) 1;
    GetDateFormat(LOCALE_USER_DEFAULT,
                  DATE_SHORTDATE,
                  &sysTime,
                  NULL,
                  lpStr2,
                  (int) 13);
    wsprintf(lpStr1, "%8s", lpStr2);
    ListView_SetItemText(hWndList, i, 4, lpStr1);
    }
bSorting = FALSE;
iColumn = 0; /* restore back to default of filename */
GlobalUnlock(lpStr1);
GlobalUnlock(lpStr2);
GlobalFree(hMem1);
GlobalFree(hMem2);
}

#endif /* ?WIN32 */

