/*
 Copyright (C) 1996 Mike White
 Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as all of the original files are included,
 that it is not sold for profit, and that this copyright notice is retained.

*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "wiz.h"
#include "helpids.h"

#define CRLF_WARNING "This option can cause corruption of files other than " \
   "text files. This is particularly true of executables, word processing " \
   "documents, or database files. The only \"safe file\" is an ASCII text " \
   "file. Press OK to confirm, or CANCEL."
extern char szFormatKeyword[2][6];

/****************************************************************************

    FUNCTION: UnZipPreferencesProc(HWND, unsigned, WPARAM, LPARAM)

    PURPOSE:  Processes messages for "UnZip Preferences" dialog box

    MESSAGES:

    WM_INITDIALOG - initialize dialog box
    WM_COMMAND    - Input received

****************************************************************************/
BOOL  recreate_dir,overwrite,newer,prompt_overwrite,lf_crlf,
      space_underscore, lbs_extract, lbs_display, lbs_test;
#ifdef WIN32
int fPrivilege;
#endif

#ifdef __BORLANDC__
#pragma warn -par
#pragma warn -aus
#endif
DWORD WINAPI
UnZipPreferencesProc(HWND hwndDlg, WORD wMessage, WPARAM wParam, LPARAM lParam)
{
#ifdef WIN32
int i;
#endif
   switch (wMessage) {
   case WM_INITDIALOG:
      {

      CenterDialog(GetParent(hwndDlg), hwndDlg); /* center on parent */

      /* UnZip Options */
      recreate_dir = uf.fRecreateDirs;
      CheckDlgButton(hwndDlg, IDC_RECREATE_DIR, recreate_dir);

      overwrite = lpDCL->noflag;
      if (overwrite)
         CheckRadioButton(hwndDlg, IDC_OVERWRITE,
            IDC_PROMPT_OVERWRITE, IDC_OVERWRITE);

      newer = lpDCL->ExtractOnlyNewer;
      if (newer)
         CheckRadioButton(hwndDlg, IDC_OVERWRITE,
            IDC_PROMPT_OVERWRITE, IDC_NEWER);

      prompt_overwrite = lpDCL->PromptToOverwrite;
      if (prompt_overwrite)
         CheckRadioButton(hwndDlg, IDC_OVERWRITE,
            IDC_PROMPT_OVERWRITE, IDC_PROMPT_OVERWRITE);

      lf_crlf = uf.fTranslate;
      CheckDlgButton(hwndDlg, IDC_LF_CRLF, lf_crlf);

      space_underscore = lpDCL->SpaceToUnderscore;
      CheckDlgButton(hwndDlg, IDC_SPACE_UNDERSCORE, space_underscore);
#ifdef WIN32
      fPrivilege = lpDCL->fPrivilege;
      if (fPrivilege == 1)
         CheckDlgButton(hwndDlg, IDC_ACL, TRUE);
      if (fPrivilege == 2)
         CheckDlgButton(hwndDlg, IDC_PRIVILEGE, TRUE);
#endif
      switch (fLB_Selection)
         {
         case 0:
                 CheckRadioButton(hwndDlg, IDC_LBS_EXTRACT,
                    IDC_LBS_TEST, IDC_LBS_EXTRACT);
                 lbs_extract = TRUE;
                 lbs_display = FALSE;
                 lbs_test = FALSE;
                 break;
         case 1:
                 CheckRadioButton(hwndDlg, IDC_LBS_EXTRACT,
                    IDC_LBS_TEST, IDC_LBS_DISPLAY);
                 lbs_display = TRUE;
                 lbs_extract = FALSE;
                 lbs_test = FALSE;
                 break;
         case 2:
                 CheckRadioButton(hwndDlg, IDC_LBS_EXTRACT,
                    IDC_LBS_TEST, IDC_LBS_TEST);
                 lbs_test = TRUE;
                 lbs_extract = FALSE;
                 lbs_display = FALSE;
                 break;
         }
      }
      break;
    /*
     * NOTE: WM_CTLCOLOR is not a supported code under Win 32
     */
#ifdef WIN32
    case WM_CTLCOLORSTATIC:
    case WM_CTLCOLORBTN:
    case WM_CTLCOLORDLG:
#else
    case WM_CTLCOLOR: /* color background of buttons and statics */
        if ((HIWORD(lParam) == CTLCOLOR_STATIC) ||
           (HIWORD(lParam) == CTLCOLOR_BTN) ||
           (HIWORD(lParam) == CTLCOLOR_DLG))
#endif
           {
           POINT point;
           SetBkMode((HDC)wParam, OPAQUE);
           SetBkColor((HDC)wParam, GetSysColor(COLOR_MENU));
           SetTextColor((HDC)wParam, GetSysColor(COLOR_MENUTEXT));
           UnrealizeObject(hBrush);
           point.x = point.y = 0;
           ClientToScreen(hwndDlg, &point);
#ifndef WIN32
           SetBrushOrg((HDC)wParam, point.x, point.y);
#else
           SetBrushOrgEx((HDC)wParam, point.x, point.y, NULL);
#endif
           hBrush = CreateSolidBrush(GetSysColor(COLOR_MENU));
           return ((DWORD)hBrush);
           }

   case WM_COMMAND:
      switch (LOWORD(wParam)) {
         case IDCANCEL:
            EndDialog(hwndDlg, wParam);
            break;
         case IDOK:
            {
            if (lbs_extract == TRUE)
               {
               fLB_Selection = 0;
               wLBSelection = IDM_LB_EXTRACT;
               }
            if (lbs_display == TRUE)
               {
               fLB_Selection = 1;
               wLBSelection = IDM_LB_DISPLAY;
               }
            if (lbs_test == TRUE)
               {
               fLB_Selection = 2;
               wLBSelection = IDM_LB_TEST;
               }
            uf.fRecreateDirs = recreate_dir;
            lpDCL->noflag = overwrite;
            lpDCL->ExtractOnlyNewer = newer;
            lpDCL->PromptToOverwrite = prompt_overwrite;
            uf.fTranslate = lf_crlf;
            lpDCL->SpaceToUnderscore = space_underscore;
#ifdef WIN32
            lpDCL->fPrivilege = fPrivilege;
#endif
            WriteZipOptionsProfile();
            EndDialog(hwndDlg, wParam);
            break;
            }
         case IDC_RECREATE_DIR:
            recreate_dir = !recreate_dir;
            CheckDlgButton(hwndDlg, IDC_RECREATE_DIR, recreate_dir);
            break;
#ifdef WIN32
         case IDC_ACL:
            if (!dwPlatformId)
               break;
            i = IsDlgButtonChecked(hwndDlg, IDC_ACL);
            if (i)
               {
               fPrivilege = 0;
               CheckDlgButton(hwndDlg, IDC_ACL, FALSE);
               CheckDlgButton(hwndDlg, IDC_PRIVILEGE, FALSE);
               }
            else
               {
               fPrivilege = 1;
               CheckDlgButton(hwndDlg, IDC_ACL, TRUE);
               CheckDlgButton(hwndDlg, IDC_PRIVILEGE, FALSE);
               }
            break;
         case IDC_PRIVILEGE:
            if (!dwPlatformId)
               break;
            i = IsDlgButtonChecked(hwndDlg, IDC_PRIVILEGE);
            if (i)
               {
               fPrivilege = 0;
               CheckDlgButton(hwndDlg, IDC_ACL, FALSE);
               CheckDlgButton(hwndDlg, IDC_PRIVILEGE, FALSE);
               }
            else
               {
               fPrivilege = 2;
               CheckDlgButton(hwndDlg, IDC_ACL, FALSE);
               CheckDlgButton(hwndDlg, IDC_PRIVILEGE, TRUE);
               }
            break;
#endif
         case IDC_OVERWRITE:
            overwrite = TRUE;
            newer = FALSE;
            prompt_overwrite = FALSE;
            CheckRadioButton(hwndDlg, IDC_OVERWRITE,
               IDC_PROMPT_OVERWRITE, IDC_OVERWRITE);
            break;
         case IDC_NEWER:
            newer = TRUE;
            overwrite = FALSE;
            prompt_overwrite = FALSE;
            CheckRadioButton(hwndDlg, IDC_OVERWRITE,
               IDC_PROMPT_OVERWRITE, IDC_NEWER);
            break;
         case IDC_PROMPT_OVERWRITE:
            prompt_overwrite = TRUE;
            overwrite = FALSE;
            newer = FALSE;
            CheckRadioButton(hwndDlg, IDC_OVERWRITE,
               IDC_PROMPT_OVERWRITE, IDC_PROMPT_OVERWRITE);
            break;
         case IDC_LF_CRLF:
            {
            lf_crlf = !lf_crlf;
            if (lf_crlf)
               {
               if (MessageBox(hwndDlg, CRLF_WARNING, "Warning About Conversions",
                  MB_OKCANCEL | MB_ICONEXCLAMATION) != IDOK)
                  lf_crlf = FALSE;
               }
            CheckDlgButton(hwndDlg, IDC_LF_CRLF, lf_crlf);
            break;
            }
         case IDC_SPACE_UNDERSCORE:
            space_underscore = !space_underscore;
            CheckDlgButton(hwndDlg, IDC_SPACE_UNDERSCORE,
               space_underscore);
            break;
         case IDC_LBS_EXTRACT:
            lbs_extract = TRUE;
            lbs_display = FALSE;
            lbs_test = FALSE;
            CheckRadioButton(hwndDlg, IDC_LBS_EXTRACT, IDC_LBS_TEST,
                  IDC_LBS_EXTRACT);
            break;
         case IDC_LBS_DISPLAY:
            lbs_display = TRUE;
            lbs_extract = FALSE;
            lbs_test = FALSE;
            CheckRadioButton(hwndDlg, IDC_LBS_EXTRACT, IDC_LBS_TEST,
               IDC_LBS_DISPLAY);
            break;
         case IDC_LBS_TEST:
            lbs_test = TRUE;
            lbs_display = FALSE;
            lbs_extract = FALSE;
            CheckRadioButton(hwndDlg, IDC_LBS_EXTRACT, IDC_LBS_TEST,
               IDC_LBS_TEST);
            break;
         case ID_HELP:
            WinHelp(hwndDlg,szHelpFileName,HELP_CONTEXT, (DWORD)(HELPID_UNZIP_OPTIONS));
            break;

         }
      default:
         break;
   }
   return FALSE;
}
#ifdef __BORLANDC__
#pragma warn .par
#pragma warn .aus
#endif

