/*
 Copyright (C) 1996 Mike White
 Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as all of the original files are included,
 that it is not sold for profit, and that this copyright notice is retained.

*/

#ifdef __BORLANDC__
#include <dir.h>
#endif
#include <direct.h>
#include <string.h>
#include <io.h>
#include <stdio.h>
#include <ctype.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include "wiz.h"
#include "helpids.h"

#ifndef WIN32
#include <lzexpand.h>
#endif

/* Define size of read/write buffer for copying files */
#define READ_WRITE_BUF 4096

extern char **pszIndex;
extern char *sz;
extern LPSTR szFileList;
extern HANDLE hFileList;
extern int ZipRetCode;
BOOL fMakeDosSFX;
BOOL fMakeSFX;
char szTempFileName[PATH_MAX];
char szTargetName[PATH_MAX];

static char szTargetFileName[PATH_MAX] = "";
char __based(__segname("STRINGS_TEXT")) szTargetZipDir[PATH_MAX];
char __based(__segname("STRINGS_TEXT")) szTargetZipFile[PATH_MAX] = "";
char __based(__segname("STRINGS_TEXT")) szCantMakeZip[] =
   "Internal error: Cannot make zip file. Common dialog error code is 0x%lX.";

void MakeArchive(HWND hWnd)
{
char tempFileName[PATH_MAX], tempPath[PATH_MAX];

/* temporary zip options flags */
BOOL fVerbose,fForce,fSystem,fVolume,fNoDirEntries,fJunkDir,fCRLF_LF,
     fLF_CRLF,fEncrypt,fRecurse,fMove,fLatestTime,fUpdate,fFreshen,
     fQuiet,fComment,fmakesfx,fOffsets, fExtra;
#ifdef WIN32
BOOL fPrivilege, fdossfx;
#endif
char fLevel;
int fRepair;

#ifndef WIN32
   FARPROC lpfnGetFilesProc;
#endif
/* Save zip options flags */
fRepair       = ZpOpt.fRepair;
#ifdef WIN32
fPrivilege    = ZpOpt.fPrivilege;
#endif
fExtra        = ZpOpt.fExtra;
fVerbose      = ZpOpt.fVerbose;
fForce        = ZpOpt.fForce;
fSystem       = ZpOpt.fSystem;
fVolume       = ZpOpt.fVolume;
fNoDirEntries = ZpOpt.fNoDirEntries;
fJunkDir      = ZpOpt.fJunkDir;
fCRLF_LF      = ZpOpt.fCRLF_LF;
fLF_CRLF      = ZpOpt.fLF_CRLF;
fEncrypt      = ZpOpt.fEncrypt;
fRecurse      = ZpOpt.fRecurse;
fMove         = ZpOpt.fMove;
fLatestTime   = ZpOpt.fLatestTime;
fUpdate       = ZpOpt.fUpdate;
fFreshen      = ZpOpt.fFreshen;
fQuiet        = ZpOpt.fQuiet;
fComment      = ZpOpt.fComment;
fLevel        = ZpOpt.fLevel;
fmakesfx      = fMakeSFX;
fOffsets      = ZpOpt.fOffsets;

#ifdef WIN32
fdossfx       = fMakeDosSFX;
#endif

#ifndef WIN32
_fmemset(&lpumb->ofn, '\0', sizeof(OPENFILENAME)); /* initialize struct */
#else
memset(&lpumb->ofn, '\0', sizeof(OPENFILENAME)); /* initialize struct */
#endif
WinAssert(hWnd);

lpumb->szUnzipToDirNameTmp[0] = '\0';

lpumb->ofn.lStructSize = sizeof(OPENFILENAME);
lpumb->ofn.hwndOwner = hWnd;
lpumb->ofn.hInstance = hInst;
lpumb->ofn.lpstrFilter = "Zip Files (*.zip)\0*.zip\0Self-extracting Files (*.exe)\0*.exe\0All Files (*.*)\0*.*\0\0";
lpumb->ofn.nFilterIndex = 1;
lpumb->ofn.lpstrFile = lpumb->szUnzipToDirNameTmp; /* result goes here! */
lpumb->ofn.nMaxFile = PATH_MAX;
lpumb->ofn.lpstrFileTitle = NULL; /* NULL causes nMaxFileTitle to be ignored */
lpumb->ofn.nMaxFileTitle = PATH_MAX; /* ignored ! */
lpumb->ofn.lpstrTitle = (LPSTR)"Archive Name";
lpumb->ofn.lpstrInitialDir =
   (LPSTR)(!szTargetZipDir[0] ? NULL : szTargetZipDir);
lpumb->ofn.Flags = OFN_SHOWHELP | OFN_HIDEREADONLY;
uf.fTrailingSlash = FALSE; /* set trailing slash to FALSE */
lpumb->szZipFileName[0] = '\0';

dwCommDlgHelpId = HELPID_ZIP_GET_ARCHIVE_NAME;

if (GetOpenFileName(&lpumb->ofn)) /* successfully got archive name ? */
   {
   if (lstrcmpi(lpumb->szUnzipToDirNameTmp, lpumb->szZipFileName)!=0)
      {
      lstrcpy(tempPath, lpumb->szUnzipToDirNameTmp);
      if (!uf.fTrailingSlash) /* Do we have a trailing slash? */
         { /* No - strip file name off and save it */
         StripDirectory(tempPath);
         lstrcpy(tempFileName, tempPath);
         /* Strip file name off, we've just saved it */
         GetDirectory(lpumb->szUnzipToDirNameTmp);
         }
      uf.fTrailingSlash = FALSE;
      /* Okay, make the directory, if necessary */
      lstrcpy(szTargetZipDir, lpumb->szUnzipToDirNameTmp);
      if (MakeDirectory(lpumb->szUnzipToDirNameTmp, FALSE))
         {
         if (lpumb->szUnzipToDirNameTmp[0] != '\0')
            lstrcat(lpumb->szUnzipToDirNameTmp, "\\");
         lstrcat(lpumb->szUnzipToDirNameTmp, tempFileName);
         /* lpumb->szUnzipToDirNameTmp now contains the fully qualified
            zip file name.
         */
         if (strrchr(lpumb->szUnzipToDirNameTmp, '.') == NULL)
            {
            if (!fMakeSFX)
               lstrcat(lpumb->szUnzipToDirNameTmp, ".zip");
            else
               lstrcat(lpumb->szUnzipToDirNameTmp, ".exe");
            }
         lstrcpy(szTargetFileName, lpumb->szUnzipToDirNameTmp);
         lstrcpy(lpumb->szZipFileName, lpumb->szUnzipToDirNameTmp);
         ZpZCL.lpszZipFN = szTargetFileName;

         }

      if (fSaveZipToDir)
         {
         getcwd(szTargetZipDir, PATH_MAX);
         WriteZipOptionsProfile();
         }

   /* NOTE: Here is where we must actually call to get the files
      to go into the archive. All we've done so far is get the
      archive name.
   */
      {
      dwCommDlgHelpId = HELPID_ZIP_SELECT_FILES;
#ifndef WIN32
      _fmemset(&lpumb->ofn, '\0', sizeof(OPENFILENAME)); /* initialize struct */
#else
      memset(&lpumb->ofn, '\0', sizeof(OPENFILENAME)); /* initialize struct */
#endif
      WinAssert(hWnd);
      szTargetZipFile[0] = '\0';
      lpumb->ofn.lStructSize = sizeof(OPENFILENAME);
      lpumb->ofn.hwndOwner = hWnd;
      lpumb->ofn.hInstance = hInst;
      lpumb->ofn.lpstrFilter = "All Files (*.*)\0*.*\0\0";
      lpumb->ofn.nFilterIndex = 1;

      lpumb->ofn.lpstrFile = szTargetZipFile;
      lpumb->ofn.nMaxFile = PATH_MAX;
      lpumb->ofn.lpstrFileTitle = NULL;
      lpumb->ofn.nMaxFileTitle = PATH_MAX; /* ignored ! */

      wsprintf(lpumb->szBuffer, "Archive %s", lpumb->szZipFileName);

      lpumb->ofn.lpstrTitle = (LPSTR) lpumb->szBuffer;
      lpumb->ofn.lpstrInitialDir =
         (LPSTR)(!szTargetZipDir[0] ? NULL : szTargetZipDir);
      lpumb->ofn.Flags = OFN_SHOWHELP | OFN_ENABLEHOOK | OFN_CREATEPROMPT |
         OFN_HIDEREADONLY|OFN_ENABLETEMPLATE;
#ifndef WIN32
      lpfnGetFilesProc = MakeProcInstance((FARPROC)GetFilesProc, hInst);
#   ifndef MSC
      (UINT CALLBACK *)lpumb->ofn.lpfnHook = (UINT CALLBACK *)lpfnGetFilesProc;
#   else
      lpumb->ofn.lpfnHook = lpfnGetFilesProc;
#   endif
#else
      lpumb->ofn.lpfnHook = (LPOFNHOOKPROC)GetFilesProc;
#endif
      lpumb->ofn.lpTemplateName = "GETFILES";   /* see getfiles.dlg   */
      if (GetOpenFileName(&lpumb->ofn) && (hFileList &&
             (ZpZCL.lpszZipFN[0] != '\0')) ||
             (ZpOpt.fRepair && (ZpZCL.lpszZipFN[0] != '\0')))
         {
         char *ptr;

         UpdateWindow(hWndMain);

         if (fMakeSFX)
            {
            ptr = strrchr(lpumb->szZipFileName, '.') + 1;
            *ptr = '\0';
            lstrcat(lpumb->szZipFileName, "exe");
            lstrcpy(ZpZCL.lpszZipFN, lpumb->szZipFileName);
            }

         ZpZCL.FNV = (char **)szFileList;
         if (!ZpOpt.fRepair)
            BufferOut( "Creating/Updating Archive: %s\n",
               lpumb->szZipFileName);
         else
            if (ZpZCL.argc != 0)
               BufferOut( "Repairing/Updating Archive: %s\n",
                  lpumb->szZipFileName);
            else
               BufferOut( "Repairing Archive: %s\n",
                  lpumb->szZipFileName);
         hSaveCursor = SetCursor(hHourGlass);
         ShowCursor(TRUE);
         if (fMakeSFX)
            {
            OFSTRUCT ofStrSrc;
            OFSTRUCT ofStrDest;
            HFILE hfSrcFile, hfDstFile;
#ifndef WIN32
            struct find_t ffblk;
#else
            WIN32_FIND_DATA ffblk;
            HANDLE hfile;
#endif

            ZpOpt.fOffsets = TRUE; /* Force adjusting of offsets */
            /* Get the path we are executing from */
            GetModuleFileName(hInst, szTargetName,
                  sizeof(szTargetName));
            ptr = strrchr(szTargetName, '\\') + 1;
            *ptr = '\0'; /* We've now got the path we are executing from */
#ifdef WIN32
            if (fMakeDosSFX)
               lstrcat(szTargetName, "sfx16.dat");
            else
               lstrcat(szTargetName, "sfx32.dat");
#else
            lstrcat(szTargetName, "sfx16.dat");
#endif
#ifndef WIN32
            if (_dos_findfirst(ZpZCL.lpszZipFN,
                _A_NORMAL|_A_RDONLY|_A_ARCH,&ffblk) != 0)
#else
            if ((hfile = FindFirstFile(ZpZCL.lpszZipFN, &ffblk)) == INVALID_HANDLE_VALUE)
#endif
               {
               hfSrcFile = LZOpenFile(szTargetName,
                  &ofStrSrc, OF_READ);
               if (hfSrcFile < 0)
                  {
#ifdef WIN32
                  if (fMakeDosSFX)
                     MessageBox (hWnd, "Can't find SFX16.DAT, continuing without making SFX exe.",
                        "Can't find SFX16.DAT", MB_ICONINFORMATION | MB_OK);
                  else
                     MessageBox (hWnd, "Can't find SFX32.DAT, continuing without making SFX exe.",
                        "Can't find SFX32.DAT", MB_ICONINFORMATION | MB_OK);
#else
                  MessageBox (hWnd, "Can't find SFX16.D1, continuing without making SFX exe.",
                     "Can't find SFX16.DAT", MB_ICONINFORMATION | MB_OK);
#endif
                  }
               else
                  {
                  hfDstFile = LZOpenFile(ZpZCL.lpszZipFN,
                     &ofStrDest, OF_CREATE);

                  LZCopy(hfSrcFile, hfDstFile);

                  LZClose(hfSrcFile);
                  LZClose(hfDstFile);
                  }
               }
            else
               {
               int in, out;
#ifdef WIN32
               FindClose(hfile);
#endif
               /* Copy the prefix file over to the temp file */
               hfSrcFile = LZOpenFile(szTargetName,
                  &ofStrSrc, OF_READ);
               if (hfSrcFile < 0)
                  {
#ifdef WIN32
                  if (fMakeDosSFX)
                     MessageBox (hWnd, "Can't find SFX16.DAT, continuing without making SFX exe.",
                        "Can't find SFX16.DAT", MB_ICONINFORMATION | MB_OK);
                  else
                     MessageBox (hWnd, "Can't find SFX32.DAT, continuing without making SFX exe.",
                        "Can't find SFX32.DAT", MB_ICONINFORMATION | MB_OK);
#else
                  MessageBox (hWnd, "Can't find SFX16.DAT, continuing without making SFX exe.",
                     "Can't find SFX16.DAT", MB_ICONINFORMATION | MB_OK);
#endif
                  }
               else
                  {
                  char buf[READ_WRITE_BUF];
                  /* Get a temp file name and directory (Goes in directory
                   * designated by tmp, temp or the current directory)
                   */
#ifdef WIN32
                  GetTempPath(sizeof(szTargetName), szTargetName);
                  GetTempFileName(szTargetName, "WIZ", 0, szTempFileName);
#else
                  GetTempFileName(0, "WIZ", 0, szTempFileName);
#endif
                  hfDstFile = LZOpenFile(szTempFileName,
                     &ofStrDest, OF_CREATE);

                  LZCopy(hfSrcFile, hfDstFile);

                  LZClose(hfSrcFile);
                  LZClose(hfDstFile);
                  /* We've got the prefix moved over, now append the
                   * archive file itself.
                   */
                  out = open(szTempFileName, O_RDWR | O_APPEND | O_BINARY );
                  in = open(ZpZCL.lpszZipFN, O_RDONLY | O_BINARY);

                  lseek(out, SEEK_CUR, SEEK_END);
                  while (read(in, buf, READ_WRITE_BUF) > 0)
                     {
                     write(out, buf, READ_WRITE_BUF);
                     }

                  close(in);
                  close(out);

                  /* Copy the temp file back over the original file */
                  hfSrcFile = LZOpenFile(szTempFileName,
                     &ofStrSrc, OF_READ);
                  if (hfSrcFile < 0)
                     {
                     MessageBox (hWnd, "Can't find temp file, continuing without making SFX exe.",
                        "Can't find temp file", MB_ICONINFORMATION | MB_OK);
                     }
                  else
                     {
                     hfDstFile = LZOpenFile(ZpZCL.lpszZipFN,
                        &ofStrDest, OF_CREATE);

                     LZCopy(hfSrcFile, hfDstFile);
                     LZClose(hfSrcFile);
                     LZClose(hfDstFile);
                     remove(szTempFileName);
                     lstrcpy(szTempFileName, ZpZCL.lpszZipFN);
                     if (lstrcmpi(&szTempFileName[lstrlen(ZpZCL.lpszZipFN) - 4],
                        ".exe") != 0)
                        {
                        lstrcpy(&ZpZCL.lpszZipFN[lstrlen(ZpZCL.lpszZipFN) - 4],
                           ".exe");
                        rename(szTempFileName, ZpZCL.lpszZipFN);
                        }
                     }
                  }
               }
            }
         ZipSetOptions(ZpOpt);
         ZipRetCode = ZipArchive(ZpZCL);
         ShowCursor(FALSE);
         SetCursor(hSaveCursor);
         }
      }

      if ((toupper(lpumb->ofn.lpstrFile[0]) != 'A') &&
          (toupper(lpumb->ofn.lpstrFile[0]) != 'B'))
          {
          lstrcpy(szTargetZipFile, lpumb->ofn.lpstrFile);
          if ((lpchLast = lstrrchr(szTargetZipFile, '\\'))!=0)
             {
             *lpchLast = '\0';
             }
           else if ((lpchLast = lstrrchr(szTargetZipFile, ':'))!=0)
             {
             *(lpchLast+1) = '\0';
             lstrcat(szTargetZipFile, "\\");
             }
           }
        }
      }
else /* either real error or canceled */
   {
   DWORD dwExtdError = CommDlgExtendedError(); /* debugging */

   if (dwExtdError != 0L) /* if not canceled then real error */
      {
      wsprintf (lpumb->szBuffer, szCantMakeZip, dwExtdError);
      MessageBox (hWnd, lpumb->szBuffer, szAppName, MB_ICONINFORMATION | MB_OK);
      }
   else
      {
      RECT mRect;

      WinAssert(hWndMain);
      GetWindowRect(hWndMain, &mRect);
      InvalidateRect(hWndMain, &mRect, TRUE);
      SendMessage(hWndMain, WM_SIZE, SIZE_RESTORED,
         MAKELONG(mRect.right-mRect.left, mRect.top-mRect.bottom));
      UpdateWindow(hWndMain);
      }
   }
/* Restore zip options flags */
#ifdef WIN32
ZpOpt.fPrivilege    = fPrivilege;
#endif
ZpOpt.fExtra        = fExtra;
ZpOpt.fRepair       = fRepair;
ZpOpt.fVerbose      = fVerbose;
ZpOpt.fForce        = fForce;
ZpOpt.fSystem       = fSystem;
ZpOpt.fVolume       = fVolume;
ZpOpt.fNoDirEntries = fNoDirEntries;
ZpOpt.fJunkDir      = fJunkDir;
ZpOpt.fCRLF_LF      = fCRLF_LF;
ZpOpt.fLF_CRLF      = fLF_CRLF;
ZpOpt.fEncrypt      = fEncrypt;
ZpOpt.fRecurse      = fRecurse;
ZpOpt.fMove         = fMove;
ZpOpt.fLatestTime   = fLatestTime;
ZpOpt.fUpdate       = fUpdate;
ZpOpt.fFreshen      = fFreshen;
ZpOpt.fComment      = fComment;
ZpOpt.fQuiet        = fQuiet;
ZpOpt.fLevel        = fLevel;
fMakeSFX              = fmakesfx;
ZpOpt.fOffsets      = fOffsets;

#ifdef WIN32
fMakeDosSFX           = fdossfx;
#endif

if (hFileList)
   {
   GlobalUnlock(hFileList);
   GlobalFree(hFileList);
   }
}

